/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.units;

import info.monitorenter.util.units.AUnit;
import info.monitorenter.util.units.IUnitSystem;
import info.monitorenter.util.units.UnitUnchanged;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitFactory {
    private static UnitFactory instance;
    public static final AUnit UNCHANGED;
    private static final Map<String, List<AUnit>> UNITSYSTEMS;

    public static UnitFactory getInstance() {
        if (instance == null) {
            instance = new UnitFactory();
        }
        return instance;
    }

    private UnitFactory() {
    }

    public AUnit getUnit(double absoluteMax, IUnitSystem units) {
        AUnit result = UNCHANGED;
        List<AUnit> choice = UNITSYSTEMS.get(units.getClass().getName());
        if (choice == null) {
            choice = this.initUnitSystem(units);
        }
        for (AUnit peek : choice) {
            if (absoluteMax < peek.getFactor()) break;
            result = peek;
        }
        return result;
    }

    public List<AUnit> getUnits(IUnitSystem unitsystem) {
        List<AUnit> choice = UNITSYSTEMS.get(unitsystem.getClass().getName());
        if (choice == null) {
            choice = this.initUnitSystem(unitsystem);
        }
        return choice;
    }

    private List<AUnit> initUnitSystem(IUnitSystem iUnitSystem) {
        LinkedList<AUnit> linkedList = new LinkedList<AUnit>();
        Class<?>[] classArray = iUnitSystem.getUnits();
        AUnit aUnit = null;
        AUnit aUnit2 = null;
        for (int i = 0; i < classArray.length; ++i) {
            if (!AUnit.class.isAssignableFrom(classArray[i])) {
                System.err.println("UnitFactory: wrong class " + classArray[i].getName() + " delivered by " + iUnitSystem.getClass().getName());
                continue;
            }
            try {
                aUnit = (AUnit)classArray[i].newInstance();
                linkedList.add(aUnit);
                if (aUnit2 == null) {
                    aUnit2 = aUnit;
                } else {
                    aUnit2.m_nextHigherUnit = aUnit;
                }
                aUnit.m_nexLowerUnit = aUnit2;
                aUnit2 = aUnit;
                continue;
            }
            catch (InstantiationException instantiationException) {
                System.err.println("UnitFactory encountered problems by instantiation of " + classArray[i].getName());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("UnitFactory has no access to " + classArray[i].getName());
            }
        }
        int n = linkedList.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            double d = ((AUnit)linkedList.get(i)).getFactor();
            for (int j = i + 1; j < n; ++j) {
                double d2 = ((AUnit)linkedList.get(j)).getFactor();
                if (!(d2 < d)) continue;
                d = d2;
                n2 = j;
            }
            linkedList.add(i, (AUnit)linkedList.remove(n2));
        }
        UNITSYSTEMS.put(iUnitSystem.getClass().getName(), linkedList);
        return linkedList;
    }

    static {
        UNCHANGED = new UnitUnchanged();
        UNITSYSTEMS = new HashMap<String, List<AUnit>>();
    }
}

