# gap> P1P1:=Polytope([[1,1],[1,-1],[-1,1],[-1,-1]]);
# <A polytope in |R^2>
# gap> P1P1:=ToricVariety(P1P1);
# <A projective toric variety of dimension 2>
# gap> CoxRing(P1P1);
# polymake: used package cddlib
#   Implementation of the double description method of Motzkin et al.
#   Copyright by Komei Fukuda.
#   http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html
# 
# ----------------------------------------------------------------
# Loading  IO_ForHomalg 2011.07.25
# by Thomas Bächler (http://wwwb.math.rwth-aachen.de/~thomas/)
#    Mohamed Barakat (http://www.mathematik.uni-kl.de/~barakat/)
#    Max Neunhöffer (http://www-groups.mcs.st-and.ac.uk/~neunhoef/)
#    Daniel Robertz (http://wwwb.math.rwth-aachen.de/~daniel/)
# For help, type: ?IO_ForHomalg package 
# ----------------------------------------------------------------
# ================================================================
#                      SINGULAR                                 /
#  A Computer Algebra System for Polynomial Computations       /   version 3-1-3
#                                                            0<
#  by: W. Decker, G.-M. Greuel, G. Pfister, H. Schoenemann     \   March 2011
# FB Mathematik der Universitaet, D-67653 Kaiserslautern        \
# ================================================================
# Q[x_1,x_2,x_3,x_4]
# (weights: [ [ 0, 0, 1, 0 ], [ 0, 0, 0, 1 ], [ 0, 0, 1, 0 ], [ 0, 0, 0, 1 ] ])
# gap> Display(ByASmallerPresentation(ClassGroup(P1P1)));
# Z^(1 x 2)
# gap> CoxRing(P1P1);
# Q[x_1,x_2,x_3,x_4]
# (weights: [ [ 1, 0 ], [ 0, 1 ], [ 1, 0 ], [ 0, 1 ] ])
# gap> IrrelevantIdeal(P1P1);
# <A torsion-free (left) ideal given by 4 generators>
# gap> Display(last);
# x_3*x_4,
# x_1*x_4,
# x_2*x_3,
# x_1*x_2 
# (over a graded ring)
# 
# A (left) ideal generated by the 4 entries of the above matrix
# gap> D:=Divisor([1,1,0,0],P1P1);
# <A divisor of a toric variety with coordinates [ 1, 1, 0, 0 ]>
# gap> ClassOfDivisor(D);
# [ 1, 1 ]
# gap> MonomsOfCoxRingOfDegree(D);
# [ x_1*x_2, x_2*x_3, x_1*x_4, x_3*x_4 ]
# gap> D2:=Divisor([2,0,0,0],P1P1);
# <A divisor of a toric variety with coordinates [ 2, 0, 0, 0 ]>
# gap> ClassOfDivisor(D2);
# [ 2, 0 ]
# gap> MonomsOfCoxRingOfDegree(D2);
# [ x_1^2, x_1*x_3, x_3^2 ]

P1P1:=Polytope([[1,1],[1,-1],[-1,1],[-1,-1]]);
P1P1:=ToricVariety(P1P1);
CoxRing(P1P1);
Display(ByASmallerPresentation(ClassGroup(P1P1)));
CoxRing(P1P1);
IrrelevantIdeal(P1P1);
Display(last);
D:=Divisor([1,1,0,0],P1P1);
ClassOfDivisor(D);
MonomsOfCoxRingOfDegree(D);
D2:=Divisor([2,0,0,0],P1P1);
ClassOfDivisor(D2);
MonomsOfCoxRingOfDegree(D2);