#############################################################################
##
#W  chains.g                 GAP4 Package `RCWA'                  Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of chains
##  of subgroups.
##
##  This is a list of descending chains of length >= 3 of groups generated by
##  3 class transpositions. The groups are represented by their positions in
##  the list 'grps'.
##
#############################################################################

return
[[5,3,23,1625],[5,3,23,3507],[5,3,23,3520,3507],
 [5,3,202],[5,3,218,202],[5,3,1625],[5,3,2429,3507],
 [5,3,2675,3507],[5,3,3507],[5,3,3520,3507],[5,3,9761],
 [5,3,10077],[5,3,17205],[5,3,17521],[5,4,268],
 [5,4,2479],[5,23,1625],[5,23,3507],[5,23,3520,3507],
 [5,26,23,1625],[5,26,23,3507],[5,26,23,3520,3507],
 [5,26,1291],[5,26,1297,1658],[5,26,1297,38530],
 [5,26,1625],[5,26,1658],[5,26,3502,3507],
 [5,26,3502,41069],[5,26,3507],[5,26,3517,3507],
 [5,26,3517,44904],[5,26,3520,3507],[5,26,38305,41411],
 [5,26,38529,45501],[5,26,38530],[5,26,41069],
 [5,26,41078,41069],[5,26,41078,41411],[5,26,41078,44904],
 [5,26,41078,45501],[5,26,41411],[5,26,44904],
 [5,26,45501],[5,199,202],[5,199,268],[5,199,328],
 [5,199,8715],[5,199,8962],[5,199,10854],[5,199,12747],
 [5,218,202],[5,221,202],[5,227,202],[5,227,218,202],
 [5,227,1297,1658],[5,227,1297,38530],[5,227,1658],
 [5,227,9749],[5,227,9759],[5,227,10110],[5,227,17193],
 [5,227,17203],[5,227,17554],[5,227,38530],[5,236,202],
 [5,281,268],[5,281,11043],[5,284,268],[5,284,11046],
 [5,289,268],[5,289,1625],[5,289,11051],[5,289,11064],
 [5,289,12030],[5,289,22481],[5,290,268],[5,290,1658],
 [5,290,11052],[5,290,11062],[5,290,12063],[5,290,22514],
 [5,299,268],[5,299,11061],[5,343,328],[5,343,12819],
 [5,346,328],[5,346,12822],[5,351,328],[5,351,1625],
 [5,351,12827],[5,351,12840],[5,351,13921],[5,351,19232],
 [5,352,328],[5,352,1658],[5,352,12828],[5,352,12838],
 [5,352,13954],[5,352,19265],[5,361,328],[5,361,12837],
 [5,1297,1658],[5,1297,38530],[5,2410,8715],
 [5,2414,2429,3507],[5,2414,2447,2429,3507],
 [5,2414,2447,3507],[5,2414,2447,3517,3507],
 [5,2414,2447,3517,44904],[5,2414,2447,9758],
 [5,2414,2447,9759],[5,2414,2447,10074,44904],
 [5,2414,2447,44904],[5,2414,2734,3507],
 [5,2414,2752,2734,3507],[5,2414,2752,3507],
 [5,2414,2752,3517,3507],[5,2414,2752,3517,44904],
 [5,2414,2752,18913],[5,2414,2752,18914],
 [5,2414,2752,19229,44904],[5,2414,2752,44904],
 [5,2414,2849,3507],[5,2414,3507],[5,2414,3517,3507],
 [5,2414,3517,44904],[5,2414,8962],[5,2414,8975,8962],
 [5,2414,8983,8962],[5,2414,8983,8993,8962],
 [5,2414,8983,8994,8962],[5,2414,8983,10074,44904],
 [5,2414,8983,19229,44904],[5,2414,8983,22478,44904],
 [5,2414,8983,44904],[5,2414,8993,8962],[5,2414,8994,8962],
 [5,2414,9758],[5,2414,9759],[5,2414,10074,44904],
 [5,2414,18913],[5,2414,18914],[5,2414,19229,44904],
 [5,2414,22162],[5,2414,22163],[5,2414,22478,44904],
 [5,2414,44904],[5,2429,3507],[5,2432,2429,3507],
 [5,2432,3502,3507],[5,2432,3502,41069],[5,2432,3507],
 [5,2432,9743],[5,2432,9749],[5,2432,9874,41069],
 [5,2432,41069],[5,2447,2429,3507],[5,2447,3507],
 [5,2447,3517,3507],[5,2447,3517,44904],[5,2447,9758],
 [5,2447,9759],[5,2447,10074,44904],[5,2447,44904],
 [5,2476,10854],[5,2492,3507],[5,2495,2492,3507],
 [5,2495,3502,3507],[5,2495,3502,41069],[5,2495,3507],
 [5,2495,11696],[5,2495,11702],[5,2495,11827,41069],
 [5,2495,41069],[5,2510,2492,3507],[5,2510,3507],
 [5,2510,3517,3507],[5,2510,3517,44904],[5,2510,11711],
 [5,2510,11712],[5,2510,12027,44904],[5,2510,44904],
 [5,2538,2554,3507],[5,2538,2557,2554,3507],
 [5,2538,2557,3502,3507],[5,2538,2557,3502,41069],
 [5,2538,2557,3507],[5,2538,2557,13587],[5,2538,2557,13593],
 [5,2538,2557,13718,41069],[5,2538,2557,41069],
 [5,2538,2675,3507],[5,2538,2678,2675,3507],
 [5,2538,2678,3502,3507],[5,2538,2678,3502,41069],
 [5,2538,2678,3507],[5,2538,2678,17187],[5,2538,2678,17193],
 [5,2538,2678,17318,41069],[5,2538,2678,41069],
 [5,2538,2849,3507],[5,2538,3502,3507],[5,2538,3502,41069],
 [5,2538,3507],[5,2538,12747],[5,2538,12760,12747],
 [5,2538,12763,12747],[5,2538,12768,12747],
 [5,2538,12768,12763,12747],[5,2538,12768,12769,12747],
 [5,2538,12768,13718,41069],[5,2538,12768,17318,41069],
 [5,2538,12768,22278,41069],[5,2538,12768,41069],
 [5,2538,12769,12747],[5,2538,13587],[5,2538,13593],
 [5,2538,13718,41069],[5,2538,17187],[5,2538,17193],
 [5,2538,17318,41069],[5,2538,22147],[5,2538,22153],
 [5,2538,22278,41069],[5,2538,41069],[5,2554,3507],
 [5,2557,2554,3507],[5,2557,3502,3507],[5,2557,3502,41069],
 [5,2557,3507],[5,2557,13587],[5,2557,13593],
 [5,2557,13718,41069],[5,2557,41069],[5,2572,2410,8715],
 [5,2572,2429,3507],[5,2572,2447,2429,3507],
 [5,2572,2447,3507],[5,2572,2447,3517,3507],
 [5,2572,2447,3517,44904],[5,2572,2447,9758],
 [5,2572,2447,9759],[5,2572,2447,10074,44904],
 [5,2572,2447,44904],[5,2572,2492,3507],
 [5,2572,2510,2492,3507],[5,2572,2510,3507],
 [5,2572,2510,3517,3507],[5,2572,2510,3517,44904],
 [5,2572,2510,11711],[5,2572,2510,11712],
 [5,2572,2510,12027,44904],[5,2572,2510,44904],
 [5,2572,2554,3507],[5,2572,3507],[5,2572,3517,3507],
 [5,2572,3517,44904],[5,2572,8715],[5,2572,8733,8715],
 [5,2572,8741,8715],[5,2572,8751,8715],[5,2572,8752,8715],
 [5,2572,9758],[5,2572,9759],[5,2572,10074,44904],
 [5,2572,11711],[5,2572,11712],[5,2572,12027,44904],
 [5,2572,13602],[5,2572,13603],[5,2572,13918,44904],
 [5,2572,44904],[5,2675,3507],[5,2678,2675,3507],
 [5,2678,3502,3507],[5,2678,3502,41069],[5,2678,3507],
 [5,2678,17187],[5,2678,17193],[5,2678,17318,41069],
 [5,2678,41069],[5,2693,2675,3507],[5,2693,3507],
 [5,2693,3517,3507],[5,2693,3517,44904],[5,2693,17202],
 [5,2693,17203],[5,2693,17518,44904],[5,2693,44904],
 [5,2734,3507],[5,2737,2476,10854],[5,2737,2492,3507],
 [5,2737,2495,2492,3507],[5,2737,2495,3502,3507],
 [5,2737,2495,3502,41069],[5,2737,2495,3507],
 [5,2737,2495,11696],[5,2737,2495,11702],
 [5,2737,2495,11827,41069],[5,2737,2495,41069],
 [5,2737,2675,3507],[5,2737,2678,2675,3507],
 [5,2737,2678,3502,3507],[5,2737,2678,3502,41069],
 [5,2737,2678,3507],[5,2737,2678,17187],[5,2737,2678,17193],
 [5,2737,2678,17318,41069],[5,2737,2678,41069],
 [5,2737,2734,3507],[5,2737,3502,3507],[5,2737,3502,41069],
 [5,2737,3507],[5,2737,10854],[5,2737,10869,10854],
 [5,2737,10872,10854],[5,2737,10877,10854],
 [5,2737,10878,10854],[5,2737,11696],[5,2737,11702],
 [5,2737,11827,41069],[5,2737,17187],[5,2737,17193],
 [5,2737,17318,41069],[5,2737,18898],[5,2737,18904],
 [5,2737,19029,41069],[5,2737,41069],[5,2752,2734,3507],
 [5,2752,3507],[5,2752,3517,3507],[5,2752,3517,44904],
 [5,2752,18913],[5,2752,18914],[5,2752,19229,44904],
 [5,2752,44904],[5,2849,3507],[5,3502,3507],
 [5,3502,41069],[5,3517,3507],[5,3517,44904],
 [5,3520,3507],[5,8733,8715],[5,8736,8715],[5,8741,8715],
 [5,8742,8715],[5,8751,8715],[5,8752,8715],[5,8754,8715],
 [5,8754,8742,8715],[5,8754,8751,8715],[5,8754,10109,45501],
 [5,8754,12062,45501],[5,8754,13953,45501],[5,8754,45501],
 [5,8975,8962],[5,8978,8962],[5,8983,8962],
 [5,8983,8993,8962],[5,8983,8994,8962],[5,8983,10074,44904],
 [5,8983,19229,44904],[5,8983,22478,44904],[5,8983,44904],
 [5,8984,8962],[5,8993,8962],[5,8994,8962],[5,8996,8962],
 [5,9874,41069],[5,9885,41411],[5,10074,44904],
 [5,10109,45501],[5,10869,10854],[5,10872,10854],
 [5,10877,10854],[5,10878,10854],[5,10887,10854],
 [5,10888,10854],[5,10890,10854],[5,10890,10872,10854],
 [5,10890,10888,10854],[5,10890,11838,41411],
 [5,10890,17329,41411],[5,10890,19040,41411],[5,10890,41411],
 [5,11827,41069],[5,11838,41411],[5,12027,44904],
 [5,12062,45501],[5,12760,12747],[5,12763,12747],
 [5,12768,12747],[5,12768,12763,12747],[5,12768,12769,12747],
 [5,12768,13718,41069],[5,12768,17318,41069],
 [5,12768,22278,41069],[5,12768,41069],[5,12769,12747],
 [5,12778,12747],[5,12779,12747],[5,12781,12747],
 [5,13718,41069],[5,13729,41411],[5,13918,44904],
 [5,13953,45501],[5,17318,41069],[5,17329,41411],
 [5,17518,44904],[5,17553,45501],[5,19029,41069],
 [5,19040,41411],[5,19229,44904],[5,19264,45501],
 [5,22278,41069],[5,22289,41411],[5,22478,44904],
 [5,22513,45501],[5,38305,41411],[5,38529,45501],
 [5,41078,41069],[5,41078,41411],[5,41078,44904],
 [5,41078,45501],[24,1,2279],[24,23,1625],[24,23,3507],
 [24,23,3520,3507],[24,26,23,1625],[24,26,23,3507],
 [24,26,23,3520,3507],[24,26,1291],[24,26,1297,1658],
 [24,26,1297,38530],[24,26,1625],[24,26,1658],
 [24,26,3502,3507],[24,26,3502,41069],[24,26,3507],
 [24,26,3517,3507],[24,26,3517,44904],[24,26,3520,3507],
 [24,26,38305,41411],[24,26,38529,45501],[24,26,38530],
 [24,26,41069],[24,26,41078,41069],[24,26,41078,41411],
 [24,26,41078,44904],[24,26,41078,45501],[24,26,41411],
 [24,26,44904],[24,26,45501],[24,89,90,1336],
 [24,89,90,5692,5705],[24,89,90,5705],[24,89,1291],
 [24,89,1336],[24,89,1377],[24,89,1391,1377],
 [24,89,1391,40108],[24,89,5645,5705],[24,89,5645,38205],
 [24,89,5690,5705],[24,89,5690,39193],[24,89,5692,5705],
 [24,89,5705],[24,89,38205],[24,89,38206,38205],
 [24,89,38206,38331],[24,89,38206,39193],
 [24,89,38206,40055],[24,89,38331],[24,89,38344,38331],
 [24,89,39193],[24,89,40055],[24,89,40068,40055],
 [24,89,40108],[24,90,1336],[24,90,5692,5705],
 [24,90,5705],[24,156,1377],[24,156,1658],[24,156,1761],
 [24,156,7813,7828],[24,156,7813,42193],[24,156,7818,7828],
 [24,156,7818,40287],[24,156,7828],[24,156,7899,7813,7828],
 [24,156,7899,7813,42193],[24,156,7899,7818,7828],
 [24,156,7899,7818,40287],[24,156,7899,7828],
 [24,156,7899,40099,40287],[24,156,7899,40287],
 [24,156,7899,40298,40287],[24,156,7899,41894,42193],
 [24,156,7899,41993,42193],[24,156,7899,42193],
 [24,156,40099,40287],[24,156,40287],[24,156,40298,40287],
 [24,156,41894,42193],[24,156,41993,42193],[24,156,42193],
 [24,157,1424,1698],[24,157,1424,41154],[24,157,1698],
 [24,157,7860,7875],[24,157,7860,41154],[24,157,7875],
 [24,157,41154],[24,1297,1658],[24,1297,38530],
 [24,1298,1291],[24,1298,1424,1698],[24,1298,1424,41154],
 [24,1298,1426,1761],[24,1298,1426,41217],[24,1298,1698],
 [24,1298,1761],[24,1298,38296,38557],[24,1298,38309,38921],
 [24,1298,38557],[24,1298,38563,38557],[24,1298,38563,38921],
 [24,1298,38563,46064],[24,1298,38563,47090],[24,1298,38921],
 [24,1298,41147,46064],[24,1298,41154],[24,1298,41212,47090],
 [24,1298,41217],[24,1298,46064],[24,1298,47090],
 [24,1339,1336],[24,1339,1625],[24,1339,1761],
 [24,1339,39276,42593],[24,1339,39289,39779],
 [24,1339,39400,39779],[24,1339,39534,39779],[24,1339,39779],
 [24,1339,42593],[24,1339,42602,42593],[24,1339,42604,42593],
 [24,1340,1336],[24,1340,1658],[24,1340,1698],
 [24,1340,39277,39424],[24,1340,39287,42936],[24,1340,39424],
 [24,1340,39433,39424],[24,1340,39439,39424],
 [24,1340,42635,42936],[24,1340,42669,42936],[24,1340,42936],
 [24,1381,1377],[24,1381,1625],[24,1381,1698],
 [24,1381,40098,41850],[24,1381,40111,40642],
 [24,1381,40261,40642],[24,1381,40330,40642],[24,1381,40642],
 [24,1381,41850],[24,1381,41861,41850],[24,1381,41865,41850],
 [24,1391,1377],[24,1391,40108],[24,1424,1698],
 [24,1424,41154],[24,1426,1761],[24,1426,41217],
 [24,2300,2279],[24,2300,3500,3507],[24,2300,3500,38205],
 [24,2300,3507],[24,2300,3517,3507],[24,2300,3517,44904],
 [24,2300,5645,5705],[24,2300,5645,38205],
 [24,2300,5695,5705],[24,2300,5695,44904],[24,2300,5705],
 [24,2300,7725,7828],[24,2300,7725,38205],
 [24,2300,7817,7828],[24,2300,7817,44904],[24,2300,7828],
 [24,2300,38205],[24,2300,44904],[24,2305,2279],
 [24,2305,3714],[24,2305,3725,3714],[24,2305,3725,42671],
 [24,2305,5859,6050],[24,2305,5859,42671],[24,2305,6050],
 [24,2305,7939,7950],[24,2305,7939,42671],[24,2305,7950],
 [24,2305,42671],[24,3500,3507],[24,3500,38205],
 [24,3502,3507],[24,3502,41069],[24,3503,3507],
 [24,3503,3677],[24,3503,3714],[24,3503,38331],
 [24,3503,38557],[24,3503,41850],[24,3503,42593],
 [24,3517,3507],[24,3517,44904],[24,3520,3507],
 [24,3522,3507],[24,3522,38921],[24,3545,3500,3507],
 [24,3545,3500,38205],[24,3545,3502,3507],
 [24,3545,3502,41069],[24,3545,3503,3507],
 [24,3545,3503,3677],[24,3545,3503,3714],
 [24,3545,3503,38331],[24,3545,3503,38557],
 [24,3545,3503,41850],[24,3545,3503,42593],[24,3545,3507],
 [24,3545,3677],[24,3545,3714],[24,3545,38205],
 [24,3545,38206,38205],[24,3545,38206,38331],
 [24,3545,38206,39193],[24,3545,38206,40055],
 [24,3545,38212,38205],[24,3545,38212,38557],
 [24,3545,38212,39424],[24,3545,38212,40287],
 [24,3545,38296,38557],[24,3545,38331],[24,3545,38335,38331],
 [24,3545,38557],[24,3545,39193],[24,3545,39197,39193],
 [24,3545,39197,39424],[24,3545,39197,41069],
 [24,3545,39197,41850],[24,3545,39201,39193],
 [24,3545,39276,42593],[24,3545,39277,39424],[24,3545,39424],
 [24,3545,40055],[24,3545,40058,40055],[24,3545,40058,40287],
 [24,3545,40058,41069],[24,3545,40058,42593],
 [24,3545,40060,40055],[24,3545,40098,41850],
 [24,3545,40099,40287],[24,3545,40287],[24,3545,41069],
 [24,3545,41850],[24,3545,42593],[24,3563,3500,3507],
 [24,3563,3500,38205],[24,3563,3507],[24,3563,3520,3507],
 [24,3563,3522,3507],[24,3563,3522,38921],[24,3563,38205],
 [24,3563,38224,38205],[24,3563,38224,38921],
 [24,3563,38224,39779],[24,3563,38224,40642],[24,3563,38921],
 [24,3563,39400,39779],[24,3563,39404],[24,3563,39779],
 [24,3563,40261,40642],[24,3563,40263],[24,3563,40642],
 [24,3648,3502,3507],[24,3648,3502,41069],[24,3648,3507],
 [24,3648,3522,3507],[24,3648,3522,38921],
 [24,3648,38309,38921],[24,3648,38534,38921],[24,3648,38921],
 [24,3648,41069],[24,3648,41083,41069],[24,3648,41085,41069],
 [24,3683,3503,3507],[24,3683,3503,3677],
 [24,3683,3503,3714],[24,3683,3503,38331],
 [24,3683,3503,38557],[24,3683,3503,41850],
 [24,3683,3503,42593],[24,3683,3507],[24,3683,3517,3507],
 [24,3683,3517,44904],[24,3683,3522,3507],
 [24,3683,3522,38921],[24,3683,3677],[24,3683,3714],
 [24,3683,38331],[24,3683,38344,38331],[24,3683,38345,38331],
 [24,3683,38345,38921],[24,3683,38345,42193],
 [24,3683,38345,42936],[24,3683,38557],[24,3683,38563,38557],
 [24,3683,38563,38921],[24,3683,38563,46064],
 [24,3683,38563,47090],[24,3683,38564,38557],[24,3683,38921],
 [24,3683,41850],[24,3683,41858,41850],[24,3683,41858,42193],
 [24,3683,41858,44904],[24,3683,41858,46064],
 [24,3683,41865,41850],[24,3683,41992,47090],
 [24,3683,41993,42193],[24,3683,42193],[24,3683,42593],
 [24,3683,42599,42593],[24,3683,42599,42936],
 [24,3683,42599,44904],[24,3683,42599,47090],
 [24,3683,42604,42593],[24,3683,42668,46064],
 [24,3683,42669,42936],[24,3683,42936],[24,3683,44904],
 [24,3683,46064],[24,3683,47090],[24,3686,3677],
 [24,3686,41995],[24,3725,3714],[24,3725,42671],
 [24,5645,5705],[24,5645,38205],[24,5653,5645,5705],
 [24,5653,5645,38205],[24,5653,5696,5705],
 [24,5653,5696,6018],[24,5653,5696,6050],
 [24,5653,5696,39424],[24,5653,5696,39779],
 [24,5653,5696,45501],[24,5653,5696,46064],
 [24,5653,5699,5705],[24,5653,5699,47090],[24,5653,5705],
 [24,5653,6018],[24,5653,6050],[24,5653,38205],
 [24,5653,38212,38205],[24,5653,38212,38557],
 [24,5653,38212,39424],[24,5653,38212,40287],
 [24,5653,38224,38205],[24,5653,38224,38921],
 [24,5653,38224,39779],[24,5653,38224,40642],
 [24,5653,38529,45501],[24,5653,38534,38921],[24,5653,38557],
 [24,5653,38563,38557],[24,5653,38563,38921],
 [24,5653,38563,46064],[24,5653,38563,47090],
 [24,5653,38566,38557],[24,5653,38921],[24,5653,39424],
 [24,5653,39439,39424],[24,5653,39534,39779],[24,5653,39779],
 [24,5653,40287],[24,5653,40293,40287],[24,5653,40293,40642],
 [24,5653,40293,45501],[24,5653,40293,47090],
 [24,5653,40298,40287],[24,5653,40327,46064],
 [24,5653,40330,40642],[24,5653,40642],[24,5653,45501],
 [24,5653,46064],[24,5653,47090],[24,5690,5705],
 [24,5690,39193],[24,5692,5705],[24,5695,5705],
 [24,5695,44904],[24,5696,5705],[24,5696,6018],
 [24,5696,6050],[24,5696,39424],[24,5696,39779],
 [24,5696,45501],[24,5696,46064],[24,5699,5705],
 [24,5699,47090],[24,5778,5690,5705],[24,5778,5690,39193],
 [24,5778,5695,5705],[24,5778,5695,44904],
 [24,5778,5696,5705],[24,5778,5696,6018],
 [24,5778,5696,6050],[24,5778,5696,39424],
 [24,5778,5696,39779],[24,5778,5696,45501],
 [24,5778,5696,46064],[24,5778,5705],[24,5778,6018],
 [24,5778,6050],[24,5778,39193],[24,5778,39197,39193],
 [24,5778,39197,39424],[24,5778,39197,41069],
 [24,5778,39197,41850],[24,5778,39208,39193],
 [24,5778,39208,39779],[24,5778,39208,41411],
 [24,5778,39208,42193],[24,5778,39400,39779],[24,5778,39424],
 [24,5778,39433,39424],[24,5778,39779],[24,5778,41069],
 [24,5778,41078,41069],[24,5778,41078,41411],
 [24,5778,41078,44904],[24,5778,41078,45501],
 [24,5778,41083,41069],[24,5778,41147,46064],
 [24,5778,41148,41411],[24,5778,41411],[24,5778,41850],
 [24,5778,41858,41850],[24,5778,41858,42193],
 [24,5778,41858,44904],[24,5778,41858,46064],
 [24,5778,41861,41850],[24,5778,41893,45501],
 [24,5778,41894,42193],[24,5778,42193],[24,5778,44904],
 [24,5778,45501],[24,5778,46064],[24,5782,5690,5705],
 [24,5782,5690,39193],[24,5782,5699,5705],
 [24,5782,5699,47090],[24,5782,5705],[24,5782,39193],
 [24,5782,39201,39193],[24,5782,39214,39193],
 [24,5782,41212,47090],[24,5782,41992,47090],[24,5782,47090],
 [24,5857,5692,5705],[24,5857,5695,5705],
 [24,5857,5695,44904],[24,5857,5699,5705],
 [24,5857,5699,47090],[24,5857,5705],[24,5857,39276,42593],
 [24,5857,39287,42936],[24,5857,39404],[24,5857,39532],
 [24,5857,42593],[24,5857,42599,42593],[24,5857,42599,42936],
 [24,5857,42599,44904],[24,5857,42599,47090],[24,5857,42936],
 [24,5857,44904],[24,5857,47090],[24,5858,6018],
 [24,5858,42639],[24,5859,6050],[24,5859,42671],
 [24,7725,7828],[24,7725,38205],[24,7727,7725,7828],
 [24,7727,7725,38205],[24,7727,7812,7828],
 [24,7727,7812,7875],[24,7727,7812,7950],
 [24,7727,7812,40055],[24,7727,7812,40642],
 [24,7727,7812,41411],[24,7727,7812,42936],
 [24,7727,7813,7828],[24,7727,7813,42193],[24,7727,7828],
 [24,7727,7875],[24,7727,7950],[24,7727,38205],
 [24,7727,38206,38205],[24,7727,38206,38331],
 [24,7727,38206,39193],[24,7727,38206,40055],
 [24,7727,38224,38205],[24,7727,38224,38921],
 [24,7727,38224,39779],[24,7727,38224,40642],
 [24,7727,38305,41411],[24,7727,38309,38921],[24,7727,38331],
 [24,7727,38345,38331],[24,7727,38345,38921],
 [24,7727,38345,42193],[24,7727,38345,42936],
 [24,7727,38347,38331],[24,7727,38921],[24,7727,39193],
 [24,7727,39208,39193],[24,7727,39208,39779],
 [24,7727,39208,41411],[24,7727,39208,42193],
 [24,7727,39214,39193],[24,7727,39287,42936],
 [24,7727,39289,39779],[24,7727,39779],[24,7727,40055],
 [24,7727,40073,40055],[24,7727,40111,40642],[24,7727,40642],
 [24,7727,41411],[24,7727,42193],[24,7727,42936],
 [24,7733,7725,7828],[24,7733,7725,38205],
 [24,7733,7818,7828],[24,7733,7818,40287],
 [24,7733,7819,7828],[24,7733,7828],[24,7733,38205],
 [24,7733,38212,38205],[24,7733,38212,38557],
 [24,7733,38212,39424],[24,7733,38212,40287],[24,7733,38530],
 [24,7733,38557],[24,7733,38564,38557],[24,7733,39424],
 [24,7733,39433,39424],[24,7733,39532],[24,7733,40287],
 [24,7812,7828],[24,7812,7875],[24,7812,7950],
 [24,7812,40055],[24,7812,40642],[24,7812,41411],
 [24,7812,42936],[24,7813,7828],[24,7813,42193],
 [24,7817,7828],[24,7817,44904],[24,7818,7828],
 [24,7818,40287],[24,7819,7828],[24,7858,7812,7828],
 [24,7858,7812,7875],[24,7858,7812,7950],
 [24,7858,7812,40055],[24,7858,7812,40642],
 [24,7858,7812,41411],[24,7858,7812,42936],
 [24,7858,7817,7828],[24,7858,7817,44904],
 [24,7858,7818,7828],[24,7858,7818,40287],[24,7858,7828],
 [24,7858,7875],[24,7858,7950],[24,7858,40055],
 [24,7858,40058,40055],[24,7858,40058,40287],
 [24,7858,40058,41069],[24,7858,40058,42593],
 [24,7858,40068,40055],[24,7858,40261,40642],[24,7858,40287],
 [24,7858,40293,40287],[24,7858,40293,40642],
 [24,7858,40293,45501],[24,7858,40293,47090],[24,7858,40642],
 [24,7858,41069],[24,7858,41078,41069],[24,7858,41078,41411],
 [24,7858,41078,44904],[24,7858,41078,45501],
 [24,7858,41085,41069],[24,7858,41212,47090],
 [24,7858,41213,41411],[24,7858,41411],[24,7858,42593],
 [24,7858,42599,42593],[24,7858,42599,42936],
 [24,7858,42599,44904],[24,7858,42599,47090],
 [24,7858,42602,42593],[24,7858,42634,45501],
 [24,7858,42635,42936],[24,7858,42936],[24,7858,44904],
 [24,7858,45501],[24,7858,47090],[24,7860,7875],
 [24,7860,41154],[24,7898,7813,7828],[24,7898,7813,42193],
 [24,7898,7817,7828],[24,7898,7817,44904],
 [24,7898,7819,7828],[24,7898,7828],[24,7898,40098,41850],
 [24,7898,40108],[24,7898,40263],[24,7898,40327,46064],
 [24,7898,41850],[24,7898,41858,41850],[24,7898,41858,42193],
 [24,7898,41858,44904],[24,7898,41858,46064],[24,7898,42193],
 [24,7898,44904],[24,7898,46064],[24,7899,7813,7828],
 [24,7899,7813,42193],[24,7899,7818,7828],
 [24,7899,7818,40287],[24,7899,7828],[24,7899,40099,40287],
 [24,7899,40287],[24,7899,40298,40287],[24,7899,41894,42193],
 [24,7899,41993,42193],[24,7899,42193],[24,7939,7950],
 [24,7939,42671],[24,38206,38205],[24,38206,38331],
 [24,38206,39193],[24,38206,40055],[24,38212,38205],
 [24,38212,38557],[24,38212,39424],[24,38212,40287],
 [24,38224,38205],[24,38224,38921],[24,38224,39779],
 [24,38224,40642],[24,38296,38557],[24,38305,41411],
 [24,38309,38921],[24,38335,38331],[24,38344,38331],
 [24,38345,38331],[24,38345,38921],[24,38345,42193],
 [24,38345,42936],[24,38347,38331],[24,38529,45501],
 [24,38534,38921],[24,38563,38557],[24,38563,38921],
 [24,38563,46064],[24,38563,47090],[24,38564,38557],
 [24,38566,38557],[24,39197,39193],[24,39197,39424],
 [24,39197,41069],[24,39197,41850],[24,39201,39193],
 [24,39208,39193],[24,39208,39779],[24,39208,41411],
 [24,39208,42193],[24,39214,39193],[24,39276,42593],
 [24,39277,39424],[24,39287,42936],[24,39289,39779],
 [24,39400,39779],[24,39433,39424],[24,39439,39424],
 [24,39534,39779],[24,40058,40055],[24,40058,40287],
 [24,40058,41069],[24,40058,42593],[24,40060,40055],
 [24,40068,40055],[24,40073,40055],[24,40098,41850],
 [24,40099,40287],[24,40111,40642],[24,40261,40642],
 [24,40293,40287],[24,40293,40642],[24,40293,45501],
 [24,40293,47090],[24,40298,40287],[24,40327,46064],
 [24,40330,40642],[24,41078,41069],[24,41078,41411],
 [24,41078,44904],[24,41078,45501],[24,41083,41069],
 [24,41085,41069],[24,41147,46064],[24,41148,41411],
 [24,41212,47090],[24,41213,41411],[24,41858,41850],
 [24,41858,42193],[24,41858,44904],[24,41858,46064],
 [24,41861,41850],[24,41865,41850],[24,41893,45501],
 [24,41894,42193],[24,41992,47090],[24,41993,42193],
 [24,42599,42593],[24,42599,42936],[24,42599,44904],
 [24,42599,47090],[24,42602,42593],[24,42604,42593],
 [24,42634,45501],[24,42635,42936],[24,42668,46064],
 [24,42669,42936],[30,23,1625],[30,23,3507],
 [30,23,3520,3507],[30,26,23,1625],[30,26,23,3507],
 [30,26,23,3520,3507],[30,26,1291],[30,26,1297,1658],
 [30,26,1297,38530],[30,26,1625],[30,26,1658],
 [30,26,3502,3507],[30,26,3502,41069],[30,26,3507],
 [30,26,3517,3507],[30,26,3517,44904],[30,26,3520,3507],
 [30,26,38305,41411],[30,26,38529,45501],[30,26,38530],
 [30,26,41069],[30,26,41078,41069],[30,26,41078,41411],
 [30,26,41078,44904],[30,26,41078,45501],[30,26,41411],
 [30,26,44904],[30,26,45501],[30,1297,1658],
 [30,1297,38530],[30,1576,1625],[30,1576,43971],
 [30,1577,1583],[30,1577,1658],[30,1577,44000],
 [30,1577,44004],[30,1577,44193],[30,1577,45418],
 [30,1619,1625],[30,1619,44825],[30,3502,3507],
 [30,3502,41069],[30,3506,3507],[30,3506,3794],
 [30,3506,38455],[30,3506,43965],[30,3517,3507],
 [30,3517,44904],[30,3520,3507],[30,3632,3502,3507],
 [30,3632,3502,41069],[30,3632,3506,3507],
 [30,3632,3506,3794],[30,3632,3506,38455],
 [30,3632,3506,43965],[30,3632,3507],[30,3632,3794],
 [30,3632,38293],[30,3632,38301],[30,3632,38449],
 [30,3632,38455],[30,3632,38526],[30,3632,41032,41069],
 [30,3632,41039],[30,3632,41069],[30,3632,41075,41069],
 [30,3632,43965],[30,3632,44000],[30,3797,3506,3507],
 [30,3797,3506,3794],[30,3797,3506,38455],
 [30,3797,3506,43965],[30,3797,3507],[30,3797,3517,3507],
 [30,3797,3517,44904],[30,3797,3794],[30,3797,38455],
 [30,3797,38458],[30,3797,38459],[30,3797,38718],
 [30,3797,38719],[30,3797,43965],[30,3797,43968,44904],
 [30,3797,44192],[30,3797,44193],[30,3797,44822,44904],
 [30,3797,44904],[30,3800,3794],[30,3800,44195],
 [30,38305,41411],[30,38529,45501],[30,41032,41069],
 [30,41043,41411],[30,41075,41069],[30,41078,41069],
 [30,41078,41411],[30,41078,44904],[30,41078,45501],
 [30,41303,41411],[30,43968,44904],[30,44003,45501],
 [30,44822,44904],[30,45417,45501],[49,23,1625],
 [49,23,3507],[49,23,3520,3507],[49,1630,1625],
 [49,1630,44983,45084],[49,1630,45084],[49,3520,3507],
 [49,3525,3507],[49,3525,45084],[49,4218,3507],
 [49,4218,3520,3507],[49,4218,3525,3507],
 [49,4218,3525,45084],[49,4218,38879],[49,4218,38880],
 [49,4218,44983,45084],[49,4218,45084],[49,44983,45084],
 [51,23,1625],[51,23,3507],[51,23,3520,3507],
 [51,1316,39015],[51,1632,1625],[51,1632,44985],
 [51,1633,1625],[51,1633,44986],[51,3520,3507],
 [51,3527,3507],[51,3527,39015],[51,4220,3507],
 [51,4220,3520,3507],[51,4220,3527,3507],
 [51,4220,3527,39015],[51,4220,38881,39015],[51,4220,39015],
 [51,4220,44985],[51,4220,44986],[51,38881,39015],
 [71,69,90,1336],[71,69,90,5692,5705],[71,69,90,5705],
 [71,69,202],[71,69,236,202],[71,69,1336],
 [71,69,4575,5705],[71,69,4821,5705],[71,69,5692,5705],
 [71,69,5705],[71,69,9788],[71,69,9963],[71,69,17232],
 [71,69,17407],[71,70,268],[71,70,4624],[71,89,90,1336],
 [71,89,90,5692,5705],[71,89,90,5705],[71,89,1291],
 [71,89,1336],[71,89,1377],[71,89,1391,1377],
 [71,89,1391,40108],[71,89,5645,5705],[71,89,5645,38205],
 [71,89,5690,5705],[71,89,5690,39193],[71,89,5692,5705],
 [71,89,5705],[71,89,38205],[71,89,38206,38205],
 [71,89,38206,38331],[71,89,38206,39193],
 [71,89,38206,40055],[71,89,38331],[71,89,38344,38331],
 [71,89,39193],[71,89,40055],[71,89,40068,40055],
 [71,89,40108],[71,90,1336],[71,90,5692,5705],
 [71,90,5705],[71,199,202],[71,199,268],[71,199,328],
 [71,199,8715],[71,199,8962],[71,199,10854],
 [71,199,12747],[71,218,202],[71,220,202],
 [71,220,236,202],[71,220,1377],[71,220,1391,1377],
 [71,220,1391,40108],[71,220,9829],[71,220,9843],
 [71,220,9924],[71,220,17273],[71,220,17287],
 [71,220,17368],[71,220,40108],[71,221,202],[71,236,202],
 [71,281,268],[71,281,11043],[71,282,268],[71,282,1336],
 [71,282,11044],[71,282,11048],[71,282,11741],
 [71,282,22192],[71,283,268],[71,283,1377],[71,283,11045],
 [71,283,11047],[71,283,11782],[71,283,22233],
 [71,284,268],[71,284,11046],[71,299,268],[71,299,11061],
 [71,343,328],[71,343,12819],[71,344,328],[71,344,1336],
 [71,344,12820],[71,344,12824],[71,344,13632],
 [71,344,18943],[71,345,328],[71,345,1377],[71,345,12821],
 [71,345,12823],[71,345,13673],[71,345,18984],
 [71,346,328],[71,346,12822],[71,361,328],[71,361,12837],
 [71,1391,1377],[71,1391,40108],[71,4555,8715],
 [71,4559,4575,5705],[71,4559,4577,4575,5705],
 [71,4559,4577,5690,5705],[71,4559,4577,5690,39193],
 [71,4559,4577,5705],[71,4559,4577,9786,39193],
 [71,4559,4577,9884],[71,4559,4577,9924],
 [71,4559,4577,39193],[71,4559,4880,5705],
 [71,4559,4882,4880,5705],[71,4559,4882,5690,5705],
 [71,4559,4882,5690,39193],[71,4559,4882,5705],
 [71,4559,4882,18941,39193],[71,4559,4882,19039],
 [71,4559,4882,19079],[71,4559,4882,39193],
 [71,4559,4995,5705],[71,4559,5690,5705],
 [71,4559,5690,39193],[71,4559,5705],[71,4559,8962],
 [71,4559,8976,8962],[71,4559,8976,8978,8962],
 [71,4559,8976,8979,8962],[71,4559,8976,9786,39193],
 [71,4559,8976,18941,39193],[71,4559,8976,22190,39193],
 [71,4559,8976,39193],[71,4559,8978,8962],
 [71,4559,8979,8962],[71,4559,8993,8962],
 [71,4559,9786,39193],[71,4559,9884],[71,4559,9924],
 [71,4559,18941,39193],[71,4559,19039],[71,4559,19079],
 [71,4559,22190,39193],[71,4559,22288],[71,4559,22328],
 [71,4559,39193],[71,4574,4575,5705],[71,4574,5645,5705],
 [71,4574,5645,38205],[71,4574,5705],[71,4574,9741,38205],
 [71,4574,9758],[71,4574,9843],[71,4574,38205],
 [71,4575,5705],[71,4577,4575,5705],[71,4577,5690,5705],
 [71,4577,5690,39193],[71,4577,5705],[71,4577,9786,39193],
 [71,4577,9884],[71,4577,9924],[71,4577,39193],
 [71,4621,10854],[71,4637,4638,5705],[71,4637,5645,5705],
 [71,4637,5645,38205],[71,4637,5705],[71,4637,11694,38205],
 [71,4637,11711],[71,4637,11796],[71,4637,38205],
 [71,4638,5705],[71,4640,4638,5705],[71,4640,5690,5705],
 [71,4640,5690,39193],[71,4640,5705],[71,4640,11739,39193],
 [71,4640,11837],[71,4640,11877],[71,4640,39193],
 [71,4683,4699,4700,5705],[71,4683,4699,5645,5705],
 [71,4683,4699,5645,38205],[71,4683,4699,5705],
 [71,4683,4699,13585,38205],[71,4683,4699,13602],
 [71,4683,4699,13687],[71,4683,4699,38205],
 [71,4683,4700,5705],[71,4683,4820,4821,5705],
 [71,4683,4820,5645,5705],[71,4683,4820,5645,38205],
 [71,4683,4820,5705],[71,4683,4820,17185,38205],
 [71,4683,4820,17202],[71,4683,4820,17287],
 [71,4683,4820,38205],[71,4683,4821,5705],
 [71,4683,4995,5705],[71,4683,5645,5705],
 [71,4683,5645,38205],[71,4683,5705],[71,4683,12747],
 [71,4683,12760,12747],[71,4683,12761,12747],
 [71,4683,12761,12760,12747],[71,4683,12761,12762,12747],
 [71,4683,12761,13585,38205],[71,4683,12761,17185,38205],
 [71,4683,12761,22145,38205],[71,4683,12761,38205],
 [71,4683,12762,12747],[71,4683,12778,12747],
 [71,4683,13585,38205],[71,4683,13602],[71,4683,13687],
 [71,4683,17185,38205],[71,4683,17202],[71,4683,17287],
 [71,4683,22145,38205],[71,4683,22162],[71,4683,22247],
 [71,4683,38205],[71,4699,4700,5705],[71,4699,5645,5705],
 [71,4699,5645,38205],[71,4699,5705],[71,4699,13585,38205],
 [71,4699,13602],[71,4699,13687],[71,4699,38205],
 [71,4700,5705],[71,4702,4555,8715],[71,4702,4575,5705],
 [71,4702,4577,4575,5705],[71,4702,4577,5690,5705],
 [71,4702,4577,5690,39193],[71,4702,4577,5705],
 [71,4702,4577,9786,39193],[71,4702,4577,9884],
 [71,4702,4577,9924],[71,4702,4577,39193],
 [71,4702,4638,5705],[71,4702,4640,4638,5705],
 [71,4702,4640,5690,5705],[71,4702,4640,5690,39193],
 [71,4702,4640,5705],[71,4702,4640,11739,39193],
 [71,4702,4640,11837],[71,4702,4640,11877],
 [71,4702,4640,39193],[71,4702,4700,5705],
 [71,4702,5690,5705],[71,4702,5690,39193],[71,4702,5705],
 [71,4702,8715],[71,4702,8734,8715],[71,4702,8736,8715],
 [71,4702,8737,8715],[71,4702,8751,8715],
 [71,4702,9786,39193],[71,4702,9884],[71,4702,9924],
 [71,4702,11739,39193],[71,4702,11837],[71,4702,11877],
 [71,4702,13630,39193],[71,4702,13728],[71,4702,13768],
 [71,4702,39193],[71,4820,4821,5705],[71,4820,5645,5705],
 [71,4820,5645,38205],[71,4820,5705],[71,4820,17185,38205],
 [71,4820,17202],[71,4820,17287],[71,4820,38205],
 [71,4821,5705],[71,4823,4821,5705],[71,4823,5690,5705],
 [71,4823,5690,39193],[71,4823,5705],[71,4823,17230,39193],
 [71,4823,17328],[71,4823,17368],[71,4823,39193],
 [71,4879,4621,10854],[71,4879,4637,4638,5705],
 [71,4879,4637,5645,5705],[71,4879,4637,5645,38205],
 [71,4879,4637,5705],[71,4879,4637,11694,38205],
 [71,4879,4637,11711],[71,4879,4637,11796],
 [71,4879,4637,38205],[71,4879,4638,5705],
 [71,4879,4820,4821,5705],[71,4879,4820,5645,5705],
 [71,4879,4820,5645,38205],[71,4879,4820,5705],
 [71,4879,4820,17185,38205],[71,4879,4820,17202],
 [71,4879,4820,17287],[71,4879,4820,38205],
 [71,4879,4821,5705],[71,4879,4880,5705],
 [71,4879,5645,5705],[71,4879,5645,38205],[71,4879,5705],
 [71,4879,10854],[71,4879,10869,10854],[71,4879,10870,10854],
 [71,4879,10871,10854],[71,4879,10887,10854],
 [71,4879,11694,38205],[71,4879,11711],[71,4879,11796],
 [71,4879,17185,38205],[71,4879,17202],[71,4879,17287],
 [71,4879,18896,38205],[71,4879,18913],[71,4879,18998],
 [71,4879,38205],[71,4880,5705],[71,4882,4880,5705],
 [71,4882,5690,5705],[71,4882,5690,39193],[71,4882,5705],
 [71,4882,18941,39193],[71,4882,19039],[71,4882,19079],
 [71,4882,39193],[71,4995,5705],[71,5645,5705],
 [71,5645,38205],[71,5690,5705],[71,5690,39193],
 [71,5692,5705],[71,8733,8715],[71,8734,8715],
 [71,8735,8715],[71,8736,8715],[71,8737,8715],
 [71,8738,8715],[71,8738,8735,8715],[71,8738,8736,8715],
 [71,8738,9828,40055],[71,8738,11781,40055],
 [71,8738,13672,40055],[71,8738,40055],[71,8751,8715],
 [71,8975,8962],[71,8976,8962],[71,8976,8978,8962],
 [71,8976,8979,8962],[71,8976,9786,39193],
 [71,8976,18941,39193],[71,8976,22190,39193],[71,8976,39193],
 [71,8977,8962],[71,8978,8962],[71,8979,8962],
 [71,8980,8962],[71,8993,8962],[71,9741,38205],
 [71,9744,38331],[71,9786,39193],[71,9828,40055],
 [71,10869,10854],[71,10870,10854],[71,10871,10854],
 [71,10872,10854],[71,10873,10854],[71,10874,10854],
 [71,10874,10869,10854],[71,10874,10873,10854],
 [71,10874,11697,38331],[71,10874,17188,38331],
 [71,10874,18899,38331],[71,10874,38331],[71,10887,10854],
 [71,11694,38205],[71,11697,38331],[71,11739,39193],
 [71,11781,40055],[71,12760,12747],[71,12761,12747],
 [71,12761,12760,12747],[71,12761,12762,12747],
 [71,12761,13585,38205],[71,12761,17185,38205],
 [71,12761,22145,38205],[71,12761,38205],[71,12762,12747],
 [71,12763,12747],[71,12764,12747],[71,12765,12747],
 [71,12778,12747],[71,13585,38205],[71,13588,38331],
 [71,13630,39193],[71,13672,40055],[71,17185,38205],
 [71,17188,38331],[71,17230,39193],[71,17272,40055],
 [71,18896,38205],[71,18899,38331],[71,18941,39193],
 [71,18983,40055],[71,22145,38205],[71,22148,38331],
 [71,22190,39193],[71,22232,40055],[71,38206,38205],
 [71,38206,38331],[71,38206,39193],[71,38206,40055],
 [71,38344,38331],[71,40068,40055],[95,90,1336],
 [95,90,5692,5705],[95,90,5705],[95,1337,1336],
 [95,1337,39274,39313],[95,1337,39313],[95,5692,5705],
 [95,5693,5705],[95,5693,39313],[95,5855,5692,5705],
 [95,5855,5693,5705],[95,5855,5693,39313],[95,5855,5705],
 [95,5855,39274,39313],[95,5855,39313],[95,5855,42526],
 [95,5855,42563],[95,39274,39313],[100,90,1336],
 [100,90,5692,5705],[100,90,5705],[100,1342,1336],
 [100,1342,39279],[100,1355,1336],[100,1355,39292],
 [100,1724,46593],[100,5692,5705],[100,5698,5705],
 [100,5698,46593],[100,5860,5692,5705],[100,5860,5698,5705],
 [100,5860,5698,46593],[100,5860,5705],[100,5860,39279],
 [100,5860,39292],[100,5860,42701,46593],[100,5860,46593],
 [100,42701,46593],[109,89,90,1336],[109,89,90,5692,5705],
 [109,89,90,5705],[109,89,1291],[109,89,1336],
 [109,89,1377],[109,89,1391,1377],[109,89,1391,40108],
 [109,89,5645,5705],[109,89,5645,38205],[109,89,5690,5705],
 [109,89,5690,39193],[109,89,5692,5705],[109,89,5705],
 [109,89,38205],[109,89,38206,38205],[109,89,38206,38331],
 [109,89,38206,39193],[109,89,38206,40055],[109,89,38331],
 [109,89,38344,38331],[109,89,39193],[109,89,40055],
 [109,89,40068,40055],[109,89,40108],[109,90,1336],
 [109,90,5692,5705],[109,90,5705],[109,1351,1336],
 [109,1351,39288],[109,1357,1336],[109,1357,39294],
 [109,1391,1377],[109,1391,40108],[109,1393,1377],
 [109,1393,1984],[109,1393,40110],[109,1393,40116],
 [109,1393,40620],[109,1393,42220],[109,5645,5705],
 [109,5645,38205],[109,5664,5645,5705],[109,5664,5645,38205],
 [109,5664,5705],[109,5664,5707,5705],[109,5664,5707,6340],
 [109,5664,5707,39759],[109,5664,5707,49500],[109,5664,6340],
 [109,5664,38205],[109,5664,38223,38205],
 [109,5664,38229,38205],[109,5664,38801],[109,5664,38807],
 [109,5664,38856],[109,5664,39759],[109,5664,40565],
 [109,5664,40571],[109,5664,40620],[109,5664,49500],
 [109,5690,5705],[109,5690,39193],[109,5692,5705],
 [109,5707,5705],[109,5707,6340],[109,5707,39759],
 [109,5707,49500],[109,5790,5690,5705],[109,5790,5690,39193],
 [109,5790,5705],[109,5790,5707,5705],[109,5790,5707,6340],
 [109,5790,5707,39759],[109,5790,5707,49500],[109,5790,6340],
 [109,5790,39193],[109,5790,39209,39193],
 [109,5790,39215,39193],[109,5790,39759],[109,5790,41385],
 [109,5790,41391],[109,5790,41440],[109,5790,42165],
 [109,5790,42171],[109,5790,42220],[109,5790,49500],
 [109,5869,6340],[109,5869,42961],[109,38206,38205],
 [109,38206,38331],[109,38206,39193],[109,38206,40055],
 [109,38223,38205],[109,38229,38205],[109,38344,38331],
 [109,38346,38331],[109,38352,38331],[109,39209,39193],
 [109,39215,39193],[109,40068,40055],[109,40070,40055],
 [109,40076,40055],[134,157,1424,1698],[134,157,1424,41154],
 [134,157,1698],[134,157,7860,7875],[134,157,7860,41154],
 [134,157,7875],[134,157,41154],[134,221,202],
 [134,228,202],[134,228,1698],[134,228,10150],
 [134,228,17594],[134,1424,1698],[134,1424,41154],
 [134,6657,7875],[134,6657,9891],[134,6903,7875],
 [134,6903,17335],[134,7860,7875],[134,7860,41154],
 [135,157,1424,1698],[135,157,1424,41154],[135,157,1698],
 [135,157,7860,7875],[135,157,7860,41154],[135,157,7875],
 [135,157,41154],[135,284,268],[135,284,11046],
 [135,291,268],[135,291,1698],[135,291,11053],
 [135,291,11068],[135,291,12103],[135,291,22554],
 [135,1424,1698],[135,1424,41154],[135,6720,7875],
 [135,6720,11844],[135,7077,7875],[135,7860,7875],
 [135,7860,41154],[136,156,1377],[136,156,1658],
 [136,156,1761],[136,156,7813,7828],[136,156,7813,42193],
 [136,156,7818,7828],[136,156,7818,40287],[136,156,7828],
 [136,156,7899,7813,7828],[136,156,7899,7813,42193],
 [136,156,7899,7818,7828],[136,156,7899,7818,40287],
 [136,156,7899,7828],[136,156,7899,40099,40287],
 [136,156,7899,40287],[136,156,7899,40298,40287],
 [136,156,7899,41894,42193],[136,156,7899,41993,42193],
 [136,156,7899,42193],[136,156,40099,40287],[136,156,40287],
 [136,156,40298,40287],[136,156,41894,42193],
 [136,156,41993,42193],[136,156,42193],[136,345,328],
 [136,345,1377],[136,345,12821],[136,345,12823],
 [136,345,13673],[136,345,18984],[136,352,328],
 [136,352,1658],[136,352,12828],[136,352,12838],
 [136,352,13954],[136,352,19265],[136,355,328],
 [136,355,1761],[136,355,12831],[136,355,12842],
 [136,355,14057],[136,355,19368],[136,6781,7828],
 [136,6783,6781,7828],[136,6783,7813,7828],
 [136,6783,7813,42193],[136,6783,7828],[136,6783,13673],
 [136,6783,13692],[136,6783,13769,42193],[136,6783,42193],
 [136,6788,6781,7828],[136,6788,7818,7828],
 [136,6788,7818,40287],[136,6788,7828],
 [136,6788,13678,40287],[136,6788,13954],[136,6788,14053],
 [136,6788,40287],[136,6961,7828],[136,6963,6961,7828],
 [136,6963,7813,7828],[136,6963,7813,42193],[136,6963,7828],
 [136,6963,18984],[136,6963,19003],[136,6963,19080,42193],
 [136,6963,42193],[136,6968,6961,7828],[136,6968,7818,7828],
 [136,6968,7818,40287],[136,6968,7828],
 [136,6968,18989,40287],[136,6968,19265],[136,6968,19364],
 [136,6968,40287],[136,7813,7828],[136,7813,42193],
 [136,7818,7828],[136,7818,40287],[136,7899,7813,7828],
 [136,7899,7813,42193],[136,7899,7818,7828],
 [136,7899,7818,40287],[136,7899,7828],
 [136,7899,40099,40287],[136,7899,40287],
 [136,7899,40298,40287],[136,7899,41894,42193],
 [136,7899,41993,42193],[136,7899,42193],[136,13678,40287],
 [136,13769,42193],[136,18989,40287],[136,19080,42193],
 [136,40099,40287],[136,40298,40287],[136,41894,42193],
 [136,41993,42193],[144,157,1424,1698],[144,157,1424,41154],
 [144,157,1698],[144,157,7860,7875],[144,157,7860,41154],
 [144,157,7875],[144,157,41154],[144,813,1698],
 [144,813,27010],[144,1424,1698],[144,1424,41154],
 [144,7242,7875],[144,7242,26751],[144,7860,7875],
 [144,7860,41154],[149,145,157,1424,1698],
 [149,145,157,1424,41154],[149,145,157,1698],
 [149,145,157,7860,7875],[149,145,157,7860,41154],
 [149,145,157,7875],[149,145,157,41154],[149,145,859],
 [149,145,866,1698],[149,145,866,28388],[149,145,1424,1698],
 [149,145,1424,41154],[149,145,1698],[149,145,7295,7875],
 [149,145,7295,28129],[149,145,7302],[149,145,7860,7875],
 [149,145,7860,41154],[149,145,7875],[149,145,28114],
 [149,145,28129],[149,145,28388],[149,145,41154],
 [149,157,1424,1698],[149,157,1424,41154],[149,157,1698],
 [149,157,7860,7875],[149,157,7860,41154],[149,157,7875],
 [149,157,41154],[149,866,1698],[149,866,28388],
 [149,1068,1698],[149,1068,33390],[149,1424,1698],
 [149,1424,41154],[149,7295,7875],[149,7295,28129],
 [149,7497,7875],[149,7497,33131],[149,7860,7875],
 [149,7860,41154],[150,157,1424,1698],[150,157,1424,41154],
 [150,157,1698],[150,157,7860,7875],[150,157,7860,41154],
 [150,157,7875],[150,157,41154],[150,1116,1698],
 [150,1116,34518],[150,1424,1698],[150,1424,41154],
 [150,7545,7875],[150,7545,34259],[150,7860,7875],
 [150,7860,41154],[152,147,157,1424,1698],
 [152,147,157,1424,41154],[152,147,157,1698],
 [152,147,157,7860,7875],[152,147,157,7860,41154],
 [152,147,157,7875],[152,147,157,41154],[152,147,962],
 [152,147,969,1698],[152,147,969,30989],[152,147,1424,1698],
 [152,147,1424,41154],[152,147,1698],[152,147,7398,7875],
 [152,147,7398,30730],[152,147,7405],[152,147,7860,7875],
 [152,147,7860,41154],[152,147,7875],[152,147,30715],
 [152,147,30730],[152,147,30989],[152,147,41154],
 [152,157,1424,1698],[152,157,1424,41154],[152,157,1698],
 [152,157,7860,7875],[152,157,7860,41154],[152,157,7875],
 [152,157,41154],[152,969,1698],[152,969,30989],
 [152,1209,1698],[152,1209,36634],[152,1424,1698],
 [152,1424,41154],[152,7398,7875],[152,7398,30730],
 [152,7638,7875],[152,7638,36375],[152,7860,7875],
 [152,7860,41154],[167,156,1377],[167,156,1658],
 [167,156,1761],[167,156,7813,7828],[167,156,7813,42193],
 [167,156,7818,7828],[167,156,7818,40287],[167,156,7828],
 [167,156,7899,7813,7828],[167,156,7899,7813,42193],
 [167,156,7899,7818,7828],[167,156,7899,7818,40287],
 [167,156,7899,7828],[167,156,7899,40099,40287],
 [167,156,7899,40287],[167,156,7899,40298,40287],
 [167,156,7899,41894,42193],[167,156,7899,41993,42193],
 [167,156,7899,42193],[167,156,40099,40287],[167,156,40287],
 [167,156,40298,40287],[167,156,41894,42193],
 [167,156,41993,42193],[167,156,42193],[167,160,1560],
 [167,160,7996],[167,165,8168],[167,1379,1377],
 [167,1379,40096],[167,1384,1377],[167,1384,40101],
 [167,1386,1377],[167,1386,1798],[167,1386,40103],
 [167,1386,40119],[167,1386,40434],[167,1386,42034],
 [167,1393,1377],[167,1393,1984],[167,1393,40110],
 [167,1393,40116],[167,1393,40620],[167,1393,42220],
 [167,1540,1551],[167,1540,1658],[167,1540,1719],
 [167,1540,43330],[167,1540,43332,43330],
 [167,1540,43338,43330],[167,1540,43339,43330],
 [167,1540,43468,47575],[167,1540,45359,47575],
 [167,1540,46448,47575],[167,1540,47575],[167,1543,1761],
 [167,1543,43441],[167,1718,1761],[167,1718,46421],
 [167,1751,1761],[167,1751,46948],[167,1758,1761],
 [167,1758,47137],[167,7813,7828],[167,7813,42193],
 [167,7815,7828],[167,7815,7996],[167,7815,40196],
 [167,7815,43643],[167,7818,7828],[167,7818,40287],
 [167,7820,7828],[167,7820,8168],[167,7822,7828],
 [167,7822,47575],[167,7896,7813,7828],[167,7896,7813,42193],
 [167,7896,7815,7828],[167,7896,7815,7996],
 [167,7896,7815,40196],[167,7896,7815,43643],[167,7896,7828],
 [167,7896,7996],[167,7896,40096],[167,7896,40119],
 [167,7896,40190],[167,7896,40196],[167,7896,40689],
 [167,7896,41786,42193],[167,7896,41796],[167,7896,42193],
 [167,7896,42199,42193],[167,7896,43643],[167,7896,43733],
 [167,7899,7813,7828],[167,7899,7813,42193],
 [167,7899,7818,7828],[167,7899,7818,40287],[167,7899,7828],
 [167,7899,40099,40287],[167,7899,40287],
 [167,7899,40298,40287],[167,7899,41894,42193],
 [167,7899,41993,42193],[167,7899,42193],
 [167,7901,7813,7828],[167,7901,7813,42193],
 [167,7901,7820,7828],[167,7901,7820,8168],[167,7901,7828],
 [167,7901,8168],[167,7901,40101],[167,7901,40116],
 [167,7901,40365],[167,7901,40686],[167,7901,41961,42193],
 [167,7901,42193],[167,7901,42196,42193],
 [167,7903,7813,7828],[167,7903,7813,42193],
 [167,7903,7822,7828],[167,7903,7822,47575],[167,7903,7828],
 [167,7903,40103],[167,7903,40110],[167,7903,40428],
 [167,7903,40617],[167,7903,42024,42193],
 [167,7903,42024,47575],[167,7903,42193],[167,7903,47575],
 [167,7976,7815,7828],[167,7976,7815,7996],
 [167,7976,7815,40196],[167,7976,7815,43643],
 [167,7976,7818,7828],[167,7976,7818,40287],
 [167,7976,7820,7828],[167,7976,7820,8168],[167,7976,7828],
 [167,7976,7996],[167,7976,8168],[167,7976,40176,40287],
 [167,7976,40176,43330],[167,7976,40193],[167,7976,40196],
 [167,7976,40287],[167,7976,40301,40287],
 [167,7976,40301,47266],[167,7976,40371],[167,7976,43330],
 [167,7976,43338,43330],[167,7976,43348,43330],
 [167,7976,43437],[167,7976,43444,47266],[167,7976,43640],
 [167,7976,43643],[167,7976,45531],[167,7976,45534],
 [167,7976,46417],[167,7976,46623],[167,7976,47116,47266],
 [167,7976,47266],[167,7980,7815,7828],[167,7980,7815,7996],
 [167,7980,7815,40196],[167,7980,7815,43643],
 [167,7980,7822,7828],[167,7980,7822,47575],[167,7980,7828],
 [167,7980,7996],[167,7980,40180],[167,7980,40187],
 [167,7980,40196],[167,7980,40434],[167,7980,40623],
 [167,7980,43468,47575],[167,7980,43478],[167,7980,43643],
 [167,7980,43667],[167,7980,47575],[167,7980,47584,47575],
 [167,8088,7818,7828],[167,8088,7818,40287],
 [167,8088,7822,7828],[167,8088,7822,47575],[167,8088,7828],
 [167,8088,40287],[167,8088,40288,40287],
 [167,8088,40295,40287],[167,8088,45359,47575],
 [167,8088,46944,47575],[167,8088,47575],
 [167,8155,7820,7828],[167,8155,7820,8168],
 [167,8155,7822,7828],[167,8155,7822,47575],[167,8155,7828],
 [167,8155,8168],[167,8155,40355],[167,8155,40362],
 [167,8155,40431],[167,8155,40620],[167,8155,46448,47575],
 [167,8155,47575],[167,8155,47581,47575],[167,40099,40287],
 [167,40176,40287],[167,40176,43330],[167,40288,40287],
 [167,40295,40287],[167,40298,40287],[167,41776,43330],
 [167,41786,42193],[167,41894,42193],[167,41961,42193],
 [167,41993,42193],[167,42024,42193],[167,42024,47575],
 [167,43332,43330],[167,43338,43330],[167,43339,43330],
 [167,43342,43330],[167,43468,47575],[167,45359,47575],
 [167,46448,47575],[167,46944,47575],[168,156,1377],
 [168,156,1658],[168,156,1761],[168,156,7813,7828],
 [168,156,7813,42193],[168,156,7818,7828],
 [168,156,7818,40287],[168,156,7828],
 [168,156,7899,7813,7828],[168,156,7899,7813,42193],
 [168,156,7899,7818,7828],[168,156,7899,7818,40287],
 [168,156,7899,7828],[168,156,7899,40099,40287],
 [168,156,7899,40287],[168,156,7899,40298,40287],
 [168,156,7899,41894,42193],[168,156,7899,41993,42193],
 [168,156,7899,42193],[168,156,40099,40287],[168,156,40287],
 [168,156,40298,40287],[168,156,41894,42193],
 [168,156,41993,42193],[168,156,42193],[168,161,8032],
 [168,178,2071],[168,178,8507],[168,1387,1377],
 [168,1387,1827],[168,1387,1855],[168,1387,40104,40450],
 [168,1387,40117,42362],[168,1387,40450],
 [168,1387,40462,40450],[168,1387,40463,40450],
 [168,1387,42062,42362],[168,1387,42091,42362],
 [168,1387,42362],[168,1397,1377],[168,1397,40114],
 [168,1577,1583],[168,1577,1658],[168,1577,44000],
 [168,1577,44004],[168,1577,44193],[168,1577,45418],
 [168,1580,1761],[168,1580,44107,44394],[168,1580,44394],
 [168,1653,1658],[168,1653,1823],[168,1653,45389],
 [168,1653,45394],[168,1653,45529],[168,1653,48014],
 [168,1666,1658],[168,1666,45532],[168,1667,1658],
 [168,1667,45533],[168,1752,1761],[168,1752,46978],
 [168,1753,1761],[168,1753,47007],[168,1765,1761],
 [168,1765,47207],[168,1766,1761],[168,1766,47208],
 [168,7813,7828],[168,7813,42193],[168,7816,7828],
 [168,7816,8032],[168,7818,7828],[168,7818,40287],
 [168,7823,7828],[168,7823,40450],[168,7833,7828],
 [168,7833,8507],[168,7833,40707],[168,7833,49887],
 [168,7897,7813,7828],[168,7897,7813,42193],
 [168,7897,7816,7828],[168,7897,7816,8032],[168,7897,7828],
 [168,7897,7833,7828],[168,7897,7833,8507],
 [168,7897,7833,40707],[168,7897,7833,49887],[168,7897,8032],
 [168,7897,8507],[168,7897,40097],[168,7897,40114],
 [168,7897,40117,42362],[168,7897,40227,44394],
 [168,7897,40231],[168,7897,40687],[168,7897,40688],
 [168,7897,40707],[168,7897,40708],[168,7897,41823,42193],
 [168,7897,41823,44394],[168,7897,42193],
 [168,7897,42197,42193],[168,7897,42197,42362],
 [168,7897,42307,42362],[168,7897,42362],[168,7897,44307],
 [168,7897,44394],[168,7897,44397,44394],[168,7897,49887],
 [168,7897,49888],[168,7899,7813,7828],[168,7899,7813,42193],
 [168,7899,7818,7828],[168,7899,7818,40287],[168,7899,7828],
 [168,7899,40099,40287],[168,7899,40287],
 [168,7899,40298,40287],[168,7899,41894,42193],
 [168,7899,41993,42193],[168,7899,42193],
 [168,7904,7813,7828],[168,7904,7813,42193],
 [168,7904,7823,7828],[168,7904,7823,40450],[168,7904,7828],
 [168,7904,40104,40450],[168,7904,40450],
 [168,7904,40458,40450],[168,7904,42054,42193],
 [168,7904,42083,42193],[168,7904,42193],
 [168,8013,7816,7828],[168,8013,7816,8032],
 [168,8013,7818,7828],[168,8013,7818,40287],[168,8013,7828],
 [168,8013,8032],[168,8013,40213,40287],[168,8013,40287],
 [168,8013,40303,40287],[168,8013,44004],[168,8013,44103],
 [168,8013,45533],[168,8013,47118],[168,8018,7816,7828],
 [168,8018,7816,8032],[168,8018,7823,7828],
 [168,8018,7823,40450],[168,8018,7828],[168,8018,8032],
 [168,8018,40218,40450],[168,8018,40450],
 [168,8018,40463,40450],[168,8018,44164],[168,8018,44193],
 [168,8018,48018],[168,8018,48424],[168,8089,7818,7828],
 [168,8089,7818,40287],[168,8089,7823,7828],
 [168,8089,7823,40450],[168,8089,7828],[168,8089,40287],
 [168,8089,40289,40287],[168,8089,40289,40450],
 [168,8089,40450],[168,8089,45389],[168,8089,45418],
 [168,8089,46974],[168,8089,47003],[168,8099,7818,7828],
 [168,8099,7818,40287],[168,8099,7828],[168,8099,7833,7828],
 [168,8099,7833,8507],[168,8099,7833,40707],
 [168,8099,7833,49887],[168,8099,8507],[168,8099,40287],
 [168,8099,40299,40287],[168,8099,40302,40287],
 [168,8099,40707],[168,8099,45529],[168,8099,45532],
 [168,8099,45642],[168,8099,47114],[168,8099,47117],
 [168,8099,47227],[168,8099,49887],[168,8259,7823,7828],
 [168,8259,7823,40450],[168,8259,7828],[168,8259,7833,7828],
 [168,8259,7833,8507],[168,8259,7833,40707],
 [168,8259,7833,49887],[168,8259,8507],[168,8259,40450],
 [168,8259,40459,40450],[168,8259,40462,40450],
 [168,8259,40707],[168,8259,48014],[168,8259,48017],
 [168,8259,48127],[168,8259,48420],[168,8259,48423],
 [168,8259,48533],[168,8259,49887],[168,40099,40287],
 [168,40104,40450],[168,40117,42362],[168,40227,44394],
 [168,40289,40287],[168,40289,40450],[168,40298,40287],
 [168,40299,40287],[168,40302,40287],[168,40303,40287],
 [168,40458,40450],[168,40459,40450],[168,40462,40450],
 [168,40463,40450],[168,41823,42193],[168,41823,44394],
 [168,41894,42193],[168,41902,42362],[168,41993,42193],
 [168,42001,42362],[168,42054,42193],[168,42062,42362],
 [168,42083,42193],[168,42091,42362],[168,42197,42193],
 [168,42197,42362],[168,42307,42362],[168,44008,44394],
 [168,44107,44394],[168,44168,44394],[168,44197,44394],
 [168,44397,44394],[326,12685,14635],[326,12688,12979],
 [326,12807,12979],[326,12865,12979],[326,14637,14635],
 [326,14638,14635],[360,352,328],[360,352,1658],
 [360,352,12828],[360,352,12838],[360,352,13954],
 [360,352,19265],[360,1656,1658],[360,1656,1915],
 [360,1656,45473],[360,1656,45486],[360,1656,45537],
 [360,1656,49157],[360,12836,12838],[360,12836,14198],
 [360,12851,12828],[360,12851,19278],[365,345,328],
 [365,345,1377],[365,345,12821],[365,345,12823],
 [365,345,13673],[365,345,18984],[365,1395,1377],
 [365,1395,2033],[365,1395,40112],[365,1395,40120],
 [365,1395,40669],[365,1395,42269],[365,12841,12823],
 [365,12841,13772],[365,12849,12821],[365,12849,19010],
 [376,12852,14514],[376,12855,19857],[376,14511,14514],
 [376,14519,14514],[376,19822,19857],[376,19852,19857],
 [377,12853,14523],[377,12854,19848],[377,14520,14523],
 [377,14528,14523],[377,19831,19848],[377,19843,19848],
 [380,12856,19862],[380,12859,14565],[380,14549,14565],
 [380,14566,14565],[380,19860,19862],[380,19861,19862],
 [416,156,1377],[416,156,1658],[416,156,1761],
 [416,156,7813,7828],[416,156,7813,42193],
 [416,156,7818,7828],[416,156,7818,40287],[416,156,7828],
 [416,156,7899,7813,7828],[416,156,7899,7813,42193],
 [416,156,7899,7818,7828],[416,156,7899,7818,40287],
 [416,156,7899,7828],[416,156,7899,40099,40287],
 [416,156,7899,40287],[416,156,7899,40298,40287],
 [416,156,7899,41894,42193],[416,156,7899,41993,42193],
 [416,156,7899,42193],[416,156,40099,40287],[416,156,40287],
 [416,156,40298,40287],[416,156,41894,42193],
 [416,156,41993,42193],[416,156,42193],[416,406,393],
 [416,406,1377],[416,406,14877],[416,406,14879],
 [416,406,15503],[416,406,25258],[416,413,393],
 [416,413,1658],[416,413,14884],[416,413,14894],
 [416,413,15784],[416,413,25539],[416,6842,7828],
 [416,6844,6842,7828],[416,6844,7813,7828],
 [416,6844,7813,42193],[416,6844,7828],[416,6844,15503],
 [416,6844,15522],[416,6844,42193],[416,7187,7828],
 [416,7813,7828],[416,7813,42193],[416,7818,7828],
 [416,7818,40287],[416,15508,40287],[416,15788,15508,40287],
 [416,15788,15522],[416,15788,40287],[416,15788,40298,40287],
 [416,25263,25258],[416,25263,25344],[416,25263,25347],
 [416,25263,40099,40287],[416,25263,40287],[416,25354,42193],
 [416,25638,25347],[416,25638,25354,42193],
 [416,25638,41993,42193],[416,25638,42193],[416,40099,40287],
 [416,40298,40287],[416,41894,42193],[416,41993,42193],
 [593,156,1377],[593,156,1658],[593,156,1761],
 [593,156,7813,7828],[593,156,7813,42193],
 [593,156,7818,7828],[593,156,7818,40287],[593,156,7828],
 [593,156,7899,7813,7828],[593,156,7899,7813,42193],
 [593,156,7899,7818,7828],[593,156,7899,7818,40287],
 [593,156,7899,7828],[593,156,7899,40099,40287],
 [593,156,7899,40287],[593,156,7899,40298,40287],
 [593,156,7899,41894,42193],[593,156,7899,41993,42193],
 [593,156,7899,42193],[593,156,40099,40287],[593,156,40287],
 [593,156,40298,40287],[593,156,41894,42193],
 [593,156,41993,42193],[593,156,42193],[593,583,569],
 [593,583,1377],[593,583,19956],[593,583,19958],
 [593,583,20637],[593,583,23773],[593,590,569],
 [593,590,1658],[593,590,19963],[593,590,19973],
 [593,590,20918],[593,590,24054],[593,7019,7828],
 [593,7132,7828],[593,7139,7132,7828],[593,7139,7818,7828],
 [593,7139,7818,40287],[593,7139,7828],[593,7139,24054],
 [593,7139,24153],[593,7139,40287],[593,7813,7828],
 [593,7813,42193],[593,7818,7828],[593,7818,40287],
 [593,20642,40287],[593,20656,20642,40287],[593,20656,20922],
 [593,20656,40287],[593,20656,40298,40287],[593,20733,20723],
 [593,20733,20918],[593,20733,20922],[593,20733,41894,42193],
 [593,20733,42193],[593,23862,23869,42193],[593,23862,24153],
 [593,23862,41993,42193],[593,23862,42193],[593,23869,42193],
 [593,40099,40287],[593,40298,40287],[593,41894,42193],
 [593,41993,42193],[905,29022,29168],[1344,39281,42761],
 [1389,40106,42109],[1389,40121,40824],[1389,40523,40824],
 [1389,40550,40824],[1389,42123,42109],[1389,42124,42109],
 [1406,40123,42449],[1406,40125,40870],[1406,40850,40870],
 [1406,40860,40870],[1406,42450,42449],[1406,42451,42449],
 [1411,40128,42494],[1411,40133,40914],[1411,40898,40914],
 [1411,40903,40914],[1411,42498,42494],[1411,42499,42494],
 [1578,44044,44030],[1591,44107,44394],[1597,1337,1336],
 [1597,1337,39274,39313],[1597,1337,39313],[1597,1339,1336],
 [1597,1339,1625],[1597,1339,1761],[1597,1339,39276,42593],
 [1597,1339,39289,39779],[1597,1339,39400,39779],
 [1597,1339,39534,39779],[1597,1339,39779],[1597,1339,42593],
 [1597,1339,42602,42593],[1597,1339,42604,42593],
 [1597,1358,1336],[1597,1358,39295,43104],[1597,1358,43104],
 [1597,1543,1761],[1597,1543,43441],[1597,1580,1761],
 [1597,1580,44107,44394],[1597,1580,44394],[1597,1764,1761],
 [1597,1764,47206,47266],[1597,1764,47266],[1597,1765,1761],
 [1597,1765,47207],[1597,39274,39313],[1597,39276,42593],
 [1597,39295,43104],[1597,39318,39313],[1597,39333,39313],
 [1597,39335,39313],[1597,39539,47266],[1597,42516,42593],
 [1597,42535,43104],[1597,42553,42593],[1597,42572,43104],
 [1597,42607,42593],[1597,42607,43104],[1597,42607,45084],
 [1597,42607,47266],[1597,43444,47266],[1597,44110,47266],
 [1618,44795,48035],[1655,45446,48796],[1655,45457,45745],
 [1655,45535,45745],[1655,45604,45745],[1655,48804,48796],
 [1655,48805,48796],[1673,45539,50046],[1673,45540,45806],
 [1673,45795,45806],[1673,45810,45806],[1673,50040,50046],
 [1673,50042,50046],[1677,45543,50075],[1677,45547,45847],
 [1677,45832,45847],[1677,45841,45847],[1677,50077,50075],
 [1677,50078,50075],[1688,45980,48445],[1699,46221,46241],
 [1755,47061,49217],[1755,47069,47331],[1755,47189,47331],
 [1755,47210,47331],[1755,49224,49217],[1755,49226,49217],
 [1764,47206,47266],[1771,47213,51006],[1771,47216,47399],
 [1771,47371,47399],[1771,47403,47399],[1771,51001,51006],
 [1771,51002,51006],[1777,47219,51050],[1777,47222,47433],
 [1777,47422,47433],[1777,47426,47433],[1777,51052,51050],
 [1777,51054,51050],[2070,1539,1625],[2070,1539,43305,43685],
 [2070,1539,43685],[2070,1630,1625],[2070,1630,44983,45084],
 [2070,1630,45084],[2070,43305,43685],[2070,43310,45084],
 [2070,43687,43685],[2070,43688,43685],[2070,44983,45084],
 [2070,45046,45084],[2282,2280,2279],[2282,2281,2279],
 [2282,2300,2279],[2282,2300,3500,3507],
 [2282,2300,3500,38205],[2282,2300,3507],
 [2282,2300,3517,3507],[2282,2300,3517,44904],
 [2282,2300,5645,5705],[2282,2300,5645,38205],
 [2282,2300,5695,5705],[2282,2300,5695,44904],
 [2282,2300,5705],[2282,2300,7725,7828],
 [2282,2300,7725,38205],[2282,2300,7817,7828],
 [2282,2300,7817,44904],[2282,2300,7828],[2282,2300,38205],
 [2282,2300,44904],[2282,2410,8715],[2282,2429,3507],
 [2282,2430,2429,3507],[2282,2430,3500,3507],
 [2282,2430,3500,38205],[2282,2430,3507],
 [2282,2430,9741,38205],[2282,2430,9791],[2282,2430,9833],
 [2282,2430,38205],[2282,2447,2429,3507],[2282,2447,3507],
 [2282,2447,3517,3507],[2282,2447,3517,44904],
 [2282,2447,9758],[2282,2447,9759],[2282,2447,10074,44904],
 [2282,2447,44904],[2282,2492,3507],[2282,2493,2492,3507],
 [2282,2493,3500,3507],[2282,2493,3500,38205],
 [2282,2493,3507],[2282,2493,11694,38205],[2282,2493,11744],
 [2282,2493,11786],[2282,2493,38205],[2282,2510,2492,3507],
 [2282,2510,3507],[2282,2510,3517,3507],
 [2282,2510,3517,44904],[2282,2510,11711],[2282,2510,11712],
 [2282,2510,12027,44904],[2282,2510,44904],[2282,2554,3507],
 [2282,2555,2554,3507],[2282,2555,3500,3507],
 [2282,2555,3500,38205],[2282,2555,3507],
 [2282,2555,13585,38205],[2282,2555,13635],[2282,2555,13677],
 [2282,2555,38205],[2282,2572,2410,8715],
 [2282,2572,2429,3507],[2282,2572,2447,2429,3507],
 [2282,2572,2447,3507],[2282,2572,2447,3517,3507],
 [2282,2572,2447,3517,44904],[2282,2572,2447,9758],
 [2282,2572,2447,9759],[2282,2572,2447,10074,44904],
 [2282,2572,2447,44904],[2282,2572,2492,3507],
 [2282,2572,2510,2492,3507],[2282,2572,2510,3507],
 [2282,2572,2510,3517,3507],[2282,2572,2510,3517,44904],
 [2282,2572,2510,11711],[2282,2572,2510,11712],
 [2282,2572,2510,12027,44904],[2282,2572,2510,44904],
 [2282,2572,2554,3507],[2282,2572,3507],
 [2282,2572,3517,3507],[2282,2572,3517,44904],
 [2282,2572,8715],[2282,2572,8733,8715],
 [2282,2572,8741,8715],[2282,2572,8751,8715],
 [2282,2572,8752,8715],[2282,2572,9758],[2282,2572,9759],
 [2282,2572,10074,44904],[2282,2572,11711],[2282,2572,11712],
 [2282,2572,12027,44904],[2282,2572,13602],[2282,2572,13603],
 [2282,2572,13918,44904],[2282,2572,44904],[2282,3500,3507],
 [2282,3500,38205],[2282,3517,3507],[2282,3517,44904],
 [2282,4555,8715],[2282,4574,4575,5705],
 [2282,4574,5645,5705],[2282,4574,5645,38205],
 [2282,4574,5705],[2282,4574,9741,38205],[2282,4574,9758],
 [2282,4574,9843],[2282,4574,38205],[2282,4575,5705],
 [2282,4582,4575,5705],[2282,4582,5695,5705],
 [2282,4582,5695,44904],[2282,4582,5705],[2282,4582,9791],
 [2282,4582,9802],[2282,4582,10074,44904],[2282,4582,44904],
 [2282,4637,4638,5705],[2282,4637,5645,5705],
 [2282,4637,5645,38205],[2282,4637,5705],
 [2282,4637,11694,38205],[2282,4637,11711],[2282,4637,11796],
 [2282,4637,38205],[2282,4638,5705],[2282,4645,4638,5705],
 [2282,4645,5695,5705],[2282,4645,5695,44904],
 [2282,4645,5705],[2282,4645,11744],[2282,4645,11755],
 [2282,4645,12027,44904],[2282,4645,44904],
 [2282,4699,4700,5705],[2282,4699,5645,5705],
 [2282,4699,5645,38205],[2282,4699,5705],
 [2282,4699,13585,38205],[2282,4699,13602],[2282,4699,13687],
 [2282,4699,38205],[2282,4700,5705],[2282,4707,4555,8715],
 [2282,4707,4575,5705],[2282,4707,4582,4575,5705],
 [2282,4707,4582,5695,5705],[2282,4707,4582,5695,44904],
 [2282,4707,4582,5705],[2282,4707,4582,9791],
 [2282,4707,4582,9802],[2282,4707,4582,10074,44904],
 [2282,4707,4582,44904],[2282,4707,4638,5705],
 [2282,4707,4645,4638,5705],[2282,4707,4645,5695,5705],
 [2282,4707,4645,5695,44904],[2282,4707,4645,5705],
 [2282,4707,4645,11744],[2282,4707,4645,11755],
 [2282,4707,4645,12027,44904],[2282,4707,4645,44904],
 [2282,4707,4700,5705],[2282,4707,5695,5705],
 [2282,4707,5695,44904],[2282,4707,5705],[2282,4707,8715],
 [2282,4707,8734,8715],[2282,4707,8741,8715],
 [2282,4707,8751,8715],[2282,4707,8752,8715],
 [2282,4707,9791],[2282,4707,9802],[2282,4707,10074,44904],
 [2282,4707,11744],[2282,4707,11755],[2282,4707,12027,44904],
 [2282,4707,13635],[2282,4707,13646],[2282,4707,13918,44904],
 [2282,4707,44904],[2282,5645,5705],[2282,5645,38205],
 [2282,5695,5705],[2282,5695,44904],[2282,6635,6656,7828],
 [2282,6635,6662,6656,7828],[2282,6635,6662,7817,7828],
 [2282,6635,6662,7817,44904],[2282,6635,6662,7828],
 [2282,6635,6662,9833],[2282,6635,6662,9843],
 [2282,6635,6662,10074,44904],[2282,6635,6662,44904],
 [2282,6635,6719,7828],[2282,6635,6725,6719,7828],
 [2282,6635,6725,7817,7828],[2282,6635,6725,7817,44904],
 [2282,6635,6725,7828],[2282,6635,6725,11786],
 [2282,6635,6725,11796],[2282,6635,6725,12027,44904],
 [2282,6635,6725,44904],[2282,6635,6781,7828],
 [2282,6635,6787,6781,7828],[2282,6635,6787,7817,7828],
 [2282,6635,6787,7817,44904],[2282,6635,6787,7828],
 [2282,6635,6787,13677],[2282,6635,6787,13687],
 [2282,6635,6787,13918,44904],[2282,6635,6787,44904],
 [2282,6635,7817,7828],[2282,6635,7817,44904],
 [2282,6635,7828],[2282,6635,8715],[2282,6635,8735,8715],
 [2282,6635,8741,8715],[2282,6635,8751,8715],
 [2282,6635,8752,8715],[2282,6635,9833],[2282,6635,9843],
 [2282,6635,10074,44904],[2282,6635,11786],[2282,6635,11796],
 [2282,6635,12027,44904],[2282,6635,13677],[2282,6635,13687],
 [2282,6635,13918,44904],[2282,6635,44904],
 [2282,6654,6656,7828],[2282,6654,7725,7828],
 [2282,6654,7725,38205],[2282,6654,7828],
 [2282,6654,9741,38205],[2282,6654,9759],[2282,6654,9802],
 [2282,6654,38205],[2282,6656,7828],[2282,6662,6656,7828],
 [2282,6662,7817,7828],[2282,6662,7817,44904],
 [2282,6662,7828],[2282,6662,9833],[2282,6662,9843],
 [2282,6662,10074,44904],[2282,6662,44904],
 [2282,6717,6719,7828],[2282,6717,7725,7828],
 [2282,6717,7725,38205],[2282,6717,7828],
 [2282,6717,11694,38205],[2282,6717,11712],[2282,6717,11755],
 [2282,6717,38205],[2282,6719,7828],[2282,6725,6719,7828],
 [2282,6725,7817,7828],[2282,6725,7817,44904],
 [2282,6725,7828],[2282,6725,11786],[2282,6725,11796],
 [2282,6725,12027,44904],[2282,6725,44904],
 [2282,6779,6781,7828],[2282,6779,7725,7828],
 [2282,6779,7725,38205],[2282,6779,7828],
 [2282,6779,13585,38205],[2282,6779,13603],[2282,6779,13646],
 [2282,6779,38205],[2282,6781,7828],[2282,6787,6781,7828],
 [2282,6787,7817,7828],[2282,6787,7817,44904],
 [2282,6787,7828],[2282,6787,13677],[2282,6787,13687],
 [2282,6787,13918,44904],[2282,6787,44904],[2282,7725,7828],
 [2282,7725,38205],[2282,7817,7828],[2282,7817,44904],
 [2282,8733,8715],[2282,8734,8715],[2282,8735,8715],
 [2282,8741,8715],[2282,8751,8715],[2282,8752,8715],
 [2282,9741,38205],[2282,10074,44904],[2282,11694,38205],
 [2282,12027,44904],[2282,13585,38205],[2282,13918,44904],
 [2285,2281,2279],[2285,2284,2279],[2285,2300,2279],
 [2285,2300,3500,3507],[2285,2300,3500,38205],
 [2285,2300,3507],[2285,2300,3517,3507],
 [2285,2300,3517,44904],[2285,2300,5645,5705],
 [2285,2300,5645,38205],[2285,2300,5695,5705],
 [2285,2300,5695,44904],[2285,2300,5705],
 [2285,2300,7725,7828],[2285,2300,7725,38205],
 [2285,2300,7817,7828],[2285,2300,7817,44904],
 [2285,2300,7828],[2285,2300,38205],[2285,2300,44904],
 [2285,2476,10854],[2285,2492,3507],[2285,2493,2492,3507],
 [2285,2493,3500,3507],[2285,2493,3500,38205],
 [2285,2493,3507],[2285,2493,11694,38205],[2285,2493,11744],
 [2285,2493,11786],[2285,2493,38205],[2285,2510,2492,3507],
 [2285,2510,3507],[2285,2510,3517,3507],
 [2285,2510,3517,44904],[2285,2510,11711],[2285,2510,11712],
 [2285,2510,12027,44904],[2285,2510,44904],[2285,2675,3507],
 [2285,2676,2675,3507],[2285,2676,3500,3507],
 [2285,2676,3500,38205],[2285,2676,3507],
 [2285,2676,17185,38205],[2285,2676,17235],[2285,2676,17277],
 [2285,2676,38205],[2285,2693,2675,3507],[2285,2693,3507],
 [2285,2693,3517,3507],[2285,2693,3517,44904],
 [2285,2693,17202],[2285,2693,17203],[2285,2693,17518,44904],
 [2285,2693,44904],[2285,2734,3507],[2285,2735,2476,10854],
 [2285,2735,2492,3507],[2285,2735,2493,2492,3507],
 [2285,2735,2493,3500,3507],[2285,2735,2493,3500,38205],
 [2285,2735,2493,3507],[2285,2735,2493,11694,38205],
 [2285,2735,2493,11744],[2285,2735,2493,11786],
 [2285,2735,2493,38205],[2285,2735,2675,3507],
 [2285,2735,2676,2675,3507],[2285,2735,2676,3500,3507],
 [2285,2735,2676,3500,38205],[2285,2735,2676,3507],
 [2285,2735,2676,17185,38205],[2285,2735,2676,17235],
 [2285,2735,2676,17277],[2285,2735,2676,38205],
 [2285,2735,2734,3507],[2285,2735,3500,3507],
 [2285,2735,3500,38205],[2285,2735,3507],[2285,2735,10854],
 [2285,2735,10869,10854],[2285,2735,10870,10854],
 [2285,2735,10871,10854],[2285,2735,10877,10854],
 [2285,2735,11694,38205],[2285,2735,11744],[2285,2735,11786],
 [2285,2735,17185,38205],[2285,2735,17235],[2285,2735,17277],
 [2285,2735,18896,38205],[2285,2735,18946],[2285,2735,18988],
 [2285,2735,38205],[2285,2752,2734,3507],[2285,2752,3507],
 [2285,2752,3517,3507],[2285,2752,3517,44904],
 [2285,2752,18913],[2285,2752,18914],[2285,2752,19229,44904],
 [2285,2752,44904],[2285,3500,3507],[2285,3500,38205],
 [2285,3517,3507],[2285,3517,44904],[2285,4621,10854],
 [2285,4637,4638,5705],[2285,4637,5645,5705],
 [2285,4637,5645,38205],[2285,4637,5705],
 [2285,4637,11694,38205],[2285,4637,11711],[2285,4637,11796],
 [2285,4637,38205],[2285,4638,5705],[2285,4645,4638,5705],
 [2285,4645,5695,5705],[2285,4645,5695,44904],
 [2285,4645,5705],[2285,4645,11744],[2285,4645,11755],
 [2285,4645,12027,44904],[2285,4645,44904],
 [2285,4820,4821,5705],[2285,4820,5645,5705],
 [2285,4820,5645,38205],[2285,4820,5705],
 [2285,4820,17185,38205],[2285,4820,17202],[2285,4820,17287],
 [2285,4820,38205],[2285,4821,5705],[2285,4828,4821,5705],
 [2285,4828,5695,5705],[2285,4828,5695,44904],
 [2285,4828,5705],[2285,4828,17235],[2285,4828,17246],
 [2285,4828,17518,44904],[2285,4828,44904],
 [2285,4879,4621,10854],[2285,4879,4637,4638,5705],
 [2285,4879,4637,5645,5705],[2285,4879,4637,5645,38205],
 [2285,4879,4637,5705],[2285,4879,4637,11694,38205],
 [2285,4879,4637,11711],[2285,4879,4637,11796],
 [2285,4879,4637,38205],[2285,4879,4638,5705],
 [2285,4879,4820,4821,5705],[2285,4879,4820,5645,5705],
 [2285,4879,4820,5645,38205],[2285,4879,4820,5705],
 [2285,4879,4820,17185,38205],[2285,4879,4820,17202],
 [2285,4879,4820,17287],[2285,4879,4820,38205],
 [2285,4879,4821,5705],[2285,4879,4880,5705],
 [2285,4879,5645,5705],[2285,4879,5645,38205],
 [2285,4879,5705],[2285,4879,10854],[2285,4879,10869,10854],
 [2285,4879,10870,10854],[2285,4879,10871,10854],
 [2285,4879,10887,10854],[2285,4879,11694,38205],
 [2285,4879,11711],[2285,4879,11796],[2285,4879,17185,38205],
 [2285,4879,17202],[2285,4879,17287],[2285,4879,18896,38205],
 [2285,4879,18913],[2285,4879,18998],[2285,4879,38205],
 [2285,4880,5705],[2285,4887,4880,5705],
 [2285,4887,5695,5705],[2285,4887,5695,44904],
 [2285,4887,5705],[2285,4887,18946],[2285,4887,18957],
 [2285,4887,19229,44904],[2285,4887,44904],[2285,5645,5705],
 [2285,5645,38205],[2285,5695,5705],[2285,5695,44904],
 [2285,6701,6717,6719,7828],[2285,6701,6717,7725,7828],
 [2285,6701,6717,7725,38205],[2285,6701,6717,7828],
 [2285,6701,6717,11694,38205],[2285,6701,6717,11712],
 [2285,6701,6717,11755],[2285,6701,6717,38205],
 [2285,6701,6719,7828],[2285,6701,6900,6902,7828],
 [2285,6701,6900,7725,7828],[2285,6701,6900,7725,38205],
 [2285,6701,6900,7828],[2285,6701,6900,17185,38205],
 [2285,6701,6900,17203],[2285,6701,6900,17246],
 [2285,6701,6900,38205],[2285,6701,6902,7828],
 [2285,6701,6959,6961,7828],[2285,6701,6959,7725,7828],
 [2285,6701,6959,7725,38205],[2285,6701,6959,7828],
 [2285,6701,6959,18896,38205],[2285,6701,6959,18914],
 [2285,6701,6959,18957],[2285,6701,6959,38205],
 [2285,6701,6961,7828],[2285,6701,7725,7828],
 [2285,6701,7725,38205],[2285,6701,7828],[2285,6701,10854],
 [2285,6701,10869,10854],[2285,6701,10870,10854],
 [2285,6701,10871,10854],[2285,6701,10888,10854],
 [2285,6701,11694,38205],[2285,6701,11712],[2285,6701,11755],
 [2285,6701,17185,38205],[2285,6701,17203],[2285,6701,17246],
 [2285,6701,18896,38205],[2285,6701,18914],[2285,6701,18957],
 [2285,6701,38205],[2285,6717,6719,7828],
 [2285,6717,7725,7828],[2285,6717,7725,38205],
 [2285,6717,7828],[2285,6717,11694,38205],[2285,6717,11712],
 [2285,6717,11755],[2285,6717,38205],[2285,6719,7828],
 [2285,6725,6719,7828],[2285,6725,7817,7828],
 [2285,6725,7817,44904],[2285,6725,7828],[2285,6725,11786],
 [2285,6725,11796],[2285,6725,12027,44904],[2285,6725,44904],
 [2285,6900,6902,7828],[2285,6900,7725,7828],
 [2285,6900,7725,38205],[2285,6900,7828],
 [2285,6900,17185,38205],[2285,6900,17203],[2285,6900,17246],
 [2285,6900,38205],[2285,6902,7828],[2285,6908,6902,7828],
 [2285,6908,7817,7828],[2285,6908,7817,44904],
 [2285,6908,7828],[2285,6908,17277],[2285,6908,17287],
 [2285,6908,17518,44904],[2285,6908,44904],
 [2285,6959,6961,7828],[2285,6959,7725,7828],
 [2285,6959,7725,38205],[2285,6959,7828],
 [2285,6959,18896,38205],[2285,6959,18914],[2285,6959,18957],
 [2285,6959,38205],[2285,6961,7828],[2285,6967,6961,7828],
 [2285,6967,7817,7828],[2285,6967,7817,44904],
 [2285,6967,7828],[2285,6967,18988],[2285,6967,18998],
 [2285,6967,19229,44904],[2285,6967,44904],[2285,7725,7828],
 [2285,7725,38205],[2285,7817,7828],[2285,7817,44904],
 [2285,10869,10854],[2285,10870,10854],[2285,10871,10854],
 [2285,10877,10854],[2285,10887,10854],[2285,10888,10854],
 [2285,11694,38205],[2285,12027,44904],[2285,17185,38205],
 [2285,17518,44904],[2285,18896,38205],[2285,19229,44904],
 [2287,2305,2279],[2287,2305,3714],[2287,2305,3725,3714],
 [2287,2305,3725,42671],[2287,2305,5859,6050],
 [2287,2305,5859,42671],[2287,2305,6050],
 [2287,2305,7939,7950],[2287,2305,7939,42671],
 [2287,2305,7950],[2287,2305,42671],[2287,2854,3714],
 [2287,2854,22359],[2287,3725,3714],[2287,3725,42671],
 [2287,5004,6050],[2287,5004,22550],[2287,5859,6050],
 [2287,5859,42671],[2287,7079,7950],[2287,7079,22370],
 [2287,7939,7950],[2287,7939,42671],[2292,2290,2279],
 [2292,2291,2279],[2292,3005,26160],[2292,5150,26160],
 [2292,7230,26160],[2297,2293,2279],[2297,2296,2279],
 [2297,3166,30394],[2297,5311,30394],[2297,7391,30394],
 [2299,2291,2279],[2299,2293,2279],[2299,2294,2279],
 [2299,2294,2291,2279],[2299,2294,2293,2279],
 [2299,2294,3060,27643],[2299,2294,5205,27643],
 [2299,2294,7285,27643],[2299,2294,27643],[2299,3060,27643],
 [2299,5205,27643],[2299,7285,27643],[2299,27648,27643],
 [2306,2300,2279],[2306,2300,3500,3507],
 [2306,2300,3500,38205],[2306,2300,3507],
 [2306,2300,3517,3507],[2306,2300,3517,44904],
 [2306,2300,5645,5705],[2306,2300,5645,38205],
 [2306,2300,5695,5705],[2306,2300,5695,44904],
 [2306,2300,5705],[2306,2300,7725,7828],
 [2306,2300,7725,38205],[2306,2300,7817,7828],
 [2306,2300,7817,44904],[2306,2300,7828],[2306,2300,38205],
 [2306,2300,44904],[2306,3500,3507],[2306,3500,38205],
 [2306,3505,3507],[2306,3505,3756],[2306,3506,3507],
 [2306,3506,3794],[2306,3506,38455],[2306,3506,43965],
 [2306,3517,3507],[2306,3517,44904],[2306,3527,3507],
 [2306,3527,39015],[2306,3548,3500,3507],
 [2306,3548,3500,38205],[2306,3548,3505,3507],
 [2306,3548,3505,3756],[2306,3548,3506,3507],
 [2306,3548,3506,3794],[2306,3548,3506,38455],
 [2306,3548,3506,43965],[2306,3548,3507],[2306,3548,3756],
 [2306,3548,3794],[2306,3548,38205],[2306,3548,38209,38205],
 [2306,3548,38209,39313],[2306,3548,38217,38205],
 [2306,3548,38217,40450],[2306,3548,38418],[2306,3548,38454],
 [2306,3548,38455],[2306,3548,39313],[2306,3548,39314,39313],
 [2306,3548,39321,39313],[2306,3548,39393],[2306,3548,39394],
 [2306,3548,40175],[2306,3548,40212],[2306,3548,40218,40450],
 [2306,3548,40254,40450],[2306,3548,40450],[2306,3548,43299],
 [2306,3548,43964],[2306,3548,43965],[2306,3570,3500,3507],
 [2306,3570,3500,38205],[2306,3570,3507],
 [2306,3570,3527,3507],[2306,3570,3527,39015],
 [2306,3570,38205],[2306,3570,38231,38205],
 [2306,3570,38231,39015],[2306,3570,39015],[2306,3570,39407],
 [2306,3570,39408],[2306,3570,40268],[2306,3570,40269],
 [2306,3760,3505,3507],[2306,3760,3505,3756],
 [2306,3760,3507],[2306,3760,3517,3507],
 [2306,3760,3517,44904],[2306,3760,3756],[2306,3760,38421],
 [2306,3760,38422],[2306,3760,38689],[2306,3760,38690],
 [2306,3760,43302,44904],[2306,3760,44793,44904],
 [2306,3760,44904],[2306,3770,3505,3507],
 [2306,3770,3505,3756],[2306,3770,3507],
 [2306,3770,3527,3507],[2306,3770,3527,39015],
 [2306,3770,3756],[2306,3770,38431,39015],
 [2306,3770,38699,39015],[2306,3770,39015],[2306,3770,43312],
 [2306,3770,43313],[2306,3770,44803],[2306,3770,44804],
 [2306,3797,3506,3507],[2306,3797,3506,3794],
 [2306,3797,3506,38455],[2306,3797,3506,43965],
 [2306,3797,3507],[2306,3797,3517,3507],
 [2306,3797,3517,44904],[2306,3797,3794],[2306,3797,38455],
 [2306,3797,38458],[2306,3797,38459],[2306,3797,38718],
 [2306,3797,38719],[2306,3797,43965],[2306,3797,43968,44904],
 [2306,3797,44192],[2306,3797,44193],[2306,3797,44822,44904],
 [2306,3797,44904],[2306,4148,3507],[2306,4148,3517,3507],
 [2306,4148,3517,44904],[2306,4148,3527,3507],
 [2306,4148,3527,39015],[2306,4148,38809,39015],
 [2306,4148,38834,39015],[2306,4148,39015],[2306,4148,44904],
 [2306,4148,44913,44904],[2306,4148,44914,44904],
 [2306,5645,5705],[2306,5645,38205],[2306,5650,5645,5705],
 [2306,5650,5645,38205],[2306,5650,5693,5705],
 [2306,5650,5693,39313],[2306,5650,5705],[2306,5650,38205],
 [2306,5650,38209,38205],[2306,5650,38209,39313],
 [2306,5650,38421],[2306,5650,38458],[2306,5650,39313],
 [2306,5650,40185],[2306,5650,40222],[2306,5658,5645,5705],
 [2306,5658,5645,38205],[2306,5658,5701,5705],
 [2306,5658,5701,6183],[2306,5658,5701,39602],
 [2306,5658,5701,47993],[2306,5658,5702,5705],
 [2306,5658,5702,6213],[2306,5658,5705],[2306,5658,6183],
 [2306,5658,6213],[2306,5658,38205],[2306,5658,38217,38205],
 [2306,5658,38217,40450],[2306,5658,38231,38205],
 [2306,5658,38231,39015],[2306,5658,38689],
 [2306,5658,38699,39015],[2306,5658,38718],
 [2306,5658,38809,39015],[2306,5658,39015],[2306,5658,39602],
 [2306,5658,39603],[2306,5658,39631],[2306,5658,40450],
 [2306,5658,40453,40450],[2306,5658,40463,40450],
 [2306,5658,40573],[2306,5658,40574],[2306,5658,47993],
 [2306,5658,47994],[2306,5658,48399],[2306,5693,5705],
 [2306,5693,39313],[2306,5695,5705],[2306,5695,44904],
 [2306,5701,5705],[2306,5701,6183],[2306,5701,39602],
 [2306,5701,47993],[2306,5702,5705],[2306,5702,6213],
 [2306,5895,5693,5705],[2306,5895,5693,39313],
 [2306,5895,5695,5705],[2306,5895,5695,44904],
 [2306,5895,5705],[2306,5895,39313],[2306,5895,39314,39313],
 [2306,5895,39325,39313],[2306,5895,43302,44904],
 [2306,5895,43968,44904],[2306,5895,44904],
 [2306,5902,5693,5705],[2306,5902,5693,39313],
 [2306,5902,5702,5705],[2306,5902,5702,6213],
 [2306,5902,5705],[2306,5902,6213],[2306,5902,39313],
 [2306,5902,39321,39313],[2306,5902,39335,39313],
 [2306,5902,43526],[2306,5902,43618],[2306,5902,44192],
 [2306,5902,44284],[2306,5974,5695,5705],
 [2306,5974,5695,44904],[2306,5974,5701,5705],
 [2306,5974,5701,6183],[2306,5974,5701,39602],
 [2306,5974,5701,47993],[2306,5974,5705],[2306,5974,6183],
 [2306,5974,39393],[2306,5974,39407],[2306,5974,39593],
 [2306,5974,39602],[2306,5974,39737],[2306,5974,44793,44904],
 [2306,5974,44803],[2306,5974,44904],[2306,5974,44913,44904],
 [2306,5974,47993],[2306,5974,48018],[2306,5975,5695,5705],
 [2306,5975,5695,44904],[2306,5975,5702,5705],
 [2306,5975,5702,6213],[2306,5975,5705],[2306,5975,6213],
 [2306,5975,39394],[2306,5975,39408],[2306,5975,39622],
 [2306,5975,39738],[2306,5975,44822,44904],[2306,5975,44904],
 [2306,5975,44914,44904],[2306,7725,7828],[2306,7725,38205],
 [2306,7730,7725,7828],[2306,7730,7725,38205],
 [2306,7730,7815,7828],[2306,7730,7815,7996],
 [2306,7730,7815,40196],[2306,7730,7815,43643],
 [2306,7730,7816,7828],[2306,7730,7816,8032],
 [2306,7730,7828],[2306,7730,7996],[2306,7730,8032],
 [2306,7730,38205],[2306,7730,38209,38205],
 [2306,7730,38209,39313],[2306,7730,38231,38205],
 [2306,7730,38231,39015],[2306,7730,38422],
 [2306,7730,38431,39015],[2306,7730,38459],
 [2306,7730,38834,39015],[2306,7730,39015],[2306,7730,39313],
 [2306,7730,39325,39313],[2306,7730,39335,39313],
 [2306,7730,39737],[2306,7730,39738],[2306,7730,40195],
 [2306,7730,40196],[2306,7730,40233],[2306,7730,43642],
 [2306,7730,43643],[2306,7730,44309],[2306,7738,7725,7828],
 [2306,7738,7725,38205],[2306,7738,7823,7828],
 [2306,7738,7823,40450],[2306,7738,7828],[2306,7738,38205],
 [2306,7738,38217,38205],[2306,7738,38217,40450],
 [2306,7738,38690],[2306,7738,38719],[2306,7738,39593],
 [2306,7738,39622],[2306,7738,40450],[2306,7815,7828],
 [2306,7815,7996],[2306,7815,40196],[2306,7815,43643],
 [2306,7816,7828],[2306,7816,8032],[2306,7817,7828],
 [2306,7817,44904],[2306,7823,7828],[2306,7823,40450],
 [2306,7975,7815,7828],[2306,7975,7815,7996],
 [2306,7975,7815,40196],[2306,7975,7815,43643],
 [2306,7975,7817,7828],[2306,7975,7817,44904],
 [2306,7975,7828],[2306,7975,7996],[2306,7975,40175],
 [2306,7975,40185],[2306,7975,40196],[2306,7975,40269],
 [2306,7975,40574],[2306,7975,43302,44904],[2306,7975,43313],
 [2306,7975,43618],[2306,7975,43643],[2306,7975,44904],
 [2306,7975,44914,44904],[2306,8012,7816,7828],
 [2306,8012,7816,8032],[2306,8012,7817,7828],
 [2306,8012,7817,44904],[2306,8012,7828],[2306,8012,8032],
 [2306,8012,40212],[2306,8012,40222],[2306,8012,40268],
 [2306,8012,40573],[2306,8012,43968,44904],[2306,8012,44904],
 [2306,8012,44913,44904],[2306,8018,7816,7828],
 [2306,8018,7816,8032],[2306,8018,7823,7828],
 [2306,8018,7823,40450],[2306,8018,7828],[2306,8018,8032],
 [2306,8018,40218,40450],[2306,8018,40450],
 [2306,8018,40463,40450],[2306,8018,44164],[2306,8018,44193],
 [2306,8018,48018],[2306,8018,48424],[2306,8054,7817,7828],
 [2306,8054,7817,44904],[2306,8054,7823,7828],
 [2306,8054,7823,40450],[2306,8054,7828],
 [2306,8054,40254,40450],[2306,8054,40450],
 [2306,8054,40453,40450],[2306,8054,44793,44904],
 [2306,8054,44822,44904],[2306,8054,44904],[2306,38209,38205],
 [2306,38209,39313],[2306,38217,38205],[2306,38217,40450],
 [2306,38231,38205],[2306,38231,39015],[2306,38431,39015],
 [2306,38699,39015],[2306,38809,39015],[2306,38834,39015],
 [2306,39314,39313],[2306,39321,39313],[2306,39325,39313],
 [2306,39335,39313],[2306,40218,40450],[2306,40254,40450],
 [2306,40453,40450],[2306,40463,40450],[2306,43302,44904],
 [2306,43968,44904],[2306,44793,44904],[2306,44822,44904],
 [2306,44913,44904],[2306,44914,44904],[2311,2300,2279],
 [2311,2300,3500,3507],[2311,2300,3500,38205],
 [2311,2300,3507],[2311,2300,3517,3507],
 [2311,2300,3517,44904],[2311,2300,5645,5705],
 [2311,2300,5645,38205],[2311,2300,5695,5705],
 [2311,2300,5695,44904],[2311,2300,5705],
 [2311,2300,7725,7828],[2311,2300,7725,38205],
 [2311,2300,7817,7828],[2311,2300,7817,44904],
 [2311,2300,7828],[2311,2300,38205],[2311,2300,44904],
 [2311,3500,3507],[2311,3500,38205],[2311,3510,3507],
 [2311,3510,3930],[2311,3510,38591],[2311,3510,44695],
 [2311,3517,3507],[2311,3517,44904],[2311,3519,3507],
 [2311,3519,4193],[2311,3525,3507],[2311,3525,45084],
 [2311,3553,3500,3507],[2311,3553,3500,38205],
 [2311,3553,3507],[2311,3553,3510,3507],
 [2311,3553,3510,3930],[2311,3553,3510,38591],
 [2311,3553,3510,44695],[2311,3553,3930],[2311,3553,38205],
 [2311,3553,38214,38205],[2311,3553,38216,38205],
 [2311,3553,38591],[2311,3553,39390],[2311,3553,39392],
 [2311,3553,39494],[2311,3553,40251],[2311,3553,40253],
 [2311,3553,40355],[2311,3553,44695],[2311,3562,3500,3507],
 [2311,3562,3500,38205],[2311,3562,3507],
 [2311,3562,3519,3507],[2311,3562,3519,4193],
 [2311,3562,4193],[2311,3562,38205],[2311,3562,38223,38205],
 [2311,3562,38227,38205],[2311,3562,39399],[2311,3562,39403],
 [2311,3562,40260],[2311,3562,40264],[2311,3568,3500,3507],
 [2311,3568,3500,38205],[2311,3568,3507],
 [2311,3568,3525,3507],[2311,3568,3525,45084],
 [2311,3568,38205],[2311,3568,38229,38205],
 [2311,3568,38230,38205],[2311,3568,39405,45084],
 [2311,3568,40266,45084],[2311,3568,45084],[2311,3935,3507],
 [2311,3935,3510,3507],[2311,3935,3510,3930],
 [2311,3935,3510,38591],[2311,3935,3510,44695],
 [2311,3935,3517,3507],[2311,3935,3517,44904],
 [2311,3935,3519,3507],[2311,3935,3519,4193],
 [2311,3935,3930],[2311,3935,4193],[2311,3935,38591],
 [2311,3935,38596,46593],[2311,3935,38597],[2311,3935,38598],
 [2311,3935,38659],[2311,3935,38660,47575],[2311,3935,38665],
 [2311,3935,38801],[2311,3935,38830],[2311,3935,44695],
 [2311,3935,44700,44904],[2311,3935,44700,46593],
 [2311,3935,44702],[2311,3935,44763,44904],
 [2311,3935,44763,47575],[2311,3935,44769],[2311,3935,44904],
 [2311,3935,46447,46593],[2311,3935,46448,47575],
 [2311,3935,46593],[2311,3935,47575],[2311,4146,3507],
 [2311,4146,3517,3507],[2311,4146,3517,44904],
 [2311,4146,3525,3507],[2311,4146,3525,45084],
 [2311,4146,38807],[2311,4146,38808],[2311,4146,38832],
 [2311,4146,38833],[2311,4146,44904],[2311,4146,44911,44904],
 [2311,4146,44911,45084],[2311,4146,45084],[2311,4195,3507],
 [2311,4195,3519,3507],[2311,4195,3519,4193],
 [2311,4195,3525,3507],[2311,4195,3525,45084],
 [2311,4195,4193],[2311,4195,38856],[2311,4195,38857],
 [2311,4195,38942],[2311,4195,38943],[2311,4195,44960,45084],
 [2311,4195,45046,45084],[2311,4195,45084],[2311,5645,5705],
 [2311,5645,38205],[2311,5655,5645,5705],
 [2311,5655,5645,38205],[2311,5655,5698,5705],
 [2311,5655,5698,46593],[2311,5655,5705],[2311,5655,38205],
 [2311,5655,38214,38205],[2311,5655,38227,38205],
 [2311,5655,38596,46593],[2311,5655,40360,46593],
 [2311,5655,46593],[2311,5657,5645,5705],
 [2311,5657,5645,38205],[2311,5657,5700,5705],
 [2311,5657,5700,6152],[2311,5657,5705],[2311,5657,6152],
 [2311,5657,38205],[2311,5657,38216,38205],
 [2311,5657,38230,38205],[2311,5657,38659],[2311,5657,38808],
 [2311,5657,40423],[2311,5657,40572],[2311,5664,5645,5705],
 [2311,5664,5645,38205],[2311,5664,5705],
 [2311,5664,5707,5705],[2311,5664,5707,6340],
 [2311,5664,5707,39759],[2311,5664,5707,49500],
 [2311,5664,6340],[2311,5664,38205],[2311,5664,38223,38205],
 [2311,5664,38229,38205],[2311,5664,38801],[2311,5664,38807],
 [2311,5664,38856],[2311,5664,39759],[2311,5664,40565],
 [2311,5664,40571],[2311,5664,40620],[2311,5664,49500],
 [2311,5695,5705],[2311,5695,44904],[2311,5698,5705],
 [2311,5698,46593],[2311,5700,5705],[2311,5700,6152],
 [2311,5707,5705],[2311,5707,6340],[2311,5707,39759],
 [2311,5707,49500],[2311,5971,5695,5705],
 [2311,5971,5695,44904],[2311,5971,5698,5705],
 [2311,5971,5698,46593],[2311,5971,5705],[2311,5971,39390],
 [2311,5971,39403],[2311,5971,39500],[2311,5971,39733],
 [2311,5971,44700,44904],[2311,5971,44700,46593],
 [2311,5971,44904],[2311,5971,46593],[2311,5973,5695,5705],
 [2311,5973,5695,44904],[2311,5973,5700,5705],
 [2311,5973,5700,6152],[2311,5973,5705],
 [2311,5973,5707,5705],[2311,5973,5707,6340],
 [2311,5973,5707,39759],[2311,5973,5707,49500],
 [2311,5973,6152],[2311,5973,6340],[2311,5973,39392],
 [2311,5973,39399],[2311,5973,39405,45084],
 [2311,5973,39563,47575],[2311,5973,39570],[2311,5973,39735],
 [2311,5973,39736],[2311,5973,39759],[2311,5973,39760],
 [2311,5973,44763,44904],[2311,5973,44763,47575],
 [2311,5973,44904],[2311,5973,44911,44904],
 [2311,5973,44911,45084],[2311,5973,44960,45084],
 [2311,5973,45084],[2311,5973,47556],[2311,5973,47575],
 [2311,5973,47581,47575],[2311,5973,49500],[2311,5973,49501],
 [2311,6075,5698,5705],[2311,6075,5698,46593],
 [2311,6075,5700,5705],[2311,6075,5700,6152],
 [2311,6075,5705],[2311,6075,6152],[2311,6075,39494],
 [2311,6075,39508],[2311,6075,39568],[2311,6075,39846],
 [2311,6075,46447,46593],[2311,6075,46593],
 [2311,6075,46596,46593],[2311,7725,7828],[2311,7725,38205],
 [2311,7735,7725,7828],[2311,7735,7725,38205],
 [2311,7735,7820,7828],[2311,7735,7820,8168],
 [2311,7735,7828],[2311,7735,8168],[2311,7735,38205],
 [2311,7735,38214,38205],[2311,7735,38229,38205],
 [2311,7735,38597],[2311,7735,38832],[2311,7735,39500],
 [2311,7735,39735],[2311,7737,7725,7828],
 [2311,7737,7725,38205],[2311,7737,7822,7828],
 [2311,7737,7822,47575],[2311,7737,7828],[2311,7737,38205],
 [2311,7737,38216,38205],[2311,7737,38223,38205],
 [2311,7737,38660,47575],[2311,7737,39563,47575],
 [2311,7737,47575],[2311,7748,7725,7828],
 [2311,7748,7725,38205],[2311,7748,7828],
 [2311,7748,7833,7828],[2311,7748,7833,8507],
 [2311,7748,7833,40707],[2311,7748,7833,49887],
 [2311,7748,8507],[2311,7748,38205],[2311,7748,38227,38205],
 [2311,7748,38230,38205],[2311,7748,38830],[2311,7748,38833],
 [2311,7748,38943],[2311,7748,39733],[2311,7748,39736],
 [2311,7748,39846],[2311,7748,40707],[2311,7748,49887],
 [2311,7817,7828],[2311,7817,44904],[2311,7820,7828],
 [2311,7820,8168],[2311,7822,7828],[2311,7822,47575],
 [2311,7833,7828],[2311,7833,8507],[2311,7833,40707],
 [2311,7833,49887],[2311,8051,7817,7828],
 [2311,8051,7817,44904],[2311,8051,7820,7828],
 [2311,8051,7820,8168],[2311,8051,7828],
 [2311,8051,7833,7828],[2311,8051,7833,8507],
 [2311,8051,7833,40707],[2311,8051,7833,49887],
 [2311,8051,8168],[2311,8051,8507],[2311,8051,40251],
 [2311,8051,40264],[2311,8051,40266,45084],
 [2311,8051,40360,46593],[2311,8051,40369],[2311,8051,40571],
 [2311,8051,40572],[2311,8051,40706],[2311,8051,40707],
 [2311,8051,44700,44904],[2311,8051,44700,46593],
 [2311,8051,44904],[2311,8051,44911,44904],
 [2311,8051,44911,45084],[2311,8051,45046,45084],
 [2311,8051,45084],[2311,8051,46593],[2311,8051,46596,46593],
 [2311,8051,46621],[2311,8051,49886],[2311,8051,49887],
 [2311,8053,7817,7828],[2311,8053,7817,44904],
 [2311,8053,7822,7828],[2311,8053,7822,47575],
 [2311,8053,7828],[2311,8053,40253],[2311,8053,40260],
 [2311,8053,40423],[2311,8053,40565],[2311,8053,44763,44904],
 [2311,8053,44763,47575],[2311,8053,44904],[2311,8053,47575],
 [2311,8155,7820,7828],[2311,8155,7820,8168],
 [2311,8155,7822,7828],[2311,8155,7822,47575],
 [2311,8155,7828],[2311,8155,8168],[2311,8155,40355],
 [2311,8155,40362],[2311,8155,40431],[2311,8155,40620],
 [2311,8155,46448,47575],[2311,8155,47575],
 [2311,8155,47581,47575],[2311,38214,38205],
 [2311,38216,38205],[2311,38223,38205],[2311,38227,38205],
 [2311,38229,38205],[2311,38230,38205],[2311,38596,46593],
 [2311,38660,47575],[2311,39405,45084],[2311,39563,47575],
 [2311,40266,45084],[2311,40360,46593],[2311,44700,44904],
 [2311,44700,46593],[2311,44763,44904],[2311,44763,47575],
 [2311,44911,44904],[2311,44911,45084],[2311,44960,45084],
 [2311,45046,45084],[2311,46447,46593],[2311,46448,47575],
 [2311,46596,46593],[2311,47581,47575],[2415,2449,4193],
 [2415,2812,4193],[2417,2429,3507],[2417,2905,3507],
 [2433,2429,3507],[2433,3503,3507],[2433,3503,3677],
 [2433,3503,3714],[2433,3503,38331],[2433,3503,38557],
 [2433,3503,41850],[2433,3503,42593],[2433,9744,38331],
 [2433,9750,38557],[2433,9914,41850],[2433,9953,42593],
 [2436,2429,3507],[2436,3506,3507],[2436,3506,3794],
 [2436,3506,38455],[2436,3506,43965],[2452,2429,3507],
 [2452,3522,3507],[2452,3522,38921],[2452,9763,38921],
 [2455,2429,3507],[2455,3525,3507],[2455,3525,45084],
 [2455,10082,45084],[2457,2429,3507],[2457,3527,3507],
 [2457,3527,39015],[2457,9768,39015],[2478,2492,3507],
 [2478,2792,3507],[2496,2492,3507],[2496,3503,3507],
 [2496,3503,3677],[2496,3503,3714],[2496,3503,38331],
 [2496,3503,38557],[2496,3503,41850],[2496,3503,42593],
 [2496,11697,38331],[2496,11703,38557],[2496,11867,41850],
 [2496,11906,42593],[2503,2492,3507],[2503,3510,3507],
 [2503,3510,3930],[2503,3510,38591],[2503,3510,44695],
 [2515,2492,3507],[2515,3522,3507],[2515,3522,38921],
 [2515,11716,38921],[2518,2492,3507],[2518,3525,3507],
 [2518,3525,45084],[2518,12035,45084],[2520,2492,3507],
 [2520,3527,3507],[2520,3527,39015],[2520,11721,39015],
 [2559,2554,3507],[2559,2555,2554,3507],
 [2559,2555,3500,3507],[2559,2555,3500,38205],
 [2559,2555,3507],[2559,2555,13585,38205],[2559,2555,13635],
 [2559,2555,13677],[2559,2555,38205],[2559,2557,2554,3507],
 [2559,2557,3502,3507],[2559,2557,3502,41069],
 [2559,2557,3507],[2559,2557,13587],[2559,2557,13593],
 [2559,2557,13718,41069],[2559,2557,41069],[2559,2558,3677],
 [2559,2558,13762],[2559,3500,3507],[2559,3500,38205],
 [2559,3502,3507],[2559,3502,41069],[2559,3503,3507],
 [2559,3503,3677],[2559,3503,3714],[2559,3503,38331],
 [2559,3503,38557],[2559,3503,41850],[2559,3503,42593],
 [2559,3545,3500,3507],[2559,3545,3500,38205],
 [2559,3545,3502,3507],[2559,3545,3502,41069],
 [2559,3545,3503,3507],[2559,3545,3503,3677],
 [2559,3545,3503,3714],[2559,3545,3503,38331],
 [2559,3545,3503,38557],[2559,3545,3503,41850],
 [2559,3545,3503,42593],[2559,3545,3507],[2559,3545,3677],
 [2559,3545,3714],[2559,3545,38205],[2559,3545,38206,38205],
 [2559,3545,38206,38331],[2559,3545,38206,39193],
 [2559,3545,38206,40055],[2559,3545,38212,38205],
 [2559,3545,38212,38557],[2559,3545,38212,39424],
 [2559,3545,38212,40287],[2559,3545,38296,38557],
 [2559,3545,38331],[2559,3545,38335,38331],[2559,3545,38557],
 [2559,3545,39193],[2559,3545,39197,39193],
 [2559,3545,39197,39424],[2559,3545,39197,41069],
 [2559,3545,39197,41850],[2559,3545,39201,39193],
 [2559,3545,39276,42593],[2559,3545,39277,39424],
 [2559,3545,39424],[2559,3545,40055],[2559,3545,40058,40055],
 [2559,3545,40058,40287],[2559,3545,40058,41069],
 [2559,3545,40058,42593],[2559,3545,40060,40055],
 [2559,3545,40098,41850],[2559,3545,40099,40287],
 [2559,3545,40287],[2559,3545,41069],[2559,3545,41850],
 [2559,3545,42593],[2559,13585,38205],[2559,13588,38331],
 [2559,13594,13585,38205],[2559,13594,13593],
 [2559,13594,13636,39424],[2559,13594,13639],
 [2559,13594,13678,40287],[2559,13594,13679],
 [2559,13594,38205],[2559,13594,38212,38205],
 [2559,13594,38212,38557],[2559,13594,38212,39424],
 [2559,13594,38212,40287],[2559,13594,38557],
 [2559,13594,39424],[2559,13594,40287],[2559,13630,39193],
 [2559,13636,39424],[2559,13672,40055],[2559,13678,40287],
 [2559,13718,41069],[2559,13758,41850],
 [2559,13797,13672,40055],[2559,13797,13677],
 [2559,13797,13678,40287],[2559,13797,13718,41069],
 [2559,13797,13722],[2559,13797,13798],[2559,13797,40055],
 [2559,13797,40058,40055],[2559,13797,40058,40287],
 [2559,13797,40058,41069],[2559,13797,40058,42593],
 [2559,13797,40287],[2559,13797,41069],[2559,13797,42593],
 [2559,38206,38205],[2559,38206,38331],[2559,38206,39193],
 [2559,38206,40055],[2559,38212,38205],[2559,38212,38557],
 [2559,38212,39424],[2559,38212,40287],[2559,38296,38557],
 [2559,38335,38331],[2559,39197,39193],[2559,39197,39424],
 [2559,39197,41069],[2559,39197,41850],[2559,39201,39193],
 [2559,39276,42593],[2559,39277,39424],[2559,40058,40055],
 [2559,40058,40287],[2559,40058,41069],[2559,40058,42593],
 [2559,40060,40055],[2559,40098,41850],[2559,40099,40287],
 [2577,2554,3507],[2577,3522,3507],[2577,3522,38921],
 [2577,13607,38921],[2580,2554,3507],[2580,3525,3507],
 [2580,3525,45084],[2580,13926,45084],[2582,2554,3507],
 [2582,3527,3507],[2582,3527,39015],[2582,13612,39015],
 [2590,2554,3507],[2590,3535,3507],[2591,2554,3507],
 [2591,3536,3507],[2618,2615,3507],[2618,3502,3507],
 [2618,3502,41069],[2618,15548,41069],[2638,2615,3507],
 [2638,2616,2615,3507],[2638,2616,3500,3507],
 [2638,2616,3500,38205],[2638,2616,3507],
 [2638,2616,15415,38205],[2638,2616,15465],[2638,2616,15507],
 [2638,2616,38205],[2638,3500,3507],[2638,3500,38205],
 [2638,3520,3507],[2638,3522,3507],[2638,3522,38921],
 [2638,3563,3500,3507],[2638,3563,3500,38205],
 [2638,3563,3507],[2638,3563,3520,3507],
 [2638,3563,3522,3507],[2638,3563,3522,38921],
 [2638,3563,38205],[2638,3563,38224,38205],
 [2638,3563,38224,38921],[2638,3563,38224,39779],
 [2638,3563,38224,40642],[2638,3563,38921],
 [2638,3563,39400,39779],[2638,3563,39404],[2638,3563,39779],
 [2638,3563,40261,40642],[2638,3563,40263],[2638,3563,40642],
 [2638,15415,38205],[2638,15437,38921],
 [2638,15478,15415,38205],[2638,15478,15520,40642],
 [2638,15478,15522],[2638,15478,38224,38205],
 [2638,15478,38224,38921],[2638,15478,38224,39779],
 [2638,15478,38224,40642],[2638,15478,39779],
 [2638,15520,40642],[2638,38224,38205],[2638,38224,38921],
 [2638,38224,39779],[2638,38224,40642],[2638,39400,39779],
 [2638,40261,40642],[2641,2615,3507],[2641,2633,2615,3507],
 [2641,2633,3507],[2641,2633,3517,3507],
 [2641,2633,3517,44904],[2641,2633,15432],[2641,2633,15433],
 [2641,2633,15748,44904],[2641,2633,44904],[2641,3517,3507],
 [2641,3517,44904],[2641,3525,3507],[2641,3525,45084],
 [2641,4146,3507],[2641,4146,3517,3507],
 [2641,4146,3517,44904],[2641,4146,3525,3507],
 [2641,4146,3525,45084],[2641,4146,38807],[2641,4146,38808],
 [2641,4146,38832],[2641,4146,38833],[2641,4146,44904],
 [2641,4146,44911,44904],[2641,4146,44911,45084],
 [2641,4146,45084],[2641,15748,44904],[2641,15756,45084],
 [2641,44911,44904],[2641,44911,45084],[2643,2615,3507],
 [2643,3527,3507],[2643,3527,39015],[2643,15442,39015],
 [2679,2675,3507],[2679,3503,3507],[2679,3503,3677],
 [2679,3503,3714],[2679,3503,38331],[2679,3503,38557],
 [2679,3503,41850],[2679,3503,42593],[2679,17188,38331],
 [2679,17194,38557],[2679,17358,41850],[2679,17397,42593],
 [2698,2675,3507],[2698,3522,3507],[2698,3522,38921],
 [2698,17207,38921],[2701,2675,3507],[2701,3525,3507],
 [2701,3525,45084],[2701,17526,45084],[2703,2675,3507],
 [2703,3527,3507],[2703,3527,39015],[2703,17212,39015],
 [2757,2734,3507],[2757,2738,3677],[2757,2738,19073],
 [2757,2739,2734,3507],[2757,2739,2738,3677],
 [2757,2739,2738,19073],[2757,2739,3503,3507],
 [2757,2739,3503,3677],[2757,2739,3503,3714],
 [2757,2739,3503,38331],[2757,2739,3503,38557],
 [2757,2739,3503,41850],[2757,2739,3503,42593],
 [2757,2739,3507],[2757,2739,3677],[2757,2739,3714],
 [2757,2739,18899,38331],[2757,2739,18905,38557],
 [2757,2739,19069,41850],[2757,2739,19073],
 [2757,2739,19108,42593],[2757,2739,19110],[2757,2739,38331],
 [2757,2739,38557],[2757,2739,41850],[2757,2739,42593],
 [2757,2752,2734,3507],[2757,2752,3507],
 [2757,2752,3517,3507],[2757,2752,3517,44904],
 [2757,2752,18913],[2757,2752,18914],[2757,2752,19229,44904],
 [2757,2752,44904],[2757,3503,3507],[2757,3503,3677],
 [2757,3503,3714],[2757,3503,38331],[2757,3503,38557],
 [2757,3503,41850],[2757,3503,42593],[2757,3517,3507],
 [2757,3517,44904],[2757,3522,3507],[2757,3522,38921],
 [2757,3683,3503,3507],[2757,3683,3503,3677],
 [2757,3683,3503,3714],[2757,3683,3503,38331],
 [2757,3683,3503,38557],[2757,3683,3503,41850],
 [2757,3683,3503,42593],[2757,3683,3507],
 [2757,3683,3517,3507],[2757,3683,3517,44904],
 [2757,3683,3522,3507],[2757,3683,3522,38921],
 [2757,3683,3677],[2757,3683,3714],[2757,3683,38331],
 [2757,3683,38344,38331],[2757,3683,38345,38331],
 [2757,3683,38345,38921],[2757,3683,38345,42193],
 [2757,3683,38345,42936],[2757,3683,38557],
 [2757,3683,38563,38557],[2757,3683,38563,38921],
 [2757,3683,38563,46064],[2757,3683,38563,47090],
 [2757,3683,38564,38557],[2757,3683,38921],[2757,3683,41850],
 [2757,3683,41858,41850],[2757,3683,41858,42193],
 [2757,3683,41858,44904],[2757,3683,41858,46064],
 [2757,3683,41865,41850],[2757,3683,41992,47090],
 [2757,3683,41993,42193],[2757,3683,42193],[2757,3683,42593],
 [2757,3683,42599,42593],[2757,3683,42599,42936],
 [2757,3683,42599,44904],[2757,3683,42599,47090],
 [2757,3683,42604,42593],[2757,3683,42668,46064],
 [2757,3683,42669,42936],[2757,3683,42936],[2757,3683,44904],
 [2757,3683,46064],[2757,3683,47090],[2757,18899,38331],
 [2757,18905,38557],[2757,18918,18899,38331],
 [2757,18918,18914],[2757,18918,19080,42193],
 [2757,18918,19086],[2757,18918,19119,42936],
 [2757,18918,19123],[2757,18918,38331],
 [2757,18918,38345,38331],[2757,18918,38345,38921],
 [2757,18918,38345,42193],[2757,18918,38345,42936],
 [2757,18918,38921],[2757,18918,42193],[2757,18918,42936],
 [2757,19069,41850],[2757,19080,42193],[2757,19108,42593],
 [2757,19119,42936],[2757,19229,44904],
 [2757,19298,19069,41850],[2757,19298,19079],
 [2757,19298,19080,42193],[2757,19298,19229,44904],
 [2757,19298,19234],[2757,19298,19299],[2757,19298,41850],
 [2757,19298,41858,41850],[2757,19298,41858,42193],
 [2757,19298,41858,44904],[2757,19298,41858,46064],
 [2757,19298,42193],[2757,19298,44904],[2757,19298,46064],
 [2757,19363,47090],[2757,38344,38331],[2757,38345,38331],
 [2757,38345,38921],[2757,38345,42193],[2757,38345,42936],
 [2757,38563,38557],[2757,38563,38921],[2757,38563,46064],
 [2757,38563,47090],[2757,38564,38557],[2757,41858,41850],
 [2757,41858,42193],[2757,41858,44904],[2757,41858,46064],
 [2757,41865,41850],[2757,41992,47090],[2757,41993,42193],
 [2757,42599,42593],[2757,42599,42936],[2757,42599,44904],
 [2757,42599,47090],[2757,42604,42593],[2757,42668,46064],
 [2757,42669,42936],[2760,2734,3507],[2760,3525,3507],
 [2760,3525,45084],[2760,19237,45084],[2762,2734,3507],
 [2762,3527,3507],[2762,3527,39015],[2762,18923,39015],
 [2772,2734,3507],[2772,3537,3507],[2773,2734,3507],
 [2773,3538,3507],[2793,2792,3507],[2793,3500,3507],
 [2793,3500,38205],[2793,20549,38205],[2796,2792,3507],
 [2796,2797,3714],[2796,2797,20763],[2796,3503,3507],
 [2796,3503,3677],[2796,3503,3714],[2796,3503,38331],
 [2796,3503,38557],[2796,3503,41850],[2796,3503,42593],
 [2796,20552,38331],[2796,20558,38557],[2796,20722,41850],
 [2796,20761,42593],[2803,2792,3507],[2803,3510,3507],
 [2803,3510,3930],[2803,3510,38591],[2803,3510,44695],
 [2810,2792,3507],[2810,3517,3507],[2810,3517,44904],
 [2810,20567,20561],[2810,20567,20568],
 [2810,20567,21048,47575],[2810,20567,38660,47575],
 [2810,20567,47575],[2810,20882,44904],[2815,2792,3507],
 [2815,2795,2792,3507],[2815,2795,3502,3507],
 [2815,2795,3502,41069],[2815,2795,3507],[2815,2795,20551],
 [2815,2795,20557],[2815,2795,20682,41069],[2815,2795,41069],
 [2815,3502,3507],[2815,3502,41069],[2815,3522,3507],
 [2815,3522,38921],[2815,3648,3502,3507],
 [2815,3648,3502,41069],[2815,3648,3507],
 [2815,3648,3522,3507],[2815,3648,3522,38921],
 [2815,3648,38309,38921],[2815,3648,38534,38921],
 [2815,3648,38921],[2815,3648,41069],[2815,3648,41083,41069],
 [2815,3648,41085,41069],[2815,20571,38921],
 [2815,20682,41069],[2815,20697,20682,41069],
 [2815,20697,20922],[2815,20697,41069],
 [2815,20697,41083,41069],[2815,38309,38921],
 [2815,38534,38921],[2815,41083,41069],[2815,41085,41069],
 [2818,2792,3507],[2818,3525,3507],[2818,3525,45084],
 [2818,20890,45084],[2820,2792,3507],[2820,3527,3507],
 [2820,3527,39015],[2820,20576,39015],[2829,2792,3507],
 [2829,3536,3507],[2850,2849,3507],[2850,3500,3507],
 [2850,3500,38205],[2850,22145,38205],[2853,2849,3507],
 [2853,2854,3714],[2853,2854,22359],[2853,3503,3507],
 [2853,3503,3677],[2853,3503,3714],[2853,3503,38331],
 [2853,3503,38557],[2853,3503,41850],[2853,3503,42593],
 [2853,22148,38331],[2853,22154,38557],[2853,22318,41850],
 [2853,22357,42593],[2855,2849,3507],[2855,3505,3507],
 [2855,3505,3756],[2869,2849,3507],[2869,3519,3507],
 [2869,3519,4193],[2871,2849,3507],[2871,3521,3507],
 [2872,2849,3507],[2872,3522,3507],[2872,3522,38921],
 [2872,22167,38921],[2875,2849,3507],[2875,3525,3507],
 [2875,3525,45084],[2875,22486,45084],[2877,2849,3507],
 [2877,3527,3507],[2877,3527,39015],[2877,22172,39015],
 [2884,2849,3507],[2884,3534,3507],[2889,2849,3507],
 [2889,3539,3507],[2906,2905,3507],[2906,3500,3507],
 [2906,3500,38205],[2906,23685,38205],
 [2906,23777,23783,40450],[2906,23777,24014],
 [2906,23777,24015],[2906,23777,40254,40450],
 [2906,23777,40450],[2908,2905,3507],[2908,3502,3507],
 [2908,3502,41069],[2908,23818,41069],[2909,2928,2905,3507],
 [2909,2928,3507],[2909,2928,3522,3507],
 [2909,2928,3522,38921],[2909,2928,23707,38921],
 [2909,2928,24023],[2909,2928,24025],[2909,2928,38921],
 [2909,3522,3507],[2909,3522,38921],[2909,3683,3503,3507],
 [2909,3683,3503,3677],[2909,3683,3503,3714],
 [2909,3683,3503,38331],[2909,3683,3503,38557],
 [2909,3683,3503,41850],[2909,3683,3503,42593],
 [2909,3683,3507],[2909,3683,3517,3507],
 [2909,3683,3517,44904],[2909,3683,3522,3507],
 [2909,3683,3522,38921],[2909,3683,3677],[2909,3683,3714],
 [2909,3683,38331],[2909,3683,38344,38331],
 [2909,3683,38345,38331],[2909,3683,38345,38921],
 [2909,3683,38345,42193],[2909,3683,38345,42936],
 [2909,3683,38557],[2909,3683,38563,38557],
 [2909,3683,38563,38921],[2909,3683,38563,46064],
 [2909,3683,38563,47090],[2909,3683,38564,38557],
 [2909,3683,38921],[2909,3683,41850],[2909,3683,41858,41850],
 [2909,3683,41858,42193],[2909,3683,41858,44904],
 [2909,3683,41858,46064],[2909,3683,41865,41850],
 [2909,3683,41992,47090],[2909,3683,41993,42193],
 [2909,3683,42193],[2909,3683,42593],[2909,3683,42599,42593],
 [2909,3683,42599,42936],[2909,3683,42599,44904],
 [2909,3683,42599,47090],[2909,3683,42604,42593],
 [2909,3683,42668,46064],[2909,3683,42669,42936],
 [2909,3683,42936],[2909,3683,44904],[2909,3683,46064],
 [2909,3683,47090],[2909,23707,38921],
 [2909,23862,23869,42193],[2909,23862,24153],
 [2909,23862,41993,42193],[2909,23862,42193],
 [2909,23869,42193],[2909,24152,23908,42936],
 [2909,24152,24018,44904],[2909,24152,24153],
 [2909,24152,42599,42593],[2909,24152,42599,42936],
 [2909,24152,42599,44904],[2909,24152,42599,47090],
 [2909,24152,47090],[2909,38345,38331],[2909,38345,38921],
 [2909,38345,42193],[2909,38345,42936],[2909,38563,38557],
 [2909,38563,38921],[2909,38563,46064],[2909,38563,47090],
 [2909,41992,47090],[2909,41993,42193],[2912,2905,3507],
 [2912,3506,3507],[2912,3506,3794],[2912,3506,38455],
 [2912,3506,43965],[2923,2905,3507],[2923,3517,3507],
 [2923,3517,44904],[2923,24018,44904],[2931,2905,3507],
 [2931,3525,3507],[2931,3525,45084],[2931,24026,45084],
 [2933,2905,3507],[2933,3527,3507],[2933,3527,39015],
 [2933,23712,39015],[2938,2905,3507],[2938,3532,3507],
 [2961,2960,3507],[2961,3500,3507],[2961,3500,38205],
 [2961,25170,38205],[2963,2960,3507],[2963,3502,3507],
 [2963,3502,41069],[2963,25303,41069],[2978,2960,3507],
 [2978,3517,3507],[2978,3517,44904],[2978,25503,44904],
 [2983,2960,3507],[2983,3522,3507],[2983,3522,38921],
 [2983,25192,38921],[2986,2960,3507],[2986,2963,2960,3507],
 [2986,2963,3502,3507],[2986,2963,3502,41069],
 [2986,2963,3507],[2986,2963,25172],[2986,2963,25178],
 [2986,2963,25303,41069],[2986,2963,41069],[2986,3502,3507],
 [2986,3502,41069],[2986,3525,3507],[2986,3525,45084],
 [2986,3651,3502,3507],[2986,3651,3502,41069],
 [2986,3651,3507],[2986,3651,3525,3507],
 [2986,3651,3525,45084],[2986,3651,38312],[2986,3651,38313],
 [2986,3651,38537],[2986,3651,38538],[2986,3651,41069],
 [2986,3651,41086,41069],[2986,3651,41086,45084],
 [2986,3651,45084],[2986,25303,41069],[2986,25511,45084],
 [2986,41086,41069],[2986,41086,45084],[2988,2960,3507],
 [2988,2961,2960,3507],[2988,2961,3500,3507],
 [2988,2961,3500,38205],[2988,2961,3507],
 [2988,2961,25170,38205],[2988,2961,25220],[2988,2961,25262],
 [2988,2961,38205],[2988,3500,3507],[2988,3500,38205],
 [2988,3527,3507],[2988,3527,39015],[2988,3570,3500,3507],
 [2988,3570,3500,38205],[2988,3570,3507],
 [2988,3570,3527,3507],[2988,3570,3527,39015],
 [2988,3570,38205],[2988,3570,38231,38205],
 [2988,3570,38231,39015],[2988,3570,39015],[2988,3570,39407],
 [2988,3570,39408],[2988,3570,40268],[2988,3570,40269],
 [2988,25170,38205],[2988,25197,39015],[2988,38231,38205],
 [2988,38231,39015],[3015,3014,3507],[3015,3500,3507],
 [3015,3500,38205],[3015,26601,38205],[3017,3014,3507],
 [3017,3502,3507],[3017,3502,41069],[3017,26734,41069],
 [3032,3014,3507],[3032,3517,3507],[3032,3517,44904],
 [3032,26934,44904],[3037,3014,3507],[3037,3522,3507],
 [3037,3522,38921],[3037,26623,38921],[3040,3014,3507],
 [3040,3525,3507],[3040,3525,45084],[3040,26942,45084],
 [3042,3014,3507],[3042,3527,3507],[3042,3527,39015],
 [3042,26628,39015],[3068,3067,3507],[3068,3500,3507],
 [3068,3500,38205],[3068,27979,38205],[3070,3067,3507],
 [3070,3502,3507],[3070,3502,41069],[3070,28112,41069],
 [3085,3067,3507],[3085,3517,3507],[3085,3517,44904],
 [3085,28312,44904],[3090,3067,3507],[3090,3522,3507],
 [3090,3522,38921],[3090,28001,38921],[3093,3067,3507],
 [3093,3525,3507],[3093,3525,45084],[3093,28320,45084],
 [3095,3067,3507],[3095,3527,3507],[3095,3527,39015],
 [3095,28006,39015],[3113,3005,26160],[3113,3008,26316],
 [3113,3060,27643],[3113,3112,28970],[3113,26161,26160],
 [3113,26161,26316],[3113,26161,27643],[3113,26161,28970],
 [3120,3119,3507],[3120,3500,3507],[3120,3500,38205],
 [3120,29305,38205],[3122,3119,3507],[3122,3502,3507],
 [3122,3502,41069],[3122,29438,41069],[3124,3119,3507],
 [3124,3123,3677],[3124,3123,29482],[3124,3503,3507],
 [3124,3503,3677],[3124,3503,3714],[3124,3503,38331],
 [3124,3503,38557],[3124,3503,41850],[3124,3503,42593],
 [3124,29308,38331],[3124,29314,38557],[3124,29478,41850],
 [3124,29517,42593],[3137,3119,3507],[3137,3517,3507],
 [3137,3517,44904],[3137,29638,44904],[3142,3119,3507],
 [3142,3522,3507],[3142,3522,38921],[3142,29327,38921],
 [3145,3119,3507],[3145,3525,3507],[3145,3525,45084],
 [3145,29646,45084],[3147,3119,3507],[3147,3527,3507],
 [3147,3527,39015],[3147,29332,39015],[3171,3170,3507],
 [3171,3500,3507],[3171,3500,38205],[3171,30580,38205],
 [3173,3170,3507],[3173,3502,3507],[3173,3502,41069],
 [3173,30713,41069],[3188,3170,3507],[3188,3517,3507],
 [3188,3517,44904],[3188,30913,44904],[3193,3170,3507],
 [3193,3522,3507],[3193,3522,38921],[3193,30602,38921],
 [3196,3170,3507],[3196,3525,3507],[3196,3525,45084],
 [3196,30921,45084],[3198,3170,3507],[3198,3527,3507],
 [3198,3527,39015],[3198,30607,39015],[3217,3060,27643],
 [3217,3064,27841],[3217,3166,30394],[3217,3216,31620],
 [3217,27645,27643],[3217,27645,27841],[3217,27645,30394],
 [3217,27645,31620],[3221,3220,3507],[3221,3500,3507],
 [3221,3500,38205],[3221,31805,38205],[3223,3220,3507],
 [3223,3502,3507],[3223,3502,41069],[3223,31938,41069],
 [3225,3220,3507],[3225,3224,3677],[3225,3224,31982],
 [3225,3503,3507],[3225,3503,3677],[3225,3503,3714],
 [3225,3503,38331],[3225,3503,38557],[3225,3503,41850],
 [3225,3503,42593],[3225,31808,38331],[3225,31814,38557],
 [3225,31978,41850],[3225,32017,42593],[3238,3220,3507],
 [3238,3517,3507],[3238,3517,44904],[3238,32138,44904],
 [3243,3220,3507],[3243,3522,3507],[3243,3522,38921],
 [3243,31827,38921],[3246,3220,3507],[3246,3525,3507],
 [3246,3525,45084],[3246,32146,45084],[3248,3220,3507],
 [3248,3527,3507],[3248,3527,39015],[3248,31832,39015],
 [3270,3269,3507],[3270,3500,3507],[3270,3500,38205],
 [3270,32981,38205],[3272,3269,3507],[3272,3502,3507],
 [3272,3502,41069],[3272,33114,41069],[3287,3269,3507],
 [3287,3517,3507],[3287,3517,44904],[3287,33314,44904],
 [3292,3269,3507],[3292,3522,3507],[3292,3522,38921],
 [3292,33003,38921],[3295,3269,3507],[3295,3525,3507],
 [3295,3525,45084],[3295,33322,45084],[3297,3269,3507],
 [3297,3527,3507],[3297,3527,39015],[3297,33008,39015],
 [3318,3317,3507],[3318,3500,3507],[3318,3500,38205],
 [3318,34109,38205],[3320,3317,3507],[3320,3502,3507],
 [3320,3502,41069],[3320,34242,41069],[3335,3317,3507],
 [3335,3517,3507],[3335,3517,44904],[3335,34442,44904],
 [3340,3317,3507],[3340,3522,3507],[3340,3522,38921],
 [3340,34131,38921],[3343,3317,3507],[3343,3525,3507],
 [3343,3525,45084],[3343,34450,45084],[3345,3317,3507],
 [3345,3527,3507],[3345,3527,39015],[3345,34136,39015],
 [3365,3364,3507],[3365,3500,3507],[3365,3500,38205],
 [3365,35190,38205],[3367,3364,3507],[3367,3502,3507],
 [3367,3502,41069],[3367,35323,41069],[3369,3364,3507],
 [3369,3368,3677],[3369,3368,35367],[3369,3503,3507],
 [3369,3503,3677],[3369,3503,3714],[3369,3503,38331],
 [3369,3503,38557],[3369,3503,41850],[3369,3503,42593],
 [3369,35193,38331],[3369,35199,38557],[3369,35363,41850],
 [3369,35402,42593],[3382,3364,3507],[3382,3517,3507],
 [3382,3517,44904],[3382,35523,44904],[3387,3364,3507],
 [3387,3522,3507],[3387,3522,38921],[3387,35212,38921],
 [3390,3364,3507],[3390,3525,3507],[3390,3525,45084],
 [3390,35531,45084],[3392,3364,3507],[3392,3527,3507],
 [3392,3527,39015],[3392,35217,39015],[3411,3410,3507],
 [3411,3500,3507],[3411,3500,38205],[3411,36225,38205],
 [3413,3410,3507],[3413,3502,3507],[3413,3502,41069],
 [3413,36358,41069],[3428,3410,3507],[3428,3517,3507],
 [3428,3517,44904],[3428,36558,44904],[3433,3410,3507],
 [3433,3522,3507],[3433,3522,38921],[3433,36247,38921],
 [3436,3410,3507],[3436,3525,3507],[3436,3525,45084],
 [3436,36566,45084],[3438,3410,3507],[3438,3527,3507],
 [3438,3527,39015],[3438,36252,39015],[3456,3455,3507],
 [3456,3500,3507],[3456,3500,38205],[3456,37215,38205],
 [3458,3455,3507],[3458,3502,3507],[3458,3502,41069],
 [3458,37348,41069],[3473,3455,3507],[3473,3517,3507],
 [3473,3517,44904],[3473,37548,44904],[3478,3455,3507],
 [3478,3522,3507],[3478,3522,38921],[3478,37237,38921],
 [3481,3455,3507],[3481,3525,3507],[3481,3525,45084],
 [3481,37556,45084],[3483,3455,3507],[3483,3527,3507],
 [3483,3527,39015],[3483,37242,39015],[3558,3500,3507],
 [3558,3500,38205],[3558,3515,3507],[3558,38219,38205],
 [3559,3500,3507],[3559,3500,38205],[3559,3516,3507],
 [3559,38220,38205],[3564,3500,3507],[3564,3500,38205],
 [3564,3521,3507],[3564,38225,38205],[3572,3500,3507],
 [3572,3500,38205],[3572,3529,3507],[3572,38233,38205],
 [3573,3500,3507],[3573,3500,38205],[3573,3530,3507],
 [3573,3531,3507],[3573,38234,38205],[3573,38234,40824],
 [3573,40271,40824],[3575,3500,3507],[3575,3500,38205],
 [3575,3532,3507],[3575,38236,38205],[3576,3500,3507],
 [3576,3500,38205],[3576,3533,3507],[3576,38237,38205],
 [3577,3500,3507],[3577,3500,38205],[3577,3534,3507],
 [3577,3535,3507],[3577,38238,38205],[3577,38238,40870],
 [3577,40275,40870],[3579,3500,3507],[3579,3500,38205],
 [3579,3536,3507],[3579,38240,38205],[3580,3500,3507],
 [3580,3500,38205],[3580,3537,3507],[3580,38241,38205],
 [3581,3500,3507],[3581,3500,38205],[3581,3538,3507],
 [3581,38242,38205],[3582,3500,3507],[3582,3500,38205],
 [3582,3539,3507],[3582,38243,38205],[3583,3500,3507],
 [3583,3500,38205],[3583,3540,3507],[3583,38244,38205],
 [3584,3500,3507],[3584,3500,38205],[3584,3541,3507],
 [3584,38245,38205],[3585,3500,3507],[3585,3500,38205],
 [3585,3542,3507],[3585,3543,3507],[3585,38246,38205],
 [3585,38246,40914],[3585,40283,40914],[3631,3502,3507],
 [3631,3502,41069],[3631,3505,3507],[3631,3505,3756],
 [3631,3510,3507],[3631,3510,3930],[3631,3510,38591],
 [3631,3510,44695],[3631,38299,41239],[3631,38412,43330],
 [3631,40995,41069],[3631,40995,43330],[3631,41073,41069],
 [3631,41073,41239],[3631,41175,41239],[3631,43332,43330],
 [3641,3502,3507],[3641,3502,41069],[3641,3515,3507],
 [3641,41076,41069],[3642,3502,3507],[3642,3502,41069],
 [3642,3516,3507],[3642,41077,41069],[3645,3502,3507],
 [3645,3502,41069],[3645,3519,3507],[3645,3519,4193],
 [3645,41080,41069],[3645,41084,41069],[3647,3502,3507],
 [3647,3502,41069],[3647,3521,3507],[3647,41082,41069],
 [3651,3502,3507],[3651,3502,41069],[3651,3525,3507],
 [3651,3525,45084],[3651,41086,41069],[3651,41086,45084],
 [3653,3502,3507],[3653,3502,41069],[3653,3527,3507],
 [3653,3527,39015],[3653,38314,39015],[3653,38539,39015],
 [3653,41088,41069],[3653,41089,41069],[3655,3502,3507],
 [3655,3502,41069],[3655,3529,3507],[3655,3530,3507],
 [3655,38541,45745],[3655,41090,41069],[3655,41090,45745],
 [3657,3502,3507],[3657,3502,41069],[3657,3531,3507],
 [3657,41092,41069],[3658,3502,3507],[3658,3502,41069],
 [3658,3532,3507],[3658,41093,41069],[3659,3502,3507],
 [3659,3502,41069],[3659,3533,3507],[3659,41094,41069],
 [3660,3502,3507],[3660,3502,41069],[3660,3534,3507],
 [3660,3536,3507],[3660,38546,45806],[3660,41095,41069],
 [3660,41095,45806],[3661,3502,3507],[3661,3502,41069],
 [3661,3535,3507],[3661,41096,41069],[3663,3502,3507],
 [3663,3502,41069],[3663,3537,3507],[3663,41098,41069],
 [3664,3502,3507],[3664,3502,41069],[3664,3538,3507],
 [3664,41099,41069],[3665,3502,3507],[3665,3502,41069],
 [3665,3539,3507],[3665,41100,41069],[3666,3502,3507],
 [3666,3502,41069],[3666,3540,3507],[3666,41101,41069],
 [3667,3502,3507],[3667,3502,41069],[3667,3541,3507],
 [3667,3542,3507],[3667,38553,45847],[3667,41102,41069],
 [3667,41102,45847],[3669,3502,3507],[3669,3502,41069],
 [3669,3543,3507],[3669,41104,41069],[3671,3503,3507],
 [3671,3503,3677],[3671,3503,3714],[3671,3503,38331],
 [3671,3503,38557],[3671,3503,41850],[3671,3503,42593],
 [3671,3505,3507],[3671,3505,3756],[3671,3710,3714],
 [3671,3710,3756],[3671,3710,42518],[3671,3710,42664],
 [3671,38332,38331],[3671,38340,38331],[3671,38413,38557],
 [3671,38559,38557],[3671,41775,41850],[3671,41854,41850],
 [3671,42516,42593],[3671,42595,42593],[3681,41990,42109],
 [3685,3503,3507],[3685,3503,3677],[3685,3503,3714],
 [3685,3503,38331],[3685,3503,38557],[3685,3503,41850],
 [3685,3503,42593],[3685,3519,3507],[3685,3519,4193],
 [3685,3724,3714],[3685,3724,4193],[3685,3724,42670],
 [3685,3724,42674],[3685,38346,38331],[3685,38350,38331],
 [3685,38565,38557],[3685,38569,38557],[3685,41860,41850],
 [3685,41864,41850],[3685,42601,42593],[3685,42605,42593],
 [3691,3503,3507],[3691,3503,3677],[3691,3503,3714],
 [3691,3503,38331],[3691,3503,38557],[3691,3503,41850],
 [3691,3503,42593],[3691,3525,3507],[3691,3525,45084],
 [3691,3527,3507],[3691,3527,39015],[3691,38352,38331],
 [3691,38353,38331],[3691,38353,39015],[3691,38353,42362],
 [3691,38353,43104],[3691,38571,38557],[3691,38571,39015],
 [3691,38571,46241],[3691,38571,47266],[3691,38572,38557],
 [3691,41866,41850],[3691,41866,42362],[3691,41866,45084],
 [3691,41866,46241],[3691,41869,41850],[3691,42000,47266],
 [3691,42001,42362],[3691,42607,42593],[3691,42607,43104],
 [3691,42607,45084],[3691,42607,47266],[3691,42609,42593],
 [3691,42676,46241],[3691,42677,43104],[3695,42004,47331],
 [3698,42007,42449],[3701,42010,47399],[3703,42012,42494],
 [3707,42016,47433],[3711,42555,44030],[3711,42558,42761],
 [3711,42663,42761],[3711,42696,42761],[3711,44032,44030],
 [3711,44034,44030],[3726,3503,3507],[3726,3503,3677],
 [3726,3503,3714],[3726,3503,38331],[3726,3503,38557],
 [3726,3503,41850],[3726,3503,42593],[3726,3521,3507],
 [3726,3687,3677],[3726,3687,41996],[3726,38348,38331],
 [3726,38567,38557],[3726,41862,41850],[3726,42603,42593],
 [3735,3503,3507],[3735,3503,3677],[3735,3503,3714],
 [3735,3503,38331],[3735,3503,38557],[3735,3503,41850],
 [3735,3503,42593],[3735,3530,3507],[3735,3696,3677],
 [3735,3696,42005],[3735,38357,38331],[3735,38576,38557],
 [3735,41871,41850],[3735,42612,42593],[3739,3503,3507],
 [3739,3503,3677],[3739,3503,3714],[3739,3503,38331],
 [3739,3503,38557],[3739,3503,41850],[3739,3503,42593],
 [3739,3534,3507],[3739,3700,3677],[3739,3700,42009],
 [3739,38361,38331],[3739,38580,38557],[3739,41875,41850],
 [3739,42616,42593],[3747,3503,3507],[3747,3503,3677],
 [3747,3503,3714],[3747,3503,38331],[3747,3503,38557],
 [3747,3503,41850],[3747,3503,42593],[3747,3542,3507],
 [3747,3708,3677],[3747,3708,42017],[3747,38369,38331],
 [3747,38588,38557],[3747,41883,41850],[3747,42624,42593],
 [3765,3505,3507],[3765,3505,3756],[3765,3522,3507],
 [3765,3522,38921],[3765,38426,38921],[3765,38694,38921],
 [3768,3505,3507],[3768,3505,3756],[3768,3525,3507],
 [3768,3525,45084],[3768,43310,45084],[3768,44801,45084],
 [3780,3505,3507],[3780,3505,3756],[3780,3537,3507],
 [3799,3506,3507],[3799,3506,3794],[3799,3506,38455],
 [3799,3506,43965],[3799,3519,3507],[3799,3519,4193],
 [3799,3522,3507],[3799,3522,38921],[3799,38463,38921],
 [3799,38463,44394],[3799,38720,38921],[3799,38720,48445],
 [3799,43973,44394],[3799,44194,48445],[3799,44197,44394],
 [3799,44824,48445],[3801,3506,3507],[3801,3506,3794],
 [3801,3506,38455],[3801,3506,43965],[3801,3521,3507],
 [3805,3506,3507],[3805,3506,3794],[3805,3506,38455],
 [3805,3506,43965],[3805,3525,3507],[3805,3525,45084],
 [3805,43976,45084],[3805,44830,45084],[3810,3506,3507],
 [3810,3506,3794],[3810,3506,38455],[3810,3506,43965],
 [3810,3530,3507],[3940,3510,3507],[3940,3510,3930],
 [3940,3510,38591],[3940,3510,44695],[3940,3522,3507],
 [3940,3522,38921],[3940,38601,38921],[3940,38664,38921],
 [3945,3510,3507],[3945,3510,3930],[3945,3510,38591],
 [3945,3510,44695],[3945,3527,3507],[3945,3527,39015],
 [3945,38606,39015],[3945,38669,39015],[4085,3515,3507],
 [4085,3517,3507],[4085,3517,44904],[4085,3521,3507],
 [4085,38747,48796],[4085,44850,44904],[4085,44850,48796],
 [4090,3515,3507],[4090,3522,3507],[4090,3522,38921],
 [4090,38751,38921],[4093,3515,3507],[4093,3525,3507],
 [4093,3525,45084],[4093,44858,45084],[4095,3515,3507],
 [4095,3527,3507],[4095,3527,39015],[4095,38756,39015],
 [4112,3516,3507],[4112,3517,3507],[4112,3517,44904],
 [4112,44877,44904],[4116,3516,3507],[4116,3521,3507],
 [4116,3522,3507],[4116,3522,38921],[4116,38777,38921],
 [4116,38777,49217],[4116,44881,49217],[4120,3516,3507],
 [4120,3525,3507],[4120,3525,45084],[4120,44885,45084],
 [4122,3516,3507],[4122,3527,3507],[4122,3527,39015],
 [4122,38783,39015],[4150,3517,3507],[4150,3517,44904],
 [4150,3529,3507],[4150,44915,44904],[4151,3517,3507],
 [4151,3517,44904],[4151,3530,3507],[4151,44916,44904],
 [4152,3517,3507],[4152,3517,44904],[4152,3531,3507],
 [4152,44917,44904],[4153,3517,3507],[4153,3517,44904],
 [4153,3532,3507],[4153,44918,44904],[4154,3517,3507],
 [4154,3517,44904],[4154,3533,3507],[4154,3540,3507],
 [4154,38840,50046],[4154,44919,44904],[4154,44919,50046],
 [4155,3517,3507],[4155,3517,44904],[4155,3534,3507],
 [4155,44920,44904],[4156,3517,3507],[4156,3517,44904],
 [4156,3535,3507],[4156,44921,44904],[4157,3517,3507],
 [4157,3517,44904],[4157,3536,3507],[4157,44922,44904],
 [4158,3517,3507],[4158,3517,44904],[4158,3537,3507],
 [4158,3539,3507],[4158,38844,50075],[4158,44923,44904],
 [4158,44923,50075],[4159,3517,3507],[4159,3517,44904],
 [4159,3538,3507],[4159,44924,44904],[4162,3517,3507],
 [4162,3517,44904],[4162,3541,3507],[4162,44927,44904],
 [4163,3517,3507],[4163,3517,44904],[4163,3542,3507],
 [4163,44928,44904],[4164,3517,3507],[4164,3517,44904],
 [4164,3543,3507],[4164,44929,44904],[4197,3519,3507],
 [4197,3519,4193],[4197,3527,3507],[4197,3527,39015],
 [4197,38858,39015],[4197,38944,39015],[4240,3521,3507],
 [4240,3525,3507],[4240,3525,45084],[4240,45005,45084],
 [4242,3521,3507],[4242,3527,3507],[4242,3527,39015],
 [4242,38903,39015],[4247,3521,3507],[4247,3532,3507],
 [4248,3521,3507],[4248,3533,3507],[4252,3521,3507],
 [4252,3537,3507],[4253,3521,3507],[4253,3538,3507],
 [4261,3522,3507],[4261,3522,38921],[4261,3525,3507],
 [4261,3525,45084],[4261,38922,38921],[4261,38923,38921],
 [4261,45026,45084],[4261,45065,45084],[4263,3522,3507],
 [4263,3522,38921],[4263,3527,3507],[4263,3527,39015],
 [4263,38924,38921],[4263,38924,39015],[4265,3522,3507],
 [4265,3522,38921],[4265,3529,3507],[4265,38926,38921],
 [4266,3522,3507],[4266,3522,38921],[4266,3530,3507],
 [4266,38927,38921],[4267,3522,3507],[4267,3522,38921],
 [4267,3531,3507],[4267,38928,38921],[4268,3522,3507],
 [4268,3522,38921],[4268,3532,3507],[4268,3540,3507],
 [4268,38929,38921],[4268,38929,51006],[4268,45033,51006],
 [4269,3522,3507],[4269,3522,38921],[4269,3533,3507],
 [4269,38930,38921],[4270,3522,3507],[4270,3522,38921],
 [4270,3534,3507],[4270,38931,38921],[4271,3522,3507],
 [4271,3522,38921],[4271,3535,3507],[4271,38932,38921],
 [4272,3522,3507],[4272,3522,38921],[4272,3536,3507],
 [4272,38933,38921],[4273,3522,3507],[4273,3522,38921],
 [4273,3537,3507],[4273,38934,38921],[4274,3522,3507],
 [4274,3522,38921],[4274,3538,3507],[4274,3539,3507],
 [4274,38935,38921],[4274,38935,51050],[4274,45039,51050],
 [4277,3522,3507],[4277,3522,38921],[4277,3541,3507],
 [4277,38938,38921],[4278,3522,3507],[4278,3522,38921],
 [4278,3542,3507],[4278,38939,38921],[4279,3522,3507],
 [4279,3522,38921],[4279,3543,3507],[4279,38940,38921],
 [4322,3525,3507],[4322,3525,45084],[4322,3529,3507],
 [4322,45087,45084],[4323,3525,3507],[4323,3525,45084],
 [4323,3530,3507],[4323,45088,45084],[4324,3525,3507],
 [4324,3525,45084],[4324,3531,3507],[4324,45089,45084],
 [4325,3525,3507],[4325,3525,45084],[4325,3532,3507],
 [4325,45090,45084],[4326,3525,3507],[4326,3525,45084],
 [4326,3533,3507],[4326,45091,45084],[4327,3525,3507],
 [4327,3525,45084],[4327,3534,3507],[4327,45092,45084],
 [4328,3525,3507],[4328,3525,45084],[4328,3535,3507],
 [4328,45093,45084],[4329,3525,3507],[4329,3525,45084],
 [4329,3536,3507],[4329,45094,45084],[4330,3525,3507],
 [4330,3525,45084],[4330,3537,3507],[4330,45095,45084],
 [4331,3525,3507],[4331,3525,45084],[4331,3538,3507],
 [4331,45096,45084],[4332,3525,3507],[4332,3525,45084],
 [4332,3539,3507],[4332,45097,45084],[4333,3525,3507],
 [4333,3525,45084],[4333,3540,3507],[4333,45098,45084],
 [4334,3525,3507],[4334,3525,45084],[4334,3541,3507],
 [4334,45099,45084],[4335,3525,3507],[4335,3525,45084],
 [4335,3542,3507],[4335,45100,45084],[4336,3525,3507],
 [4336,3525,45084],[4336,3543,3507],[4336,45101,45084],
 [4355,3527,3507],[4355,3527,39015],[4355,3529,3507],
 [4355,39016,39015],[4356,3527,3507],[4356,3527,39015],
 [4356,3530,3507],[4356,39017,39015],[4357,3527,3507],
 [4357,3527,39015],[4357,3531,3507],[4357,39018,39015],
 [4358,3527,3507],[4358,3527,39015],[4358,3532,3507],
 [4358,39019,39015],[4359,3527,3507],[4359,3527,39015],
 [4359,3533,3507],[4359,39020,39015],[4360,3527,3507],
 [4360,3527,39015],[4360,3534,3507],[4360,39021,39015],
 [4361,3527,3507],[4361,3527,39015],[4361,3535,3507],
 [4361,39022,39015],[4362,3527,3507],[4362,3527,39015],
 [4362,3536,3507],[4362,39023,39015],[4363,3527,3507],
 [4363,3527,39015],[4363,3537,3507],[4363,39024,39015],
 [4364,3527,3507],[4364,3527,39015],[4364,3538,3507],
 [4364,39025,39015],[4365,3527,3507],[4365,3527,39015],
 [4365,3539,3507],[4365,39026,39015],[4366,3527,3507],
 [4366,3527,39015],[4366,3540,3507],[4366,39027,39015],
 [4367,3527,3507],[4367,3527,39015],[4367,3541,3507],
 [4367,39028,39015],[4368,3527,3507],[4368,3527,39015],
 [4368,3542,3507],[4368,39029,39015],[4369,3527,3507],
 [4369,3527,39015],[4369,3543,3507],[4369,39030,39015],
 [4403,3530,3507],[4403,3535,3507],[4404,3530,3507],
 [4404,3536,3507],[4409,3530,3507],[4409,3541,3507],
 [4411,3530,3507],[4411,3543,3507],[4580,4575,5705],
 [4580,5693,5705],[4580,5693,39313],[4580,9789,39313],
 [4583,4575,5705],[4583,5696,5705],[4583,5696,6018],
 [4583,5696,6050],[4583,5696,39424],[4583,5696,39779],
 [4583,5696,45501],[4583,5696,46064],[4583,9792,39424],
 [4583,9804,39779],[4583,10109,45501],[4583,10143,46064],
 [4585,4575,5705],[4585,5698,5705],[4585,5698,46593],
 [4585,10176,46593],[4586,4575,5705],[4586,5699,5705],
 [4586,5699,47090],[4586,10208,47090],[4626,4638,5705],
 [4626,5106,5705],[4643,4638,5705],[4643,5693,5705],
 [4643,5693,39313],[4643,11742,39313],[4646,4638,5705],
 [4646,5696,5705],[4646,5696,6018],[4646,5696,6050],
 [4646,5696,39424],[4646,5696,39779],[4646,5696,45501],
 [4646,5696,46064],[4646,11745,39424],[4646,11757,39779],
 [4646,12062,45501],[4646,12096,46064],[4648,4638,5705],
 [4648,5698,5705],[4648,5698,46593],[4648,12129,46593],
 [4649,4638,5705],[4649,5699,5705],[4649,5699,47090],
 [4649,12161,47090],[4705,4700,5705],[4705,5693,5705],
 [4705,5693,39313],[4705,13633,39313],[4710,4700,5705],
 [4710,5698,5705],[4710,5698,46593],[4710,14020,46593],
 [4711,4699,4700,5705],[4711,4699,5645,5705],
 [4711,4699,5645,38205],[4711,4699,5705],
 [4711,4699,13585,38205],[4711,4699,13602],[4711,4699,13687],
 [4711,4699,38205],[4711,4700,5705],[4711,4708,6018],
 [4711,4708,13958],[4711,4709,4700,5705],
 [4711,4709,4708,6018],[4711,4709,4708,13958],
 [4711,4709,5696,5705],[4711,4709,5696,6018],
 [4711,4709,5696,6050],[4711,4709,5696,39424],
 [4711,4709,5696,39779],[4711,4709,5696,45501],
 [4711,4709,5696,46064],[4711,4709,5705],[4711,4709,6018],
 [4711,4709,6050],[4711,4709,13636,39424],
 [4711,4709,13648,39779],[4711,4709,13953,45501],
 [4711,4709,13958],[4711,4709,13987,46064],[4711,4709,13990],
 [4711,4709,39424],[4711,4709,39779],[4711,4709,45501],
 [4711,4709,46064],[4711,5645,5705],[4711,5645,38205],
 [4711,5653,5645,5705],[4711,5653,5645,38205],
 [4711,5653,5696,5705],[4711,5653,5696,6018],
 [4711,5653,5696,6050],[4711,5653,5696,39424],
 [4711,5653,5696,39779],[4711,5653,5696,45501],
 [4711,5653,5696,46064],[4711,5653,5699,5705],
 [4711,5653,5699,47090],[4711,5653,5705],[4711,5653,6018],
 [4711,5653,6050],[4711,5653,38205],[4711,5653,38212,38205],
 [4711,5653,38212,38557],[4711,5653,38212,39424],
 [4711,5653,38212,40287],[4711,5653,38224,38205],
 [4711,5653,38224,38921],[4711,5653,38224,39779],
 [4711,5653,38224,40642],[4711,5653,38529,45501],
 [4711,5653,38534,38921],[4711,5653,38557],
 [4711,5653,38563,38557],[4711,5653,38563,38921],
 [4711,5653,38563,46064],[4711,5653,38563,47090],
 [4711,5653,38566,38557],[4711,5653,38921],[4711,5653,39424],
 [4711,5653,39439,39424],[4711,5653,39534,39779],
 [4711,5653,39779],[4711,5653,40287],[4711,5653,40293,40287],
 [4711,5653,40293,40642],[4711,5653,40293,45501],
 [4711,5653,40293,47090],[4711,5653,40298,40287],
 [4711,5653,40327,46064],[4711,5653,40330,40642],
 [4711,5653,40642],[4711,5653,45501],[4711,5653,46064],
 [4711,5653,47090],[4711,5696,5705],[4711,5696,6018],
 [4711,5696,6050],[4711,5696,39424],[4711,5696,39779],
 [4711,5696,45501],[4711,5696,46064],[4711,5699,5705],
 [4711,5699,47090],[4711,13585,38205],
 [4711,13594,13585,38205],[4711,13594,13593],
 [4711,13594,13636,39424],[4711,13594,13639],
 [4711,13594,13678,40287],[4711,13594,13679],
 [4711,13594,38205],[4711,13594,38212,38205],
 [4711,13594,38212,38557],[4711,13594,38212,39424],
 [4711,13594,38212,40287],[4711,13594,38557],
 [4711,13594,39424],[4711,13594,40287],[4711,13607,38921],
 [4711,13636,39424],[4711,13648,39779],[4711,13678,40287],
 [4711,13690,40642],[4711,13953,45501],[4711,13987,46064],
 [4711,14052,13678,40287],[4711,14052,13687],
 [4711,14052,13690,40642],[4711,14052,13953,45501],
 [4711,14052,13960],[4711,14052,14055],[4711,14052,40287],
 [4711,14052,40293,40287],[4711,14052,40293,40642],
 [4711,14052,40293,45501],[4711,14052,40293,47090],
 [4711,14052,40642],[4711,14052,45501],[4711,14052,47090],
 [4711,38212,38205],[4711,38212,38557],[4711,38212,39424],
 [4711,38212,40287],[4711,38224,38205],[4711,38224,38921],
 [4711,38224,39779],[4711,38224,40642],[4711,38529,45501],
 [4711,38534,38921],[4711,38563,38557],[4711,38563,38921],
 [4711,38563,46064],[4711,38563,47090],[4711,38566,38557],
 [4711,39439,39424],[4711,39534,39779],[4711,40293,40287],
 [4711,40293,40642],[4711,40293,45501],[4711,40293,47090],
 [4711,40298,40287],[4711,40327,46064],[4711,40330,40642],
 [4744,4761,5705],[4744,4821,5705],[4763,4761,5705],
 [4763,5690,5705],[4763,5690,39193],[4763,15460,39193],
 [4766,4761,5705],[4766,5693,5705],[4766,5693,39313],
 [4766,15463,39313],[4768,4761,5705],[4768,5695,5705],
 [4768,5695,44904],[4768,15476,15470],[4768,15476,15477],
 [4768,15476,15914,47575],[4768,15476,39563,47575],
 [4768,15476,47575],[4768,15748,44904],[4769,4760,4761,5705],
 [4769,4760,5645,5705],[4769,4760,5645,38205],
 [4769,4760,5705],[4769,4760,15415,38205],[4769,4760,15432],
 [4769,4760,15517],[4769,4760,38205],[4769,4772,4761,5705],
 [4769,4772,5699,5705],[4769,4772,5699,47090],
 [4769,4772,5705],[4769,4772,15469],[4769,4772,15482],
 [4769,4772,15882,47090],[4769,4772,47090],[4769,5645,5705],
 [4769,5645,38205],[4769,5653,5645,5705],
 [4769,5653,5645,38205],[4769,5653,5696,5705],
 [4769,5653,5696,6018],[4769,5653,5696,6050],
 [4769,5653,5696,39424],[4769,5653,5696,39779],
 [4769,5653,5696,45501],[4769,5653,5696,46064],
 [4769,5653,5699,5705],[4769,5653,5699,47090],
 [4769,5653,5705],[4769,5653,6018],[4769,5653,6050],
 [4769,5653,38205],[4769,5653,38212,38205],
 [4769,5653,38212,38557],[4769,5653,38212,39424],
 [4769,5653,38212,40287],[4769,5653,38224,38205],
 [4769,5653,38224,38921],[4769,5653,38224,39779],
 [4769,5653,38224,40642],[4769,5653,38529,45501],
 [4769,5653,38534,38921],[4769,5653,38557],
 [4769,5653,38563,38557],[4769,5653,38563,38921],
 [4769,5653,38563,46064],[4769,5653,38563,47090],
 [4769,5653,38566,38557],[4769,5653,38921],[4769,5653,39424],
 [4769,5653,39439,39424],[4769,5653,39534,39779],
 [4769,5653,39779],[4769,5653,40287],[4769,5653,40293,40287],
 [4769,5653,40293,40642],[4769,5653,40293,45501],
 [4769,5653,40293,47090],[4769,5653,40298,40287],
 [4769,5653,40327,46064],[4769,5653,40330,40642],
 [4769,5653,40642],[4769,5653,45501],[4769,5653,46064],
 [4769,5653,47090],[4769,5699,5705],[4769,5699,47090],
 [4769,15415,38205],[4769,15424,38557],[4769,15437,38921],
 [4769,15508,40287],[4769,15520,40642],
 [4769,15788,15508,40287],[4769,15788,15522],
 [4769,15788,40287],[4769,15788,40298,40287],
 [4769,15882,47090],[4769,38212,38205],[4769,38212,38557],
 [4769,38212,39424],[4769,38212,40287],[4769,38224,38205],
 [4769,38224,38921],[4769,38224,39779],[4769,38224,40642],
 [4769,38534,38921],[4769,38563,38557],[4769,38563,38921],
 [4769,38563,46064],[4769,38563,47090],[4769,40293,40287],
 [4769,40293,40642],[4769,40293,45501],[4769,40293,47090],
 [4769,40298,40287],[4771,4761,5705],[4771,5698,5705],
 [4771,5698,46593],[4771,15850,46593],[4809,4835,6213],
 [4809,5120,6213],[4826,4821,5705],[4826,5693,5705],
 [4826,5693,39313],[4826,17233,39313],[4829,4821,5705],
 [4829,5696,5705],[4829,5696,6018],[4829,5696,6050],
 [4829,5696,39424],[4829,5696,39779],[4829,5696,45501],
 [4829,5696,46064],[4829,17236,39424],[4829,17248,39779],
 [4829,17553,45501],[4829,17587,46064],[4831,4821,5705],
 [4831,5698,5705],[4831,5698,46593],[4831,17620,46593],
 [4832,4821,5705],[4832,5699,5705],[4832,5699,47090],
 [4832,17652,47090],[4885,4880,5705],[4885,5693,5705],
 [4885,5693,39313],[4885,18944,39313],[4889,4880,5705],
 [4889,4882,4880,5705],[4889,4882,5690,5705],
 [4889,4882,5690,39193],[4889,4882,5705],
 [4889,4882,18941,39193],[4889,4882,19039],[4889,4882,19079],
 [4889,4882,39193],[4889,4887,4880,5705],
 [4889,4887,5695,5705],[4889,4887,5695,44904],
 [4889,4887,5705],[4889,4887,18946],[4889,4887,18957],
 [4889,4887,19229,44904],[4889,4887,44904],[4889,4888,6018],
 [4889,4888,19269],[4889,5690,5705],[4889,5690,39193],
 [4889,5695,5705],[4889,5695,44904],[4889,5696,5705],
 [4889,5696,6018],[4889,5696,6050],[4889,5696,39424],
 [4889,5696,39779],[4889,5696,45501],[4889,5696,46064],
 [4889,5778,5690,5705],[4889,5778,5690,39193],
 [4889,5778,5695,5705],[4889,5778,5695,44904],
 [4889,5778,5696,5705],[4889,5778,5696,6018],
 [4889,5778,5696,6050],[4889,5778,5696,39424],
 [4889,5778,5696,39779],[4889,5778,5696,45501],
 [4889,5778,5696,46064],[4889,5778,5705],[4889,5778,6018],
 [4889,5778,6050],[4889,5778,39193],[4889,5778,39197,39193],
 [4889,5778,39197,39424],[4889,5778,39197,41069],
 [4889,5778,39197,41850],[4889,5778,39208,39193],
 [4889,5778,39208,39779],[4889,5778,39208,41411],
 [4889,5778,39208,42193],[4889,5778,39400,39779],
 [4889,5778,39424],[4889,5778,39433,39424],[4889,5778,39779],
 [4889,5778,41069],[4889,5778,41078,41069],
 [4889,5778,41078,41411],[4889,5778,41078,44904],
 [4889,5778,41078,45501],[4889,5778,41083,41069],
 [4889,5778,41147,46064],[4889,5778,41148,41411],
 [4889,5778,41411],[4889,5778,41850],[4889,5778,41858,41850],
 [4889,5778,41858,42193],[4889,5778,41858,44904],
 [4889,5778,41858,46064],[4889,5778,41861,41850],
 [4889,5778,41893,45501],[4889,5778,41894,42193],
 [4889,5778,42193],[4889,5778,44904],[4889,5778,45501],
 [4889,5778,46064],[4889,18941,39193],[4889,18947,39424],
 [4889,18959,18941,39193],[4889,18959,18957],
 [4889,18959,19040,41411],[4889,18959,19044],
 [4889,18959,19080,42193],[4889,18959,19082],
 [4889,18959,39193],[4889,18959,39208,39193],
 [4889,18959,39208,39779],[4889,18959,39208,41411],
 [4889,18959,39208,42193],[4889,18959,39779],
 [4889,18959,41411],[4889,18959,42193],[4889,19029,41069],
 [4889,19040,41411],[4889,19069,41850],[4889,19080,42193],
 [4889,19229,44904],[4889,19264,45501],
 [4889,19298,19069,41850],[4889,19298,19079],
 [4889,19298,19080,42193],[4889,19298,19229,44904],
 [4889,19298,19234],[4889,19298,19299],[4889,19298,41850],
 [4889,19298,41858,41850],[4889,19298,41858,42193],
 [4889,19298,41858,44904],[4889,19298,41858,46064],
 [4889,19298,42193],[4889,19298,44904],[4889,19298,46064],
 [4889,39197,39193],[4889,39197,39424],[4889,39197,41069],
 [4889,39197,41850],[4889,39208,39193],[4889,39208,39779],
 [4889,39208,41411],[4889,39208,42193],[4889,39400,39779],
 [4889,39433,39424],[4889,41078,41069],[4889,41078,41411],
 [4889,41078,44904],[4889,41078,45501],[4889,41083,41069],
 [4889,41147,46064],[4889,41148,41411],[4889,41858,41850],
 [4889,41858,42193],[4889,41858,44904],[4889,41858,46064],
 [4889,41861,41850],[4889,41893,45501],[4889,41894,42193],
 [4890,4880,5705],[4890,5698,5705],[4890,5698,46593],
 [4890,19331,46593],[4891,4880,5705],[4891,5699,5705],
 [4891,5699,47090],[4891,19363,47090],[4937,4938,5705],
 [4937,5645,5705],[4937,5645,38205],[4937,20549,38205],
 [4940,4938,5705],[4940,5690,5705],[4940,5690,39193],
 [4940,20594,39193],[4943,4938,5705],[4943,5693,5705],
 [4943,5693,39313],[4943,20597,39313],[4945,4938,5705],
 [4945,5695,5705],[4945,5695,44904],[4945,20882,44904],
 [4948,4938,5705],[4948,5698,5705],[4948,5698,46593],
 [4948,20984,46593],[4949,4938,5705],[4949,5699,5705],
 [4949,5699,47090],[4949,21016,47090],[5000,4995,5705],
 [5000,5693,5705],[5000,5693,39313],[5000,22193,39313],
 [5002,4995,5705],[5002,5695,5705],[5002,5695,44904],
 [5002,22478,44904],[5003,4995,5705],[5003,5004,6050],
 [5003,5004,22550],[5003,5696,5705],[5003,5696,6018],
 [5003,5696,6050],[5003,5696,39424],[5003,5696,39779],
 [5003,5696,45501],[5003,5696,46064],[5003,22196,39424],
 [5003,22208,39779],[5003,22513,45501],[5003,22547,46064],
 [5005,4995,5705],[5005,5698,5705],[5005,5698,46593],
 [5005,22580,46593],[5006,4995,5705],[5006,5699,5705],
 [5006,5699,47090],[5006,22612,47090],[5007,4995,5705],
 [5007,5700,5705],[5007,5700,6152],[5009,4995,5705],
 [5009,5702,5705],[5009,5702,6213],[5026,4995,5705],
 [5026,5719,5705],[5030,4995,5705],[5030,5723,5705],
 [5032,4995,5705],[5032,5725,5705],[5050,5051,5705],
 [5050,5645,5705],[5050,5645,38205],[5050,23685,38205],
 [5053,5051,5705],[5053,5690,5705],[5053,5690,39193],
 [5053,23730,39193],[5056,5051,5705],[5056,5693,5705],
 [5056,5693,39313],[5056,23733,39313],[5058,5051,5705],
 [5058,5695,5705],[5058,5695,44904],[5058,24018,44904],
 [5061,5051,5705],[5061,5698,5705],[5061,5698,46593],
 [5061,24120,46593],[5062,5051,5705],[5062,5058,5051,5705],
 [5062,5058,5695,5705],[5062,5058,5695,44904],
 [5062,5058,5705],[5062,5058,23735],[5062,5058,23746],
 [5062,5058,24018,44904],[5062,5058,44904],[5062,5695,5705],
 [5062,5695,44904],[5062,5699,5705],[5062,5699,47090],
 [5062,5857,5692,5705],[5062,5857,5695,5705],
 [5062,5857,5695,44904],[5062,5857,5699,5705],
 [5062,5857,5699,47090],[5062,5857,5705],
 [5062,5857,39276,42593],[5062,5857,39287,42936],
 [5062,5857,39404],[5062,5857,39532],[5062,5857,42593],
 [5062,5857,42599,42593],[5062,5857,42599,42936],
 [5062,5857,42599,44904],[5062,5857,42599,47090],
 [5062,5857,42936],[5062,5857,44904],[5062,5857,47090],
 [5062,23908,42936],[5062,24018,44904],
 [5062,24152,23908,42936],[5062,24152,24018,44904],
 [5062,24152,24153],[5062,24152,42599,42593],
 [5062,24152,42599,42936],[5062,24152,42599,44904],
 [5062,24152,42599,47090],[5062,24152,47090],
 [5062,39287,42936],[5062,42599,42593],[5062,42599,42936],
 [5062,42599,44904],[5062,42599,47090],[5105,5106,5705],
 [5105,5645,5705],[5105,5645,38205],[5105,25170,38205],
 [5105,25272,25268,40450],[5105,25272,25698],
 [5105,25272,25727],[5105,25272,40450],
 [5105,25272,40453,40450],[5111,5106,5705],[5111,5693,5705],
 [5111,5693,39313],[5111,25218,39313],[5113,5106,5705],
 [5113,5695,5705],[5113,5695,44904],[5113,25503,44904],
 [5114,5115,6050],[5114,5115,25575],[5114,5696,5705],
 [5114,5696,6018],[5114,5696,6050],[5114,5696,39424],
 [5114,5696,39779],[5114,5696,45501],[5114,5696,46064],
 [5114,25221,39424],[5114,25572,46064],[5116,5106,5705],
 [5116,5698,5705],[5116,5698,46593],[5116,25605,46593],
 [5117,5106,5705],[5117,5108,5106,5705],
 [5117,5108,5690,5705],[5117,5108,5690,39193],
 [5117,5108,5705],[5117,5108,25215,39193],[5117,5108,25313],
 [5117,5108,25353],[5117,5108,39193],[5117,5690,5705],
 [5117,5690,39193],[5117,5699,5705],[5117,5699,47090],
 [5117,5782,5690,5705],[5117,5782,5690,39193],
 [5117,5782,5699,5705],[5117,5782,5699,47090],
 [5117,5782,5705],[5117,5782,39193],[5117,5782,39201,39193],
 [5117,5782,39214,39193],[5117,5782,41212,47090],
 [5117,5782,41992,47090],[5117,5782,47090],[5117,25215,39193],
 [5117,25224,25215,39193],[5117,25224,25347],
 [5117,25224,39193],[5117,25224,39201,39193],
 [5117,25637,47090],[5117,39201,39193],[5117,39214,39193],
 [5117,41212,47090],[5117,41992,47090],[5159,5160,5705],
 [5159,5645,5705],[5159,5645,38205],[5159,26601,38205],
 [5162,5160,5705],[5162,5690,5705],[5162,5690,39193],
 [5162,26646,39193],[5165,5160,5705],[5165,5693,5705],
 [5165,5693,39313],[5165,26649,39313],[5167,5160,5705],
 [5167,5695,5705],[5167,5695,44904],[5167,26934,44904],
 [5170,5160,5705],[5170,5698,5705],[5170,5698,46593],
 [5170,27036,46593],[5171,5160,5705],[5171,5699,5705],
 [5171,5699,47090],[5171,27068,47090],[5212,5213,5705],
 [5212,5645,5705],[5212,5645,38205],[5212,27979,38205],
 [5215,5213,5705],[5215,5690,5705],[5215,5690,39193],
 [5215,28024,39193],[5218,5213,5705],[5218,5693,5705],
 [5218,5693,39313],[5218,28027,39313],[5220,5213,5705],
 [5220,5695,5705],[5220,5695,44904],[5220,28312,44904],
 [5223,5213,5705],[5223,5698,5705],[5223,5698,46593],
 [5223,28414,46593],[5224,5213,5705],[5224,5699,5705],
 [5224,5699,47090],[5224,28446,47090],[5258,5150,26160],
 [5258,5153,26316],[5258,5205,27643],[5258,5257,28970],
 [5258,26161,26160],[5258,26161,26316],[5258,26161,27643],
 [5258,26161,28970],[5264,5265,5705],[5264,5645,5705],
 [5264,5645,38205],[5264,29305,38205],[5267,5265,5705],
 [5267,5690,5705],[5267,5690,39193],[5267,29350,39193],
 [5270,5265,5705],[5270,5693,5705],[5270,5693,39313],
 [5270,29353,39313],[5272,5265,5705],[5272,5695,5705],
 [5272,5695,44904],[5272,29638,44904],[5274,5265,5705],
 [5274,5273,6018],[5274,5273,29678],[5274,5696,5705],
 [5274,5696,6018],[5274,5696,6050],[5274,5696,39424],
 [5274,5696,39779],[5274,5696,45501],[5274,5696,46064],
 [5274,29356,39424],[5274,29368,39779],[5274,29673,45501],
 [5274,29707,46064],[5275,5265,5705],[5275,5698,5705],
 [5275,5698,46593],[5275,29740,46593],[5276,5265,5705],
 [5276,5699,5705],[5276,5699,47090],[5276,29772,47090],
 [5315,5316,5705],[5315,5645,5705],[5315,5645,38205],
 [5315,30580,38205],[5318,5316,5705],[5318,5690,5705],
 [5318,5690,39193],[5318,30625,39193],[5321,5316,5705],
 [5321,5693,5705],[5321,5693,39313],[5321,30628,39313],
 [5323,5316,5705],[5323,5695,5705],[5323,5695,44904],
 [5323,30913,44904],[5326,5316,5705],[5326,5698,5705],
 [5326,5698,46593],[5326,31015,46593],[5327,5316,5705],
 [5327,5699,5705],[5327,5699,47090],[5327,31047,47090],
 [5362,5205,27643],[5362,5209,27841],[5362,5311,30394],
 [5362,5361,31620],[5362,27645,27643],[5362,27645,27841],
 [5362,27645,30394],[5362,27645,31620],[5365,5366,5705],
 [5365,5645,5705],[5365,5645,38205],[5365,31805,38205],
 [5368,5366,5705],[5368,5690,5705],[5368,5690,39193],
 [5368,31850,39193],[5371,5366,5705],[5371,5693,5705],
 [5371,5693,39313],[5371,31853,39313],[5373,5366,5705],
 [5373,5695,5705],[5373,5695,44904],[5373,32138,44904],
 [5375,5366,5705],[5375,5374,6018],[5375,5374,32178],
 [5375,5696,5705],[5375,5696,6018],[5375,5696,6050],
 [5375,5696,39424],[5375,5696,39779],[5375,5696,45501],
 [5375,5696,46064],[5375,31856,39424],[5375,31868,39779],
 [5375,32173,45501],[5375,32207,46064],[5376,5366,5705],
 [5376,5698,5705],[5376,5698,46593],[5376,32240,46593],
 [5377,5366,5705],[5377,5699,5705],[5377,5699,47090],
 [5377,32272,47090],[5414,5415,5705],[5414,5645,5705],
 [5414,5645,38205],[5414,32981,38205],[5417,5415,5705],
 [5417,5690,5705],[5417,5690,39193],[5417,33026,39193],
 [5420,5415,5705],[5420,5693,5705],[5420,5693,39313],
 [5420,33029,39313],[5422,5415,5705],[5422,5695,5705],
 [5422,5695,44904],[5422,33314,44904],[5425,5415,5705],
 [5425,5698,5705],[5425,5698,46593],[5425,33416,46593],
 [5426,5415,5705],[5426,5699,5705],[5426,5699,47090],
 [5426,33448,47090],[5462,5463,5705],[5462,5645,5705],
 [5462,5645,38205],[5462,34109,38205],[5465,5463,5705],
 [5465,5690,5705],[5465,5690,39193],[5465,34154,39193],
 [5468,5463,5705],[5468,5693,5705],[5468,5693,39313],
 [5468,34157,39313],[5470,5463,5705],[5470,5695,5705],
 [5470,5695,44904],[5470,34442,44904],[5473,5463,5705],
 [5473,5698,5705],[5473,5698,46593],[5473,34544,46593],
 [5474,5463,5705],[5474,5699,5705],[5474,5699,47090],
 [5474,34576,47090],[5509,5510,5705],[5509,5645,5705],
 [5509,5645,38205],[5509,35190,38205],[5512,5510,5705],
 [5512,5690,5705],[5512,5690,39193],[5512,35235,39193],
 [5515,5510,5705],[5515,5693,5705],[5515,5693,39313],
 [5515,35238,39313],[5517,5510,5705],[5517,5695,5705],
 [5517,5695,44904],[5517,35523,44904],[5519,5510,5705],
 [5519,5518,6018],[5519,5518,35563],[5519,5696,5705],
 [5519,5696,6018],[5519,5696,6050],[5519,5696,39424],
 [5519,5696,39779],[5519,5696,45501],[5519,5696,46064],
 [5519,35241,39424],[5519,35253,39779],[5519,35558,45501],
 [5519,35592,46064],[5520,5510,5705],[5520,5698,5705],
 [5520,5698,46593],[5520,35625,46593],[5521,5510,5705],
 [5521,5699,5705],[5521,5699,47090],[5521,35657,47090],
 [5555,5556,5705],[5555,5645,5705],[5555,5645,38205],
 [5555,36225,38205],[5558,5556,5705],[5558,5690,5705],
 [5558,5690,39193],[5558,36270,39193],[5561,5556,5705],
 [5561,5693,5705],[5561,5693,39313],[5561,36273,39313],
 [5563,5556,5705],[5563,5695,5705],[5563,5695,44904],
 [5563,36558,44904],[5566,5556,5705],[5566,5698,5705],
 [5566,5698,46593],[5566,36660,46593],[5567,5556,5705],
 [5567,5699,5705],[5567,5699,47090],[5567,36692,47090],
 [5600,5601,5705],[5600,5645,5705],[5600,5645,38205],
 [5600,37215,38205],[5603,5601,5705],[5603,5690,5705],
 [5603,5690,39193],[5603,37260,39193],[5606,5601,5705],
 [5606,5693,5705],[5606,5693,39313],[5606,37263,39313],
 [5608,5601,5705],[5608,5695,5705],[5608,5695,44904],
 [5608,37548,44904],[5611,5601,5705],[5611,5698,5705],
 [5611,5698,46593],[5611,37650,46593],[5612,5601,5705],
 [5612,5699,5705],[5612,5699,47090],[5612,37682,47090],
 [5660,5645,5705],[5660,5645,38205],[5660,5703,5705],
 [5660,38219,38205],[5661,5645,5705],[5661,5645,38205],
 [5661,5704,5705],[5661,38220,38205],[5666,5645,5705],
 [5666,5645,38205],[5666,5709,5705],[5666,38225,38205],
 [5674,5645,5705],[5674,5645,38205],[5674,5717,5705],
 [5674,38233,38205],[5675,5645,5705],[5675,5645,38205],
 [5675,5718,5705],[5675,5719,5705],[5675,38234,38205],
 [5675,38234,40824],[5675,40576,40824],[5677,5645,5705],
 [5677,5645,38205],[5677,5720,5705],[5677,38236,38205],
 [5678,5645,5705],[5678,5645,38205],[5678,5721,5705],
 [5678,38237,38205],[5679,5645,5705],[5679,5645,38205],
 [5679,5722,5705],[5679,5723,5705],[5679,38238,38205],
 [5679,38238,40870],[5679,40580,40870],[5681,5645,5705],
 [5681,5645,38205],[5681,5724,5705],[5681,38240,38205],
 [5682,5645,5705],[5682,5645,38205],[5682,5725,5705],
 [5682,38241,38205],[5683,5645,5705],[5683,5645,38205],
 [5683,5726,5705],[5683,38242,38205],[5684,5645,5705],
 [5684,5645,38205],[5684,5727,5705],[5684,38243,38205],
 [5685,5645,5705],[5685,5645,38205],[5685,5728,5705],
 [5685,38244,38205],[5686,5645,5705],[5686,5645,38205],
 [5686,5729,5705],[5686,38245,38205],[5687,5645,5705],
 [5687,5645,38205],[5687,5730,5705],[5687,5731,5705],
 [5687,38246,38205],[5687,38246,40914],[5687,40588,40914],
 [5776,5690,5705],[5776,5690,39193],[5776,5693,5705],
 [5776,5693,39313],[5776,39195,39193],[5776,39195,39313],
 [5781,5690,5705],[5781,5690,39193],[5781,5698,5705],
 [5781,5698,46593],[5781,39200,39193],[5781,39213,39193],
 [5781,41180,46593],[5781,41960,46593],[5783,5690,5705],
 [5783,5690,39193],[5783,5700,5705],[5783,5700,6152],
 [5783,5701,5705],[5783,5701,6183],[5783,5701,39602],
 [5783,5701,47993],[5783,39202,39193],[5783,39202,41239],
 [5783,39216,39193],[5783,39216,42362],[5783,41243,41239],
 [5783,41253,41239],[5783,42062,42362],[5783,42172,42362],
 [5785,5690,5705],[5785,5690,39193],[5785,5702,5705],
 [5785,5702,6213],[5785,39204,39193],[5785,39218,39193],
 [5786,5690,5705],[5786,5690,39193],[5786,5703,5705],
 [5786,5704,5705],[5786,39205,39193],[5786,39205,42109],
 [5786,42110,42109],[5792,5690,5705],[5792,5690,39193],
 [5792,5709,5705],[5792,39211,39193],[5800,5690,5705],
 [5800,5690,39193],[5800,5717,5705],[5800,39219,39193],
 [5801,5690,5705],[5801,5690,39193],[5801,5718,5705],
 [5801,39220,39193],[5802,5690,5705],[5802,5690,39193],
 [5802,5719,5705],[5802,39221,39193],[5803,5690,5705],
 [5803,5690,39193],[5803,5720,5705],[5803,5721,5705],
 [5803,39222,39193],[5803,39222,42449],[5803,42178,42449],
 [5805,5690,5705],[5805,5690,39193],[5805,5722,5705],
 [5805,39224,39193],[5806,5690,5705],[5806,5690,39193],
 [5806,5723,5705],[5806,39225,39193],[5807,5690,5705],
 [5807,5690,39193],[5807,5724,5705],[5807,39226,39193],
 [5808,5690,5705],[5808,5690,39193],[5808,5725,5705],
 [5808,5726,5705],[5808,39227,39193],[5808,39227,42494],
 [5808,42183,42494],[5810,5690,5705],[5810,5690,39193],
 [5810,5727,5705],[5810,39229,39193],[5811,5690,5705],
 [5811,5690,39193],[5811,5728,5705],[5811,39230,39193],
 [5812,5690,5705],[5812,5690,39193],[5812,5729,5705],
 [5812,39231,39193],[5813,5690,5705],[5813,5690,39193],
 [5813,5730,5705],[5813,39232,39193],[5814,5690,5705],
 [5814,5690,39193],[5814,5731,5705],[5814,39233,39193],
 [5896,5693,5705],[5896,5693,39313],[5896,5696,5705],
 [5896,5696,6018],[5896,5696,6050],[5896,5696,39424],
 [5896,5696,39779],[5896,5696,45501],[5896,5696,46064],
 [5896,5698,5705],[5896,5698,46593],[5896,39315,39313],
 [5896,39315,39424],[5896,39315,43330],[5896,39315,44030],
 [5896,39327,39313],[5896,39327,39779],[5896,39327,43685],
 [5896,39327,44394],[5896,39438,39424],[5896,39502,39779],
 [5896,43337,43330],[5896,43337,43685],[5896,43337,45501],
 [5896,43337,46593],[5896,43342,43330],[5896,43371,46064],
 [5896,43374,43685],[5896,44003,45501],[5896,44008,44394],
 [5896,44037,44030],[5896,44037,44394],[5896,44037,46064],
 [5896,44037,46593],[5896,44040,44030],[5899,5693,5705],
 [5899,5693,39313],[5899,5699,5705],[5899,5699,47090],
 [5899,39318,39313],[5899,39331,39313],[5899,43436,47090],
 [5899,44102,47090],[5900,5693,5705],[5900,5693,39313],
 [5900,5700,5705],[5900,5700,6152],[5900,39319,39313],
 [5900,39333,39313],[5903,5693,5705],[5903,5693,39313],
 [5903,5703,5705],[5903,39322,39313],[5904,5693,5705],
 [5904,5693,39313],[5904,5704,5705],[5904,39323,39313],
 [5907,5693,5705],[5907,5693,39313],[5907,5707,5705],
 [5907,5707,6340],[5907,5707,39759],[5907,5707,49500],
 [5907,39326,39313],[5907,39332,39313],[5909,5693,5705],
 [5909,5693,39313],[5909,5709,5705],[5909,39328,39313],
 [5917,5693,5705],[5917,5693,39313],[5917,5717,5705],
 [5917,39336,39313],[5918,5693,5705],[5918,5693,39313],
 [5918,5718,5705],[5918,39337,39313],[5919,5693,5705],
 [5919,5693,39313],[5919,5719,5705],[5919,39338,39313],
 [5920,5693,5705],[5920,5693,39313],[5920,5720,5705],
 [5920,39339,39313],[5921,5693,5705],[5921,5693,39313],
 [5921,5721,5705],[5921,39340,39313],[5922,5693,5705],
 [5922,5693,39313],[5922,5722,5705],[5922,39341,39313],
 [5923,5693,5705],[5923,5693,39313],[5923,5723,5705],
 [5923,39342,39313],[5924,5693,5705],[5924,5693,39313],
 [5924,5724,5705],[5924,39343,39313],[5925,5693,5705],
 [5925,5693,39313],[5925,5725,5705],[5925,39344,39313],
 [5926,5693,5705],[5926,5693,39313],[5926,5726,5705],
 [5926,39345,39313],[5927,5693,5705],[5927,5693,39313],
 [5927,5727,5705],[5927,39346,39313],[5928,5693,5705],
 [5928,5693,39313],[5928,5728,5705],[5928,39347,39313],
 [5929,5693,5705],[5929,5693,39313],[5929,5729,5705],
 [5929,39348,39313],[5930,5693,5705],[5930,5693,39313],
 [5930,5730,5705],[5930,39349,39313],[5931,5693,5705],
 [5931,5693,39313],[5931,5731,5705],[5931,39350,39313],
 [5976,5695,5705],[5976,5695,44904],[5976,5703,5705],
 [5976,5709,5705],[5976,39650,48796],[5976,44850,44904],
 [5976,44850,48796],[5977,5695,5705],[5977,5695,44904],
 [5977,5704,5705],[5977,44877,44904],[5990,5695,5705],
 [5990,5695,44904],[5990,5717,5705],[5990,44915,44904],
 [5991,5695,5705],[5991,5695,44904],[5991,5718,5705],
 [5991,44916,44904],[5992,5695,5705],[5992,5695,44904],
 [5992,5719,5705],[5992,44917,44904],[5993,5695,5705],
 [5993,5695,44904],[5993,5720,5705],[5993,44918,44904],
 [5994,5695,5705],[5994,5695,44904],[5994,5721,5705],
 [5994,5728,5705],[5994,39743,50046],[5994,44919,44904],
 [5994,44919,50046],[5995,5695,5705],[5995,5695,44904],
 [5995,5722,5705],[5995,44920,44904],[5996,5695,5705],
 [5996,5695,44904],[5996,5723,5705],[5996,44921,44904],
 [5997,5695,5705],[5997,5695,44904],[5997,5724,5705],
 [5997,44922,44904],[5998,5695,5705],[5998,5695,44904],
 [5998,5725,5705],[5998,5727,5705],[5998,39747,50075],
 [5998,44923,44904],[5998,44923,50075],[5999,5695,5705],
 [5999,5695,44904],[5999,5726,5705],[5999,44924,44904],
 [6002,5695,5705],[6002,5695,44904],[6002,5729,5705],
 [6002,44927,44904],[6003,5695,5705],[6003,5695,44904],
 [6003,5730,5705],[6003,44928,44904],[6004,5695,5705],
 [6004,5695,44904],[6004,5731,5705],[6004,44929,44904],
 [6008,5696,5705],[6008,5696,6018],[6008,5696,6050],
 [6008,5696,39424],[6008,5696,39779],[6008,5696,45501],
 [6008,5696,46064],[6008,5700,5705],[6008,5700,6152],
 [6008,6042,6050],[6008,6042,6152],[6008,6042,45922],
 [6008,6042,46140],[6008,39427,39424],[6008,39441,39424],
 [6008,39565,39779],[6008,39783,39779],[6008,45358,45501],
 [6008,45507,45501],[6008,45919,46064],[6008,46068,46064],
 [6010,5696,5705],[6010,5696,6018],[6010,5696,6050],
 [6010,5696,39424],[6010,5696,39779],[6010,5696,45501],
 [6010,5696,46064],[6010,5702,5705],[6010,5702,6213],
 [6010,6044,6050],[6010,6044,6213],[6010,6044,45981],
 [6010,6044,46142],[6010,39429,39424],[6010,39443,39424],
 [6010,39624,39779],[6010,39785,39779],[6010,45417,45501],
 [6010,45509,45501],[6010,45978,46064],[6010,46070,46064],
 [6012,45476,49217],[6025,45625,45745],[6028,45628,51006],
 [6030,45630,45806],[6034,45634,51050],[6037,45637,45847],
 [6043,45951,48035],[6043,45957,46241],[6043,46116,46241],
 [6043,46139,46241],[6043,48040,48035],[6043,48042,48035],
 [6045,5696,5705],[6045,5696,6018],[6045,5696,6050],
 [6045,5696,39424],[6045,5696,39779],[6045,5696,45501],
 [6045,5696,46064],[6045,5703,5705],[6045,6011,6018],
 [6045,6011,45450],[6045,39430,39424],[6045,39652,39779],
 [6045,45445,45501],[6045,46006,46064],[6061,5696,5705],
 [6061,5696,6018],[6061,5696,6050],[6061,5696,39424],
 [6061,5696,39779],[6061,5696,45501],[6061,5696,46064],
 [6061,5719,5705],[6061,6027,6018],[6061,6027,45627],
 [6061,39446,39424],[6061,39788,39779],[6061,45512,45501],
 [6061,46073,46064],[6063,5696,5705],[6063,5696,6018],
 [6063,5696,6050],[6063,5696,39424],[6063,5696,39779],
 [6063,5696,45501],[6063,5696,46064],[6063,5721,5705],
 [6063,6029,6018],[6063,6029,45629],[6063,39448,39424],
 [6063,39790,39779],[6063,45514,45501],[6063,46075,46064],
 [6067,5696,5705],[6067,5696,6018],[6067,5696,6050],
 [6067,5696,39424],[6067,5696,39779],[6067,5696,45501],
 [6067,5696,46064],[6067,5725,5705],[6067,6033,6018],
 [6067,6033,45633],[6067,39452,39424],[6067,39794,39779],
 [6067,45518,45501],[6067,46079,46064],[6074,5698,5705],
 [6074,5698,46593],[6074,5699,5705],[6074,5699,47090],
 [6074,46416,46593],[6074,46416,47090],[6076,5698,5705],
 [6076,5698,46593],[6076,5701,5705],[6076,5701,6183],
 [6076,5701,39602],[6076,5701,47993],[6076,46477,46593],
 [6076,46597,46593],[6077,5698,5705],[6077,5698,46593],
 [6077,5702,5705],[6077,5702,6213],[6077,46506,46593],
 [6077,46598,46593],[6078,5698,5705],[6078,5698,46593],
 [6078,5703,5705],[6078,46534,46593],[6079,5698,5705],
 [6079,5698,46593],[6079,5704,5705],[6079,46561,46593],
 [6084,5698,5705],[6084,5698,46593],[6084,5709,5705],
 [6084,46591,46593],[6092,5698,5705],[6092,5698,46593],
 [6092,5717,5705],[6092,46599,46593],[6093,5698,5705],
 [6093,5698,46593],[6093,5718,5705],[6093,46600,46593],
 [6094,5698,5705],[6094,5698,46593],[6094,5719,5705],
 [6094,46601,46593],[6095,5698,5705],[6095,5698,46593],
 [6095,5720,5705],[6095,46602,46593],[6096,5698,5705],
 [6096,5698,46593],[6096,5721,5705],[6096,46603,46593],
 [6097,5698,5705],[6097,5698,46593],[6097,5722,5705],
 [6097,46604,46593],[6098,5698,5705],[6098,5698,46593],
 [6098,5723,5705],[6098,46605,46593],[6099,5698,5705],
 [6099,5698,46593],[6099,5724,5705],[6099,46606,46593],
 [6100,5698,5705],[6100,5698,46593],[6100,5725,5705],
 [6100,46607,46593],[6101,5698,5705],[6101,5698,46593],
 [6101,5726,5705],[6101,46608,46593],[6102,5698,5705],
 [6102,5698,46593],[6102,5727,5705],[6102,46609,46593],
 [6103,5698,5705],[6103,5698,46593],[6103,5728,5705],
 [6103,46610,46593],[6104,5698,5705],[6104,5698,46593],
 [6104,5729,5705],[6104,46611,46593],[6105,5698,5705],
 [6105,5698,46593],[6105,5730,5705],[6105,46612,46593],
 [6106,5698,5705],[6106,5698,46593],[6106,5731,5705],
 [6106,46613,46593],[6107,5699,5705],[6107,5699,47090],
 [6107,5700,5705],[6107,5700,6152],[6107,46943,47090],
 [6107,47092,47090],[6108,5699,5705],[6108,5699,47090],
 [6108,5701,5705],[6108,5701,6183],[6108,5701,39602],
 [6108,5701,47993],[6108,46973,47090],[6108,47093,47090],
 [6109,5699,5705],[6109,5699,47090],[6109,5702,5705],
 [6109,5702,6213],[6109,5707,5705],[6109,5707,6340],
 [6109,5707,39759],[6109,5707,49500],[6109,39539,47266],
 [6109,39623,48445],[6109,47002,47090],[6109,47002,48445],
 [6109,47091,47090],[6109,47091,47266],[6109,47140,47266],
 [6109,48446,48445],[6110,5699,5705],[6110,5699,47090],
 [6110,5703,5705],[6110,47030,47090],[6111,5699,5705],
 [6111,5699,47090],[6111,5704,5705],[6111,47057,47090],
 [6116,5699,5705],[6116,5699,47090],[6116,5709,5705],
 [6116,47087,47090],[6124,5699,5705],[6124,5699,47090],
 [6124,5717,5705],[6124,5719,5705],[6124,39543,47331],
 [6124,47095,47090],[6124,47095,47331],[6125,5699,5705],
 [6125,5699,47090],[6125,5718,5705],[6125,47096,47090],
 [6127,5699,5705],[6127,5699,47090],[6127,5720,5705],
 [6127,47098,47090],[6128,5699,5705],[6128,5699,47090],
 [6128,5721,5705],[6128,47099,47090],[6129,5699,5705],
 [6129,5699,47090],[6129,5722,5705],[6129,47100,47090],
 [6130,5699,5705],[6130,5699,47090],[6130,5723,5705],
 [6130,5724,5705],[6130,39549,47399],[6130,47101,47090],
 [6130,47101,47399],[6132,5699,5705],[6132,5699,47090],
 [6132,5725,5705],[6132,47103,47090],[6133,5699,5705],
 [6133,5699,47090],[6133,5726,5705],[6133,47104,47090],
 [6134,5699,5705],[6134,5699,47090],[6134,5727,5705],
 [6134,47105,47090],[6135,5699,5705],[6135,5699,47090],
 [6135,5728,5705],[6135,47106,47090],[6136,5699,5705],
 [6136,5699,47090],[6136,5729,5705],[6136,5731,5705],
 [6136,39555,47433],[6136,47107,47090],[6136,47107,47433],
 [6137,5699,5705],[6137,5699,47090],[6137,5730,5705],
 [6137,47108,47090],[6245,5703,5705],[6245,5720,5705],
 [6251,5703,5705],[6251,5726,5705],[6252,5703,5705],
 [6252,5727,5705],[6253,5703,5705],[6253,5728,5705],
 [6559,5719,5705],[6559,5722,5705],[6561,5719,5705],
 [6561,5724,5705],[6566,5719,5705],[6566,5729,5705],
 [6567,5719,5705],[6567,5730,5705],[6658,6654,6656,7828],
 [6658,6654,7725,7828],[6658,6654,7725,38205],
 [6658,6654,7828],[6658,6654,9741,38205],[6658,6654,9759],
 [6658,6654,9802],[6658,6654,38205],[6658,6656,7828],
 [6658,6657,7875],[6658,6657,9891],[6658,6659,6656,7828],
 [6658,6659,6657,7875],[6658,6659,6657,9891],
 [6658,6659,7812,7828],[6658,6659,7812,7875],
 [6658,6659,7812,7950],[6658,6659,7812,40055],
 [6658,6659,7812,40642],[6658,6659,7812,41411],
 [6658,6659,7812,42936],[6658,6659,7828],[6658,6659,7875],
 [6658,6659,7950],[6658,6659,9828,40055],
 [6658,6659,9846,40642],[6658,6659,9885,41411],
 [6658,6659,9891],[6658,6659,9964,42936],[6658,6659,9966],
 [6658,6659,40055],[6658,6659,40642],[6658,6659,41411],
 [6658,6659,42936],[6658,7725,7828],[6658,7725,38205],
 [6658,7727,7725,7828],[6658,7727,7725,38205],
 [6658,7727,7812,7828],[6658,7727,7812,7875],
 [6658,7727,7812,7950],[6658,7727,7812,40055],
 [6658,7727,7812,40642],[6658,7727,7812,41411],
 [6658,7727,7812,42936],[6658,7727,7813,7828],
 [6658,7727,7813,42193],[6658,7727,7828],[6658,7727,7875],
 [6658,7727,7950],[6658,7727,38205],[6658,7727,38206,38205],
 [6658,7727,38206,38331],[6658,7727,38206,39193],
 [6658,7727,38206,40055],[6658,7727,38224,38205],
 [6658,7727,38224,38921],[6658,7727,38224,39779],
 [6658,7727,38224,40642],[6658,7727,38305,41411],
 [6658,7727,38309,38921],[6658,7727,38331],
 [6658,7727,38345,38331],[6658,7727,38345,38921],
 [6658,7727,38345,42193],[6658,7727,38345,42936],
 [6658,7727,38347,38331],[6658,7727,38921],[6658,7727,39193],
 [6658,7727,39208,39193],[6658,7727,39208,39779],
 [6658,7727,39208,41411],[6658,7727,39208,42193],
 [6658,7727,39214,39193],[6658,7727,39287,42936],
 [6658,7727,39289,39779],[6658,7727,39779],[6658,7727,40055],
 [6658,7727,40073,40055],[6658,7727,40111,40642],
 [6658,7727,40642],[6658,7727,41411],[6658,7727,42193],
 [6658,7727,42936],[6658,7812,7828],[6658,7812,7875],
 [6658,7812,7950],[6658,7812,40055],[6658,7812,40642],
 [6658,7812,41411],[6658,7812,42936],[6658,7813,7828],
 [6658,7813,42193],[6658,9741,38205],[6658,9744,38331],
 [6658,9763,38921],[6658,9786,39193],[6658,9804,39779],
 [6658,9828,40055],[6658,9846,40642],[6658,9885,41411],
 [6658,9925,42193],[6658,9964,42936],[6658,38206,38205],
 [6658,38206,38331],[6658,38206,39193],[6658,38206,40055],
 [6658,38224,38205],[6658,38224,38921],[6658,38224,39779],
 [6658,38224,40642],[6658,38305,41411],[6658,38309,38921],
 [6658,38345,38331],[6658,38345,38921],[6658,38345,42193],
 [6658,38345,42936],[6658,38347,38331],[6658,39208,39193],
 [6658,39208,39779],[6658,39208,41411],[6658,39208,42193],
 [6658,39214,39193],[6658,39287,42936],[6658,39289,39779],
 [6658,40073,40055],[6658,40111,40642],[6663,6656,7828],
 [6663,6657,7875],[6663,6657,9891],[6663,6659,6656,7828],
 [6663,6659,6657,7875],[6663,6659,6657,9891],
 [6663,6659,7812,7828],[6663,6659,7812,7875],
 [6663,6659,7812,7950],[6663,6659,7812,40055],
 [6663,6659,7812,40642],[6663,6659,7812,41411],
 [6663,6659,7812,42936],[6663,6659,7828],[6663,6659,7875],
 [6663,6659,7950],[6663,6659,9828,40055],
 [6663,6659,9846,40642],[6663,6659,9885,41411],
 [6663,6659,9891],[6663,6659,9964,42936],[6663,6659,9966],
 [6663,6659,40055],[6663,6659,40642],[6663,6659,41411],
 [6663,6659,42936],[6663,6662,6656,7828],
 [6663,6662,7817,7828],[6663,6662,7817,44904],
 [6663,6662,7828],[6663,6662,9833],[6663,6662,9843],
 [6663,6662,10074,44904],[6663,6662,44904],[6663,7812,7828],
 [6663,7812,7875],[6663,7812,7950],[6663,7812,40055],
 [6663,7812,40642],[6663,7812,41411],[6663,7812,42936],
 [6663,7817,7828],[6663,7817,44904],[6663,7818,7828],
 [6663,7818,40287],[6663,7858,7812,7828],
 [6663,7858,7812,7875],[6663,7858,7812,7950],
 [6663,7858,7812,40055],[6663,7858,7812,40642],
 [6663,7858,7812,41411],[6663,7858,7812,42936],
 [6663,7858,7817,7828],[6663,7858,7817,44904],
 [6663,7858,7818,7828],[6663,7858,7818,40287],
 [6663,7858,7828],[6663,7858,7875],[6663,7858,7950],
 [6663,7858,40055],[6663,7858,40058,40055],
 [6663,7858,40058,40287],[6663,7858,40058,41069],
 [6663,7858,40058,42593],[6663,7858,40068,40055],
 [6663,7858,40261,40642],[6663,7858,40287],
 [6663,7858,40293,40287],[6663,7858,40293,40642],
 [6663,7858,40293,45501],[6663,7858,40293,47090],
 [6663,7858,40642],[6663,7858,41069],[6663,7858,41078,41069],
 [6663,7858,41078,41411],[6663,7858,41078,44904],
 [6663,7858,41078,45501],[6663,7858,41085,41069],
 [6663,7858,41212,47090],[6663,7858,41213,41411],
 [6663,7858,41411],[6663,7858,42593],[6663,7858,42599,42593],
 [6663,7858,42599,42936],[6663,7858,42599,44904],
 [6663,7858,42599,47090],[6663,7858,42602,42593],
 [6663,7858,42634,45501],[6663,7858,42635,42936],
 [6663,7858,42936],[6663,7858,44904],[6663,7858,45501],
 [6663,7858,47090],[6663,9828,40055],[6663,9834,40287],
 [6663,9846,40642],[6663,9874,41069],[6663,9885,41411],
 [6663,9953,42593],[6663,9964,42936],[6663,10074,44904],
 [6663,10109,45501],[6663,10208,47090],[6663,40058,40055],
 [6663,40058,40287],[6663,40058,41069],[6663,40058,42593],
 [6663,40068,40055],[6663,40261,40642],[6663,40293,40287],
 [6663,40293,40642],[6663,40293,45501],[6663,40293,47090],
 [6663,41078,41069],[6663,41078,41411],[6663,41078,44904],
 [6663,41078,45501],[6663,41085,41069],[6663,41212,47090],
 [6663,41213,41411],[6663,42599,42593],[6663,42599,42936],
 [6663,42599,44904],[6663,42599,47090],[6663,42602,42593],
 [6663,42634,45501],[6663,42635,42936],[6667,6656,7828],
 [6667,7822,7828],[6667,7822,47575],[6667,10240,47575],
 [6668,6656,7828],[6668,7823,7828],[6668,7823,40450],
 [6668,9839,40450],[6721,6719,7828],[6721,7813,7828],
 [6721,7813,42193],[6721,11878,42193],[6722,6719,7828],
 [6722,6720,7875],[6722,6720,11844],[6722,7812,7828],
 [6722,7812,7875],[6722,7812,7950],[6722,7812,40055],
 [6722,7812,40642],[6722,7812,41411],[6722,7812,42936],
 [6722,11781,40055],[6722,11799,40642],[6722,11838,41411],
 [6722,11917,42936],[6726,6719,7828],[6726,7818,7828],
 [6726,7818,40287],[6726,11787,40287],[6730,6719,7828],
 [6730,7822,7828],[6730,7822,47575],[6730,12193,47575],
 [6731,6719,7828],[6731,7823,7828],[6731,7823,40450],
 [6731,11792,40450],[6782,6781,7828],[6782,7812,7828],
 [6782,7812,7875],[6782,7812,7950],[6782,7812,40055],
 [6782,7812,40642],[6782,7812,41411],[6782,7812,42936],
 [6782,13672,40055],[6782,13690,40642],[6782,13729,41411],
 [6782,13808,42936],[6792,6781,7828],[6792,7822,7828],
 [6792,7822,47575],[6792,14084,47575],[6793,6781,7828],
 [6793,7823,7828],[6793,7823,40450],[6793,13683,40450],
 [6810,6781,7828],[6810,7840,7828],[6810,7840,40824],
 [6810,13700,40824],[6813,6781,7828],[6813,7843,7828],
 [6813,7843,50046],[6813,7847,7828],[6813,7847,50075],
 [6813,13703,14523],[6813,13709,14565],[6813,14264,14523],
 [6813,14264,14565],[6813,14264,50046],[6813,14264,50075],
 [6814,6781,7828],[6814,7844,7828],[6814,7844,40870],
 [6814,13704,40870],[6822,6781,7828],[6822,7852,7828],
 [6822,7852,40914],[6822,13712,40914],[6848,6842,7828],
 [6848,7817,7828],[6848,7817,44904],[6848,15748,44904],
 [6853,6840,6842,7828],[6853,6840,7725,7828],
 [6853,6840,7725,38205],[6853,6840,7828],
 [6853,6840,15415,38205],[6853,6840,15433],
 [6853,6840,15476,15470],[6853,6840,15476,15477],
 [6853,6840,15476,15914,47575],[6853,6840,15476,39563,47575],
 [6853,6840,15476,47575],[6853,6840,38205],[6853,6842,7828],
 [6853,7725,7828],[6853,7725,38205],[6853,7737,7725,7828],
 [6853,7737,7725,38205],[6853,7737,7822,7828],
 [6853,7737,7822,47575],[6853,7737,7828],[6853,7737,38205],
 [6853,7737,38216,38205],[6853,7737,38223,38205],
 [6853,7737,38660,47575],[6853,7737,39563,47575],
 [6853,7737,47575],[6853,7822,7828],[6853,7822,47575],
 [6853,15415,38205],[6853,15476,15470],[6853,15476,15477],
 [6853,15476,15914,47575],[6853,15476,39563,47575],
 [6853,15476,47575],[6853,15914,47575],[6853,38216,38205],
 [6853,38223,38205],[6853,38660,47575],[6853,39563,47575],
 [6854,6842,7828],[6854,7823,7828],[6854,7823,40450],
 [6854,15513,40450],[6883,6842,7828],[6883,7852,7828],
 [6883,7852,40914],[6883,15542,40914],[6904,6900,6902,7828],
 [6904,6900,7725,7828],[6904,6900,7725,38205],
 [6904,6900,7828],[6904,6900,17185,38205],[6904,6900,17203],
 [6904,6900,17246],[6904,6900,38205],[6904,6902,7828],
 [6904,6903,7875],[6904,6903,17335],[6904,6905,6902,7828],
 [6904,6905,6903,7875],[6904,6905,6903,17335],
 [6904,6905,7812,7828],[6904,6905,7812,7875],
 [6904,6905,7812,7950],[6904,6905,7812,40055],
 [6904,6905,7812,40642],[6904,6905,7812,41411],
 [6904,6905,7812,42936],[6904,6905,7828],[6904,6905,7875],
 [6904,6905,7950],[6904,6905,17272,40055],
 [6904,6905,17290,40642],[6904,6905,17329,41411],
 [6904,6905,17335],[6904,6905,17408,42936],[6904,6905,17410],
 [6904,6905,40055],[6904,6905,40642],[6904,6905,41411],
 [6904,6905,42936],[6904,7725,7828],[6904,7725,38205],
 [6904,7727,7725,7828],[6904,7727,7725,38205],
 [6904,7727,7812,7828],[6904,7727,7812,7875],
 [6904,7727,7812,7950],[6904,7727,7812,40055],
 [6904,7727,7812,40642],[6904,7727,7812,41411],
 [6904,7727,7812,42936],[6904,7727,7813,7828],
 [6904,7727,7813,42193],[6904,7727,7828],[6904,7727,7875],
 [6904,7727,7950],[6904,7727,38205],[6904,7727,38206,38205],
 [6904,7727,38206,38331],[6904,7727,38206,39193],
 [6904,7727,38206,40055],[6904,7727,38224,38205],
 [6904,7727,38224,38921],[6904,7727,38224,39779],
 [6904,7727,38224,40642],[6904,7727,38305,41411],
 [6904,7727,38309,38921],[6904,7727,38331],
 [6904,7727,38345,38331],[6904,7727,38345,38921],
 [6904,7727,38345,42193],[6904,7727,38345,42936],
 [6904,7727,38347,38331],[6904,7727,38921],[6904,7727,39193],
 [6904,7727,39208,39193],[6904,7727,39208,39779],
 [6904,7727,39208,41411],[6904,7727,39208,42193],
 [6904,7727,39214,39193],[6904,7727,39287,42936],
 [6904,7727,39289,39779],[6904,7727,39779],[6904,7727,40055],
 [6904,7727,40073,40055],[6904,7727,40111,40642],
 [6904,7727,40642],[6904,7727,41411],[6904,7727,42193],
 [6904,7727,42936],[6904,7812,7828],[6904,7812,7875],
 [6904,7812,7950],[6904,7812,40055],[6904,7812,40642],
 [6904,7812,41411],[6904,7812,42936],[6904,7813,7828],
 [6904,7813,42193],[6904,17185,38205],[6904,17188,38331],
 [6904,17207,38921],[6904,17230,39193],[6904,17248,39779],
 [6904,17272,40055],[6904,17290,40642],[6904,17329,41411],
 [6904,17369,42193],[6904,17408,42936],[6904,38206,38205],
 [6904,38206,38331],[6904,38206,39193],[6904,38206,40055],
 [6904,38224,38205],[6904,38224,38921],[6904,38224,39779],
 [6904,38224,40642],[6904,38305,41411],[6904,38309,38921],
 [6904,38345,38331],[6904,38345,38921],[6904,38345,42193],
 [6904,38345,42936],[6904,38347,38331],[6904,39208,39193],
 [6904,39208,39779],[6904,39208,41411],[6904,39208,42193],
 [6904,39214,39193],[6904,39287,42936],[6904,39289,39779],
 [6904,40073,40055],[6904,40111,40642],[6909,6902,7828],
 [6909,6903,7875],[6909,6903,17335],[6909,6905,6902,7828],
 [6909,6905,6903,7875],[6909,6905,6903,17335],
 [6909,6905,7812,7828],[6909,6905,7812,7875],
 [6909,6905,7812,7950],[6909,6905,7812,40055],
 [6909,6905,7812,40642],[6909,6905,7812,41411],
 [6909,6905,7812,42936],[6909,6905,7828],[6909,6905,7875],
 [6909,6905,7950],[6909,6905,17272,40055],
 [6909,6905,17290,40642],[6909,6905,17329,41411],
 [6909,6905,17335],[6909,6905,17408,42936],[6909,6905,17410],
 [6909,6905,40055],[6909,6905,40642],[6909,6905,41411],
 [6909,6905,42936],[6909,6908,6902,7828],
 [6909,6908,7817,7828],[6909,6908,7817,44904],
 [6909,6908,7828],[6909,6908,17277],[6909,6908,17287],
 [6909,6908,17518,44904],[6909,6908,44904],[6909,7812,7828],
 [6909,7812,7875],[6909,7812,7950],[6909,7812,40055],
 [6909,7812,40642],[6909,7812,41411],[6909,7812,42936],
 [6909,7817,7828],[6909,7817,44904],[6909,7818,7828],
 [6909,7818,40287],[6909,7858,7812,7828],
 [6909,7858,7812,7875],[6909,7858,7812,7950],
 [6909,7858,7812,40055],[6909,7858,7812,40642],
 [6909,7858,7812,41411],[6909,7858,7812,42936],
 [6909,7858,7817,7828],[6909,7858,7817,44904],
 [6909,7858,7818,7828],[6909,7858,7818,40287],
 [6909,7858,7828],[6909,7858,7875],[6909,7858,7950],
 [6909,7858,40055],[6909,7858,40058,40055],
 [6909,7858,40058,40287],[6909,7858,40058,41069],
 [6909,7858,40058,42593],[6909,7858,40068,40055],
 [6909,7858,40261,40642],[6909,7858,40287],
 [6909,7858,40293,40287],[6909,7858,40293,40642],
 [6909,7858,40293,45501],[6909,7858,40293,47090],
 [6909,7858,40642],[6909,7858,41069],[6909,7858,41078,41069],
 [6909,7858,41078,41411],[6909,7858,41078,44904],
 [6909,7858,41078,45501],[6909,7858,41085,41069],
 [6909,7858,41212,47090],[6909,7858,41213,41411],
 [6909,7858,41411],[6909,7858,42593],[6909,7858,42599,42593],
 [6909,7858,42599,42936],[6909,7858,42599,44904],
 [6909,7858,42599,47090],[6909,7858,42602,42593],
 [6909,7858,42634,45501],[6909,7858,42635,42936],
 [6909,7858,42936],[6909,7858,44904],[6909,7858,45501],
 [6909,7858,47090],[6909,17272,40055],[6909,17278,40287],
 [6909,17290,40642],[6909,17318,41069],[6909,17329,41411],
 [6909,17397,42593],[6909,17408,42936],[6909,17518,44904],
 [6909,17553,45501],[6909,17652,47090],[6909,40058,40055],
 [6909,40058,40287],[6909,40058,41069],[6909,40058,42593],
 [6909,40068,40055],[6909,40261,40642],[6909,40293,40287],
 [6909,40293,40642],[6909,40293,45501],[6909,40293,47090],
 [6909,41078,41069],[6909,41078,41411],[6909,41078,44904],
 [6909,41078,45501],[6909,41085,41069],[6909,41212,47090],
 [6909,41213,41411],[6909,42599,42593],[6909,42599,42936],
 [6909,42599,44904],[6909,42599,47090],[6909,42602,42593],
 [6909,42634,45501],[6909,42635,42936],[6913,6902,7828],
 [6913,7822,7828],[6913,7822,47575],[6913,17684,47575],
 [6914,6902,7828],[6914,7823,7828],[6914,7823,40450],
 [6914,17283,40450],[6962,6961,7828],[6962,7812,7828],
 [6962,7812,7875],[6962,7812,7950],[6962,7812,40055],
 [6962,7812,40642],[6962,7812,41411],[6962,7812,42936],
 [6962,18983,40055],[6962,19001,40642],[6962,19040,41411],
 [6962,19119,42936],[6972,6961,7828],[6972,7822,7828],
 [6972,7822,47575],[6972,19395,47575],[6973,6961,7828],
 [6973,7823,7828],[6973,7823,40450],[6973,18994,40450],
 [6975,6961,7828],[6975,7825,7828],[6975,7825,48796],
 [6975,19482,48796],[6993,6961,7828],[6993,7843,7828],
 [6993,7843,50046],[6993,19575,50046],[6994,6961,7828],
 [6994,7844,7828],[6994,7844,40870],[6994,7852,7828],
 [6994,7852,40914],[6994,19015,19848],[6994,19015,19857],
 [6994,19015,40870],[6994,19015,40914],[6994,19576,19848],
 [6994,19577,19857],[6997,6961,7828],[6997,7847,7828],
 [6997,7847,50075],[6997,19579,50075],[7017,7019,7828],
 [7017,7725,7828],[7017,7725,38205],[7017,20549,38205],
 [7017,20567,20561],[7017,20567,20568],
 [7017,20567,21048,47575],[7017,20567,38660,47575],
 [7017,20567,47575],[7021,6825,14635],[7021,6842,7828],
 [7021,6844,6842,7828],[7021,6844,7813,7828],
 [7021,6844,7813,42193],[7021,6844,7828],[7021,6844,15503],
 [7021,6844,15522],[7021,6844,42193],[7021,6849,6842,7828],
 [7021,6849,7818,7828],[7021,6849,7818,40287],
 [7021,6849,7828],[7021,6849,15508,40287],[7021,6849,15784],
 [7021,6849,15883],[7021,6849,40287],[7021,6961,7828],
 [7021,6963,6961,7828],[7021,6963,7813,7828],
 [7021,6963,7813,42193],[7021,6963,7828],[7021,6963,18984],
 [7021,6963,19003],[7021,6963,19080,42193],[7021,6963,42193],
 [7021,6968,6961,7828],[7021,6968,7818,7828],
 [7021,6968,7818,40287],[7021,6968,7828],
 [7021,6968,18989,40287],[7021,6968,19265],[7021,6968,19364],
 [7021,6968,40287],[7021,7019,7828],[7021,7026,7019,7828],
 [7021,7026,7818,7828],[7021,7026,7818,40287],
 [7021,7026,7828],[7021,7026,20642,40287],[7021,7026,20918],
 [7021,7026,21017],[7021,7026,40287],[7021,7813,7828],
 [7021,7813,42193],[7021,7818,7828],[7021,7818,40287],
 [7021,7899,7813,7828],[7021,7899,7813,42193],
 [7021,7899,7818,7828],[7021,7899,7818,40287],
 [7021,7899,7828],[7021,7899,40099,40287],[7021,7899,40287],
 [7021,7899,40298,40287],[7021,7899,41894,42193],
 [7021,7899,41993,42193],[7021,7899,42193],[7021,14651,14635],
 [7021,14653,14635],[7021,14653,14658,14635],
 [7021,14653,15589],[7021,14653,19070],[7021,14653,20723],
 [7021,14658,14635],[7021,14661,14635],
 [7021,14668,6825,14635],[7021,14668,6842,7828],
 [7021,14668,6961,7828],[7021,14668,7019,7828],
 [7021,14668,7828],[7021,14668,14635],
 [7021,14668,14651,14635],[7021,14672,14635],
 [7021,15508,40287],[7021,15788,15508,40287],
 [7021,15788,15522],[7021,15788,40287],
 [7021,15788,40298,40287],[7021,18989,40287],
 [7021,19080,42193],[7021,20642,40287],
 [7021,20656,20642,40287],[7021,20656,20922],
 [7021,20656,40287],[7021,20656,40298,40287],
 [7021,20733,20723],[7021,20733,20918],[7021,20733,20922],
 [7021,20733,41894,42193],[7021,20733,42193],
 [7021,40099,40287],[7021,40298,40287],[7021,41894,42193],
 [7021,41993,42193],[7025,7019,7828],[7025,7817,7828],
 [7025,7817,44904],[7025,20882,44904],[7030,7017,7019,7828],
 [7030,7017,7725,7828],[7030,7017,7725,38205],
 [7030,7017,7828],[7030,7017,20549,38205],
 [7030,7017,20567,20561],[7030,7017,20567,20568],
 [7030,7017,20567,21048,47575],[7030,7017,20567,38660,47575],
 [7030,7017,20567,47575],[7030,7017,20610],[7030,7017,38205],
 [7030,7019,7828],[7030,7725,7828],[7030,7725,38205],
 [7030,7737,7725,7828],[7030,7737,7725,38205],
 [7030,7737,7822,7828],[7030,7737,7822,47575],
 [7030,7737,7828],[7030,7737,38205],[7030,7737,38216,38205],
 [7030,7737,38223,38205],[7030,7737,38660,47575],
 [7030,7737,39563,47575],[7030,7737,47575],[7030,7822,7828],
 [7030,7822,47575],[7030,20549,38205],[7030,21048,47575],
 [7030,38216,38205],[7030,38223,38205],[7030,39563,47575],
 [7031,7019,7828],[7031,7823,7828],[7031,7823,40450],
 [7031,20647,40450],[7052,7019,7828],[7052,7844,7828],
 [7052,7844,40870],[7052,20668,40870],[7074,7076,7828],
 [7074,7077,7875],[7074,7079,7950],[7074,7079,22370],
 [7074,7725,7828],[7074,7725,38205],[7074,7727,7725,7828],
 [7074,7727,7725,38205],[7074,7727,7812,7828],
 [7074,7727,7812,7875],[7074,7727,7812,7950],
 [7074,7727,7812,40055],[7074,7727,7812,40642],
 [7074,7727,7812,41411],[7074,7727,7812,42936],
 [7074,7727,7813,7828],[7074,7727,7813,42193],
 [7074,7727,7828],[7074,7727,7875],[7074,7727,7950],
 [7074,7727,38205],[7074,7727,38206,38205],
 [7074,7727,38206,38331],[7074,7727,38206,39193],
 [7074,7727,38206,40055],[7074,7727,38224,38205],
 [7074,7727,38224,38921],[7074,7727,38224,39779],
 [7074,7727,38224,40642],[7074,7727,38305,41411],
 [7074,7727,38309,38921],[7074,7727,38331],
 [7074,7727,38345,38331],[7074,7727,38345,38921],
 [7074,7727,38345,42193],[7074,7727,38345,42936],
 [7074,7727,38347,38331],[7074,7727,38921],[7074,7727,39193],
 [7074,7727,39208,39193],[7074,7727,39208,39779],
 [7074,7727,39208,41411],[7074,7727,39208,42193],
 [7074,7727,39214,39193],[7074,7727,39287,42936],
 [7074,7727,39289,39779],[7074,7727,39779],[7074,7727,40055],
 [7074,7727,40073,40055],[7074,7727,40111,40642],
 [7074,7727,40642],[7074,7727,41411],[7074,7727,42193],
 [7074,7727,42936],[7074,7812,7828],[7074,7812,7875],
 [7074,7812,7950],[7074,7812,40055],[7074,7812,40642],
 [7074,7812,41411],[7074,7812,42936],[7074,7813,7828],
 [7074,7813,42193],[7074,22145,38205],[7074,22148,38331],
 [7074,22167,38921],[7074,22190,39193],[7074,22208,39779],
 [7074,22232,40055],[7074,22250,40642],[7074,22289,41411],
 [7074,22329,42193],[7074,22368,42936],[7074,38206,38205],
 [7074,38206,38331],[7074,38206,39193],[7074,38206,40055],
 [7074,38224,38205],[7074,38224,38921],[7074,38224,39779],
 [7074,38224,40642],[7074,38305,41411],[7074,38309,38921],
 [7074,38345,38331],[7074,38345,38921],[7074,38345,42193],
 [7074,38345,42936],[7074,38347,38331],[7074,39208,39193],
 [7074,39208,39779],[7074,39208,41411],[7074,39208,42193],
 [7074,39214,39193],[7074,39287,42936],[7074,39289,39779],
 [7074,40073,40055],[7074,40111,40642],[7082,7076,7828],
 [7082,7077,7875],[7082,7079,7950],[7082,7079,22370],
 [7082,7812,7828],[7082,7812,7875],[7082,7812,7950],
 [7082,7812,40055],[7082,7812,40642],[7082,7812,41411],
 [7082,7812,42936],[7082,7817,7828],[7082,7817,44904],
 [7082,7818,7828],[7082,7818,40287],[7082,7858,7812,7828],
 [7082,7858,7812,7875],[7082,7858,7812,7950],
 [7082,7858,7812,40055],[7082,7858,7812,40642],
 [7082,7858,7812,41411],[7082,7858,7812,42936],
 [7082,7858,7817,7828],[7082,7858,7817,44904],
 [7082,7858,7818,7828],[7082,7858,7818,40287],
 [7082,7858,7828],[7082,7858,7875],[7082,7858,7950],
 [7082,7858,40055],[7082,7858,40058,40055],
 [7082,7858,40058,40287],[7082,7858,40058,41069],
 [7082,7858,40058,42593],[7082,7858,40068,40055],
 [7082,7858,40261,40642],[7082,7858,40287],
 [7082,7858,40293,40287],[7082,7858,40293,40642],
 [7082,7858,40293,45501],[7082,7858,40293,47090],
 [7082,7858,40642],[7082,7858,41069],[7082,7858,41078,41069],
 [7082,7858,41078,41411],[7082,7858,41078,44904],
 [7082,7858,41078,45501],[7082,7858,41085,41069],
 [7082,7858,41212,47090],[7082,7858,41213,41411],
 [7082,7858,41411],[7082,7858,42593],[7082,7858,42599,42593],
 [7082,7858,42599,42936],[7082,7858,42599,44904],
 [7082,7858,42599,47090],[7082,7858,42602,42593],
 [7082,7858,42634,45501],[7082,7858,42635,42936],
 [7082,7858,42936],[7082,7858,44904],[7082,7858,45501],
 [7082,7858,47090],[7082,22232,40055],[7082,22238,40287],
 [7082,22250,40642],[7082,22278,41069],[7082,22289,41411],
 [7082,22357,42593],[7082,22368,42936],[7082,22478,44904],
 [7082,22513,45501],[7082,22612,47090],[7082,40058,40055],
 [7082,40058,40287],[7082,40058,41069],[7082,40058,42593],
 [7082,40068,40055],[7082,40261,40642],[7082,40293,40287],
 [7082,40293,40642],[7082,40293,45501],[7082,40293,47090],
 [7082,41078,41069],[7082,41078,41411],[7082,41078,44904],
 [7082,41078,45501],[7082,41085,41069],[7082,41212,47090],
 [7082,41213,41411],[7082,42599,42593],[7082,42599,42936],
 [7082,42599,44904],[7082,42599,47090],[7082,42602,42593],
 [7082,42634,45501],[7082,42635,42936],[7087,7076,7828],
 [7087,7077,7875],[7087,7079,7950],[7087,7079,22370],
 [7087,7812,7828],[7087,7812,7875],[7087,7812,7950],
 [7087,7812,40055],[7087,7812,40642],[7087,7812,41411],
 [7087,7812,42936],[7087,7822,7828],[7087,7822,47575],
 [7087,7823,7828],[7087,7823,40450],[7087,7863,7812,7828],
 [7087,7863,7812,7875],[7087,7863,7812,7950],
 [7087,7863,7812,40055],[7087,7863,7812,40642],
 [7087,7863,7812,41411],[7087,7863,7812,42936],
 [7087,7863,7822,7828],[7087,7863,7822,47575],
 [7087,7863,7823,7828],[7087,7863,7823,40450],
 [7087,7863,7828],[7087,7863,7875],[7087,7863,7950],
 [7087,7863,40055],[7087,7863,40063,40055],
 [7087,7863,40063,40450],[7087,7863,40063,41239],
 [7087,7863,40063,42761],[7087,7863,40070,40055],
 [7087,7863,40426,40642],[7087,7863,40450],
 [7087,7863,40455,40450],[7087,7863,40455,40642],
 [7087,7863,40455,48035],[7087,7863,40455,48445],
 [7087,7863,40642],[7087,7863,41239],[7087,7863,41244,41239],
 [7087,7863,41244,41411],[7087,7863,41244,47575],
 [7087,7863,41244,48035],[7087,7863,41250,41239],
 [7087,7863,41303,41411],[7087,7863,41304,48445],
 [7087,7863,41411],[7087,7863,42761],[7087,7863,42765,42761],
 [7087,7863,42765,42936],[7087,7863,42765,47575],
 [7087,7863,42765,48445],[7087,7863,42767,42761],
 [7087,7863,42795,42936],[7087,7863,42796,48035],
 [7087,7863,42936],[7087,7863,47575],[7087,7863,48035],
 [7087,7863,48445],[7087,22232,40055],[7087,22243,40450],
 [7087,22250,40642],[7087,22283,41239],[7087,22289,41411],
 [7087,22362,42761],[7087,22368,42936],[7087,22644,47575],
 [7087,22675,48035],[7087,22704,48445],[7087,40063,40055],
 [7087,40063,40450],[7087,40063,41239],[7087,40063,42761],
 [7087,40070,40055],[7087,40426,40642],[7087,40455,40450],
 [7087,40455,40642],[7087,40455,48035],[7087,40455,48445],
 [7087,41244,41239],[7087,41244,41411],[7087,41244,47575],
 [7087,41244,48035],[7087,41250,41239],[7087,41303,41411],
 [7087,41304,48445],[7087,42765,42761],[7087,42765,42936],
 [7087,42765,47575],[7087,42765,48445],[7087,42767,42761],
 [7087,42795,42936],[7087,42796,48035],[7130,7132,7828],
 [7130,7725,7828],[7130,7725,38205],[7130,23685,38205],
 [7143,7132,7828],[7143,7822,7828],[7143,7822,47575],
 [7143,24184,47575],[7144,7132,7828],[7144,7138,7132,7828],
 [7144,7138,7817,7828],[7144,7138,7817,44904],
 [7144,7138,7828],[7144,7138,23777,23783,40450],
 [7144,7138,23777,24014],[7144,7138,23777,24015],
 [7144,7138,23777,40254,40450],[7144,7138,23777,40450],
 [7144,7138,23787],[7144,7138,24018,44904],[7144,7138,44904],
 [7144,7817,7828],[7144,7817,44904],[7144,7823,7828],
 [7144,7823,40450],[7144,8054,7817,7828],
 [7144,8054,7817,44904],[7144,8054,7823,7828],
 [7144,8054,7823,40450],[7144,8054,7828],
 [7144,8054,40254,40450],[7144,8054,40450],
 [7144,8054,40453,40450],[7144,8054,44793,44904],
 [7144,8054,44822,44904],[7144,8054,44904],
 [7144,23777,23783,40450],[7144,23777,24014],
 [7144,23777,24015],[7144,23777,40254,40450],
 [7144,23777,40450],[7144,23783,40450],[7144,24018,44904],
 [7144,40254,40450],[7144,40453,40450],[7144,44793,44904],
 [7144,44822,44904],[7164,7132,7828],[7164,7843,7828],
 [7164,7843,50046],[7164,24364,50046],[7185,7187,7828],
 [7185,7725,7828],[7185,7725,38205],[7185,25170,38205],
 [7194,6767,12979],[7194,6781,7828],[7194,6783,6781,7828],
 [7194,6783,7813,7828],[7194,6783,7813,42193],
 [7194,6783,7828],[7194,6783,13673],[7194,6783,13692],
 [7194,6783,13769,42193],[7194,6783,42193],
 [7194,6788,6781,7828],[7194,6788,7818,7828],
 [7194,6788,7818,40287],[7194,6788,7828],
 [7194,6788,13678,40287],[7194,6788,13954],[7194,6788,14053],
 [7194,6788,40287],[7194,7132,7828],[7194,7134,7132,7828],
 [7194,7134,7813,7828],[7194,7134,7813,42193],
 [7194,7134,7828],[7194,7134,23773],[7194,7134,23792],
 [7194,7134,23869,42193],[7194,7134,42193],
 [7194,7139,7132,7828],[7194,7139,7818,7828],
 [7194,7139,7818,40287],[7194,7139,7828],[7194,7139,24054],
 [7194,7139,24153],[7194,7139,40287],[7194,7187,7828],
 [7194,7189,7187,7828],[7194,7189,7813,7828],
 [7194,7189,7813,42193],[7194,7189,7828],[7194,7189,25258],
 [7194,7189,25277],[7194,7189,25354,42193],[7194,7189,42193],
 [7194,7813,7828],[7194,7813,42193],[7194,7818,7828],
 [7194,7818,40287],[7194,7899,7813,7828],
 [7194,7899,7813,42193],[7194,7899,7818,7828],
 [7194,7899,7818,40287],[7194,7899,7828],
 [7194,7899,40099,40287],[7194,7899,40287],
 [7194,7899,40298,40287],[7194,7899,41894,42193],
 [7194,7899,41993,42193],[7194,7899,42193],
 [7194,12992,6767,12979],[7194,12992,6781,7828],
 [7194,12992,7132,7828],[7194,12992,7187,7828],
 [7194,12992,7828],[7194,12992,12979],
 [7194,12992,13009,12979],[7194,12994,12979],
 [7194,12999,12979],[7194,12999,12994,12979],
 [7194,12999,13759],[7194,12999,23859],[7194,12999,25344],
 [7194,13002,12979],[7194,13009,12979],[7194,13013,12979],
 [7194,13678,40287],[7194,13769,42193],
 [7194,23862,23869,42193],[7194,23862,24153],
 [7194,23862,41993,42193],[7194,23862,42193],
 [7194,23869,42193],[7194,25263,25258],[7194,25263,25344],
 [7194,25263,25347],[7194,25263,40099,40287],
 [7194,25263,40287],[7194,25354,42193],[7194,25638,25347],
 [7194,25638,25354,42193],[7194,25638,41993,42193],
 [7194,25638,42193],[7194,40099,40287],[7194,40298,40287],
 [7194,41894,42193],[7194,41993,42193],[7198,7187,7828],
 [7198,7822,7828],[7198,7822,47575],[7198,25669,47575],
 [7199,7187,7828],[7199,7193,7187,7828],
 [7199,7193,7817,7828],[7199,7193,7817,44904],
 [7199,7193,7828],[7199,7193,25262],
 [7199,7193,25272,25268,40450],[7199,7193,25272,25698],
 [7199,7193,25272,25727],[7199,7193,25272,40450],
 [7199,7193,25272,40453,40450],[7199,7193,25503,44904],
 [7199,7193,44904],[7199,7817,7828],[7199,7817,44904],
 [7199,7823,7828],[7199,7823,40450],[7199,8054,7817,7828],
 [7199,8054,7817,44904],[7199,8054,7823,7828],
 [7199,8054,7823,40450],[7199,8054,7828],
 [7199,8054,40254,40450],[7199,8054,40450],
 [7199,8054,40453,40450],[7199,8054,44793,44904],
 [7199,8054,44822,44904],[7199,8054,44904],[7199,25268,40450],
 [7199,25272,25268,40450],[7199,25272,25698],
 [7199,25272,25727],[7199,25272,40450],
 [7199,25272,40453,40450],[7199,25503,44904],
 [7199,40254,40450],[7199,40453,40450],[7199,44793,44904],
 [7199,44822,44904],[7223,7187,7828],[7223,7847,7828],
 [7223,7847,50075],[7223,25853,50075],[7239,7241,7828],
 [7239,7725,7828],[7239,7725,38205],[7239,26601,38205],
 [7243,7241,7828],[7243,7813,7828],[7243,7813,42193],
 [7243,26785,42193],[7244,7241,7828],[7244,7242,7875],
 [7244,7242,26751],[7244,7812,7828],[7244,7812,7875],
 [7244,7812,7950],[7244,7812,40055],[7244,7812,40642],
 [7244,7812,41411],[7244,7812,42936],[7244,26688,40055],
 [7244,26706,40642],[7244,26745,41411],[7244,26824,42936],
 [7247,7241,7828],[7247,7817,7828],[7247,7817,44904],
 [7247,26934,44904],[7248,7241,7828],[7248,7818,7828],
 [7248,7818,40287],[7248,26694,40287],[7252,7241,7828],
 [7252,7822,7828],[7252,7822,47575],[7252,27100,47575],
 [7253,7241,7828],[7253,7823,7828],[7253,7823,40450],
 [7253,26699,40450],[7292,7294,7828],[7292,7725,7828],
 [7292,7725,38205],[7292,27979,38205],[7296,7294,7828],
 [7296,7813,7828],[7296,7813,42193],[7296,28163,42193],
 [7297,7294,7828],[7297,7295,7875],[7297,7295,28129],
 [7297,7812,7828],[7297,7812,7875],[7297,7812,7950],
 [7297,7812,40055],[7297,7812,40642],[7297,7812,41411],
 [7297,7812,42936],[7297,28066,40055],[7297,28084,40642],
 [7297,28123,41411],[7297,28202,42936],[7300,7294,7828],
 [7300,7817,7828],[7300,7817,44904],[7300,28312,44904],
 [7301,7294,7828],[7301,7818,7828],[7301,7818,40287],
 [7301,28072,40287],[7305,7294,7828],[7305,7822,7828],
 [7305,7822,47575],[7305,28478,47575],[7306,7294,7828],
 [7306,7823,7828],[7306,7823,40450],[7306,28077,40450],
 [7344,7346,7828],[7344,7725,7828],[7344,7725,38205],
 [7344,29305,38205],[7348,7346,7828],[7348,7813,7828],
 [7348,7813,42193],[7348,29489,42193],[7352,7346,7828],
 [7352,7817,7828],[7352,7817,44904],[7352,29638,44904],
 [7353,7346,7828],[7353,7818,7828],[7353,7818,40287],
 [7353,29398,40287],[7357,7346,7828],[7357,7822,7828],
 [7357,7822,47575],[7357,29804,47575],[7358,7346,7828],
 [7358,7823,7828],[7358,7823,40450],[7358,29403,40450],
 [7360,7346,7828],[7360,7825,7828],[7360,7825,48796],
 [7360,29891,48796],[7375,7346,7828],[7375,7840,7828],
 [7375,7840,40824],[7375,29420,40824],[7395,7397,7828],
 [7395,7725,7828],[7395,7725,38205],[7395,30580,38205],
 [7399,7397,7828],[7399,7813,7828],[7399,7813,42193],
 [7399,30764,42193],[7400,7397,7828],[7400,7398,7875],
 [7400,7398,30730],[7400,7812,7828],[7400,7812,7875],
 [7400,7812,7950],[7400,7812,40055],[7400,7812,40642],
 [7400,7812,41411],[7400,7812,42936],[7400,30667,40055],
 [7400,30685,40642],[7400,30724,41411],[7400,30803,42936],
 [7403,7397,7828],[7403,7817,7828],[7403,7817,44904],
 [7403,30913,44904],[7404,7397,7828],[7404,7818,7828],
 [7404,7818,40287],[7404,30673,40287],[7408,7397,7828],
 [7408,7822,7828],[7408,7822,47575],[7408,31079,47575],
 [7409,7397,7828],[7409,7823,7828],[7409,7823,40450],
 [7409,30678,40450],[7445,7447,7828],[7445,7725,7828],
 [7445,7725,38205],[7445,31805,38205],[7449,7447,7828],
 [7449,7813,7828],[7449,7813,42193],[7449,31989,42193],
 [7453,7447,7828],[7453,7817,7828],[7453,7817,44904],
 [7453,32138,44904],[7454,7447,7828],[7454,7818,7828],
 [7454,7818,40287],[7454,31898,40287],[7458,7447,7828],
 [7458,7822,7828],[7458,7822,47575],[7458,32304,47575],
 [7459,7447,7828],[7459,7823,7828],[7459,7823,40450],
 [7459,31903,40450],[7461,7447,7828],[7461,7825,7828],
 [7461,7825,48796],[7461,32391,48796],[7476,7447,7828],
 [7476,7840,7828],[7476,7840,40824],[7476,31920,40824],
 [7494,7496,7828],[7494,7725,7828],[7494,7725,38205],
 [7494,32981,38205],[7498,7496,7828],[7498,7813,7828],
 [7498,7813,42193],[7498,33165,42193],[7502,7496,7828],
 [7502,7817,7828],[7502,7817,44904],[7502,33314,44904],
 [7503,7496,7828],[7503,7818,7828],[7503,7818,40287],
 [7503,33074,40287],[7507,7496,7828],[7507,7822,7828],
 [7507,7822,47575],[7507,33480,47575],[7508,7496,7828],
 [7508,7823,7828],[7508,7823,40450],[7508,33079,40450],
 [7542,7544,7828],[7542,7725,7828],[7542,7725,38205],
 [7542,34109,38205],[7546,7544,7828],[7546,7813,7828],
 [7546,7813,42193],[7546,34293,42193],[7547,7544,7828],
 [7547,7545,7875],[7547,7545,34259],[7547,7812,7828],
 [7547,7812,7875],[7547,7812,7950],[7547,7812,40055],
 [7547,7812,40642],[7547,7812,41411],[7547,7812,42936],
 [7547,34196,40055],[7547,34214,40642],[7547,34253,41411],
 [7547,34332,42936],[7550,7544,7828],[7550,7817,7828],
 [7550,7817,44904],[7550,34442,44904],[7551,7544,7828],
 [7551,7818,7828],[7551,7818,40287],[7551,34202,40287],
 [7555,7544,7828],[7555,7822,7828],[7555,7822,47575],
 [7555,34608,47575],[7556,7544,7828],[7556,7823,7828],
 [7556,7823,40450],[7556,34207,40450],[7589,7591,7828],
 [7589,7725,7828],[7589,7725,38205],[7589,35190,38205],
 [7593,7591,7828],[7593,7813,7828],[7593,7813,42193],
 [7593,35374,42193],[7597,7591,7828],[7597,7817,7828],
 [7597,7817,44904],[7597,35523,44904],[7598,7591,7828],
 [7598,7818,7828],[7598,7818,40287],[7598,35283,40287],
 [7602,7591,7828],[7602,7822,7828],[7602,7822,47575],
 [7602,35689,47575],[7603,7591,7828],[7603,7823,7828],
 [7603,7823,40450],[7603,35288,40450],[7605,7591,7828],
 [7605,7825,7828],[7605,7825,48796],[7605,35776,48796],
 [7620,7591,7828],[7620,7840,7828],[7620,7840,40824],
 [7620,35305,40824],[7635,7637,7828],[7635,7725,7828],
 [7635,7725,38205],[7635,36225,38205],[7639,7637,7828],
 [7639,7813,7828],[7639,7813,42193],[7639,36409,42193],
 [7643,7637,7828],[7643,7817,7828],[7643,7817,44904],
 [7643,36558,44904],[7644,7637,7828],[7644,7818,7828],
 [7644,7818,40287],[7644,36318,40287],[7648,7637,7828],
 [7648,7822,7828],[7648,7822,47575],[7648,36724,47575],
 [7649,7637,7828],[7649,7823,7828],[7649,7823,40450],
 [7649,36323,40450],[7680,7682,7828],[7680,7725,7828],
 [7680,7725,38205],[7680,37215,38205],[7684,7682,7828],
 [7684,7813,7828],[7684,7813,42193],[7684,37399,42193],
 [7685,7682,7828],[7685,7683,7875],[7685,7683,37365],
 [7685,7812,7828],[7685,7812,7875],[7685,7812,7950],
 [7685,7812,40055],[7685,7812,40642],[7685,7812,41411],
 [7685,7812,42936],[7685,37302,40055],[7685,37320,40642],
 [7685,37359,41411],[7685,37438,42936],[7688,7682,7828],
 [7688,7817,7828],[7688,7817,44904],[7688,37548,44904],
 [7689,7682,7828],[7689,7818,7828],[7689,7818,40287],
 [7689,37308,40287],[7693,7682,7828],[7693,7822,7828],
 [7693,7822,47575],[7693,37714,47575],[7694,7682,7828],
 [7694,7823,7828],[7694,7823,40450],[7694,37313,40450],
 [7696,7682,7828],[7696,7825,7828],[7696,7825,48796],
 [7696,37801,48796],[7711,7682,7828],[7711,7840,7828],
 [7711,7840,40824],[7711,37330,40824],[7715,7682,7828],
 [7715,7844,7828],[7715,7844,40870],[7715,37334,40870],
 [7718,7682,7828],[7718,7847,7828],[7718,7847,50075],
 [7718,37898,50075],[7740,7725,7828],[7740,7725,38205],
 [7740,7825,7828],[7740,7825,48796],[7740,38219,38205],
 [7740,38225,38205],[7740,38747,48796],[7740,39650,48796],
 [7741,7725,7828],[7741,7725,38205],[7741,7826,7828],
 [7741,38220,38205],[7754,7725,7828],[7754,7725,38205],
 [7754,7839,7828],[7754,38233,38205],[7755,7725,7828],
 [7755,7725,38205],[7755,7840,7828],[7755,7840,40824],
 [7755,38234,38205],[7755,38234,40824],[7757,7725,7828],
 [7757,7725,38205],[7757,7842,7828],[7757,38236,38205],
 [7758,7725,7828],[7758,7725,38205],[7758,7843,7828],
 [7758,7843,50046],[7758,38237,38205],[7758,38244,38205],
 [7758,38840,50046],[7758,39743,50046],[7759,7725,7828],
 [7759,7725,38205],[7759,7844,7828],[7759,7844,40870],
 [7759,38238,38205],[7759,38238,40870],[7761,7725,7828],
 [7761,7725,38205],[7761,7846,7828],[7761,38240,38205],
 [7762,7725,7828],[7762,7725,38205],[7762,7847,7828],
 [7762,7847,50075],[7762,38241,38205],[7762,38243,38205],
 [7762,38844,50075],[7762,39747,50075],[7763,7725,7828],
 [7763,7725,38205],[7763,7848,7828],[7763,38242,38205],
 [7766,7725,7828],[7766,7725,38205],[7766,7851,7828],
 [7766,38245,38205],[7767,7725,7828],[7767,7725,38205],
 [7767,7852,7828],[7767,7852,40914],[7767,38246,38205],
 [7767,38246,40914],[7857,7812,7828],[7857,7812,7875],
 [7857,7812,7950],[7857,7812,40055],[7857,7812,40642],
 [7857,7812,41411],[7857,7812,42936],[7857,7816,7828],
 [7857,7816,8032],[7857,7936,7950],[7857,7936,8032],
 [7857,7936,42566],[7857,7936,42986],[7857,40057,40055],
 [7857,40078,40055],[7857,40225,40642],[7857,40645,40642],
 [7857,41043,41411],[7857,41418,41411],[7857,42564,42936],
 [7857,42939,42936],[7861,7812,7828],[7861,7812,7875],
 [7861,7812,7950],[7861,7812,40055],[7861,7812,40642],
 [7861,7812,41411],[7861,7812,42936],[7861,7820,7828],
 [7861,7820,8168],[7861,7940,7950],[7861,7940,8168],
 [7861,7940,42704],[7861,7940,42984],[7861,40061,40055],
 [7861,40076,40055],[7861,40363,40642],[7861,40643,40642],
 [7861,41181,41411],[7861,41416,41411],[7861,42702,42936],
 [7861,42937,42936],[7867,7812,7828],[7867,7812,7875],
 [7867,7812,7950],[7867,7812,40055],[7867,7812,40642],
 [7867,7812,41411],[7867,7812,42936],[7867,7826,7828],
 [7867,40067,40055],[7867,40540,40642],[7867,41358,41411],
 [7867,42879,42936],[7880,7812,7828],[7880,7812,7875],
 [7880,7812,7950],[7880,7812,40055],[7880,7812,40642],
 [7880,7812,41411],[7880,7812,42936],[7880,7839,7828],
 [7880,40080,40055],[7880,40647,40642],[7880,41420,41411],
 [7880,42941,42936],[7883,7812,7828],[7883,7812,7875],
 [7883,7812,7950],[7883,7812,40055],[7883,7812,40642],
 [7883,7812,41411],[7883,7812,42936],[7883,7842,7828],
 [7883,40083,40055],[7883,40650,40642],[7883,41423,41411],
 [7883,42944,42936],[7887,7812,7828],[7887,7812,7875],
 [7887,7812,7950],[7887,7812,40055],[7887,7812,40642],
 [7887,7812,41411],[7887,7812,42936],[7887,7846,7828],
 [7887,40087,40055],[7887,40654,40642],[7887,41427,41411],
 [7887,42948,42936],[7889,7812,7828],[7889,7812,7875],
 [7889,7812,7950],[7889,7812,40055],[7889,7812,40642],
 [7889,7812,41411],[7889,7812,42936],[7889,7848,7828],
 [7889,40089,40055],[7889,40656,40642],[7889,41429,41411],
 [7889,42950,42936],[7892,7812,7828],[7892,7812,7875],
 [7892,7812,7950],[7892,7812,40055],[7892,7812,40642],
 [7892,7812,41411],[7892,7812,42936],[7892,7851,7828],
 [7892,40092,40055],[7892,40659,40642],[7892,41432,41411],
 [7892,42953,42936],[7897,7813,7828],[7897,7813,42193],
 [7897,7816,7828],[7897,7816,8032],[7897,7833,7828],
 [7897,7833,8507],[7897,7833,40707],[7897,7833,49887],
 [7897,40117,42362],[7897,40227,44394],[7897,41823,42193],
 [7897,41823,44394],[7897,42197,42193],[7897,42197,42362],
 [7897,42307,42362],[7897,44397,44394],[7906,7813,7828],
 [7906,7813,42193],[7906,7825,7828],[7906,7825,48796],
 [7906,7826,7828],[7906,40106,42109],[7906,40541,49217],
 [7906,42111,42109],[7906,42111,42193],[7906,42111,48796],
 [7906,42111,49217],[7916,7813,7828],[7916,7813,42193],
 [7916,7820,7828],[7916,7820,8168],[7916,41961,42193],
 [7916,42196,42193],[7919,7813,7828],[7919,7813,42193],
 [7919,7815,7828],[7919,7815,7996],[7919,7815,40196],
 [7919,7815,43643],[7919,41786,42193],[7919,42199,42193],
 [7920,7813,7828],[7920,7813,42193],[7920,7839,7828],
 [7920,42200,42193],[7921,7813,7828],[7921,7813,42193],
 [7921,7840,7828],[7921,7840,40824],[7921,40121,40824],
 [7921,40691,40824],[7921,42201,42193],[7921,42202,42193],
 [7923,7813,7828],[7923,7813,42193],[7923,7842,7828],
 [7923,7843,7828],[7923,7843,50046],[7923,40123,42449],
 [7923,40693,51006],[7923,42203,42193],[7923,42203,42449],
 [7923,42203,50046],[7923,42203,51006],[7925,7813,7828],
 [7925,7813,42193],[7925,7844,7828],[7925,7844,40870],
 [7925,40125,40870],[7925,40695,40870],[7925,42205,42193],
 [7925,42206,42193],[7927,7813,7828],[7927,7813,42193],
 [7927,7846,7828],[7927,42207,42193],[7928,7813,7828],
 [7928,7813,42193],[7928,7847,7828],[7928,7847,50075],
 [7928,7848,7828],[7928,40128,42494],[7928,40699,51050],
 [7928,42208,42193],[7928,42208,42494],[7928,42208,50075],
 [7928,42208,51050],[7932,7813,7828],[7932,7813,42193],
 [7932,7851,7828],[7932,42212,42193],[7933,7813,7828],
 [7933,7813,42193],[7933,7852,7828],[7933,7852,40914],
 [7933,40133,40914],[7933,40703,40914],[7933,42213,42193],
 [7933,42214,42193],[7935,42529,43685],[7935,42535,43104],
 [7935,42985,43104],[7935,43048,43104],[7935,43688,43685],
 [7935,43690,43685],[7993,7815,7828],[7993,7815,7996],
 [7993,7815,40196],[7993,7815,43643],[7993,7818,7828],
 [7993,7818,40287],[7993,7820,7828],[7993,7820,8168],
 [7993,40176,40287],[7993,40176,43330],[7993,40301,40287],
 [7993,40301,47266],[7993,43338,43330],[7993,43348,43330],
 [7993,43444,47266],[7993,47116,47266],[8013,7816,7828],
 [8013,7816,8032],[8013,7818,7828],[8013,7818,40287],
 [8013,40213,40287],[8013,40303,40287],[8017,7816,7828],
 [8017,7816,8032],[8017,7822,7828],[8017,7822,47575],
 [8017,44134,47575],[8017,47583,47575],[8020,7816,7828],
 [8020,7816,8032],[8020,7825,7828],[8020,7825,48796],
 [8020,44221,48796],[8020,48802,48796],[8047,7816,7828],
 [8047,7816,8032],[8047,7852,7828],[8047,7852,40914],
 [8047,40247,40914],[8047,40793,40914],[8056,7817,7828],
 [8056,7817,44904],[8056,7825,7828],[8056,7825,48796],
 [8056,44850,44904],[8056,44850,48796],[8057,7817,7828],
 [8057,7817,44904],[8057,7826,7828],[8057,44877,44904],
 [8070,7817,7828],[8070,7817,44904],[8070,7839,7828],
 [8070,44915,44904],[8071,7817,7828],[8071,7817,44904],
 [8071,7840,7828],[8071,7840,40824],[8071,40271,40824],
 [8071,40576,40824],[8071,44916,44904],[8071,44917,44904],
 [8073,7817,7828],[8073,7817,44904],[8073,7842,7828],
 [8073,44918,44904],[8074,7817,7828],[8074,7817,44904],
 [8074,7843,7828],[8074,7843,50046],[8074,44919,44904],
 [8074,44919,50046],[8075,7817,7828],[8075,7817,44904],
 [8075,7844,7828],[8075,7844,40870],[8075,40275,40870],
 [8075,40580,40870],[8075,44920,44904],[8075,44921,44904],
 [8077,7817,7828],[8077,7817,44904],[8077,7846,7828],
 [8077,44922,44904],[8078,7817,7828],[8078,7817,44904],
 [8078,7847,7828],[8078,7847,50075],[8078,44923,44904],
 [8078,44923,50075],[8079,7817,7828],[8079,7817,44904],
 [8079,7848,7828],[8079,44924,44904],[8082,7817,7828],
 [8082,7817,44904],[8082,7851,7828],[8082,44927,44904],
 [8083,7817,7828],[8083,7817,44904],[8083,7852,7828],
 [8083,7852,40914],[8083,40283,40914],[8083,40588,40914],
 [8083,44928,44904],[8083,44929,44904],[8091,7818,7828],
 [8091,7818,40287],[8091,7825,7828],[8091,7825,48796],
 [8091,40291,40287],[8091,40297,40287],[8091,45446,48796],
 [8091,47031,48796],[8092,7818,7828],[8092,7818,40287],
 [8092,7826,7828],[8092,40292,40287],[8105,7818,7828],
 [8105,7818,40287],[8105,7839,7828],[8105,7840,7828],
 [8105,7840,40824],[8105,40305,40287],[8105,40305,40824],
 [8105,40305,45745],[8105,40305,47331],[8105,45535,45745],
 [8105,47120,47331],[8108,7818,7828],[8108,7818,40287],
 [8108,7842,7828],[8108,40308,40287],[8109,7818,7828],
 [8109,7818,40287],[8109,7843,7828],[8109,7843,50046],
 [8109,40309,40287],[8109,40316,40287],[8109,45539,50046],
 [8109,47124,50046],[8110,7818,7828],[8110,7818,40287],
 [8110,7844,7828],[8110,7844,40870],[8110,7846,7828],
 [8110,40310,40287],[8110,40310,40870],[8110,40310,45806],
 [8110,40310,47399],[8110,45540,45806],[8110,47126,47399],
 [8113,7818,7828],[8113,7818,40287],[8113,7847,7828],
 [8113,7847,50075],[8113,40313,40287],[8113,40315,40287],
 [8113,45543,50075],[8113,47128,50075],[8114,7818,7828],
 [8114,7818,40287],[8114,7848,7828],[8114,40314,40287],
 [8117,7818,7828],[8117,7818,40287],[8117,7851,7828],
 [8117,7852,7828],[8117,7852,40914],[8117,40317,40287],
 [8117,40317,40914],[8117,40317,45847],[8117,40317,47433],
 [8117,45547,45847],[8117,47132,47433],[8122,7819,7828],
 [8122,7822,7828],[8122,7822,47575],[8122,45920,47575],
 [8123,7819,7828],[8123,7823,7828],[8123,7823,40450],
 [8123,40323,40450],[8156,7820,7828],[8156,7820,8168],
 [8156,7823,7828],[8156,7823,40450],[8156,40356,40450],
 [8156,40461,40450],[8173,7820,7828],[8173,7820,8168],
 [8173,7840,7828],[8173,7840,40824],[8173,40373,40824],
 [8173,40748,40824],[8176,7820,7828],[8176,7820,8168],
 [8176,7843,7828],[8176,7843,50046],[8176,46628,50046],
 [8176,49931,50046],[8221,7822,7828],[8221,7822,47575],
 [8221,7825,7828],[8221,7825,48796],[8221,47496,47575],
 [8221,47496,48796],[8222,7822,7828],[8222,7822,47575],
 [8222,7826,7828],[8222,47523,47575],[8234,7815,7828],
 [8234,7815,7996],[8234,7815,40196],[8234,7815,43643],
 [8234,7822,7828],[8234,7822,47575],[8234,43468,47575],
 [8234,47584,47575],[8235,7822,7828],[8235,7822,47575],
 [8235,7839,7828],[8235,47585,47575],[8236,7822,7828],
 [8236,7822,47575],[8236,7840,7828],[8236,7840,40824],
 [8236,40436,40824],[8236,40625,40824],[8236,47586,47575],
 [8236,47587,47575],[8238,7822,7828],[8238,7822,47575],
 [8238,7842,7828],[8238,47588,47575],[8239,7822,7828],
 [8239,7822,47575],[8239,7843,7828],[8239,7843,50046],
 [8239,47589,47575],[8239,47589,50046],[8240,7822,7828],
 [8240,7822,47575],[8240,7844,7828],[8240,7844,40870],
 [8240,40440,40870],[8240,40629,40870],[8240,47590,47575],
 [8240,47591,47575],[8242,7822,7828],[8242,7822,47575],
 [8242,7846,7828],[8242,47592,47575],[8243,7822,7828],
 [8243,7822,47575],[8243,7847,7828],[8243,7847,50075],
 [8243,47593,47575],[8243,47593,50075],[8244,7822,7828],
 [8244,7822,47575],[8244,7848,7828],[8244,47594,47575],
 [8247,7822,7828],[8247,7822,47575],[8247,7851,7828],
 [8247,47597,47575],[8248,7822,7828],[8248,7822,47575],
 [8248,7852,7828],[8248,7852,40914],[8248,40448,40914],
 [8248,40637,40914],[8248,47598,47575],[8248,47599,47575],
 [8251,7823,7828],[8251,7823,40450],[8251,7825,7828],
 [8251,7825,48796],[8251,40451,40450],[8251,40457,40450],
 [8251,47931,48796],[8251,48337,48796],[8252,7823,7828],
 [8252,7823,40450],[8252,7826,7828],[8252,40452,40450],
 [8265,7823,7828],[8265,7823,40450],[8265,7839,7828],
 [8265,40465,40450],[8266,7823,7828],[8266,7823,40450],
 [8266,7840,7828],[8266,7840,40824],[8266,40466,40450],
 [8266,40466,40824],[8268,7823,7828],[8268,7823,40450],
 [8268,7842,7828],[8268,40468,40450],[8269,7823,7828],
 [8269,7823,40450],[8269,7843,7828],[8269,7843,50046],
 [8269,40469,40450],[8269,40476,40450],[8269,48024,50046],
 [8269,48430,50046],[8270,7823,7828],[8270,7823,40450],
 [8270,7844,7828],[8270,7844,40870],[8270,40470,40450],
 [8270,40470,40870],[8272,7823,7828],[8272,7823,40450],
 [8272,7846,7828],[8272,40472,40450],[8273,7823,7828],
 [8273,7823,40450],[8273,7847,7828],[8273,7847,50075],
 [8273,40473,40450],[8273,40475,40450],[8273,48028,50075],
 [8273,48434,50075],[8274,7823,7828],[8274,7823,40450],
 [8274,7848,7828],[8274,40474,40450],[8277,7823,7828],
 [8277,7823,40450],[8277,7851,7828],[8277,40477,40450],
 [8278,7823,7828],[8278,7823,40450],[8278,7852,7828],
 [8278,7852,40914],[8278,40478,40450],[8278,40478,40914],
 [8325,7825,7828],[8325,7825,48796],[8325,7842,7828],
 [8325,48807,48796],[8331,7825,7828],[8331,7825,48796],
 [8331,7848,7828],[8331,48813,48796],[8353,7826,7828],
 [8353,7843,7828],[8353,7843,50046],[8353,49159,50046],
 [8357,7826,7828],[8357,7847,7828],[8357,7847,50075],
 [8357,49163,50075],[8614,7839,7828],[8614,7844,7828],
 [8614,7844,40870],[8614,40814,40870],[8622,7839,7828],
 [8622,7852,7828],[8622,7852,40914],[8622,40822,40914],
 [8629,7840,7828],[8629,7840,40824],[8629,7846,7828],
 [8629,40829,40824],[8634,7840,7828],[8634,7840,40824],
 [8634,7851,7828],[8634,40834,40824],[8653,7842,7828],
 [8653,7847,7828],[8653,7847,50075],[8653,50033,50075],
 [8664,7843,7828],[8664,7843,50046],[8664,7848,7828],
 [8664,50044,50046],[8676,7844,7828],[8676,7844,40870],
 [8676,7851,7828],[8676,40876,40870],[8692,7846,7828],
 [8692,7852,7828],[8692,7852,40914],[8692,40892,40914],
 [8743,8734,8715],[8743,8742,8715],[8743,9792,39424],
 [8743,11745,39424],[8743,13636,39424],[8868,9834,40287],
 [8868,15508,40287],[9000,8980,8962],[9000,8994,8962],
 [9000,9964,42936],[9000,19119,42936],[9000,22368,42936],
 [9224,9925,42193],[9224,25354,42193],[10821,11787,40287],
 [10821,15508,40287],[10879,10873,10854],[10879,10877,10854],
 [10879,11867,41850],[10879,17358,41850],[10879,19069,41850],
 [11122,11878,42193],[11122,23869,42193],[12785,12762,12747],
 [12785,12781,12747],[12785,13690,40642],[12785,17290,40642],
 [12785,22250,40642],[13876,13678,40287],[13876,40213,40287],
 [13881,13823,14523],[13881,13898,14523],[13881,14213,14523],
 [14047,13678,40287],[14047,40288,40287],[14054,13678,40287],
 [14054,40295,40287],[14058,13678,40287],[14058,40299,40287],
 [14064,12849,12821],[14064,12849,19010],[14064,12851,12828],
 [14064,12851,19278],[14064,13678,40287],[14064,13700,40824],
 [14064,13965,45745],[14064,14065,12831],[14064,14065,12850],
 [14064,14065,19376],[14064,18989,40287],[14064,19011,40824],
 [14064,19276,45745],[14064,19375,47331],[14064,40305,40287],
 [14064,40305,40824],[14064,40305,45745],[14064,40305,47331],
 [14070,13678,40287],[14070,13704,40870],[14070,13970,45806],
 [14070,40310,40287],[14070,40310,40870],[14070,40310,45806],
 [14070,40310,47399],[14076,13678,40287],[14076,13712,40914],
 [14076,13977,45847],[14076,40317,40287],[14076,40317,40914],
 [14076,40317,45847],[14076,40317,47433],[14179,14192,14565],
 [14179,14317,14565],[14179,14434,14565],[14207,14219,14565],
 [14207,14317,14565],[14207,14450,14565],[14323,13823,14523],
 [14323,14333,14523],[14323,14374,14523],[15563,15502,40055],
 [15563,40073,40055],[15564,15502,40055],[15564,40074,40055],
 [15568,15502,40055],[15568,40078,40055],[15600,15460,39193],
 [15600,39209,39193],[15607,15526,15517],[15607,15526,16062],
 [15607,15526,40572],[15607,16063,15517],[15607,16063,15527],
 [15607,16063,40573],[15607,40117,42362],[15607,42172,42362],
 [15714,15463,39313],[15714,39326,39313],[15785,15466,39424],
 [15785,39434,39424],[15789,15508,40287],[15789,40299,40287],
 [15792,15783,45501],[15792,45507,45501],[15793,15508,40287],
 [15793,40303,40287],[15826,15526,15517],[15826,15526,16062],
 [15826,15526,40572],[15826,15817,46064],[15826,40327,46064],
 [15826,46068,46064],[15859,15526,15517],[15859,15526,16062],
 [15859,15526,40572],[15891,15882,47090],[15891,47092,47090],
 [16084,6842,7828],[16084,7833,7828],[16084,7833,8507],
 [16084,7833,40707],[16084,7833,49887],[16088,6842,7828],
 [16088,6847,8032],[16088,7816,7828],[16088,7816,8032],
 [16111,15484,4761,5705],[16111,15484,4773,6152],
 [16111,15484,5700,5705],[16111,15484,5700,6152],
 [16111,15484,5705],[16111,15484,6152],[16111,15484,15470],
 [16111,15484,15913],[16111,15484,16062],[16135,15520,40642],
 [16135,40645,40642],[16185,15534,40870],[16185,40695,40870],
 [16193,15542,40914],[16193,40703,40914],[16213,15542,40914],
 [16213,40723,40914],[16284,15542,40914],[16284,40793,40914],
 [16489,17278,40287],[16489,20642,40287],[16613,17369,42193],
 [16613,23869,42193],[19343,19136,19857],[19343,19349,19857],
 [19343,19786,19857],[19429,19080,42193],[19429,42054,42193],
 [19437,19317,19862],[19437,19443,19862],[19437,19800,19862],
 [19458,19080,42193],[19458,42083,42193],[19512,12836,12838],
 [19512,12836,14198],[19512,12841,12823],[19512,12841,13772],
 [19512,13766,42109],[19512,13769,42193],[19512,14171,48796],
 [19512,14201,49217],[19512,19077,42109],[19512,19080,42193],
 [19512,19482,48796],[19512,19486,12835],[19512,19486,12842],
 [19512,19486,14175],[19512,42111,42109],[19512,42111,42193],
 [19512,42111,48796],[19512,42111,49217],[19657,19080,42193],
 [19657,42196,42193],[19660,19080,42193],[19660,42199,42193],
 [19664,19080,42193],[19664,19094,42449],[19664,19575,50046],
 [19664,42203,42193],[19664,42203,42449],[19664,42203,50046],
 [19664,42203,51006],[19670,19080,42193],[19670,19099,42494],
 [19670,19579,50075],[19670,42208,42193],[19670,42208,42494],
 [19670,42208,50075],[19670,42208,51050],[19910,20642,40287],
 [19910,22238,40287],[20612,5696,5705],[20612,5696,6018],
 [20612,5696,6050],[20612,5696,39424],[20612,5696,39779],
 [20612,5696,45501],[20612,5696,46064],[20612,20600,39424],
 [20612,20917,45501],[20661,20654,40642],[20661,40645,40642],
 [20702,20693,41411],[20702,41418,41411],[20727,20912,20557],
 [20727,20912,20561],[20727,20912,38524],[20738,20722,41850],
 [20738,41864,41850],[20777,20761,42593],[20777,42605,42593],
 [20814,20800,43330],[20814,43342,43330],[20819,20812,43685],
 [20819,43689,43685],[20847,20693,41411],[20847,41043,41411],
 [20851,20682,41069],[20851,20697,20682,41069],
 [20851,20697,20922],[20851,20697,41069],
 [20851,20697,41083,41069],[20851,20698,20682,41069],
 [20851,20698,20888],[20851,20698,41069],
 [20851,20698,41084,41069],[20851,20836,20681],
 [20851,20836,20682,41069],[20851,20836,41032,41069],
 [20851,20836,41069],[20851,41032,41069],[20851,41047,44394],
 [20851,41083,41069],[20851,41084,41069],[20851,43973,44394],
 [20851,44008,44394],[20855,20636,40055],
 [20855,20640,20636,40055],[20855,20640,20681],
 [20855,20640,40055],[20855,20640,40057,40055],
 [20855,20780,43104],[20855,40057,40055],[20855,40077,40055],
 [20855,40077,43104],[20855,42572,43104],[20927,20917,45501],
 [20927,45508,45501],[20946,20558,38557],[20946,38558,38557],
 [20951,5696,5705],[20951,5696,6018],[20951,5696,6050],
 [20951,5696,39424],[20951,5696,39779],[20951,5696,45501],
 [20951,5696,46064],[20951,20600,39424],[20951,20917,45501],
 [21052,20571,38921],[21052,20912,20557],[21052,20912,20561],
 [21052,20912,38524],[21052,38534,38921],[21052,38664,38921],
 [21053,20572,2792,3507],[21053,20572,2812,4193],
 [21053,20572,3507],[21053,20572,3519,3507],
 [21053,20572,3519,4193],[21053,20572,4193],
 [21053,20572,20568],[21053,20572,20884],[21053,20572,20888],
 [21057,20576,39015],[21057,38669,39015],[21057,38881,39015],
 [21221,7019,7828],[21221,7833,7828],[21221,7833,8507],
 [21221,7833,40707],[21221,7833,49887],[21268,20654,40642],
 [21268,40644,40642],[21311,20642,40287],
 [21311,20656,20642,40287],[21311,20656,20922],
 [21311,20656,40287],[21311,20656,40298,40287],
 [21311,20926,20642,40287],[21311,20926,20660],
 [21311,20926,40287],[21311,20926,40302,40287],
 [21311,40298,40287],[21311,40302,40287],[21319,20934,45806],
 [21319,45630,45806],[21326,20941,45847],[21326,45637,45847],
 [21330,20657,20641],[21330,20657,20888],[21330,20657,40264],
 [21393,20668,40870],[21393,40769,40870],[21628,22329,42193],
 [21628,25354,42193],[23780,7132,7828],[23780,7141,8168],
 [23780,7820,7828],[23780,7820,8168],[23798,7132,7828],
 [23798,7815,7828],[23798,7815,7996],[23798,7815,40196],
 [23798,7815,43643],[23821,23829,41411],[23821,41181,41411],
 [23822,23829,41411],[23822,41213,41411],[23839,23829,41411],
 [23839,41419,41411],[23856,23688,38331],[23856,38332,38331],
 [23861,23869,42193],[23861,41961,42193],[23865,23858,41850],
 [23865,41855,41850],[23879,23869,42193],[23879,42199,42193],
 [23897,23908,42936],[23897,24018,44904],[23897,42599,42593],
 [23897,42599,42936],[23897,42599,44904],[23897,42599,47090],
 [23900,23908,42936],[23900,42702,42936],[23936,23695,23703],
 [23936,23695,24121],[23936,23695,38597],[23936,23946,23690],
 [23936,23946,23703],[23936,23946,38422],[23936,38412,43330],
 [23936,43338,43330],[23937,23694,38557],[23937,23946,23690],
 [23937,23946,23703],[23937,23946,38422],[23937,38413,38557],
 [23937,38564,38557],[23942,23935,2905,3507],
 [23942,23935,2911,3756],[23942,23935,3505,3507],
 [23942,23935,3505,3756],[23942,23935,3507],
 [23942,23935,3756],[23942,23935,23690],[23942,23935,23698],
 [23942,23935,24014],[23950,23707,38921],[23950,38426,38921],
 [23955,23946,23690],[23955,23946,23703],[23955,23946,38422],
 [24050,23818,41069],[24050,41075,41069],[24143,24364,50046],
 [24143,46628,50046],[24168,24364,50046],[24168,47124,50046],
 [24172,24368,50075],[24172,47128,50075],[24250,24026,45084],
 [24250,44830,45084],[24559,24364,50046],[24559,49979,50046],
 [25179,3503,3507],[25179,3503,3677],[25179,3503,3714],
 [25179,3503,38331],[25179,3503,38557],[25179,3503,41850],
 [25179,3503,42593],[25179,25173,38331],[25179,25343,41850],
 [25180,25173,38331],[25180,38337,38331],[25260,7187,7828],
 [25260,7815,7828],[25260,7815,7996],[25260,7815,40196],
 [25260,7815,43643],[25265,25257,40055],[25265,40061,40055],
 [25280,25257,40055],[25280,40076,40055],[25380,25393,42936],
 [25380,42527,42936],[25382,3503,3507],[25382,3503,3677],
 [25382,3503,3714],[25382,3503,38331],[25382,3503,38557],
 [25382,3503,41850],[25382,3503,42593],[25382,25173,38331],
 [25382,25179,3503,3507],[25382,25179,3503,3677],
 [25382,25179,3503,3714],[25382,25179,3503,38331],
 [25382,25179,3503,38557],[25382,25179,3503,41850],
 [25382,25179,3503,42593],[25382,25179,25173,38331],
 [25382,25179,25343,41850],[25382,25179,25347],
 [25382,25179,38557],[25382,25343,41850],
 [25424,25341,25354,42193],[25424,25341,25431],
 [25424,25341,41786,42193],[25424,25341,42193],
 [25424,25354,42193],[25424,25638,25347],
 [25424,25638,25354,42193],[25424,25638,41993,42193],
 [25424,25638,42193],[25424,41786,42193],[25424,41993,42193],
 [25438,25314,41411],[25438,25433,43685],
 [25438,25841,25314,41411],[25438,25841,25321],
 [25438,25841,41411],[25438,25841,41416,41411],
 [25438,41006,41411],[25438,41006,43685],[25438,41416,41411],
 [25438,43687,43685],[25450,25853,50075],[25450,43652,50075],
 [25478,25844,25231],[25478,25844,25241],[25478,25844,39738],
 [25534,25349,25353],[25534,25349,25698],[25534,25349,42053],
 [25549,25221,39424],[25549,39443,39424],[25568,25572,46064],
 [25568,45949,46064],[25601,25605,46593],[25601,42701,46593],
 [25601,46477,46593],[25606,25393,42936],[25606,42702,42936],
 [25614,25401,43104],[25614,42710,43104],[25633,25349,25353],
 [25633,25349,25698],[25633,25349,42053],[25633,25637,47090],
 [25633,41992,47090],[25633,46973,47090],[25645,25215,39193],
 [25645,25224,25215,39193],[25645,25224,25347],
 [25645,25224,39193],[25645,25224,39201,39193],
 [25645,25238,25215,39193],[25645,25238,25321],
 [25645,25238,39193],[25645,25238,39215,39193],
 [25645,25324,25215,39193],[25645,25324,25241],
 [25645,25324,39193],[25645,25324,39218,39193],
 [25645,39201,39193],[25645,39215,39193],[25645,39218,39193],
 [25645,39539,47266],[25645,41220,47266],[25645,42000,47266],
 [25646,25362,42362],[25646,42001,42362],[25652,25368,42449],
 [25652,42007,42449],[25657,25373,42494],[25657,42012,42494],
 [25709,25819,5106,5705],[25709,25819,5120,6213],
 [25709,25819,5702,5705],[25709,25819,5702,6213],
 [25709,25819,5705],[25709,25819,6213],[25709,25819,25227],
 [25709,25819,25241],[25709,25819,25727],[25891,25233,39779],
 [25891,39785,39779],[40372,40377,40870],[40372,40814,40870],
 [40747,40752,40870],[40747,40814,40870],[42216,42227,42449],
 [42216,42272,42449],[42263,42277,42494],[42263,42318,42494],
 [43449,43454,47399],[43449,47348,47399],[44248,44318,50075],
 [44248,49163,50075],[45431,45441,45847],[45431,45781,45847],
 [45732,45735,45806],[45732,45774,45806],[46986,46997,47433],
 [46986,47354,47433],[47500,47678,51006],[47500,48897,51006],
 [48891,48903,51050],[48891,50923,51050],[49153,49163,50075],
 [49153,49968,50075]];

#############################################################################
##
#E  chains.g . . . . . . . . . . . . . . . . . . . . . . . . . . .  ends here
