/*
 * Decompiled with CFR 0.152.
 */
package javajs.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javajs.util.SB;

class PDFObject
extends SB {
    private Map<String, Object> dictionary;
    private byte[] stream;
    private int index;
    String type;
    int len;
    int pt;

    PDFObject(int n) {
        this.index = n;
    }

    String getRef() {
        return String.valueOf(this.index) + " 0 R";
    }

    String getID() {
        return String.valueOf(this.type.substring(0, 1)) + this.index;
    }

    boolean isFont() {
        return "Font".equals(this.type);
    }

    void setStream(byte[] byArray) {
        this.stream = byArray;
    }

    Object getDef(String string) {
        return this.dictionary.get(string);
    }

    void addDef(String string, Object object) {
        if (this.dictionary == null) {
            this.dictionary = new Hashtable<String, Object>();
        }
        this.dictionary.put(string, object);
        if (string.equals("Type")) {
            this.type = ((String)object).substring(1);
        }
    }

    void setAsStream() {
        this.stream = this.toBytes(0, -1);
        this.setLength(0);
    }

    int output(OutputStream outputStream) throws IOException {
        if (this.index > 0) {
            String string = String.valueOf(this.index) + " 0 obj\n";
            this.write(outputStream, string.getBytes(), 0);
        }
        int n = 0;
        if (this.dictionary != null) {
            if (this.dictionary.containsKey("Length")) {
                boolean bl;
                if (this.stream == null) {
                    this.setAsStream();
                }
                boolean bl2 = bl = (n = this.stream.length) > 1000;
                if (bl) {
                    Deflater deflater = new Deflater(9);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                    deflaterOutputStream.write(this.stream, 0, n);
                    deflaterOutputStream.finish();
                    this.stream = byteArrayOutputStream.toByteArray();
                    this.dictionary.put("Filter", "/FlateDecode");
                    n = this.stream.length;
                }
                this.dictionary.put("Length", "" + n);
            }
            this.write(outputStream, this.getDictionaryText(this.dictionary, "\n").getBytes(), 0);
        }
        if (this.length() > 0) {
            this.write(outputStream, this.toString().getBytes(), 0);
        }
        if (this.stream != null) {
            this.write(outputStream, "stream\r\n".getBytes(), 0);
            this.write(outputStream, this.stream, n);
            this.write(outputStream, "\r\nendstream\r\n".getBytes(), 0);
        }
        if (this.index > 0) {
            this.write(outputStream, "endobj\n".getBytes(), 0);
        }
        return this.len;
    }

    private void write(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        if (n == 0) {
            n = byArray.length;
        }
        this.len += n;
        outputStream.write(byArray, 0, n);
    }

    private String getDictionaryText(Map<String, Object> map, String string) {
        SB sB = new SB();
        sB.append("<<");
        if (map.containsKey("Type")) {
            sB.append("/Type").appendO(map.get("Type"));
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2.equals("Type") || string2.startsWith("!")) continue;
            sB.append("/" + string2);
            Object object = entry.getValue();
            if (object instanceof Map) {
                sB.append(this.getDictionaryText((Map)object, ""));
                continue;
            }
            string2 = (String)entry.getValue();
            if (!string2.startsWith("/")) {
                sB.append(" ");
            }
            sB.appendO(string2);
        }
        return sB.length() > 3 ? sB.append(">>").append(string).toString() : "";
    }

    private Map<String, Object> createSubdict(Map<String, Object> map, String string) {
        Hashtable hashtable = (Hashtable)map.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable();
            map.put(string, hashtable);
        }
        return hashtable;
    }

    void addResource(String string, String string2, String string3) {
        Map<String, Object> map = this.createSubdict(this.dictionary, "Resources");
        if (string != null) {
            map = this.createSubdict(map, string);
        }
        map.put(string2, string3);
    }
}

