/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jspecview.application.MainFrame;
import jspecview.common.JSVersion;
import org.jmol.api.JSVInterface;
import org.jmol.util.Logger;

public class JSpecView
implements JSVInterface {
    private MainFrame mainFrame;
    private static String propertiesFileName = "jspecview.properties";

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("JSpecView Application " + JSVersion.VERSION);
        JSpecView jSpecView = new JSpecView();
        jSpecView.mainFrame = new MainFrame(null, jSpecView);
        if (stringArray.length > 0) {
            if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("-script")) {
                jSpecView.mainFrame.runScriptNow(stringArray[1]);
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    System.out.println("JSpecView is attempting to open " + stringArray[n]);
                    jSpecView.mainFrame.vwr.openFile(stringArray[n], false);
                    ++n;
                }
            }
        }
        jSpecView.mainFrame.setVisible(true);
    }

    @Override
    public void runScript(String string) {
        this.mainFrame.runScriptNow(string);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFileName);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFileName);
            properties.store(fileOutputStream, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean bl, Object object) {
        if (bl && JOptionPane.showConfirmDialog((Component)object, "Exit JSpecView?", "Exit", 0, 3) != 0) {
            return;
        }
        System.exit(0);
    }

    @Override
    public void syncToJmol(String string) {
    }
}

