/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class NWChemReader
extends MOReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;
    private Lst<String> atomTypes;
    private Map<String, Lst<String>> htMOs = new Hashtable<String, Lst<String>>();
    int nBasisFunctions;
    private static String DS_LIST = "d2-   d1-   d0    d1+   d2+";
    private static String FS_LIST = "f3-   f2-   f1-   f0    f1+   f2+   f3+";
    private static String DC_LIST = "DXX   DXY   DXZ   DYY   DYZ   DZZ";
    private static String FC_LIST = "XXX   XXY   XXZ   XYY   XYZ   XZZ   YYY   YYZ   YZZ   ZZZ";
    int moCount;
    private boolean purging;

    @Override
    protected void initializeReader() {
        this.calculationType = "(NWCHEM)";
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.trim().startsWith("NWChem")) {
            boolean bl = this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
            if (this.inInput) {
                this.checkMOs();
            }
        }
        if (this.line.startsWith("          Step")) {
            this.init();
            return true;
        }
        if (this.line.indexOf("  wavefunction    = ") >= 0) {
            this.calculationType = this.line.substring(this.line.indexOf("=") + 1).trim() + "(NWCHEM)";
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("Total") >= 0) {
            this.readTotal();
            return true;
        }
        if (this.line.indexOf("@") >= 0) {
            this.readAtSign();
            return true;
        }
        if (this.line.startsWith(" Task  times")) {
            this.init();
            ++this.taskNumber;
            return true;
        }
        if (this.line.startsWith("      Optimization converged")) {
            this.converged = true;
            return true;
        }
        if (this.line.startsWith("      Symmetry information")) {
            this.readSymmetry();
            return true;
        }
        if (this.line.indexOf("Output coordinates in ") >= 0) {
            String thisLine = this.line;
            if (!this.htMOs.isEmpty()) {
                this.checkMOs();
            }
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            this.readAtoms(thisLine);
            return true;
        }
        if (this.line.indexOf("Vibrational analysis") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith("  Mulliken analysis of the total density")) {
            if (this.equivalentAtomSets != 0) {
                this.readPartialCharges();
            }
            return true;
        }
        if (this.line.contains("Basis \"ao basis\"") && this.doReadMolecularOrbitals) {
            return this.readBasis();
        }
        if (this.line.contains("Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets != 0) {
                this.readMOs();
            }
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.checkMOs();
        this.finalizeReaderASCR();
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String key, String value, int nAtomSets) {
        this.energyKey = key;
        this.energyValue = value;
        this.setProps(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.setNames(this.energyKey + " = " + this.energyValue, null, this.equivalentAtomSets);
        this.asc.setAtomSetEnergy(value, this.parseFloatStr(value));
        this.haveEnergy = true;
    }

    private void setEnergy(String key, String value) {
        this.energyKey = key;
        this.energyValue = value;
        this.asc.setAtomSetModelProperty(this.energyKey, this.energyValue);
        this.asc.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        String[] tokens = PT.getTokens(this.readLines(3));
        this.setProps("Symmetry group name", tokens[tokens.length - 1], this.equivalentAtomSets);
    }

    private void readTotal() {
        String[] tokens = this.getTokens();
        try {
            if (tokens[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + tokens[1] + ")", tokens[tokens.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S' && this.readLines(2) == null) {
            return;
        }
        String[] tokens = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", tokens[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.setProps("Step", tokens[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void setProps(String key, String value, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            this.asc.setAtomSetModelPropertyForSet(key, value, i);
        }
    }

    private void setNames(String atomSetName, BS namedSets, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            if (namedSets != null && namedSets.get(i)) continue;
            this.asc.setModelInfoForSet("name", atomSetName, i);
        }
    }

    private void readAtoms(String thisLine) throws Exception {
        String[] tokens;
        float scale = thisLine.indexOf("angstroms") < 0 ? 0.5291772f : 1.0f;
        this.readLines(3);
        this.haveEnergy = false;
        this.asc.newAtomSet();
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        this.atomTypes = new Lst();
        while (this.rd() != null && this.line.length() > 0 && (tokens = this.getTokens()).length >= 6) {
            String name;
            this.setAtomCoordScaled(null, (String[])tokens, (int)3, (float)scale).atomName = name = this.fixTag(tokens[1]);
            this.atomTypes.addLast(name);
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.asc.setAtomSetModelProperty("Step", "converged");
        } else if (this.inInput) {
            this.asc.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        String[] tokens;
        Properties p;
        this.readLines(3);
        this.asc.newAtomSet();
        if (this.equivalentAtomSets > 1 && (p = (Properties)this.asc.getAtomSetAuxiliaryInfoValue(this.asc.iSet - 1, "modelProperties")) != null) {
            this.asc.setCurrentModelInfo("modelProperties", p.clone());
        }
        this.asc.setAtomSetModelProperty("vector", "gradient");
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        float f = 0.5291772f;
        while (this.rd() != null && this.line.length() > 0 && (tokens = this.getTokens()).length >= 8) {
            Atom atom = this.setAtomCoordScaled(null, tokens, 2, f);
            atom.atomName = this.fixTag(tokens[1]);
            this.asc.addVibrationVector(atom.index, -this.parseFloatStr(tokens[5]), -this.parseFloatStr(tokens[6]), -this.parseFloatStr(tokens[7]));
        }
    }

    private void readFrequencies() throws Exception {
        String[] tokens;
        int firstFrequencyAtomSetIndex = this.asc.atomSetCount;
        int firstVibrationNumber = this.vibrationNumber;
        String path = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.readLines(2);
        this.asc.newAtomSet();
        while (this.rd() != null && this.line.indexOf("---") < 0) {
            tokens = this.getTokens();
            this.setAtomCoordScaled(null, (String[])tokens, (int)2, (float)0.5291772f).atomName = this.fixTag(tokens[0]);
        }
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.readLines(3);
        boolean firstTime = true;
        BS bsIgnore = new BS();
        while (this.rd() != null && this.line.indexOf("P.Frequency") >= 0) {
            tokens = PT.getTokensAt(this.line, 12);
            int frequencyCount = tokens.length;
            int iAtom0 = this.asc.ac;
            int ac = this.asc.getLastAtomSetAtomCount();
            if (firstTime) {
                iAtom0 -= ac;
            }
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = tokens[i].equals("0.00") || !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) {
                    bsIgnore.set(this.vibrationNumber);
                    continue;
                }
                if (!firstTime) {
                    this.asc.cloneLastAtomSet();
                }
                firstTime = false;
                this.asc.setAtomSetFrequency(this.vibrationNumber, path, null, tokens[i], null);
            }
            this.readLines(1);
            this.fillFrequencyData(iAtom0, ac, ac, ignore, false, 0, 0, null, 0, null);
            this.readLines(3);
        }
        try {
            this.discardLinesUntilContains("Infra Red Intensities");
            this.readLines(2);
            int idx = firstFrequencyAtomSetIndex;
            for (int i = firstVibrationNumber; i < this.vibrationNumber; ++i) {
                if (this.rd() == null) {
                    return;
                }
                if (bsIgnore.get(i)) continue;
                tokens = this.getTokens();
                int iset = this.asc.iSet;
                this.asc.iSet = idx++;
                this.asc.setAtomSetModelProperty("IRIntensity", tokens[3] + " au");
                this.asc.iSet = iset;
            }
        }
        catch (Exception e) {
            System.out.println("nwchem infra red issue" + e);
        }
    }

    void readPartialCharges() throws Exception {
        this.readLines(4);
        int ac = this.asc.ac;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atoms = this.asc.atoms;
        for (int i = i0; i < ac; ++i) {
            String[] tokens;
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            do {
                if (this.rd() != null && this.line.length() >= 3) continue;
                return;
            } while ((tokens = this.getTokens())[0].indexOf(".") >= 0);
            atoms[i].partialCharge = (float)this.parseIntStr(tokens[2]) - this.parseFloatStr(tokens[3]);
        }
    }

    private String fixTag(String tag) {
        if (tag.equalsIgnoreCase("bq")) {
            return "X";
        }
        if (tag.toLowerCase().startsWith("bq")) {
            tag = tag.substring(2) + "-Bq";
        }
        return "" + Character.toUpperCase(tag.charAt(0)) + (tag.length() == 1 ? "" : "" + Character.toLowerCase(tag.charAt(1)));
    }

    private boolean readBasis() throws Exception {
        int i;
        boolean isD6F10;
        this.gaussianCount = 0;
        this.shellCount = 0;
        this.nBasisFunctions = 0;
        boolean bl = isD6F10 = this.line.indexOf("cartesian") >= 0;
        if (isD6F10) {
            this.getDFMap("DC", DC_LIST, 4, "DXX   DYY   DZZ   DXY   DXZ   DYZ", 3);
            this.getDFMap("FC", FC_LIST, 6, "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", 3);
        } else {
            this.getDFMap("DS", DS_LIST, 3, "d0    d1+   d1-   d2+   d2-", 2);
            this.getDFMap("FS", FS_LIST, 5, "f0    f1+   f1-   f2+   f2-   f3+   f3-", 2);
        }
        this.shells = new Lst();
        Hashtable atomInfo = new Hashtable();
        String atomSym = null;
        Lst<Lst> atomData = null;
        Lst shellData = null;
        while (this.line != null) {
            int nBlankLines = 0;
            while (this.line.length() < 3 || this.line.charAt(2) == ' ') {
                shellData = new Lst();
                this.rd();
                if (this.line.length() >= 3) continue;
                ++nBlankLines;
            }
            if (nBlankLines >= 2) break;
            if (this.parseIntStr(this.line) == Integer.MIN_VALUE) {
                atomSym = this.getTokens()[0];
                if (atomSym.length() > 2) {
                    atomSym = JmolAdapter.getElementSymbol(Elements.elementNumberFromName(atomSym));
                }
                atomData = new Lst<Lst>();
                atomInfo.put(atomSym, atomData);
                this.rd();
                this.rd();
                continue;
            }
            while (this.line != null && this.line.length() > 3) {
                String[] tokens = this.getTokens();
                Object[] o = new Object[]{tokens[1], new float[]{this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3])}};
                shellData.addLast(o);
                this.rd();
            }
            atomData.addLast(shellData);
        }
        int nD = isD6F10 ? 6 : 5;
        int nF = isD6F10 ? 10 : 7;
        Lst<float[]> gdata = new Lst<float[]>();
        for (i = 0; i < this.atomTypes.size(); ++i) {
            atomData = (Lst<Lst>)atomInfo.get(this.atomTypes.get(i));
            int nShells = atomData.size();
            for (int ishell = 0; ishell < nShells; ++ishell) {
                ++this.shellCount;
                shellData = (Lst)atomData.get(ishell);
                int nGaussians = shellData.size();
                String type = (String)((Object[])shellData.get(0))[0];
                switch (type.charAt(0)) {
                    case 'S': {
                        ++this.nBasisFunctions;
                        break;
                    }
                    case 'P': {
                        this.nBasisFunctions += 3;
                        break;
                    }
                    case 'D': {
                        this.nBasisFunctions += nD;
                        break;
                    }
                    case 'F': {
                        this.nBasisFunctions += nF;
                    }
                }
                int[] slater = new int[]{i + 1, isD6F10 ? BasisFunctionReader.getQuantumShellTagID(type) : BasisFunctionReader.getQuantumShellTagIDSpherical(type), this.gaussianCount + 1, nGaussians};
                this.shells.addLast(slater);
                for (int ifunc = 0; ifunc < nGaussians; ++ifunc) {
                    gdata.addLast((float[])((Object[])shellData.get(ifunc))[1]);
                }
                this.gaussianCount += nGaussians;
            }
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (i = 0; i < this.gaussianCount; ++i) {
            this.gaussians[i] = (float[])gdata.get(i);
        }
        Logger.info(this.gaussianCount + " Gaussians read");
        return true;
    }

    private boolean readMOs() throws Exception {
        Lst<String> lines = new Lst<String>();
        this.htMOs.put(this.line, lines);
        lines.addLast(this.line);
        int nblank = 0;
        while (nblank != 2 && this.rd() != null) {
            lines.addLast(this.line);
            if (this.line.length() < 2) {
                ++nblank;
                continue;
            }
            nblank = 0;
        }
        return true;
    }

    private void checkMOs() throws Exception {
        if (this.shells == null) {
            return;
        }
        block0: for (Map.Entry<String, Lst<String>> entry : this.htMOs.entrySet()) {
            this.line = entry.getKey();
            this.alphaBeta = this.line.substring(0, this.line.indexOf("Final")).trim() + " ";
            int moCount = 0;
            if (!this.filterMO()) continue;
            Lst<String> list = entry.getValue();
            int n = list.size();
            Logger.info(this.line);
            for (int i = 3; i < n; ++i) {
                while (i < n && ((this.line = (String)list.get(i)).length() < 2 || this.line.charAt(1) != 'V')) {
                    ++i;
                }
                if (i == n) continue block0;
                this.line = this.line.replace('=', ' ');
                String[] tokens = this.getTokens();
                float occupancy = this.parseFloatStr(tokens[3]);
                float energy = this.parseFloatStr(tokens[5]);
                String symmetry = tokens.length > 7 ? tokens[7] : null;
                Hashtable<String, Object> mo = new Hashtable<String, Object>();
                mo.put("occupancy", Float.valueOf(occupancy));
                mo.put("energy", Float.valueOf(energy));
                if (symmetry != null) {
                    mo.put("symmetry", symmetry);
                }
                float[] coefs = null;
                this.setMO(mo);
                mo.put("type", this.alphaBeta + ++moCount);
                coefs = new float[this.nBasisFunctions];
                mo.put("coefficients", coefs);
                i += 3;
                while ((this.line = (String)list.get(++i)) != null && this.line.length() > 3) {
                    tokens = this.getTokens();
                    coefs[this.parseIntStr((String)tokens[0]) - 1] = this.parseFloatStr(tokens[1]);
                    int pt = tokens.length / 2;
                    if (pt != 5 && pt != 6) continue;
                    coefs[this.parseIntStr((String)tokens[pt]) - 1] = this.parseFloatStr(tokens[pt + 1]);
                }
            }
        }
        this.energyUnits = "a.u.";
        this.setMOData(true);
        this.htMOs.clear();
    }

    @Override
    public String rd() throws Exception {
        this.RL();
        if (!this.purging && this.line != null && this.line.startsWith("--")) {
            this.purging = true;
            this.discardLinesUntilStartsWith("*");
            this.rd();
            this.purging = false;
            this.RL();
        }
        return this.line;
    }
}

