/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.PT;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.SimpleUnitCell;

class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String sgName;
    SymmetryOperation[] symmetryOperations;
    String infoStr;
    int[] cellRange;
    String latticeType = "P";
    public String intlTableNo;

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(Map<String, Object> info, float[] unitCellParams) {
        this.cellRange = (int[])info.get("unitCellRange");
        this.sgName = (String)info.get("spaceGroup");
        if (this.sgName == null || this.sgName == "") {
            this.sgName = "spacegroup unspecified";
        }
        this.infoStr = "Spacegroup: " + this.sgName;
        this.latticeType = (String)info.get("latticeType");
        if (this.latticeType == null) {
            this.latticeType = "P";
        }
        this.intlTableNo = (String)info.get("intlTableNo");
        int symmetryCount = info.containsKey("symmetryCount") ? (Integer)info.get("symmetryCount") : 0;
        this.symmetryOperations = (SymmetryOperation[])info.remove("symmetryOps");
        if (this.symmetryOperations != null) {
            String c = "";
            String s = "\nNumber of symmetry operations: " + (symmetryCount == 0 ? 1 : symmetryCount) + "\nSymmetry Operations:";
            for (int i = 0; i < symmetryCount; ++i) {
                SymmetryOperation op = this.symmetryOperations[i];
                s = s + "\n" + op.fixMagneticXYZ(op, op.xyz, true);
                if (!op.isCenteringOp) continue;
                c = c + " (" + PT.rep(PT.replaceAllCharacters(op.xyz, "xyz", "0"), "0+", "") + ")";
            }
            if (c.length() > 0) {
                this.infoStr = this.infoStr + "\nCentering: " + c;
            }
            this.infoStr = this.infoStr + s;
            this.infoStr = this.infoStr + "\n";
        }
        if (unitCellParams == null) {
            unitCellParams = (float[])info.get("unitCellParams");
        }
        if (!SimpleUnitCell.isValid(unitCellParams)) {
            return null;
        }
        this.coordinatesAreFractional = info.containsKey("coordinatesAreFractional") ? (Boolean)info.get("coordinatesAreFractional") : false;
        this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        return unitCellParams;
    }
}

