/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Map;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;

class Bridge {
    Atom a;
    Atom b;
    int[][] ladder;
    boolean isAntiparallel;

    Bridge(Atom a, Atom b, Map<int[][], Boolean> htLadders) {
        this.a = a;
        this.b = b;
        this.ladder = new int[2][2];
        int n = Math.min(a.i, b.i);
        this.ladder[0][1] = n;
        this.ladder[0][0] = n;
        int n2 = Math.max(a.i, b.i);
        this.ladder[1][1] = n2;
        this.ladder[1][0] = n2;
        this.addLadder(htLadders);
    }

    boolean addBridge(Bridge bridge, Map<int[][], Boolean> htLadders) {
        if (bridge.isAntiparallel != this.isAntiparallel || !this.canAdd(bridge) || !bridge.canAdd(this)) {
            return false;
        }
        this.extendLadder(bridge.ladder[0][0], bridge.ladder[1][0]);
        this.extendLadder(bridge.ladder[0][1], bridge.ladder[1][1]);
        bridge.ladder = this.ladder;
        if (bridge.ladder != this.ladder) {
            htLadders.remove(bridge.ladder);
            this.addLadder(htLadders);
        }
        return true;
    }

    private void addLadder(Map<int[][], Boolean> htLadders) {
        htLadders.put(this.ladder, this.isAntiparallel ? Boolean.TRUE : Boolean.FALSE);
    }

    private boolean canAdd(Bridge bridge) {
        int index1 = bridge.a.i;
        int index2 = bridge.b.i;
        return this.isAntiparallel ? index1 >= this.ladder[0][1] && index2 <= this.ladder[1][0] || index1 <= this.ladder[0][0] && index2 >= this.ladder[1][1] : index1 <= this.ladder[0][0] && index2 <= this.ladder[1][0] || index1 >= this.ladder[0][1] && index2 >= this.ladder[1][1];
    }

    private void extendLadder(int index1, int index2) {
        if (this.ladder[0][0] > index1) {
            this.ladder[0][0] = index1;
        }
        if (this.ladder[0][1] < index1) {
            this.ladder[0][1] = index1;
        }
        if (this.ladder[1][0] > index2) {
            this.ladder[1][0] = index2;
        }
        if (this.ladder[1][1] < index2) {
            this.ladder[1][1] = index2;
        }
    }

    public String toString() {
        return (this.isAntiparallel ? "a " : "p ") + this.a + " - " + this.b + "\t" + Escape.e(this.ladder);
    }
}

