/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;

public class SmilesMeasure {
    SmilesSearch search;
    int nPoints;
    int type;
    int index;
    boolean isNot;
    private int[] indices = new int[4];
    static final String TYPES = "__dat";
    private final float[] minmax;
    private static final float radiansPerDegree = (float)Math.PI / 180;
    private final P3[] points = new P3[4];

    SmilesMeasure(SmilesSearch search, int index, int type, boolean isNot, float[] minmax) {
        this.search = search;
        this.type = Math.min(4, Math.max(type, 2));
        this.index = index;
        this.isNot = isNot;
        this.minmax = minmax;
        for (int i = minmax.length - 2; i >= 0; i -= 2) {
            if (!(minmax[i] > minmax[i + 1])) continue;
            float min = minmax[i + 1];
            minmax[i + 1] = minmax[i];
            minmax[i] = min;
        }
    }

    boolean addPoint(int index) {
        if (this.nPoints == this.type) {
            return false;
        }
        if (this.nPoints == 0) {
            for (int i = 1; i < this.type; ++i) {
                this.indices[i] = index + i;
            }
        }
        this.indices[this.nPoints++] = index;
        return true;
    }

    boolean check() {
        for (int i = 0; i < this.type; ++i) {
            int iAtom = this.search.patternAtoms[this.indices[i]].getMatchingAtomIndex();
            this.points[i] = (P3)((Object)this.search.targetAtoms[iAtom]);
        }
        float d = 0.0f;
        switch (this.type) {
            case 2: {
                d = this.points[0].distance(this.points[1]);
                break;
            }
            case 3: {
                this.search.v.vA.sub2(this.points[0], this.points[1]);
                this.search.v.vB.sub2(this.points[2], this.points[1]);
                d = this.search.v.vA.angle(this.search.v.vB) / ((float)Math.PI / 180);
                break;
            }
            case 4: {
                d = SmilesMeasure.setTorsionData(this.points[0], this.points[1], this.points[2], this.points[3], this.search.v, true);
            }
        }
        for (int i = this.minmax.length - 2; i >= 0; i -= 2) {
            if (!(d >= this.minmax[i]) || !(d <= this.minmax[i + 1])) continue;
            return !this.isNot;
        }
        return this.isNot;
    }

    public static float setTorsionData(T3 pt1a, T3 pt1, T3 pt2, T3 pt2a, VTemp v, boolean withDihedral) {
        v.vTemp1.sub2(pt1a, pt1);
        v.vTemp2.sub2(pt2a, pt2);
        if (!withDihedral) {
            return 0.0f;
        }
        v.vNorm2.sub2(pt1, pt2);
        v.vNorm2.normalize();
        v.vTemp1.cross(v.vTemp1, v.vNorm2);
        v.vTemp1.normalize();
        v.vTemp2.cross(v.vTemp2, v.vNorm2);
        v.vTemp2.normalize();
        v.vNorm3.cross(v.vTemp1, v.vTemp2);
        return v.vTemp1.angle(v.vTemp2) / ((float)Math.PI / 180) * (float)(v.vNorm2.dot(v.vNorm3) < 0.0f ? 1 : -1);
    }

    public String toString() {
        String s = "(." + TYPES.charAt(this.type) + this.index + ":" + PT.toJSON(null, this.minmax) + ") for";
        for (int i = 0; i < this.type; ++i) {
            s = s + " " + (i >= this.nPoints ? "?" : "" + this.indices[i]);
        }
        return s;
    }
}

