/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.crypto.TlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;

    protected AbstractTlsPeer(TlsCrypto tlsCrypto) {
        this.crypto = tlsCrypto;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
    }

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    @Override
    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedPadding() {
        return false;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        if (!bl) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }

    @Override
    public TlsHeartbeat getHeartbeat() {
        return null;
    }

    @Override
    public short getHeartbeatPolicy() {
        return 2;
    }

    @Override
    public int getRenegotiationPolicy() {
        return 0;
    }
}

