/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.RegexpOptions;
import org.jruby.util.StringSupport;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    private Object pattern;
    transient RubyRegexp regexp;
    private boolean charOffsetUpdated;
    private Region charOffsets;
    private static ObjectAllocator MATCH_DATA_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyMatchData(runtime2, klass);
        }
    };
    private static final int MATCH_BUSY = ObjectFlags.MATCH_BUSY;

    public static RubyClass createMatchDataClass(Ruby runtime2) {
        RubyClass matchDataClass = runtime2.defineClass("MatchData", runtime2.getObject(), MATCH_DATA_ALLOCATOR);
        matchDataClass.setClassIndex(ClassIndex.MATCHDATA);
        matchDataClass.setReifiedClass(RubyMatchData.class);
        runtime2.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.kindOf = new RubyModule.JavaClassKindOf(RubyMatchData.class);
        matchDataClass.getMetaClass().undefineMethod("new");
        matchDataClass.defineAnnotatedMethods(RubyMatchData.class);
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime2) {
        super(runtime2, runtime2.getMatchData());
    }

    public RubyMatchData(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    final void initMatchData(ThreadContext context, RubyString str, Matcher matcher, Regex pattern) {
        Region region = matcher.getRegion();
        this.regs = region == null ? null : region.clone();
        this.begin = matcher.getBegin();
        this.end = matcher.getEnd();
        this.pattern = pattern;
        this.regexp = null;
        this.charOffsets = null;
        this.charOffsetUpdated = false;
        this.str = str.newFrozen();
        this.infectBy(str);
    }

    final void initMatchData(ThreadContext context, RubyString str, int beg, RubyString pattern) {
        this.regs = null;
        this.begin = beg;
        this.end = beg + pattern.size();
        this.pattern = pattern.newFrozen();
        this.regexp = null;
        this.charOffsets = null;
        this.charOffsetUpdated = false;
        this.str = str.newFrozen();
        this.infectBy(str);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyMatchData match2 = (RubyMatchData)clone2;
        match2.regs = this.regs;
        match2.begin = this.begin;
        match2.end = this.end;
        match2.pattern = this.pattern;
        match2.regexp = this.regexp;
        match2.charOffsetUpdated = this.charOffsetUpdated;
        match2.charOffsets = this.charOffsets;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.MATCHDATA;
    }

    private static void updatePairs(ByteList value2, Encoding encoding2, Pair[] pairs) {
        int p2;
        Arrays.sort(pairs);
        int length2 = pairs.length;
        byte[] bytes2 = value2.getUnsafeBytes();
        int s2 = p2 = value2.getBegin();
        int c = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            int q = s2 + pairs[i2].bytePos;
            pairs[i2].charPos = c += StringSupport.strLength(encoding2, bytes2, p2, q);
            p2 = q;
        }
    }

    private void updateCharOffsetOnlyOneReg(ByteList value2, Encoding encoding2) {
        if (this.charOffsetUpdated) {
            return;
        }
        if (this.charOffsets == null || this.charOffsets.numRegs < 1) {
            this.charOffsets = new Region(1);
        }
        if (encoding2.maxLength() == 1) {
            this.charOffsets.beg[0] = this.begin;
            this.charOffsets.end[0] = this.end;
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[2];
        if (this.begin >= 0) {
            pairs[0] = new Pair();
            pairs[0].bytePos = this.begin;
            pairs[1] = new Pair();
            pairs[1].bytePos = this.end;
        }
        RubyMatchData.updatePairs(value2, encoding2, (Pair[])pairs);
        if (this.begin < 0) {
            this.charOffsets.end[0] = -1;
            this.charOffsets.beg[0] = -1;
            return;
        }
        Pair key2 = new Pair();
        key2.bytePos = this.begin;
        this.charOffsets.beg[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        key2.bytePos = this.end;
        this.charOffsets.end[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        this.charOffsetUpdated = true;
    }

    private void updateCharOffsetManyRegs(ByteList value2, Encoding encoding2) {
        if (this.charOffsetUpdated) {
            return;
        }
        Region regs = this.regs;
        int numRegs = regs.numRegs;
        if (this.charOffsets == null || this.charOffsets.numRegs < numRegs) {
            this.charOffsets = new Region(numRegs);
        }
        if (encoding2.maxLength() == 1) {
            for (int i2 = 0; i2 < numRegs; ++i2) {
                this.charOffsets.beg[i2] = regs.beg[i2];
                this.charOffsets.end[i2] = regs.end[i2];
            }
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i3 = 0; i3 < pairs.length; ++i3) {
            pairs[i3] = new Pair();
        }
        int numPos = 0;
        for (int i4 = 0; i4 < numRegs; ++i4) {
            if (regs.beg[i4] < 0) continue;
            pairs[numPos++].bytePos = regs.beg[i4];
            pairs[numPos++].bytePos = regs.end[i4];
        }
        RubyMatchData.updatePairs(value2, encoding2, (Pair[])pairs);
        Pair key2 = new Pair();
        for (int i5 = 0; i5 < regs.numRegs; ++i5) {
            if (regs.beg[i5] < 0) {
                this.charOffsets.end[i5] = -1;
                this.charOffsets.beg[i5] = -1;
                continue;
            }
            key2.bytePos = regs.beg[i5];
            this.charOffsets.beg[i5] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
            key2.bytePos = regs.end[i5];
            this.charOffsets.end[i5] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        }
        this.charOffsetUpdated = true;
    }

    private void updateCharOffset() {
        if (this.charOffsetUpdated) {
            return;
        }
        ByteList value2 = this.str.getByteList();
        Encoding enc = value2.getEncoding();
        if (this.regs == null) {
            this.updateCharOffsetOnlyOneReg(value2, enc);
        } else {
            this.updateCharOffsetManyRegs(value2, enc);
        }
        this.charOffsetUpdated = true;
    }

    public final void use() {
        this.flags |= MATCH_BUSY;
    }

    public final boolean used() {
        return (this.flags & MATCH_BUSY) != 0;
    }

    final void check() {
        if (this.str == null) {
            throw this.metaClass.runtime.newTypeError("uninitialized Match");
        }
    }

    final Regex getPattern() {
        Object pattern = this.pattern;
        if (pattern instanceof Regex) {
            return (Regex)pattern;
        }
        if (pattern == null) {
            throw this.metaClass.runtime.newTypeError("uninitialized Match (missing pattern)");
        }
        Regex regexPattern = RubyRegexp.getQuotedRegexpFromCache(this.metaClass.runtime, (RubyString)pattern, RegexpOptions.NULL_OPTIONS);
        this.pattern = regexPattern;
        return regexPattern;
    }

    private RubyRegexp getRegexp() {
        RubyRegexp regexp2 = this.regexp;
        if (regexp2 != null) {
            return regexp2;
        }
        Regex pattern = this.getPattern();
        this.regexp = RubyRegexp.newRegexp(this.metaClass.runtime, (ByteList)pattern.getUserObject(), pattern);
        return this.regexp;
    }

    private static RubyString makeShared(Ruby runtime2, RubyString str, int index2, int length2) {
        return str.makeShared(runtime2, index2, length2);
    }

    private RubyArray match_array(Ruby runtime2, int start2) {
        this.check();
        IRubyObject nil = runtime2.getNil();
        if (this.regs == null) {
            if (start2 != 0) {
                return runtime2.newEmptyArray();
            }
            if (this.begin == -1) {
                return runtime2.newArray(nil);
            }
            RubyString ss = RubyMatchData.makeShared(runtime2, this.str, this.begin, this.end - this.begin);
            return runtime2.newArray((IRubyObject)ss.infectBy(this));
        }
        RubyArray arr = RubyArray.newBlankArray(runtime2, this.regs.numRegs - start2);
        int index2 = 0;
        for (int i2 = start2; i2 < this.regs.numRegs; ++i2) {
            if (this.regs.beg[i2] == -1) {
                arr.storeInternal(index2++, nil);
                continue;
            }
            RubyString ss = RubyMatchData.makeShared(runtime2, this.str, this.regs.beg[i2], this.regs.end[i2] - this.regs.beg[i2]);
            arr.storeInternal(index2++, ss.infectBy(this));
        }
        return arr;
    }

    public IRubyObject group(long n) {
        return RubyRegexp.nth_match((int)n, this);
    }

    public IRubyObject group(int n) {
        return RubyRegexp.nth_match(n, this);
    }

    public int getNameToBackrefNumber(String name2) {
        try {
            byte[] bytes2 = name2.getBytes();
            return this.getPattern().nameToBackrefNumber(bytes2, 0, bytes2.length, this.regs);
        }
        catch (JOniException je) {
            throw this.metaClass.runtime.newIndexError(je.getMessage());
        }
    }

    public IRubyObject[] getNamedBackrefValues(Ruby runtime2) {
        Regex pattern = this.getPattern();
        if (pattern.numberOfNames() == 0) {
            return NULL_ARRAY;
        }
        IRubyObject[] values2 = new IRubyObject[pattern.numberOfNames()];
        int j = 0;
        Iterator<NameEntry> i2 = pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            int nth = pattern.nameToBackrefNumber(e.name, e.nameP, e.nameEnd, this.regs);
            values2[j++] = RubyRegexp.nth_match(nth, this);
        }
        return values2;
    }

    @Override
    @JRubyMethod
    public RubyString inspect() {
        NameEntry e;
        if (this.str == null) {
            return (RubyString)this.anyToString();
        }
        Ruby runtime2 = this.metaClass.runtime;
        RubyString result2 = runtime2.newString();
        result2.cat((byte)35).cat((byte)60);
        result2.append(this.getMetaClass().getRealClass().to_s());
        NameEntry[] names2 = new NameEntry[this.regs == null ? 1 : this.regs.numRegs];
        Regex pattern = this.getPattern();
        Iterator<NameEntry> i2 = pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            e = i2.next();
            for (int num : e.getBackRefs()) {
                names2[num] = e;
            }
        }
        for (int i3 = 0; i3 < names2.length; ++i3) {
            IRubyObject v;
            result2.cat((byte)32);
            if (i3 > 0) {
                e = names2[i3];
                if (e != null) {
                    result2.cat(e.name, e.nameP, e.nameEnd - e.nameP);
                } else {
                    result2.cat((byte)(48 + i3));
                }
                result2.cat((byte)58);
            }
            if ((v = RubyRegexp.nth_match(i3, this)).isNil()) {
                result2.cat(RubyNil.nilBytes);
                continue;
            }
            result2.append(((RubyString)v).inspect(runtime2));
        }
        return result2.cat((byte)62);
    }

    @JRubyMethod
    public RubyRegexp regexp(ThreadContext context, Block block) {
        this.check();
        return this.getRegexp();
    }

    @JRubyMethod
    public IRubyObject names(ThreadContext context, Block block) {
        this.check();
        return this.getRegexp().names(context);
    }

    @Override
    @JRubyMethod
    public RubyArray to_a(ThreadContext context) {
        return this.match_array(context.runtime, 0);
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        this.check();
        Ruby runtime2 = context.runtime;
        RubyArray result2 = RubyArray.newArray(runtime2, args2.length);
        for (IRubyObject arg2 : args2) {
            if (arg2 instanceof RubyFixnum) {
                result2.append(RubyRegexp.nth_match(arg2.convertToInteger().getIntValue(), this));
                continue;
            }
            int num = this.namevToBacktraceNumber(context, arg2);
            if (num >= 0) {
                result2.append(RubyRegexp.nth_match(num, this));
                continue;
            }
            this.matchAryAref(context, arg2, result2);
        }
        return result2;
    }

    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.metaClass.runtime.getCurrentContext(), args2);
    }

    @JRubyMethod
    public IRubyObject captures(ThreadContext context) {
        return this.match_array(context.runtime, 1);
    }

    private int nameToBackrefNumber(RubyString str) {
        this.check();
        return RubyMatchData.nameToBackrefNumber(this.metaClass.runtime, this.getPattern(), this.regs, str);
    }

    private static int nameToBackrefNumber(Ruby runtime2, Regex pattern, Region regs, ByteListHolder str) {
        assert (pattern != null);
        ByteList value2 = str.getByteList();
        try {
            return pattern.nameToBackrefNumber(value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize(), regs);
        }
        catch (JOniException je) {
            throw runtime2.newIndexError(je.getMessage());
        }
    }

    public final int backrefNumber(Ruby runtime2, IRubyObject obj) {
        this.check();
        return RubyMatchData.backrefNumber(runtime2, this.getPattern(), this.regs, obj);
    }

    public static int backrefNumber(Ruby runtime2, Regex pattern, Region regs, IRubyObject obj) {
        if (obj instanceof RubySymbol) {
            return RubyMatchData.nameToBackrefNumber(runtime2, pattern, regs, ((RubySymbol)obj).to_s(runtime2));
        }
        if (obj instanceof RubyString) {
            return RubyMatchData.nameToBackrefNumber(runtime2, pattern, regs, (RubyString)obj);
        }
        return RubyNumeric.num2int(obj);
    }

    private int namevToBacktraceNumber(ThreadContext context, IRubyObject name2) {
        int num = -1;
        switch (name2.getType().getClassIndex()) {
            case SYMBOL: {
                name2 = name2.asString();
            }
            case STRING: {
                Ruby runtime2 = context.runtime;
                if (this.regexp.isNil() || RubyEncoding.areCompatible(this.regexp, name2) == null || (num = RubyMatchData.nameToBackrefNumber(runtime2, this.regexp.getPattern(), this.regs, name2.convertToString())) < 1) {
                    this.nameToBackrefError(runtime2, name2.toString());
                }
                return num;
            }
        }
        return -1;
    }

    private int nameToBackrefError(Ruby runtime2, String name2) {
        throw runtime2.newIndexError("undefined group name reference " + name2);
    }

    private IRubyObject matchArySubseq(ThreadContext context, int beg, int len, RubyArray result2) {
        int j;
        int end2;
        assert (result2 != null);
        int olen = this.regs.numRegs;
        int wantedEnd = beg + len;
        int n = end2 = olen < wantedEnd ? olen : wantedEnd;
        if (len == 0) {
            return result2;
        }
        for (j = beg; j < end2; ++j) {
            result2.append(RubyRegexp.nth_match(j, this));
        }
        if (wantedEnd > j) {
            int newLength = result2.size() + wantedEnd - j;
            result2.storeInternal(newLength - 1, context.nil);
        }
        return result2;
    }

    private IRubyObject matchAryAref(ThreadContext context, IRubyObject index2, RubyArray result2) {
        int numRegs = this.regs.numRegs;
        int[] begLen = new int[2];
        IRubyObject isRange = RubyRange.rangeBeginLength(context, index2, numRegs, begLen, 1);
        if (isRange.isNil()) {
            return context.nil;
        }
        if (!isRange.isTrue()) {
            IRubyObject nthMatch = RubyRegexp.nth_match(index2.convertToInteger().getIntValue(), this);
            return result2.push(nthMatch);
        }
        return this.matchArySubseq(context, begLen[0], begLen[1], result2);
    }

    @Deprecated
    public IRubyObject op_aref19(IRubyObject idx, IRubyObject rest2) {
        return this.op_aref(this.getRuntime().getCurrentContext(), idx, rest2);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        this.check();
        IRubyObject result2 = this.op_arefCommon(idx);
        return result2 == null ? this.to_a(context).aref(idx) : result2;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx, IRubyObject rest2) {
        IRubyObject result2;
        return !rest2.isNil() || (result2 = this.op_arefCommon(idx)) == null ? this.to_a(context).aref(idx, rest2) : result2;
    }

    private IRubyObject op_arefCommon(IRubyObject idx) {
        if (idx instanceof RubyFixnum) {
            int num = RubyNumeric.fix2int(idx);
            if (num >= 0) {
                return RubyRegexp.nth_match(num, this);
            }
        } else {
            if (idx instanceof RubySymbol) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber(((RubySymbol)idx).to_s(this.metaClass.runtime)), this);
            }
            if (idx instanceof RubyString) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)idx), this);
            }
        }
        return null;
    }

    public final IRubyObject at(int nth) {
        return RubyRegexp.nth_match(nth, this);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.runtime;
        return this.regs == null ? RubyFixnum.one(runtime2) : RubyFixnum.newFixnum(runtime2, this.regs.numRegs);
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context, IRubyObject index2) {
        int b2;
        this.check();
        Ruby runtime2 = context.runtime;
        int i2 = this.backrefNumber(runtime2, index2);
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime2.newIndexError("index " + i2 + " out of matches");
        }
        int n = b2 = this.regs == null ? this.begin : this.regs.beg[i2];
        if (b2 < 0) {
            return context.nil;
        }
        this.updateCharOffset();
        return RubyFixnum.newFixnum(runtime2, this.charOffsets.beg[i2]);
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context, IRubyObject index2) {
        int e;
        this.check();
        Ruby runtime2 = context.runtime;
        int i2 = this.backrefNumber(runtime2, index2);
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime2.newIndexError("index " + i2 + " out of matches");
        }
        int n = e = this.regs == null ? this.end : this.regs.end[i2];
        if (e < 0) {
            return context.nil;
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            e = this.charOffsets.end[i2];
        }
        return RubyFixnum.newFixnum(runtime2, e);
    }

    public IRubyObject offset(ThreadContext context, IRubyObject index2) {
        return this.offset19(context, index2);
    }

    @JRubyMethod(name={"offset"})
    public IRubyObject offset19(ThreadContext context, IRubyObject index2) {
        int e;
        int b2;
        this.check();
        Ruby runtime2 = context.runtime;
        int i2 = this.backrefNumber(runtime2, index2);
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime2.newIndexError("index " + i2 + " out of matches");
        }
        if (this.regs == null) {
            b2 = this.begin;
            e = this.end;
        } else {
            b2 = this.regs.beg[i2];
            e = this.regs.end[i2];
        }
        if (b2 < 0) {
            return runtime2.newArray(context.nil, context.nil);
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b2 = this.charOffsets.beg[i2];
            e = this.charOffsets.end[i2];
        }
        return runtime2.newArray((IRubyObject)RubyFixnum.newFixnum(runtime2, b2), (IRubyObject)RubyFixnum.newFixnum(runtime2, e));
    }

    @JRubyMethod
    public IRubyObject pre_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.nil;
        }
        return RubyMatchData.makeShared(context.runtime, this.str, 0, this.begin).infectBy(this);
    }

    @JRubyMethod
    public IRubyObject post_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.nil;
        }
        int strLen = this.str.getByteList().length();
        return RubyMatchData.makeShared(context.runtime, this.str, this.end, strLen - this.end).infectBy(this);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        this.check();
        IRubyObject ss = RubyRegexp.last_match(this);
        if (ss.isNil()) {
            ss = RubyString.newEmptyString(this.metaClass.runtime);
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod
    public IRubyObject string() {
        this.check();
        return this.str;
    }

    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (!(original instanceof RubyMatchData)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData origMatchData = (RubyMatchData)original;
        this.str = origMatchData.str;
        this.regs = origMatchData.regs;
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RubyMatchData)) {
            return false;
        }
        RubyMatchData that = (RubyMatchData)other;
        return (this.str == that.str || this.str != null && this.str.equals(that.str)) && (this.regexp == that.regexp || this.getRegexp().equals(that.getRegexp())) && (this.charOffsets == that.charOffsets || this.charOffsets != null && this.charOffsets.equals(that.charOffsets)) && this.charOffsetUpdated == that.charOffsetUpdated && this.begin == that.begin && this.end == that.end;
    }

    @Override
    @JRubyMethod(name={"eql?", "=="}, required=1)
    public IRubyObject eql_p(IRubyObject obj) {
        return this.metaClass.runtime.newBoolean(this.equals(obj));
    }

    @Override
    public int hashCode() {
        this.check();
        return this.getPattern().hashCode() ^ this.str.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.metaClass.runtime.newFixnum(this.hashCode());
    }

    @JRubyMethod
    public RubyHash named_captures(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = RubyHash.newHash(runtime2);
        if (this.regexp == context.nil) {
            return hash2;
        }
        Iterator<NameEntry> i2 = this.getPattern().namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry entry = i2.next();
            RubyString key2 = RubyString.newStringShared(runtime2, new ByteList(entry.name, entry.nameP, entry.nameEnd - entry.nameP, this.regexp.getEncoding(), false));
            boolean found = false;
            for (int b2 : entry.getBackRefs()) {
                IRubyObject value2 = RubyRegexp.nth_match(b2, this);
                if (!value2.isTrue()) continue;
                hash2.op_asetForString(runtime2, key2, value2);
                found = true;
            }
            if (found) continue;
            hash2.op_asetForString(runtime2, key2, context.nil);
        }
        return hash2;
    }

    public int begin(int i2) {
        if (this.regs == null) {
            if (i2 > 1) {
                return -1;
            }
            return this.begin;
        }
        if (i2 > this.regs.numRegs) {
            return -1;
        }
        return this.regs.beg[i2];
    }

    public int end(int i2) {
        if (this.regs == null) {
            if (i2 > 1) {
                return -1;
            }
            return this.end;
        }
        if (i2 > this.regs.numRegs) {
            return -1;
        }
        return this.regs.end[i2];
    }

    public int numRegs() {
        return this.regs == null ? 1 : this.regs.numRegs;
    }

    @Override
    @Deprecated
    public RubyArray to_a() {
        return this.match_array(this.getRuntime(), 0);
    }

    @Deprecated
    public IRubyObject op_aref(IRubyObject idx) {
        return this.op_aref(this.getRuntime().getCurrentContext(), idx);
    }

    @Deprecated
    public IRubyObject op_aref(IRubyObject idx, IRubyObject rest2) {
        return this.op_aref(this.getRuntime().getCurrentContext(), idx, rest2);
    }

    private static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        private Pair() {
        }

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }
}

