/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.parser.StaticScope;

public class IRWriter {
    private IRWriter() {
    }

    public static void persist(IRWriterEncoder file2, IRScope script) throws IOException {
        file2.startEncoding(script);
        IRWriter.persistScopeInstructions(file2, script);
        file2.startEncodingScopeHeaders(script);
        IRWriter.persistScopeHeaders(file2, script);
        file2.endEncodingScopeHeaders(script);
        file2.endEncoding(script);
    }

    private static void persistScopeInstructions(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeInstrs(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeInstructions(file2, scope);
        }
    }

    private static void persistScopeInstrs(IRWriterEncoder file2, IRScope scope) {
        file2.startEncodingScopeInstrs(scope);
        if (scope instanceof IRMethod && !scope.hasBeenBuilt()) {
            ((IRMethod)scope).lazilyAcquireInterpreterContext();
        }
        for (Instr instr : scope.getInterpreterContext().getInstructions()) {
            file2.encode(instr);
        }
        file2.endEncodingScopeInstrs(scope);
    }

    private static void persistScopeHeaders(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeHeader(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeHeaders(file2, scope);
        }
    }

    private static void persistScopeHeader(IRWriterEncoder file2, IRScope scope) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Writing Scope Header");
        }
        file2.startEncodingScopeHeader(scope);
        scope.persistScopeHeader(file2);
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("NAME = " + scope.getId());
        }
        if (scope instanceof IRScriptBody) {
            file2.encode(scope.getId());
        } else {
            file2.encodeRaw(scope.getName());
            file2.encode(scope.getLexicalParent());
        }
        IRWriter.persistStaticScope(file2, scope.getStaticScope());
        file2.endEncodingScopeHeader(scope);
    }

    private static void persistStaticScope(IRWriterEncoder file2, StaticScope staticScope) {
        file2.encode(staticScope.getType());
        file2.encode(staticScope.getVariables());
        file2.encode(staticScope.getFirstKeywordIndex());
        file2.encode(staticScope.getSignature());
    }
}

