/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.runtime.builtin.IRubyObject;

public abstract class ArraySupport {
    private ArraySupport() {
    }

    public static void copy(Object[] src, Object[] dst, int dstOff, int length2) {
        switch (length2) {
            case 0: {
                return;
            }
            case 1: {
                dst[dstOff] = src[0];
                return;
            }
            case 2: {
                assert (src != dst);
                dst[dstOff] = src[0];
                dst[++dstOff] = src[1];
                return;
            }
            case 3: {
                assert (src != dst);
                dst[dstOff] = src[0];
                dst[++dstOff] = src[1];
                dst[++dstOff] = src[2];
                return;
            }
        }
        System.arraycopy(src, 0, dst, dstOff, length2);
    }

    public static void copy(Object[] src, int srcOff, Object[] dst, int dstOff, int length2) {
        switch (length2) {
            case 0: {
                return;
            }
            case 1: {
                dst[dstOff] = src[srcOff];
                return;
            }
            case 2: {
                assert (src != dst);
                dst[dstOff] = src[srcOff];
                dst[++dstOff] = src[srcOff + 1];
                return;
            }
            case 3: {
                assert (src != dst);
                dst[dstOff] = src[srcOff];
                dst[++dstOff] = src[srcOff + 1];
                dst[++dstOff] = src[srcOff + 2];
                return;
            }
        }
        System.arraycopy(src, srcOff, dst, dstOff, length2);
    }

    public static Object[] newCopy(Object[] src, int length2) {
        Object[] copy = new Object[length2];
        if (length2 > src.length) {
            length2 = src.length;
        }
        ArraySupport.copy(src, copy, 0, length2);
        return copy;
    }

    public static IRubyObject[] newCopy(IRubyObject[] src, int length2) {
        Object[] copy = new IRubyObject[length2];
        if (length2 > src.length) {
            length2 = src.length;
        }
        ArraySupport.copy(src, copy, 0, length2);
        return copy;
    }

    public static IRubyObject[] newCopy(IRubyObject[] src, int srcOff, int length2) {
        Object[] copy = new IRubyObject[length2];
        if (length2 > src.length) {
            length2 = src.length;
        }
        ArraySupport.copy(src, srcOff, copy, 0, length2);
        return copy;
    }

    public static Class[] newCopy(Class[] src, int length2) {
        Object[] copy = new Class[length2];
        if (length2 > src.length) {
            length2 = src.length;
        }
        ArraySupport.copy(src, copy, 0, length2);
        return copy;
    }

    public static Object[] newCopy(Object[] src, Object last2) {
        switch (src.length) {
            case 0: {
                return new Object[]{last2};
            }
            case 1: {
                return new Object[]{src[0], last2};
            }
            case 2: {
                return new Object[]{src[0], src[1], last2};
            }
            case 3: {
                return new Object[]{src[0], src[1], src[2], last2};
            }
        }
        Object[] copy = new Object[src.length + 1];
        System.arraycopy(src, 0, copy, 0, src.length);
        copy[src.length] = last2;
        return copy;
    }

    public static IRubyObject[] newCopy(IRubyObject[] src, IRubyObject last2) {
        switch (src.length) {
            case 0: {
                return new IRubyObject[]{last2};
            }
            case 1: {
                return new IRubyObject[]{src[0], last2};
            }
            case 2: {
                return new IRubyObject[]{src[0], src[1], last2};
            }
            case 3: {
                return new IRubyObject[]{src[0], src[1], src[2], last2};
            }
            case 4: {
                return new IRubyObject[]{src[0], src[1], src[2], src[3], last2};
            }
        }
        IRubyObject[] copy = new IRubyObject[src.length + 1];
        System.arraycopy(src, 0, copy, 0, src.length);
        copy[src.length] = last2;
        return copy;
    }

    public static IRubyObject[] newCopy(IRubyObject first2, IRubyObject[] src) {
        switch (src.length) {
            case 0: {
                return new IRubyObject[]{first2};
            }
            case 1: {
                return new IRubyObject[]{first2, src[0]};
            }
            case 2: {
                return new IRubyObject[]{first2, src[0], src[1]};
            }
            case 3: {
                return new IRubyObject[]{first2, src[0], src[1], src[2]};
            }
            case 4: {
                return new IRubyObject[]{first2, src[0], src[1], src[2], src[3]};
            }
        }
        IRubyObject[] copy = new IRubyObject[1 + src.length];
        copy[0] = first2;
        System.arraycopy(src, 0, copy, 1, src.length);
        return copy;
    }
}

