/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.RubyDateFormatter;

public class RubyTimeOutputFormatter {
    final String flags;
    final int width;
    public static final RubyTimeOutputFormatter DEFAULT_FORMATTER = new RubyTimeOutputFormatter("", 0);
    private static final int SMALLBUF = 100;

    public RubyTimeOutputFormatter(String flags2, int width) {
        this.flags = flags2;
        this.width = width;
    }

    public int getWidth(int defaultWidth) {
        if (this.flags.indexOf(45) != -1) {
            return 0;
        }
        return this.width != 0 ? this.width : defaultWidth;
    }

    public char getPadder(char defaultPadder) {
        int padder = defaultPadder;
        block5: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '_': {
                    padder = 32;
                    continue block5;
                }
                case '0': {
                    padder = 48;
                    continue block5;
                }
                case '-': {
                    padder = 0;
                }
            }
        }
        return (char)padder;
    }

    public String format(CharSequence sequence, long value2, RubyDateFormatter.FieldType type2) {
        int width = this.getWidth(type2.defaultWidth);
        char padder = this.getPadder(type2.defaultPadder);
        sequence = sequence == null ? RubyTimeOutputFormatter.formatNumber(value2, width, padder) : RubyTimeOutputFormatter.padding(sequence, width, padder);
        block4: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '^': {
                    sequence = sequence.toString().toUpperCase();
                    continue block4;
                }
                case '#': {
                    char last2 = sequence.charAt(sequence.length() - 1);
                    sequence = Character.isLowerCase(last2) ? sequence.toString().toUpperCase() : sequence.toString().toLowerCase();
                }
            }
        }
        return sequence.toString();
    }

    static CharSequence formatNumber(long value2, int width, char padder) {
        if (value2 >= 0L || padder != '0') {
            return RubyTimeOutputFormatter.padding(Long.toString(value2), width, padder);
        }
        return RubyTimeOutputFormatter.padding(new StringBuilder().append('-'), Long.toString(-value2), width - 1, padder);
    }

    static StringBuilder formatSignedNumber(long value2, int width, char padder) {
        StringBuilder out = new StringBuilder();
        if (padder == '0') {
            if (value2 >= 0L) {
                return RubyTimeOutputFormatter.padding(out.append('+'), Long.toString(value2), width - 1, padder);
            }
            return RubyTimeOutputFormatter.padding(out.append('-'), Long.toString(-value2), width - 1, padder);
        }
        if (value2 >= 0L) {
            StringBuilder str = new StringBuilder().append('+').append(Long.toString(value2));
            return RubyTimeOutputFormatter.padding(out, str, width, padder);
        }
        return RubyTimeOutputFormatter.padding(out, Long.toString(value2), width, padder);
    }

    private static CharSequence padding(CharSequence sequence, int width, char padder) {
        int len = sequence.length();
        if (len >= width) {
            return sequence;
        }
        if (width > 100) {
            throw new IndexOutOfBoundsException("padding width " + width + " too large");
        }
        StringBuilder out = new StringBuilder(width + len);
        for (int i2 = len; i2 < width; ++i2) {
            out.append(padder);
        }
        out.append(sequence);
        return out;
    }

    private static StringBuilder padding(StringBuilder out, CharSequence sequence, int width, char padder) {
        int len = sequence.length();
        if (len >= width) {
            return out.append(sequence);
        }
        if (width > 100) {
            throw new IndexOutOfBoundsException("padding width " + width + " too large");
        }
        out.ensureCapacity(width + len);
        for (int i2 = len; i2 < width; ++i2) {
            out.append(padder);
        }
        return out.append(sequence);
    }
}

