/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;

public class RedRable
extends AbstractRable {
    CachableRed src;

    public RedRable(CachableRed cachableRed) {
        super((Filter)null);
        this.src = cachableRed;
    }

    public CachableRed getSource() {
        return this.src;
    }

    public Object getProperty(String string) {
        return this.src.getProperty(string);
    }

    public String[] getPropertyNames() {
        return this.src.getPropertyNames();
    }

    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds();
    }

    public RenderedImage createDefaultRendering() {
        return this.getSource();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        Rectangle rectangle = (shape = renderContext.getAreaOfInterest()) != null ? shape.getBounds() : this.getBounds2D().getBounds();
        AffineTransform affineTransform = renderContext.getTransform();
        CachableRed cachableRed = this.getSource();
        if (!rectangle.intersects(cachableRed.getBounds())) {
            return null;
        }
        if (affineTransform.isIdentity()) {
            return cachableRed;
        }
        if (affineTransform.getScaleX() == 1.0 && affineTransform.getScaleY() == 1.0 && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
            int n = (int)((double)cachableRed.getMinX() + affineTransform.getTranslateX());
            int n2 = (int)((double)cachableRed.getMinY() + affineTransform.getTranslateY());
            double d = (double)n - ((double)cachableRed.getMinX() + affineTransform.getTranslateX());
            double d2 = (double)n2 - ((double)cachableRed.getMinY() + affineTransform.getTranslateY());
            if (d > -1.0E-4 && d < 1.0E-4 && d2 > -1.0E-4 && d2 < 1.0E-4) {
                return new TranslateRed(cachableRed, n, n2);
            }
        }
        return new AffineRed(cachableRed, affineTransform, renderingHints);
    }
}

