# -*- coding: utf-8 -*-
info = {
    "name": "pl",
    "date_order": "DMY",
    "january": [
        "styczeń",
        "sty",
        "stycznia",
        "Styczeń",
        "Styczen",
        "Stycznia",
        "Styczniu",
        "Sty"
    ],
    "february": [
        "luty",
        "lut",
        "lutego",
        "Luty",
        "Lutego",
        "Lutym",
        "Lut"
    ],
    "march": [
        "marzec",
        "mar",
        "marca",
        "Marzec",
        "Marca",
        "Marcu",
        "Mar"
    ],
    "april": [
        "kwiecień",
        "kwi",
        "kwietnia",
        "Kwiecień",
        "Kwiecien",
        "Kwietnia",
        "Kwietniu",
        "Kwi",
        "Kwie"
    ],
    "may": [
        "maj",
        "maja",
        "Maj",
        "Maja",
        "Maju"
    ],
    "june": [
        "czerwiec",
        "cze",
        "czerwca",
        "Czerwiec",
        "Czerwca",
        "Czerwcu",
        "Cze"
    ],
    "july": [
        "lipiec",
        "lip",
        "lipca",
        "Lipiec",
        "Lipca",
        "Lipcu",
        "Lip"
    ],
    "august": [
        "sierpień",
        "sie",
        "sierpnia",
        "Sierpień",
        "Sierpien",
        "Sierpnia",
        "Sierpniu",
        "Sie"
    ],
    "september": [
        "wrzesień",
        "wrz",
        "września",
        "Wrzesień",
        "Wrzesien",
        "Września",
        "Wrzesnia",
        "Wrześniu",
        "Wrzesniu",
        "Wrz"
    ],
    "october": [
        "październik",
        "paź",
        "października",
        "Październik",
        "Pazdziernik",
        "Października",
        "Pazdziernika",
        "Październiku",
        "Pazdzierniku",
        "Paź",
        "Paz"
    ],
    "november": [
        "listopad",
        "lis",
        "listopada",
        "Listopad",
        "Listopada",
        "Listopadzie",
        "Lis"
    ],
    "december": [
        "grudzień",
        "gru",
        "grudnia",
        "Grudzień",
        "Grudzien",
        "Grudnia",
        "Grudniu",
        "Gru"
    ],
    "monday": [
        "poniedziałek",
        "pon",
        "Poniedziałek",
        "Poniedzialek",
        "Pon",
        "Pn"
    ],
    "tuesday": [
        "wtorek",
        "wt",
        "Wtorek",
        "Wt",
        "Wto"
    ],
    "wednesday": [
        "środa",
        "śr",
        "Środa",
        "Sroda",
        "Środę",
        "Srode",
        "Śro",
        "Sro",
        "Śr",
        "Sr"
    ],
    "thursday": [
        "czwartek",
        "czw",
        "Czwartek",
        "Czw",
        "Cz"
    ],
    "friday": [
        "piątek",
        "pt",
        "Piątek",
        "Piatek",
        "Pią",
        "Pia",
        "Pi",
        "Pt"
    ],
    "saturday": [
        "sobota",
        "sob",
        "Sobota",
        "Sobotę",
        "Sobote",
        "Sob",
        "So",
        "Sb"
    ],
    "sunday": [
        "niedziela",
        "niedz",
        "Niedziela",
        "Niedzielę",
        "Niedziele",
        "Nie",
        "Nd"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "rok",
        "r",
        "rok",
        "lata",
        "lat"
    ],
    "month": [
        "miesiąc",
        "mies",
        "mc",
        "miesiąc",
        "miesiac",
        "miesięcy",
        "miesiąca",
        "miesiące",
        "miesiace"
    ],
    "week": [
        "tydzień",
        "tydz",
        "tydzień",
        "tydzien",
        "tygodni",
        "tygodnie"
    ],
    "day": [
        "dzień",
        "dzień",
        "dzien",
        "dnia",
        "dniu",
        "dni"
    ],
    "hour": [
        "godzina",
        "godz",
        "g",
        "godzina",
        "godzinę",
        "godzine",
        "godzin",
        "godziny",
        "godz"
    ],
    "minute": [
        "minuta",
        "min",
        "minuta",
        "min",
        "minuty",
        "minut",
        "minute",
        "minutę"
    ],
    "second": [
        "sekunda",
        "sek",
        "s",
        "sekunda",
        "sekundę",
        "sekunde",
        "sekundy",
        "sekund",
        "s",
        "sek"
    ],
    "relative-type": {
        "1 year ago": [
            "w zeszłym roku"
        ],
        "0 year ago": [
            "w tym roku"
        ],
        "in 1 year": [
            "w przyszłym roku"
        ],
        "1 month ago": [
            "w zeszłym miesiącu"
        ],
        "0 month ago": [
            "w tym miesiącu"
        ],
        "in 1 month": [
            "w przyszłym miesiącu"
        ],
        "1 week ago": [
            "w zeszłym tygodniu"
        ],
        "0 week ago": [
            "w tym tygodniu"
        ],
        "in 1 week": [
            "w przyszłym tygodniu"
        ],
        "1 day ago": [
            "wczoraj"
        ],
        "0 day ago": [
            "dzisiaj"
        ],
        "in 1 day": [
            "jutro"
        ],
        "0 hour ago": [
            "ta godzina"
        ],
        "0 minute ago": [
            "ta minuta"
        ],
        "0 second ago": [
            "teraz"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "za (\\d+) rok",
            "za (\\d+) roku"
        ],
        "\\1 year ago": [
            "(\\d+) rok temu",
            "(\\d+) roku temu"
        ],
        "in \\1 month": [
            "za (\\d+) miesiąc",
            "za (\\d+) miesiąca",
            "za (\\d+) mies"
        ],
        "\\1 month ago": [
            "(\\d+) miesiąc temu",
            "(\\d+) miesiąca temu",
            "(\\d+) mies temu",
            "–(\\d+) mies"
        ],
        "in \\1 week": [
            "za (\\d+) tydzień",
            "za (\\d+) tygodnia",
            "za (\\d+) tydz",
            "za (\\d+) tyg"
        ],
        "\\1 week ago": [
            "(\\d+) tydzień temu",
            "(\\d+) tygodnia temu",
            "(\\d+) tydz temu",
            "(\\d+) tyg temu"
        ],
        "in \\1 day": [
            "za (\\d+) dzień",
            "za (\\d+) dnia"
        ],
        "\\1 day ago": [
            "(\\d+) dzień temu",
            "(\\d+) dnia temu"
        ],
        "in \\1 hour": [
            "za (\\d+) godzinę",
            "za (\\d+) godziny",
            "za (\\d+) godz",
            "za (\\d+) g"
        ],
        "\\1 hour ago": [
            "(\\d+) godzinę temu",
            "(\\d+) godziny temu",
            "(\\d+) godz temu",
            "(\\d+) g temu"
        ],
        "in \\1 minute": [
            "za (\\d+) minutę",
            "za (\\d+) minuty",
            "za (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minutę temu",
            "(\\d+) minuty temu",
            "(\\d+) min temu"
        ],
        "in \\1 second": [
            "za (\\d+) sekundę",
            "za (\\d+) sekundy",
            "za (\\d+) sek",
            "za (\\d+) s"
        ],
        "\\1 second ago": [
            "(\\d+) sekundę temu",
            "(\\d+) sekundy temu",
            "(\\d+) sek temu",
            "(\\d+) s temu"
        ]
    },
    "locale_specific": {},
    "dateorder": "DMY",
    "sentence_splitter_group": 1,
    "skip": [
        "r.",
        "roku",
        "w",
        "o",
        "i",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "ago": [
        "temu"
    ],
    "in": [
        "za"
    ],
    "simplifications": [
        {
            "dziś": "0 dnia"
        },
        {
            "dzisiaj": "0 dnia"
        },
        {
            "onegdaj": "2 dnia"
        },
        {
            "przedwczoraj": "2 dnia temu"
        },
        {
            "jutro": "za 1 dnia"
        },
        {
            "pojutrze": "za 2 dnia"
        }
    ]
}