/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class MaterialRetained
extends NodeComponentRetained {
    Color3f ambientColor = new Color3f(0.2f, 0.2f, 0.2f);
    Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f diffuseColor = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f specularColor = new Color3f(1.0f, 1.0f, 1.0f);
    float shininess = 64.0f;
    int colorTarget = 2;
    boolean lightingEnable = true;
    static final int AMBIENT_COLOR_CHANGED = 1;
    static final int EMISSIVE_COLOR_CHANGED = 2;
    static final int DIFFUSE_COLOR_CHANGED = 4;
    static final int SPECULAR_COLOR_CHANGED = 8;
    static final int SHININESS_CHANGED = 16;
    static final int ENABLE_CHANGED = 32;
    static final int COLORTARGET_CHANGED = 64;

    MaterialRetained() {
    }

    void createMaterial(Color3f color3f, Color3f color3f2, Color3f color3f3, Color3f color3f4, float f) {
        this.ambientColor.set((Tuple3f)color3f);
        this.emissiveColor.set((Tuple3f)color3f2);
        this.diffuseColor.set((Tuple3f)color3f3);
        this.specularColor.set((Tuple3f)color3f4);
        this.shininess = f;
    }

    final void initAmbientColor(Color3f color3f) {
        this.ambientColor.set((Tuple3f)color3f);
    }

    final void setAmbientColor(Color3f color3f) {
        this.initAmbientColor(color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    final void initAmbientColor(float f, float f2, float f3) {
        this.ambientColor.set(f, f2, f3);
    }

    final void setAmbientColor(float f, float f2, float f3) {
        this.initAmbientColor(f, f2, f3);
        this.sendMessage(1, new Color3f(f, f2, f3));
    }

    final void getAmbientColor(Color3f color3f) {
        color3f.set((Tuple3f)this.ambientColor);
    }

    final void initEmissiveColor(Color3f color3f) {
        this.emissiveColor.set((Tuple3f)color3f);
    }

    final void setEmissiveColor(Color3f color3f) {
        this.initEmissiveColor(color3f);
        this.sendMessage(2, new Color3f(color3f));
    }

    final void initEmissiveColor(float f, float f2, float f3) {
        this.emissiveColor.set(f, f2, f3);
    }

    final void setEmissiveColor(float f, float f2, float f3) {
        this.initEmissiveColor(f, f2, f3);
        this.sendMessage(2, new Color3f(f, f2, f3));
    }

    final void getEmissiveColor(Color3f color3f) {
        color3f.set((Tuple3f)this.emissiveColor);
    }

    final void initDiffuseColor(Color3f color3f) {
        this.diffuseColor.set((Tuple3f)color3f);
    }

    final void setDiffuseColor(Color3f color3f) {
        this.initDiffuseColor(color3f);
        this.sendMessage(4, new Color3f(color3f));
    }

    final void initDiffuseColor(float f, float f2, float f3) {
        this.diffuseColor.set(f, f2, f3);
    }

    final void setDiffuseColor(float f, float f2, float f3) {
        this.initDiffuseColor(f, f2, f3);
        this.sendMessage(4, new Color3f(f, f2, f3));
    }

    final void initDiffuseColor(float f, float f2, float f3, float f4) {
        this.diffuseColor.set(f, f2, f3);
    }

    final void setDiffuseColor(float f, float f2, float f3, float f4) {
        this.initDiffuseColor(f, f2, f3);
        this.sendMessage(4, new Color3f(f, f2, f3));
    }

    final void getDiffuseColor(Color3f color3f) {
        color3f.set((Tuple3f)this.diffuseColor);
    }

    final void initSpecularColor(Color3f color3f) {
        this.specularColor.set((Tuple3f)color3f);
    }

    final void setSpecularColor(Color3f color3f) {
        this.initSpecularColor(color3f);
        this.sendMessage(8, new Color3f(color3f));
    }

    final void initSpecularColor(float f, float f2, float f3) {
        this.specularColor.set(f, f2, f3);
    }

    final void setSpecularColor(float f, float f2, float f3) {
        this.initSpecularColor(f, f2, f3);
        this.sendMessage(8, new Color3f(f, f2, f3));
    }

    final void getSpecularColor(Color3f color3f) {
        color3f.set((Tuple3f)this.specularColor);
    }

    final void initShininess(float f) {
        this.shininess = f < 1.0f ? 1.0f : (f > 128.0f ? 128.0f : f);
    }

    final void setShininess(float f) {
        this.initShininess(f);
        this.sendMessage(16, new Float(this.shininess));
    }

    final float getShininess() {
        return this.shininess;
    }

    void initLightingEnable(boolean bl) {
        this.lightingEnable = bl;
    }

    void setLightingEnable(boolean bl) {
        this.initLightingEnable(bl);
        this.sendMessage(32, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    boolean getLightingEnable() {
        return this.lightingEnable;
    }

    void initColorTarget(int n) {
        this.colorTarget = n;
    }

    final void setColorTarget(int n) {
        this.initColorTarget(n);
        this.sendMessage(64, new Integer(n));
    }

    final int getColorTarget() {
        return this.colorTarget;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                MaterialRetained materialRetained = new MaterialRetained();
                materialRetained.set(this);
                materialRetained.source = this.source;
                this.mirror = materialRetained;
            }
        } else {
            ((MaterialRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context, float f, float f2, float f3, float f4, boolean bl) {
        Pipeline.getPipeline().updateMaterial(context, f, f2, f3, f4, this.ambientColor.x, this.ambientColor.y, this.ambientColor.z, this.emissiveColor.x, this.emissiveColor.y, this.emissiveColor.z, this.diffuseColor.x, this.diffuseColor.y, this.diffuseColor.z, this.specularColor.x, this.specularColor.y, this.specularColor.z, this.shininess, this.colorTarget, bl);
    }

    @Override
    synchronized void initMirrorObject() {
        MaterialRetained materialRetained = (MaterialRetained)this.mirror;
        materialRetained.set(this);
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        MaterialRetained materialRetained = (MaterialRetained)this.mirror;
        if ((n & 1) != 0) {
            materialRetained.ambientColor = (Color3f)object;
        } else if ((n & 2) != 0) {
            materialRetained.emissiveColor = (Color3f)object;
        } else if ((n & 4) != 0) {
            materialRetained.diffuseColor = (Color3f)object;
        } else if ((n & 8) != 0) {
            materialRetained.specularColor = (Color3f)object;
        } else if ((n & 0x10) != 0) {
            materialRetained.shininess = ((Float)object).floatValue();
        } else if ((n & 0x20) != 0) {
            materialRetained.lightingEnable = (Boolean)object;
        } else if ((n & 0x40) != 0) {
            materialRetained.colorTarget = (Integer)object;
        }
    }

    boolean equivalent(MaterialRetained materialRetained) {
        return materialRetained != null && this.lightingEnable == materialRetained.lightingEnable && this.diffuseColor.equals((Tuple3f)materialRetained.diffuseColor) && this.emissiveColor.equals((Tuple3f)materialRetained.emissiveColor) && this.specularColor.equals((Tuple3f)materialRetained.specularColor) && this.ambientColor.equals((Tuple3f)materialRetained.ambientColor) && this.colorTarget == materialRetained.colorTarget && this.shininess == materialRetained.shininess;
    }

    @Override
    protected Object clone() {
        MaterialRetained materialRetained = (MaterialRetained)super.clone();
        materialRetained.ambientColor = new Color3f(this.ambientColor);
        materialRetained.emissiveColor = new Color3f(this.emissiveColor);
        materialRetained.diffuseColor = new Color3f(this.diffuseColor);
        materialRetained.specularColor = new Color3f(this.specularColor);
        return materialRetained;
    }

    protected void set(MaterialRetained materialRetained) {
        super.set(materialRetained);
        this.ambientColor.set((Tuple3f)materialRetained.ambientColor);
        this.emissiveColor.set((Tuple3f)materialRetained.emissiveColor);
        this.diffuseColor.set((Tuple3f)materialRetained.diffuseColor);
        this.specularColor.set((Tuple3f)materialRetained.specularColor);
        this.shininess = materialRetained.shininess;
        this.lightingEnable = materialRetained.lightingEnable;
        this.colorTarget = materialRetained.colorTarget;
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 13;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 13;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 1) {
            this.setFrequencyChangeMask(1, 1);
        }
    }
}

