/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class ColoringAttributesRetained
extends NodeComponentRetained {
    static final int COLOR_CHANGED = 1;
    static final int SHADE_MODEL_CHANGED = 2;
    Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    int shadeModel = 3;

    ColoringAttributesRetained() {
    }

    final void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    final void setColor(Color3f color3f) {
        this.initColor(color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    final void initColor(float f, float f2, float f3) {
        this.color.set(f, f2, f3);
    }

    final void setColor(float f, float f2, float f3) {
        this.initColor(f, f2, f3);
        this.sendMessage(1, new Color3f(f, f2, f3));
    }

    final void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    final void initShadeModel(int n) {
        this.shadeModel = n;
    }

    final void setShadeModel(int n) {
        this.initShadeModel(n);
        this.sendMessage(2, new Integer(n));
    }

    final int getShadeModel() {
        return this.shadeModel;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                ColoringAttributesRetained coloringAttributesRetained = new ColoringAttributesRetained();
                coloringAttributesRetained.source = this.source;
                coloringAttributesRetained.set(this);
                this.mirror = coloringAttributesRetained;
            }
        } else {
            ((ColoringAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context, float f, float f2, float f3, float f4, boolean bl) {
        Pipeline.getPipeline().updateColoringAttributes(context, f, f3, f2, this.color.x, this.color.y, this.color.z, f4, bl, this.shadeModel);
    }

    synchronized void initMirrorObject() {
        ((ColoringAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        ColoringAttributesRetained coloringAttributesRetained = (ColoringAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            coloringAttributesRetained.color.set((Tuple3f)((Color3f)object));
        } else if ((n & 2) != 0) {
            coloringAttributesRetained.shadeModel = (Integer)object;
        }
    }

    boolean equivalent(ColoringAttributesRetained coloringAttributesRetained) {
        return coloringAttributesRetained != null && this.color.equals((Tuple3f)coloringAttributesRetained.color) && this.shadeModel == coloringAttributesRetained.shadeModel;
    }

    protected Object clone() {
        ColoringAttributesRetained coloringAttributesRetained = (ColoringAttributesRetained)super.clone();
        coloringAttributesRetained.color = new Color3f(this.color);
        return coloringAttributesRetained;
    }

    protected void set(ColoringAttributesRetained coloringAttributesRetained) {
        super.set(coloringAttributesRetained);
        this.color.set((Tuple3f)coloringAttributesRetained.color);
        this.shadeModel = coloringAttributesRetained.shadeModel;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 6;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 6;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n) {
        if (n == 1 || n == 3) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

