/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class PCMToPCM
extends AudioCodec {
    private Format lastInputFormat = null;
    private Format lastOutputFormat = null;
    private int bias = 0;
    private int signMask = 0;
    private int inputSampleSize = 8;
    private int outputSampleSize = 8;
    private int numberOfInputChannels = 1;
    private int numberOfOutputChannels = 1;
    private boolean channels2To1 = false;
    private boolean channels1To2 = false;
    private boolean channels2To2 = false;
    private int inputLsbOffset;
    private int inputMsbOffset;
    private int outputLsbOffset;
    private int outputMsbOffset;

    public PCMToPCM() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "PCM to PCM converter";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        int otherChnl = af.getChannels() == 1 ? 2 : 1;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1, 16 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, otherChnl, 0, 1, 16 * otherChnl, af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 1, 1, 16 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, otherChnl, 1, 1, 16 * otherChnl, af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 0, 16 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, otherChnl, 0, 0, 16 * otherChnl, af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 1, 0, 16 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 16, otherChnl, 1, 0, 16 * otherChnl, af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 8, af.getChannels(), -1, 1, 8 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 8, otherChnl, -1, 1, 8 * otherChnl, af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 8, af.getChannels(), -1, 0, 8 * af.getChannels(), af.getFrameRate(), af.getDataType()), new AudioFormat("LINEAR", af.getSampleRate(), 8, otherChnl, -1, 0, 8 * otherChnl, af.getFrameRate(), af.getDataType())};
        return this.supportedOutputFormats;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        if (this.lastInputFormat != this.inputFormat || this.lastOutputFormat != this.outputFormat) {
            this.initConverter(this.inputFormat, this.outputFormat);
        }
        int inpLength = inputBuffer.getLength();
        int outLength = this.calculateOutputSize(inputBuffer.getLength());
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        this.convert(inpData, inputBuffer.getOffset(), inpLength, outData, outputBuffer.getOffset());
        this.updateOutput(outputBuffer, this.outputFormat, outLength, outputBuffer.getOffset());
        return 0;
    }

    private int calculateOutputSize(int inputLength) {
        int outputLength = inputLength;
        if (this.inputSampleSize == 8 && this.outputSampleSize == 16) {
            outputLength *= 2;
        }
        if (this.inputSampleSize == 16 && this.outputSampleSize == 8) {
            outputLength /= 2;
        }
        if (this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2) {
            outputLength *= 2;
        }
        if (this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1) {
            outputLength /= 2;
        }
        return outputLength;
    }

    private void initConverter(AudioFormat inFormat, AudioFormat outFormat) {
        this.lastInputFormat = inFormat;
        this.lastOutputFormat = outFormat;
        this.numberOfInputChannels = inFormat.getChannels();
        this.numberOfOutputChannels = outFormat.getChannels();
        this.inputSampleSize = inFormat.getSampleSizeInBits();
        this.outputSampleSize = outFormat.getSampleSizeInBits();
        if (inFormat.getEndian() == 1 || 8 == this.inputSampleSize) {
            this.inputLsbOffset = 1;
            this.inputMsbOffset = 0;
        } else {
            this.inputLsbOffset = -1;
            this.inputMsbOffset = 1;
        }
        int outputEndianess = outFormat.getEndian();
        if (outputEndianess == -1) {
            outputEndianess = inFormat.getEndian();
        }
        if (outputEndianess == 1 || 8 == this.outputSampleSize) {
            this.outputLsbOffset = 1;
            this.outputMsbOffset = 0;
        } else {
            this.outputLsbOffset = -1;
            this.outputMsbOffset = 1;
        }
        this.signMask = inFormat.getSigned() == 1 ? -1 : 65535;
        this.bias = inFormat.getSigned() == outFormat.getSigned() || outFormat.getSigned() == -1 ? 0 : 32768;
        this.channels2To1 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
        this.channels1To2 = this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2;
        this.channels2To2 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 2;
    }

    private void convert(byte[] input, int inputOffset, int inputLength, byte[] outData, int outputOffset) {
        int sample1 = 0;
        int sample2 = 0;
        outputOffset += this.outputMsbOffset;
        int i = inputOffset + this.inputMsbOffset;
        while (i < inputLength + inputOffset) {
            if (8 == this.inputSampleSize) {
                sample1 = input[i++] << 8;
                if (this.numberOfInputChannels == 2) {
                    sample2 = input[i++] << 8;
                }
            } else {
                sample1 = (input[i] << 8) + (0xFF & input[i + this.inputLsbOffset]);
                i += 2;
                if (this.numberOfInputChannels == 2) {
                    sample2 = (input[i] << 8) + (0xFF & input[i + this.inputLsbOffset]);
                    i += 2;
                }
            }
            if (this.channels2To1) {
                sample1 = (sample1 & this.signMask) + (sample2 & this.signMask) >> 1;
            }
            sample1 = (short)(sample1 + this.bias);
            if (this.channels2To2) {
                sample2 = (short)(sample2 + this.bias);
            }
            if (this.channels1To2) {
                sample2 = sample1;
            }
            if (8 == this.outputSampleSize) {
                outData[outputOffset++] = (byte)(sample1 >> 8);
                if (this.numberOfOutputChannels != 2) continue;
                outData[outputOffset++] = (byte)(sample2 >> 8);
                continue;
            }
            outData[outputOffset + this.outputLsbOffset] = (byte)sample1;
            outData[outputOffset] = (byte)(sample1 >> 8);
            outputOffset += 2;
            if (this.numberOfOutputChannels != 2) continue;
            outData[outputOffset + this.outputLsbOffset] = (byte)sample2;
            outData[outputOffset] = (byte)(sample2 >> 8);
            outputOffset += 2;
        }
    }
}

