/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SSRCTable {
    static final int INCR = 16;
    int[] ssrcList = new int[16];
    Object[] objList = new Object[16];
    int total = 0;

    public synchronized void put(int ssrc, Object obj) {
        if (this.total == 0) {
            this.ssrcList[0] = ssrc;
            this.objList[0] = obj;
            this.total = 1;
            return;
        }
        int i = 0;
        while (i < this.total) {
            if (this.ssrcList[i] >= ssrc) {
                if (this.ssrcList[i] != ssrc) break;
                this.objList[i] = obj;
                return;
            }
            ++i;
        }
        if (this.total == this.ssrcList.length) {
            int[] sl = new int[this.ssrcList.length + 16];
            Object[] ol = new Object[this.objList.length + 16];
            if (i > 0) {
                System.arraycopy(this.ssrcList, 0, sl, 0, this.total);
                System.arraycopy(this.objList, 0, ol, 0, this.total);
            }
            this.ssrcList = sl;
            this.objList = ol;
        }
        int x = this.total - 1;
        while (x >= i) {
            this.ssrcList[x + 1] = this.ssrcList[x];
            this.objList[x + 1] = this.objList[x];
            --x;
        }
        this.ssrcList[i] = ssrc;
        this.objList[i] = obj;
        ++this.total;
    }

    private int indexOf(int ssrc) {
        if (this.total <= 3) {
            if (this.total > 0 && this.ssrcList[0] == ssrc) {
                return 0;
            }
            if (this.total > 1 && this.ssrcList[1] == ssrc) {
                return 1;
            }
            if (this.total > 2 && this.ssrcList[2] == ssrc) {
                return 2;
            }
            return -1;
        }
        if (this.ssrcList[0] == ssrc) {
            return 0;
        }
        if (this.ssrcList[this.total - 1] == ssrc) {
            return this.total - 1;
        }
        int i = 0;
        int j = this.total - 1;
        do {
            int x;
            if (this.ssrcList[x = (j - i) / 2 + i] == ssrc) {
                return x;
            }
            if (ssrc > this.ssrcList[x]) {
                i = x + 1;
                continue;
            }
            if (ssrc >= this.ssrcList[x]) continue;
            j = x;
        } while (i < j);
        return -1;
    }

    public synchronized Object remove(int ssrc) {
        int i = this.indexOf(ssrc);
        if (i < 0) {
            return null;
        }
        Object res = this.objList[i];
        while (i < this.total - 1) {
            this.ssrcList[i] = this.ssrcList[i + 1];
            this.objList[i] = this.objList[i + 1];
            ++i;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void removeObj(Object obj) {
        if (obj == null) {
            return;
        }
        i = 0;
        while (i < this.total) {
            if (this.objList[i] == obj) break;
            ++i;
        }
        if (i < this.total) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            this.ssrcList[i] = this.ssrcList[i + 1];
            this.objList[i] = this.objList[i + 1];
            ++i;
lbl13:
            // 2 sources

            ** while (i < this.total - 1)
        }
lbl14:
        // 1 sources

        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
    }

    public synchronized void removeAll() {
        int i = 0;
        while (i < this.total) {
            this.ssrcList[i] = 0;
            this.objList[i] = null;
            ++i;
        }
        this.total = 0;
    }

    public int size() {
        return this.total;
    }

    public synchronized Object get(int ssrc) {
        int i = this.indexOf(ssrc);
        if (i < 0) {
            return null;
        }
        return this.objList[i];
    }

    public synchronized int getSSRC(Object obj) {
        int i = 0;
        while (i < this.total) {
            if (this.objList[i] == obj) {
                return this.ssrcList[i];
            }
            ++i;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public synchronized Enumeration elements() {
        return new Enumeration(){
            int next = 0;

            public boolean hasMoreElements() {
                return this.next < SSRCTable.this.total;
            }

            public Object nextElement() {
                SSRCTable sSRCTable = SSRCTable.this;
                synchronized (sSRCTable) {
                    if (this.next < SSRCTable.this.total) {
                        Object object = SSRCTable.this.objList[this.next++];
                        return object;
                    }
                }
                throw new NoSuchElementException("SSRCTable Enumeration");
            }
        };
    }
}

