﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CostExplorer
{
namespace Model
{

  /**
   * <p> Summary of rightsizing recommendations </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/RightsizingRecommendationSummary">AWS
   * API Reference</a></p>
   */
  class AWS_COSTEXPLORER_API RightsizingRecommendationSummary
  {
  public:
    RightsizingRecommendationSummary();
    RightsizingRecommendationSummary(Aws::Utils::Json::JsonView jsonValue);
    RightsizingRecommendationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline const Aws::String& GetTotalRecommendationCount() const{ return m_totalRecommendationCount; }

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline bool TotalRecommendationCountHasBeenSet() const { return m_totalRecommendationCountHasBeenSet; }

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline void SetTotalRecommendationCount(const Aws::String& value) { m_totalRecommendationCountHasBeenSet = true; m_totalRecommendationCount = value; }

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline void SetTotalRecommendationCount(Aws::String&& value) { m_totalRecommendationCountHasBeenSet = true; m_totalRecommendationCount = std::move(value); }

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline void SetTotalRecommendationCount(const char* value) { m_totalRecommendationCountHasBeenSet = true; m_totalRecommendationCount.assign(value); }

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline RightsizingRecommendationSummary& WithTotalRecommendationCount(const Aws::String& value) { SetTotalRecommendationCount(value); return *this;}

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline RightsizingRecommendationSummary& WithTotalRecommendationCount(Aws::String&& value) { SetTotalRecommendationCount(std::move(value)); return *this;}

    /**
     * <p> Total number of instance recommendations.</p>
     */
    inline RightsizingRecommendationSummary& WithTotalRecommendationCount(const char* value) { SetTotalRecommendationCount(value); return *this;}


    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline const Aws::String& GetEstimatedTotalMonthlySavingsAmount() const{ return m_estimatedTotalMonthlySavingsAmount; }

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline bool EstimatedTotalMonthlySavingsAmountHasBeenSet() const { return m_estimatedTotalMonthlySavingsAmountHasBeenSet; }

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline void SetEstimatedTotalMonthlySavingsAmount(const Aws::String& value) { m_estimatedTotalMonthlySavingsAmountHasBeenSet = true; m_estimatedTotalMonthlySavingsAmount = value; }

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline void SetEstimatedTotalMonthlySavingsAmount(Aws::String&& value) { m_estimatedTotalMonthlySavingsAmountHasBeenSet = true; m_estimatedTotalMonthlySavingsAmount = std::move(value); }

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline void SetEstimatedTotalMonthlySavingsAmount(const char* value) { m_estimatedTotalMonthlySavingsAmountHasBeenSet = true; m_estimatedTotalMonthlySavingsAmount.assign(value); }

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline RightsizingRecommendationSummary& WithEstimatedTotalMonthlySavingsAmount(const Aws::String& value) { SetEstimatedTotalMonthlySavingsAmount(value); return *this;}

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline RightsizingRecommendationSummary& WithEstimatedTotalMonthlySavingsAmount(Aws::String&& value) { SetEstimatedTotalMonthlySavingsAmount(std::move(value)); return *this;}

    /**
     * <p> Estimated total savings resulting from modifications, on a monthly
     * basis.</p>
     */
    inline RightsizingRecommendationSummary& WithEstimatedTotalMonthlySavingsAmount(const char* value) { SetEstimatedTotalMonthlySavingsAmount(value); return *this;}


    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline const Aws::String& GetSavingsCurrencyCode() const{ return m_savingsCurrencyCode; }

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline bool SavingsCurrencyCodeHasBeenSet() const { return m_savingsCurrencyCodeHasBeenSet; }

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline void SetSavingsCurrencyCode(const Aws::String& value) { m_savingsCurrencyCodeHasBeenSet = true; m_savingsCurrencyCode = value; }

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline void SetSavingsCurrencyCode(Aws::String&& value) { m_savingsCurrencyCodeHasBeenSet = true; m_savingsCurrencyCode = std::move(value); }

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline void SetSavingsCurrencyCode(const char* value) { m_savingsCurrencyCodeHasBeenSet = true; m_savingsCurrencyCode.assign(value); }

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsCurrencyCode(const Aws::String& value) { SetSavingsCurrencyCode(value); return *this;}

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsCurrencyCode(Aws::String&& value) { SetSavingsCurrencyCode(std::move(value)); return *this;}

    /**
     * <p> The currency code that Amazon Web Services used to calculate the
     * savings.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsCurrencyCode(const char* value) { SetSavingsCurrencyCode(value); return *this;}


    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline const Aws::String& GetSavingsPercentage() const{ return m_savingsPercentage; }

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline bool SavingsPercentageHasBeenSet() const { return m_savingsPercentageHasBeenSet; }

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline void SetSavingsPercentage(const Aws::String& value) { m_savingsPercentageHasBeenSet = true; m_savingsPercentage = value; }

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline void SetSavingsPercentage(Aws::String&& value) { m_savingsPercentageHasBeenSet = true; m_savingsPercentage = std::move(value); }

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline void SetSavingsPercentage(const char* value) { m_savingsPercentageHasBeenSet = true; m_savingsPercentage.assign(value); }

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsPercentage(const Aws::String& value) { SetSavingsPercentage(value); return *this;}

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsPercentage(Aws::String&& value) { SetSavingsPercentage(std::move(value)); return *this;}

    /**
     * <p> Savings percentage based on the recommended modifications, relative to the
     * total On Demand costs associated with these instances.</p>
     */
    inline RightsizingRecommendationSummary& WithSavingsPercentage(const char* value) { SetSavingsPercentage(value); return *this;}

  private:

    Aws::String m_totalRecommendationCount;
    bool m_totalRecommendationCountHasBeenSet;

    Aws::String m_estimatedTotalMonthlySavingsAmount;
    bool m_estimatedTotalMonthlySavingsAmountHasBeenSet;

    Aws::String m_savingsCurrencyCode;
    bool m_savingsCurrencyCodeHasBeenSet;

    Aws::String m_savingsPercentage;
    bool m_savingsPercentageHasBeenSet;
  };

} // namespace Model
} // namespace CostExplorer
} // namespace Aws
