﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/DashboardSourceTemplate.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace QuickSight
{
namespace Model
{

  /**
   * <p>Dashboard source entity.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DashboardSourceEntity">AWS
   * API Reference</a></p>
   */
  class AWS_QUICKSIGHT_API DashboardSourceEntity
  {
  public:
    DashboardSourceEntity();
    DashboardSourceEntity(Aws::Utils::Json::JsonView jsonValue);
    DashboardSourceEntity& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Source template.</p>
     */
    inline const DashboardSourceTemplate& GetSourceTemplate() const{ return m_sourceTemplate; }

    /**
     * <p>Source template.</p>
     */
    inline bool SourceTemplateHasBeenSet() const { return m_sourceTemplateHasBeenSet; }

    /**
     * <p>Source template.</p>
     */
    inline void SetSourceTemplate(const DashboardSourceTemplate& value) { m_sourceTemplateHasBeenSet = true; m_sourceTemplate = value; }

    /**
     * <p>Source template.</p>
     */
    inline void SetSourceTemplate(DashboardSourceTemplate&& value) { m_sourceTemplateHasBeenSet = true; m_sourceTemplate = std::move(value); }

    /**
     * <p>Source template.</p>
     */
    inline DashboardSourceEntity& WithSourceTemplate(const DashboardSourceTemplate& value) { SetSourceTemplate(value); return *this;}

    /**
     * <p>Source template.</p>
     */
    inline DashboardSourceEntity& WithSourceTemplate(DashboardSourceTemplate&& value) { SetSourceTemplate(std::move(value)); return *this;}

  private:

    DashboardSourceTemplate m_sourceTemplate;
    bool m_sourceTemplateHasBeenSet;
  };

} // namespace Model
} // namespace QuickSight
} // namespace Aws
