/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Binding;
import com.google.inject.internal.AbstractBindingProcessor;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ProcessedBindingData;
import com.google.inject.spi.UntargettedBinding;

class UntargettedBindingProcessor
extends AbstractBindingProcessor {
    UntargettedBindingProcessor(Errors errors, ProcessedBindingData bindingData) {
        super(errors, bindingData);
    }

    @Override
    public <T> Boolean visit(Binding<T> binding2) {
        return (Boolean)binding2.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)binding2){

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                this.prepareBinding();
                if (this.key.getAnnotationType() != null) {
                    UntargettedBindingProcessor.this.errors.missingImplementationWithHint(this.key, UntargettedBindingProcessor.this.injector);
                    UntargettedBindingProcessor.this.putBinding(UntargettedBindingProcessor.this.invalidBinding(UntargettedBindingProcessor.this.injector, this.key, this.source));
                    return true;
                }
                try {
                    BindingImpl binding2 = UntargettedBindingProcessor.this.injector.createUninitializedBinding(this.key, this.scoping, this.source, UntargettedBindingProcessor.this.errors, false);
                    this.scheduleInitialization(binding2);
                    UntargettedBindingProcessor.this.putBinding(binding2);
                }
                catch (ErrorsException e2) {
                    UntargettedBindingProcessor.this.errors.merge(e2.getErrors());
                    UntargettedBindingProcessor.this.putBinding(UntargettedBindingProcessor.this.invalidBinding(UntargettedBindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding2) {
                return false;
            }
        });
    }
}

