/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;

public class WrapperQueryBuilder
extends AbstractQueryBuilder<WrapperQueryBuilder> {
    public static final String NAME = "wrapper";
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private final byte[] source;

    public WrapperQueryBuilder(byte[] source) {
        if (source == null || source.length == 0) {
            throw new IllegalArgumentException("query source text cannot be null or empty");
        }
        this.source = source;
    }

    public WrapperQueryBuilder(String source) {
        if (Strings.isEmpty(source)) {
            throw new IllegalArgumentException("query source string cannot be null or empty");
        }
        this.source = source.getBytes(StandardCharsets.UTF_8);
    }

    public WrapperQueryBuilder(BytesReference source) {
        if (source == null || source.length() == 0) {
            throw new IllegalArgumentException("query source text cannot be null or empty");
        }
        this.source = BytesRef.deepCopyOf((BytesRef)source.toBytesRef()).bytes;
    }

    public WrapperQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.source = in.readByteArray();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.source);
    }

    public byte[] source() {
        return this.source;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.source);
        builder.endObject();
    }

    public static WrapperQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[wrapper] query malformed", new Object[0]);
        }
        String fieldName = parser.currentName();
        if (!QUERY_FIELD.match(fieldName, parser.getDeprecationHandler())) {
            throw new ParsingException(parser.getTokenLocation(), "[wrapper] query malformed, expected `query` but was " + fieldName, new Object[0]);
        }
        parser.nextToken();
        byte[] source = parser.binaryValue();
        parser.nextToken();
        if (source == null) {
            throw new ParsingException(parser.getTokenLocation(), "wrapper query has no [query] specified", new Object[0]);
        }
        return new WrapperQueryBuilder(source);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("this query must be rewritten first");
    }

    @Override
    protected int doHashCode() {
        return Arrays.hashCode(this.source);
    }

    @Override
    protected boolean doEquals(WrapperQueryBuilder other) {
        return Arrays.equals(this.source, other.source);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext context) throws IOException {
        try (XContentParser qSourceParser = XContentFactory.xContent((byte[])this.source).createParser(context.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.source);){
            QueryBuilder queryBuilder = WrapperQueryBuilder.parseInnerQueryBuilder(qSourceParser).rewrite(context);
            if (this.boost() != 1.0f || this.queryName() != null) {
                BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                boolQueryBuilder.must(queryBuilder);
                BoolQueryBuilder boolQueryBuilder2 = boolQueryBuilder;
                return boolQueryBuilder2;
            }
            QueryBuilder queryBuilder2 = queryBuilder;
            return queryBuilder2;
        }
    }
}

