/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Vecf;

public class Vec2f {
    private float x;
    private float y;

    public Vec2f() {
    }

    public Vec2f(Vec2f arg) {
        this(arg.x, arg.y);
    }

    public Vec2f(float x, float y) {
        this.set(x, y);
    }

    public Vec2f copy() {
        return new Vec2f(this);
    }

    public void set(Vec2f arg) {
        this.set(arg.x, arg.y);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(int i, float val) {
        switch (i) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float dot(Vec2f arg) {
        return this.x * arg.x + this.y * arg.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.scale(1.0f / len);
    }

    public Vec2f times(float val) {
        Vec2f tmp = new Vec2f(this);
        tmp.scale(val);
        return tmp;
    }

    public void scale(float val) {
        this.x *= val;
        this.y *= val;
    }

    public Vec2f plus(Vec2f arg) {
        Vec2f tmp = new Vec2f();
        tmp.add(this, arg);
        return tmp;
    }

    public void add(Vec2f b) {
        this.add(this, b);
    }

    public void add(Vec2f a, Vec2f b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
    }

    public Vec2f addScaled(float s, Vec2f arg) {
        Vec2f tmp = new Vec2f();
        tmp.addScaled(this, s, arg);
        return tmp;
    }

    public void addScaled(Vec2f a, float s, Vec2f b) {
        this.x = a.x + s * b.x;
        this.y = a.y + s * b.y;
    }

    public Vec2f minus(Vec2f arg) {
        Vec2f tmp = new Vec2f();
        tmp.sub(this, arg);
        return tmp;
    }

    public void sub(Vec2f b) {
        this.sub(this, b);
    }

    public void sub(Vec2f a, Vec2f b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
    }

    public Vecf toVecf() {
        Vecf out = new Vecf(2);
        for (int i = 0; i < 2; ++i) {
            out.set(i, this.get(i));
        }
        return out;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

