# gopass fish shell completion

function __fish_gopass_no_subcommand --description 'Test if there has been any subcommand yet'
    for i in (commandline -opc)
        if contains -- $i audit hibp clone completion bash zsh fish openbsdksh config copy cp create new delete remove rm edit set find search fsck generate git init remote add remove push pull status history hist init insert jsonapi listen configure list ls mounts add mount remove rm unmount umount move mv pwgen recipients add authorize remove rm deauthorize update show sync templates show cat edit create new remove rm update version help h
            return 1
        end
    end
    return 0
end

complete -c gopass -n '__fish_gopass_no_subcommand' -f -l yes -d 'Assume yes on all yes/no questions or use the default on all others'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l clip -s c -d 'Copy the first line of the secret into the clipboard'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l alsoclip -s C -d 'Copy the first line of the secret into the clipboard and show everything'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l help -s h -d 'show help'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l version -s v -d 'print the version'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l help -s h -d 'show help'
complete -c gopass -n '__fish_gopass_no_subcommand' -f -l version -s v -d 'print the version'
complete -c gopass -n '__fish_seen_subcommand_from audit' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'audit' -d 'Scan for weak passwords'
complete -c gopass -n '__fish_seen_subcommand_from audit' -f -l jobs -s j -r -d 'The number of jobs to run concurrently when auditing'
complete -c gopass -n '__fish_seen_subcommand_from hibp' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from audit' -a 'hibp' -d 'Detect leaked passwords'
complete -c gopass -n '__fish_seen_subcommand_from hibp' -f -l force -s f -d 'Force to move the secret and overwrite existing one'
complete -c gopass -n '__fish_seen_subcommand_from hibp' -f -l api -s a -d 'Use HIBP API'
complete -c gopass -n '__fish_seen_subcommand_from hibp' -f -l dumps -r -d 'One or more HIBP v1/v2 dumps'
complete -c gopass -n '__fish_seen_subcommand_from clone' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'clone' -d 'Clone a store from git'
complete -c gopass -n '__fish_seen_subcommand_from clone' -f -l path -r -d 'Path to clone the repo to'
complete -c gopass -n '__fish_seen_subcommand_from clone' -f -l crypto -r -d 'Select crypto backend (gpg, gpgcli, plain, xc)'
complete -c gopass -n '__fish_seen_subcommand_from clone' -f -l sync -r -d 'Select sync backend (git, gitcli, noop)'
complete -c gopass -n '__fish_seen_subcommand_from completion' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'completion' -d 'Bash and ZSH completion'
complete -c gopass -n '__fish_seen_subcommand_from bash' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from completion' -a 'bash' -d 'Source for auto completion in bash'
complete -c gopass -n '__fish_seen_subcommand_from zsh' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from completion' -a 'zsh' -d 'Source for auto completion in zsh'
complete -c gopass -n '__fish_seen_subcommand_from fish' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from completion' -a 'fish' -d 'Source for auto completion in fish'
complete -c gopass -n '__fish_seen_subcommand_from fish' -f -l help -s h -d 'show help'
complete -c gopass -n '__fish_seen_subcommand_from openbsdksh' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from completion' -a 'openbsdksh' -d 'Source for auto completion in OpenBSD\'s ksh'
complete -c gopass -n '__fish_seen_subcommand_from config' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'config' -d 'Edit configuration'
complete -c gopass -n '__fish_seen_subcommand_from config' -f -l store -r -d 'Set value to substore config'
complete -c gopass -n '__fish_seen_subcommand_from copy cp' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'copy cp' -d 'Copy secrets from one location to another'
complete -c gopass -n '__fish_seen_subcommand_from copy cp' -f -l force -s f -d 'Force to copy the secret and overwrite existing one'
complete -c gopass -n '__fish_seen_subcommand_from create new' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'create new' -d 'Easy creation of new secrets'
complete -c gopass -n '__fish_seen_subcommand_from create new' -f -l store -s s -r -d 'Which store to use'
complete -c gopass -n '__fish_seen_subcommand_from delete remove rm' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'delete remove rm' -d 'Remove secrets'
complete -c gopass -n '__fish_seen_subcommand_from delete remove rm' -f -l recursive -s r -d 'Recursive delete files and folders'
complete -c gopass -n '__fish_seen_subcommand_from delete remove rm' -f -l force -s f -d 'Force to delete the secret'
complete -c gopass -n '__fish_seen_subcommand_from edit set' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'edit set' -d 'Edit new or existing secrets'
complete -c gopass -n '__fish_seen_subcommand_from edit set' -f -l editor -s e -r -d 'Use this editor binary'
complete -c gopass -n '__fish_seen_subcommand_from edit set' -f -l create -s c -d 'Create a new secret if none found'
complete -c gopass -n '__fish_seen_subcommand_from find search' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'find search' -d 'Search for secrets'
complete -c gopass -n '__fish_seen_subcommand_from find search' -f -l clip -s c -d 'Copy the password into the clipboard'
complete -c gopass -n '__fish_seen_subcommand_from find search' -f -l force -s f -d 'In the case of an exact match, display the password even if safecontent is enabled'
complete -c gopass -n '__fish_seen_subcommand_from fsck' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'fsck' -d 'Check store integrity'
complete -c gopass -n '__fish_seen_subcommand_from fsck' -f -l decrypt -d 'Decrypt during fsck'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'generate' -d 'Generate a new password'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l clip -s c -d 'Copy the generated password to the clipboard'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l print -s p -d 'Print the generated password to the terminal'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l force -s f -d 'Force to overwrite existing password'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l edit -s e -d 'Open secret for editing after generating a password'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l symbols -s s -d 'Use symbols in the password'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l memorable -s m -d 'Generate a memorable password'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l strict -d 'Require strict character class rules'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l xkcd -s x -d 'Use multiple random english words combined to a password. By default, space is used as separator and all words are lowercase'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l xkcdsep -s xs -r -d 'Word separator for generated xkcd style password. If no separator is specified, the words are combined without spaces/separator and the first character of words is capitalised. This flag implies -xkcd'
complete -c gopass -n '__fish_seen_subcommand_from generate' -f -l xkcdlang -s xl -r -d 'Language to generate password from, currently de (german) and en (english, default) are supported'
complete -c gopass -n '__fish_seen_subcommand_from git' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'git' -d 'Run a git command inside a password store (init, remote, push, pull)'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from git' -a 'init' -d 'Init git repo'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l sign-key -r -d 'GPG Key to sign commits'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l rcs -r -d 'Select sync backend (git, gitcli, noop)'
complete -c gopass -n '__fish_seen_subcommand_from remote' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from git' -a 'remote' -d 'Manage git remotes'
complete -c gopass -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from remote' -a 'add' -d 'Add git remote'
complete -c gopass -n '__fish_seen_subcommand_from add' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from remote' -a 'remove' -d 'Remove git remote'
complete -c gopass -n '__fish_seen_subcommand_from remove' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from push' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from git' -a 'push' -d 'Push to remote'
complete -c gopass -n '__fish_seen_subcommand_from push' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from pull' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from git' -a 'pull' -d 'Pull from remote'
complete -c gopass -n '__fish_seen_subcommand_from pull' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from status' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from git' -a 'status' -d 'RCS status'
complete -c gopass -n '__fish_seen_subcommand_from status' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from history hist' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'history hist' -d 'Show password history'
complete -c gopass -n '__fish_seen_subcommand_from history hist' -f -l password -s p -d 'Include passwords in output'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'init' -d 'Initialize new password store.'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l path -s p -r -d 'Set the sub-store path to operate on'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l store -s s -r -d 'Set the name of the sub-store'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l crypto -r -d 'Select crypto backend (gpg, gpgcli, plain, xc)'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l rcs -r -d 'Select sync backend (git, gitcli, noop)'
complete -c gopass -n '__fish_seen_subcommand_from init' -f -l nogit -d '(DEPRECATED): Select noop RCS backend. Use \'--rcs noop\' instead'
complete -c gopass -n '__fish_seen_subcommand_from insert' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'insert' -d 'Insert a new secret'
complete -c gopass -n '__fish_seen_subcommand_from insert' -f -l echo -s e -d 'Display secret while typing'
complete -c gopass -n '__fish_seen_subcommand_from insert' -f -l multiline -s m -d 'Insert using $EDITOR'
complete -c gopass -n '__fish_seen_subcommand_from insert' -f -l force -s f -d 'Overwrite any existing secret and do not prompt to confirm recipients'
complete -c gopass -n '__fish_seen_subcommand_from insert' -f -l append -s a -d 'Append to any existing data'
complete -c gopass -n '__fish_seen_subcommand_from jsonapi' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'jsonapi' -d 'Run and configure gopass as jsonapi e.g. for browser plugins'
complete -c gopass -n '__fish_seen_subcommand_from listen' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from jsonapi' -a 'listen' -d 'Listen and respond to messages via stdin/stdout'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from jsonapi' -a 'configure' -d 'Setup gopass native messaging manifest for selected browser'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l browser -r -d 'One of \'chrome\' and \'firefox\''
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l path -r -d 'Path to install \'gopass_wrapper.sh\' to'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l manifest-path -r -d 'Path to install \'com.justwatch.gopass.json\' to'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l global -d 'Install for all users, requires superuser rights'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l libpath -r -d 'Library path for global installation on linux. Default is /usr/lib'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l gopass-path -r -d 'Path to gopass binary. Default is auto detected'
complete -c gopass -n '__fish_seen_subcommand_from configure' -f -l print -d 'Print installation summary before creating any files'
complete -c gopass -n '__fish_seen_subcommand_from list ls' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'list ls' -d 'List existing secrets'
complete -c gopass -n '__fish_seen_subcommand_from list ls' -f -l limit -s l -r -d 'Max tree depth'
complete -c gopass -n '__fish_seen_subcommand_from list ls' -f -l flat -s f -d 'Print flat list'
complete -c gopass -n '__fish_seen_subcommand_from list ls' -f -l folders -s fo -d 'Print flat list of folders'
complete -c gopass -n '__fish_seen_subcommand_from list ls' -f -l strip-prefix -s s -d 'Strip prefix from filtered entries'
complete -c gopass -n '__fish_seen_subcommand_from mounts' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'mounts' -d 'Edit mounted stores'
complete -c gopass -n '__fish_seen_subcommand_from add mount' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from mounts' -a 'add mount' -d 'Mount a password store'
complete -c gopass -n '__fish_seen_subcommand_from add mount' -f -l init -s i -r -d 'Init the store with the given recipient key'
complete -c gopass -n '__fish_seen_subcommand_from remove rm unmount umount' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from mounts' -a 'remove rm unmount umount' -d 'Umount an mounted password store'
complete -c gopass -n '__fish_seen_subcommand_from move mv' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'move mv' -d 'Move secrets from one location to another'
complete -c gopass -n '__fish_seen_subcommand_from move mv' -f -l force -s f -d 'Force to move the secret and overwrite existing one'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'pwgen' -d 'Generate passwords'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l no-numerals -s 0 -d 'Do not include numerals in the generated passwords.'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l one-per-line -s 1 -d 'Print one password per line'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l xkcd -s x -d 'Use multiple random english words combined to a password. By default, space is used as separator and all words are lowercase'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l xkcdsep -s xs -r -d 'Word separator for generated xkcd style password. If no separator is specified, the words are combined without spaces/separator and the first character of words is capitalised. This flag implies -xkcd'
complete -c gopass -n '__fish_seen_subcommand_from pwgen' -f -l xkcdlang -s xl -r -d 'Language to generate password from, currently de (german) and en (english, default) are supported'
complete -c gopass -n '__fish_seen_subcommand_from recipients' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'recipients' -d 'Edit recipient permissions'
complete -c gopass -n '__fish_seen_subcommand_from add authorize' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from recipients' -a 'add authorize' -d 'Add any number of Recipients to any store'
complete -c gopass -n '__fish_seen_subcommand_from add authorize' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from add authorize' -f -l force -d 'Force adding non-existing keys'
complete -c gopass -n '__fish_seen_subcommand_from remove rm deauthorize' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from recipients' -a 'remove rm deauthorize' -d 'Remove any number of Recipients from any store'
complete -c gopass -n '__fish_seen_subcommand_from remove rm deauthorize' -f -l store -r -d 'Store to operate on'
complete -c gopass -n '__fish_seen_subcommand_from remove rm deauthorize' -f -l force -d 'Force adding non-existing keys'
complete -c gopass -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from recipients' -a 'update' -d 'Recompute the saved recipient list checksums'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'show' -d 'Display a secret'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l clip -s c -d 'Copy the first line of the secret into the clipboard'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l alsoclip -s C -d 'Copy the first line of the secret and show everything'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l qr -d 'Print the first line of the secret as QR Code'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l force -s f -d 'Display the password even if safecontent is enabled'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l password -s o -d 'Display only the password'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l sync -s s -d 'Sync before attempting to display the secret'
complete -c gopass -n '__fish_seen_subcommand_from show' -f -l revision -r -d 'Show a past revision'
complete -c gopass -n '__fish_seen_subcommand_from sync' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'sync' -d 'Sync all local stores with their remotes'
complete -c gopass -n '__fish_seen_subcommand_from sync' -f -l store -s s -r -d 'Select the store to sync'
complete -c gopass -n '__fish_seen_subcommand_from templates' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'templates' -d 'Edit templates'
complete -c gopass -n '__fish_seen_subcommand_from show cat' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from templates' -a 'show cat' -d 'Show a secret template.'
complete -c gopass -n '__fish_seen_subcommand_from edit create new' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from templates' -a 'edit create new' -d 'Edit secret templates.'
complete -c gopass -n '__fish_seen_subcommand_from remove rm' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_seen_subcommand_from templates' -a 'remove rm' -d 'Remove secret templates.'
complete -c gopass -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'update' -d 'Check for updates'
complete -c gopass -n '__fish_seen_subcommand_from update' -f -l pre -d 'Update to prereleases'
complete -c gopass -n '__fish_seen_subcommand_from version' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'version' -d 'Display version'
complete -c gopass -n '__fish_seen_subcommand_from help h' -f -l help -s h -d 'show help'
complete -r -c gopass -n '__fish_gopass_no_subcommand' -a 'help h' -d 'Shows a list of commands or help for one command'

