/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.apache.ivy.osgi.repo.RepoDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedRepoDescriptor
extends RepoDescriptor {
    private List<RepoDescriptor> repos;

    public AggregatedRepoDescriptor(List<RepoDescriptor> repos) {
        this.repos = repos;
    }

    @Override
    public Iterator<ModuleDescriptorWrapper> getModules() {
        final Iterator<RepoDescriptor> itRepos = this.repos.iterator();
        return new Iterator<ModuleDescriptorWrapper>(){
            private Iterator<ModuleDescriptorWrapper> current = null;
            private ModuleDescriptorWrapper next = null;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.current == null) {
                        if (!itRepos.hasNext()) {
                            return false;
                        }
                        RepoDescriptor repo = (RepoDescriptor)itRepos.next();
                        this.current = repo.getModules();
                    }
                    if (this.current.hasNext()) {
                        this.next = this.current.next();
                        continue;
                    }
                    this.current = null;
                }
                return true;
            }

            @Override
            public ModuleDescriptorWrapper next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ModuleDescriptorWrapper ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> getCapabilities() {
        HashSet<String> ret = new HashSet<String>();
        for (RepoDescriptor repo : this.repos) {
            Set<String> capabilities = repo.getCapabilities();
            if (capabilities == null) continue;
            ret.addAll(capabilities);
        }
        return ret;
    }

    @Override
    public Set<ModuleDescriptorWrapper> findModules(String requirement, String value) {
        HashSet<ModuleDescriptorWrapper> ret = new HashSet<ModuleDescriptorWrapper>();
        for (RepoDescriptor repo : this.repos) {
            Set<ModuleDescriptorWrapper> modules = repo.findModules(requirement, value);
            if (modules == null) continue;
            ret.addAll(modules);
        }
        return ret;
    }

    @Override
    public Set<String> getCapabilityValues(String capabilityName) {
        HashSet<String> ret = new HashSet<String>();
        for (RepoDescriptor repo : this.repos) {
            Set<String> capabilityValues = repo.getCapabilityValues(capabilityName);
            if (capabilityValues == null) continue;
            ret.addAll(capabilityValues);
        }
        return ret;
    }
}

