"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Unstable APIs that shouldn't be used in most circumstances.
 * @category Unstable APIs
 */
class UnstableApis {
    constructor(client) {
        this.client = client;
    }
    /**
     * Creates a group.
     * @param {string} localpart The localpart for the group
     * @return {Promise<string>} Resolves to the created group ID.
     */
    createGroup(localpart) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.client.doRequest("POST", "/_matrix/client/r0/create_group", null, { "localpart": localpart });
            return response["group_id"];
        });
    }
    /**
     * Invites a user to the group.
     * @param {string} groupId The group ID to invite the user to.
     * @param {string} userId The user ID to invite to the group.
     * @return {Promise<"join" | "invite" | "reject">} Resolves to the invite state for
     *  the user. This is normally "invite", but may be "join" or "reject" if the user's
     *  homeserver accepted/rejected the invite right away.
     */
    inviteUserToGroup(groupId, userId) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.client.doRequest("PUT", `/_matrix/client/r0/groups/${encodeURIComponent(groupId)}/admin/users/invite/${encodeURIComponent(userId)}`, null, {});
            return response["state"];
        });
    }
    /**
     * Updates a group's profile
     * @param {string} groupId The group ID to update.
     * @param {GroupProfile} profile The profile to update the group with.
     * @return {Promise<any>} Resolves when completed.
     */
    setGroupProfile(groupId, profile) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.client.doRequest("POST", `/_matrix/client/r0/groups/${encodeURIComponent(groupId)}/profile`, null, profile);
        });
    }
    /**
     * Sets a group's join policy to either be publicly joinable (open) or
     * require an invite (invite).
     * @param {string} groupId The group ID to set the policy for.
     * @param {"open" | "invite"} policy The policy to set.
     * @return {Promise<any>} Resolves when completed.
     */
    setGroupJoinPolicy(groupId, policy) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.client.doRequest("PUT", `/_matrix/client/r0/groups/${encodeURIComponent(groupId)}/settings/m.join_policy`, null, {
                "m.join_policy": {
                    "type": policy,
                },
            });
        });
    }
    /**
     * Adds a reaction to an event. The contract for this function may change in the future.
     * @param {string} roomId The room ID to react in
     * @param {string} eventId The event ID to react against, in the given room
     * @param {string} emoji The emoji to react with
     * @returns {Promise<string>} Resolves to the event ID of the reaction
     */
    addReactionToEvent(roomId, eventId, emoji) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.client.sendEvent(roomId, "m.reaction", {
                "m.relates_to": {
                    event_id: eventId,
                    key: emoji,
                    rel_type: "m.annotation",
                },
            });
        });
    }
}
exports.UnstableApis = UnstableApis;
