/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemOpenIconic
extends AbstractPSystem {
    private final String iconName;
    private final double factor;

    public PSystemOpenIconic(String iconName, double factor) {
        this.iconName = iconName;
        this.factor = factor;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        OpenIcon icon = OpenIcon.retrieve(this.iconName);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 5.0, 5.0, null, false);
        imageBuilder.setUDrawable(icon.asTextBlock(HColorUtils.BLACK, this.factor));
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Open iconic)");
    }
}

