/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.PlanUtils;
import net.sourceforge.plantuml.project.Solver3;
import net.sourceforge.plantuml.project.core.AbstractTask;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.time.Wink;

public class TaskImpl
extends AbstractTask
implements Task,
LoadPlanable {
    private final Solver3 solver;
    private final Map<Resource, Integer> resources2 = new LinkedHashMap<Resource, Integer>();
    private final LoadPlanable defaultPlan;
    private boolean diamond;
    private Url url;
    private ComplementColors colors;
    private int completion = 100;

    @Override
    public void setUrl(Url url) {
        this.url = url;
    }

    public TaskImpl(TaskCode code, LoadPlanable defaultPlan) {
        super(code);
        this.defaultPlan = defaultPlan;
        this.solver = new Solver3(this);
        this.setStart(new Wink(0));
        this.setLoad(Load.inWinks(1));
    }

    @Override
    public int getLoadAt(Wink instant) {
        LoadPlanable result = this.defaultPlan;
        if (this.resources2.size() > 0) {
            result = PlanUtils.multiply(this.defaultPlan, this.getRessourcePlan());
        }
        return result.getLoadAt(instant);
    }

    public int loadForResource(Resource res, Wink instant) {
        if (this.resources2.keySet().contains(res) && instant.compareTo(this.getStart()) >= 0 && instant.compareTo(this.getEnd()) <= 0) {
            if (res.isClosedAt(instant)) {
                return 0;
            }
            return this.resources2.get(res);
        }
        return 0;
    }

    private LoadPlanable getRessourcePlan() {
        if (this.resources2.size() == 0) {
            throw new IllegalStateException();
        }
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Wink instant) {
                int result = 0;
                for (Map.Entry ent : TaskImpl.this.resources2.entrySet()) {
                    Resource res = (Resource)ent.getKey();
                    if (res.isClosedAt(instant)) continue;
                    int percentage = (Integer)ent.getValue();
                    result += percentage;
                }
                return result;
            }
        };
    }

    public String getPrettyDisplay() {
        if (this.resources2.size() > 0) {
            StringBuilder result = new StringBuilder(this.code.getSimpleDisplay());
            result.append(" ");
            Iterator<Map.Entry<Resource, Integer>> it = this.resources2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Resource, Integer> ent = it.next();
                result.append("{");
                result.append(ent.getKey().getName());
                int percentage = ent.getValue();
                if (percentage != 100) {
                    result.append(":" + percentage + "%");
                }
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.code.getSimpleDisplay();
    }

    public String toString() {
        return this.code.toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getLoad() + "]";
    }

    @Override
    public TaskCode getCode() {
        return this.code;
    }

    @Override
    public Wink getStart() {
        Wink result = (Wink)this.solver.getData(TaskAttribute.START);
        while (this.getLoadAt(result) == 0) {
            result = result.increment();
        }
        return result;
    }

    @Override
    public Wink getEnd() {
        return (Wink)this.solver.getData(TaskAttribute.END);
    }

    @Override
    public Load getLoad() {
        return (Load)this.solver.getData(TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(Wink start) {
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(Wink end) {
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        this.resources2.put(resource, percentage);
    }

    @Override
    public void setDiamond(boolean diamond) {
        this.diamond = diamond;
    }

    @Override
    public boolean isDiamond() {
        return this.diamond;
    }

    @Override
    public void setCompletion(int completion) {
        this.completion = completion;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final ComplementColors getColors() {
        return this.colors;
    }

    public final int getCompletion() {
        return this.completion;
    }
}

