/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementPattern;

public class ComplementBeforeOrAfterOrAtTaskStartOrEnd
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexLeaf("COMPLEMENT" + suffix, "(?:at|with|after|(\\d+)[%s]+days?[%s]+(before|after))[%s]+\\[([^\\[\\]]+?)\\].?s[%s]+(start|end)");
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        String code = arg.get("COMPLEMENT" + suffix, 2);
        String position = arg.get("COMPLEMENT" + suffix, 3);
        Moment task = system.getExistingMoment(code);
        if (task == null) {
            return Failable.error("No such task " + code);
        }
        String days = arg.get("COMPLEMENT" + suffix, 0);
        TaskInstant result = new TaskInstant(task, TaskAttribute.fromString(position));
        if (days != null) {
            int delta = Integer.parseInt(days);
            if ("before".equalsIgnoreCase(arg.get("COMPLEMENT" + suffix, 1))) {
                delta = -delta;
            }
            result = result.withDelta(delta);
        }
        return Failable.ok(result);
    }
}

