/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public abstract class UGraphicUtils {
    public static void writeImage(OutputStream os, String metadata, FileFormatOption fileFormatOption, long seed, ColorMapper colorMapper, HColor background, TextBlock image) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage im = UGraphicUtils.createImage(colorMapper, background, image);
            PngIO.write((RenderedImage)im, os, fileFormatOption.isWithMetadata() ? metadata : null, 96);
        } else if (fileFormat == FileFormat.SVG) {
            Dimension2D size = UGraphicUtils.computeSize(colorMapper, background, image);
            UGraphicSvg svg = new UGraphicSvg(true, size, colorMapper, StringUtils.getAsHtml(colorMapper.getMappedColor(background)), false, 1.0, fileFormatOption.getSvgLinkTarget(), fileFormatOption.getHoverColor(), seed, fileFormatOption.getPreserveAspectRatio());
            image.drawU(svg);
            svg.createXml(os, fileFormatOption.isWithMetadata() ? metadata : null);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps ug = new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            image.drawU(ug);
            os.write(ug.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps ug = new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            image.drawU(ug);
            os.write(ug.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static BufferedImage createImage(ColorMapper colorMapper, HColor background, TextBlock image) {
        Dimension2D size = UGraphicUtils.computeSize(colorMapper, background, image);
        EmptyImageBuilder builder = new EmptyImageBuilder(size.getWidth(), size.getHeight(), colorMapper.getMappedColor(background));
        BufferedImage im = builder.getBufferedImage();
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(colorMapper, g2d, 1.0);
        image.drawU(ug);
        g2d.dispose();
        return im;
    }

    private static Dimension2D computeSize(ColorMapper colorMapper, HColor background, TextBlock image) {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, colorMapper.getMappedColor(background));
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d tmp = new UGraphicG2d(colorMapper, g2d, 1.0);
        Dimension2D size = image.calculateDimension(tmp.getStringBounder());
        g2d.dispose();
        return size;
    }
}

