/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import org.coode.mdock.DynamicConfigPanel;
import org.coode.mdock.NodePanel;
import org.coode.mdock.NodeReanimator;
import org.coode.mdock.NodeSerialiser;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.Util;
import org.coode.mdock.VerticalSplitterNode;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponentFactory;
import org.protege.editor.core.ui.view.ViewComponentPropertiesFactory;
import org.protege.editor.core.ui.view.ViewsPaneMemento;
import org.protege.editor.core.ui.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewsPane
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(ViewsPane.class);
    private ViewsPaneMemento memento;
    private DynamicConfigPanel dynamicConfigPanel;
    private NodePanel nodePanel;
    public static final String VIEW_LAYOUT_PREFERENCES_ID = "ViewLayoutPreferences";

    public ViewsPane(Workspace workspace, ViewsPaneMemento memento) {
        this.memento = memento;
        this.setLayout(new BorderLayout());
        String serialisedViews = this.readViewLayout();
        Reader reader = null;
        if (serialisedViews.length() != 0 && !memento.isForceReset()) {
            reader = new StringReader(serialisedViews);
        } else if (memento.getInitialCongigFileURL() != null) {
            try {
                reader = new InputStreamReader(new BufferedInputStream(memento.getInitialCongigFileURL().openStream()));
            }
            catch (IOException e) {
                this.logger.error("An error occurred whilst loading a views configuration file: {}", (Throwable)e);
            }
        }
        if (reader != null) {
            NodeReanimator nodeReanimator = new NodeReanimator(reader, new ViewComponentFactory(workspace));
            SplitterNode node = nodeReanimator.getRootNode();
            this.nodePanel = new NodePanel(node);
            this.add(this.nodePanel);
            this.dynamicConfigPanel = new DynamicConfigPanel(this.nodePanel);
        } else {
            VerticalSplitterNode node = new VerticalSplitterNode(Collections.emptyList(), Collections.emptyList());
            this.nodePanel = new NodePanel(node);
            this.add(this.nodePanel);
            this.dynamicConfigPanel = new DynamicConfigPanel(this.nodePanel);
        }
    }

    public void dispose() {
        this.logger.debug("Disposing of views");
        for (View view : this.getViews()) {
            view.dispose();
        }
    }

    public Set<View> getViews() {
        HashSet<View> views = new HashSet<View>();
        ViewsPane.getViews(this, views);
        return views;
    }

    private static void getViews(Component c, Set<View> result) {
        if (c instanceof View) {
            result.add((View)c);
        }
        if (c instanceof Container) {
            Component[] components;
            for (Component comp : components = ((Container)c).getComponents()) {
                ViewsPane.getViews(comp, result);
            }
        }
    }

    public void saveViews(Writer writer) {
        try {
            NodeSerialiser nodeSerialiser = new NodeSerialiser(this.nodePanel.getRootNode(), new ViewComponentPropertiesFactory(), writer);
            nodeSerialiser.serialise();
            writer.flush();
        }
        catch (IOException | ParserConfigurationException e) {
            this.logger.error("An error occurred whilst saving a views configuration file: {}", (Throwable)e);
        }
    }

    public void saveViews() {
        StringWriter writer = new StringWriter();
        this.saveViews(writer);
        this.storeViewLayout(writer.getBuffer().toString());
    }

    public boolean containsView(String id) {
        for (View view : this.getViews()) {
            if (!id.equals(view.getId())) continue;
            return true;
        }
        return false;
    }

    public void addView(View view, String label) {
        view.createUI();
        this.dynamicConfigPanel.setCurrentComponent(view, label);
        this.dynamicConfigPanel.activate();
    }

    public void bringViewToFront(String id) {
        for (View view : this.getViews()) {
            if (view.getId() == null || !view.getId().equals(id)) continue;
            Util.bringToFront(view);
        }
    }

    public static Preferences getViewLayoutPreferences() {
        PreferencesManager prefsMan = PreferencesManager.getInstance();
        return prefsMan.getApplicationPreferences(VIEW_LAYOUT_PREFERENCES_ID);
    }

    public String getLayoutPreferencesKey() {
        return "protege-4.1." + this.memento.getViewPaneId();
    }

    public void storeViewLayout(String serialisation) {
        ViewsPane.getViewLayoutPreferences().putString(this.getLayoutPreferencesKey(), serialisation);
    }

    public String readViewLayout() {
        return ViewsPane.getViewLayoutPreferences().getString(this.getLayoutPreferencesKey(), "");
    }
}

