import { Range } from 'vscode-languageserver/lib/main';
import { Point, SyntaxNode } from 'web-tree-sitter';
export declare function forEach(node: SyntaxNode, cb: (n: SyntaxNode) => void): void;
export declare function range(n: SyntaxNode): Range;
export declare function isDefinition(n: SyntaxNode): boolean;
export declare function isReference(n: SyntaxNode): boolean;
export declare function findParent(start: SyntaxNode, predicate: (n: SyntaxNode) => boolean): SyntaxNode | null;
/**
 * Given a tree and a point, try to find the named leaf node that the point corresponds to.
 * This is a helper for wordAtPoint, useful in cases where the point occurs at the boundary of
 * a word so the normal behavior of "namedDescendantForPosition" does not find the desired leaf.
 * For example, if you do
 * > (new Parser()).setLanguage(bash).parse("echo 42").rootNode.descendantForIndex(4).text
 * then you get 'echo 42', not the leaf node for 'echo'.
 *
 * TODO: the need for this function might reveal a flaw in tree-sitter-bash.
 */
export declare function namedLeafDescendantForPosition(point: Point, rootNode: SyntaxNode): SyntaxNode | null;
