/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class MeasurementTable
extends JDialog {
    Viewer vwr;
    private JTable measurementTable;
    private MeasurementTableModel measurementTableModel;
    int selectedMeasurementRow = -1;
    JButton deleteButton;
    JButton deleteAllButton;
    final Class<? extends String> stringClass = "".getClass();

    public MeasurementTable(Viewer vwr, JFrame parentFrame) {
        super(parentFrame, GT.$("Measurements"), false);
        this.vwr = vwr;
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.constructMeasurementTable(), "Center");
        JPanel foo = new JPanel();
        foo.setLayout(new BorderLayout());
        foo.add((Component)this.constructMeasurementButtonPanel(), "West");
        foo.add((Component)this.constructDismissButtonPanel(), "East");
        container.add((Component)foo, "South");
        this.addWindowListener(new MeasurementListWindowListener());
        this.getContentPane().add(container);
        this.pack();
        this.centerDialog();
    }

    JComponent constructMeasurementTable() {
        this.measurementTableModel = new MeasurementTableModel();
        this.measurementTable = new JTable(this.measurementTableModel);
        this.measurementTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.measurementTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int i = 5;
        while (--i > 0) {
            this.measurementTable.getColumnModel().getColumn(i).setPreferredWidth(15);
        }
        this.measurementTable.setSelectionMode(0);
        this.measurementTable.setRowSelectionAllowed(true);
        this.measurementTable.setColumnSelectionAllowed(false);
        ListSelectionModel measurementSelection = this.measurementTable.getSelectionModel();
        measurementSelection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    MeasurementTable.this.selectedMeasurementRow = -1;
                    MeasurementTable.this.deleteButton.setEnabled(false);
                } else {
                    MeasurementTable.this.selectedMeasurementRow = lsm.getMinSelectionIndex();
                    MeasurementTable.this.deleteButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.measurementTable);
    }

    JComponent constructMeasurementButtonPanel() {
        JPanel measurementButtonPanel = new JPanel();
        measurementButtonPanel.setLayout(new FlowLayout(0));
        this.deleteButton = new JButton(GT.$("Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.vwr.script("measures delete " + (MeasurementTable.this.selectedMeasurementRow + 1) + "\u0001## EDITOR_IGNORE ##");
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteAllButton = new JButton(GT.$("DeleteAll"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.vwr.script("measures delete\u0001## EDITOR_IGNORE ##");
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteAllButton.setEnabled(false);
        measurementButtonPanel.add(this.deleteAllButton);
        measurementButtonPanel.add(this.deleteButton);
        return measurementButtonPanel;
    }

    JComponent constructDismissButtonPanel() {
        JPanel dismissButtonPanel = new JPanel();
        dismissButtonPanel.setLayout(new FlowLayout(2));
        JButton dismissButton = new JButton(GT.$("Dismiss"));
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurementTable.this.close();
            }
        });
        dismissButtonPanel.add(dismissButton);
        this.getRootPane().setDefaultButton(dismissButton);
        return dismissButtonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateMeasurementTableData();
        this.setVisible(true);
    }

    void updateMeasurementTableData() {
        this.deleteAllButton.setEnabled(this.vwr.getMeasurementCount() > 0);
        this.measurementTableModel.fireTableDataChanged();
    }

    public void updateTables() {
        this.updateMeasurementTableData();
    }

    class MeasurementTableModel
    extends AbstractTableModel {
        final String[] measurementHeaders = new String[]{GT.$("Value"), "a", "b", "c", "d"};

        MeasurementTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.measurementHeaders[col];
        }

        @Override
        public int getRowCount() {
            return MeasurementTable.this.vwr.getMeasurementCount();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class<? extends String> getColumnClass(int col) {
            return MeasurementTable.this.stringClass;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                MeasurementTable.this.deleteAllButton.setEnabled(true);
                return MeasurementTable.this.vwr.getMeasurementStringValue(row);
            }
            int[] countPlusIndices = MeasurementTable.this.vwr.getMeasurementCountPlusIndices(row);
            if (countPlusIndices == null || col > countPlusIndices[0]) {
                return null;
            }
            int atomIndex = countPlusIndices[col];
            return MeasurementTable.this.vwr.getAtomInfo(atomIndex >= 0 ? atomIndex : -row * 10 - col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class MeasurementListWindowListener
    extends WindowAdapter {
        MeasurementListWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MeasurementTable.this.close();
        }
    }
}

