/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.io.importexport.ValidatorErrorExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.validation.PaintVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;

public class ValidatorLayer
extends Layer
implements LayerManager.LayerChangeListener {
    private final Runnable invalidator = this::invalidate;

    public ValidatorLayer() {
        super(I18n.tr("Validation errors", new Object[0]));
        MainApplication.getLayerManager().addLayerChangeListener(this);
        MainApplication.getMap().validatorDialog.tree.addInvalidationListener(this.invalidator);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "validator_small");
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        DefaultMutableTreeNode root = MainApplication.getMap().validatorDialog.tree.getRoot();
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        PaintVisitor paintVisitor = new PaintVisitor(g, mv);
        for (DefaultMutableTreeNode severity = (DefaultMutableTreeNode)root.getLastChild(); severity != null; severity = severity.getPreviousSibling()) {
            ValidatorTreePanel.visitTestErrors(severity, paintVisitor::visit);
        }
        paintVisitor.clearPaintedObjects();
    }

    @Override
    public String getToolTipText() {
        MultiMap<Severity, TestError> errorTree = new MultiMap<Severity, TestError>();
        List<TestError> errors = MainApplication.getMap().validatorDialog.tree.getErrors();
        for (TestError e : errors) {
            errorTree.put(e.getSeverity(), e);
        }
        StringBuilder b = new StringBuilder();
        for (Severity s : Severity.values()) {
            if (!errorTree.containsKey(s)) continue;
            b.append(I18n.tr(s.toString(), new Object[0])).append(": ").append(errorTree.get(s).size()).append("<br>");
        }
        if (b.length() == 0) {
            return "<html>" + I18n.tr("No validation errors", new Object[0]) + "</html>";
        }
        return "<html>" + I18n.tr("Validation errors", new Object[0]) + ":<br>" + b + "</html>";
    }

    @Override
    public void mergeFrom(Layer from) {
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this), new Layer.LayerSaveAsAction(this)};
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Validation errors file", new Object[0]), ValidatorErrorExporter.FILE_FILTER);
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof OsmDataLayer && e.getSource().getLayersOfType(OsmDataLayer.class).size() <= 1) {
            e.scheduleRemoval(Collections.singleton(this));
        } else if (e.getRemovedLayer() == this) {
            OsmValidator.resetErrorLayer();
        }
    }

    @Override
    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.IN_FRONT;
    }

    @Override
    public synchronized void destroy() {
        MainApplication.getMap().validatorDialog.tree.removeInvalidationListener(this.invalidator);
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        super.destroy();
    }

    @Override
    public String getChangesetSourceTag() {
        return "JOSM Validator";
    }
}

