/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.math.ScientificEquationSafe;

public class CommandCreoleMath
implements Command {
    private final Pattern2 pattern;
    private final double scale;

    private CommandCreoleMath(String p, double scale) {
        this.pattern = MyPattern.cmpile(p);
        this.scale = scale;
    }

    public static Command create(double scale) {
        return new CommandCreoleMath("^(?i)(\\<math\\>(.+?)\\</math\\>)", scale);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String math = m.group(2);
        stripe.addMath(ScientificEquationSafe.fromAsciiMath(math), this.scale);
        return line.substring(m.group(1).length());
    }
}

