/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.PathUtils;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawRegular
extends AbstractTaskDraw {
    private static final HColor defaultColor = HColorSet.instance().getColorIfValid("GreenYellow");
    private ComplementColors colors;
    private int completion = 100;
    private Url url;
    private final Wink end;
    private final boolean oddStart;
    private final boolean oddEnd;
    private final double margin = 2.0;

    public TaskDrawRegular(TimeScale timeScale, double y, String prettyDisplay, Wink start, Wink end, boolean oddStart, boolean oddEnd) {
        super(timeScale, y, prettyDisplay, start);
        this.end = end;
        this.oddStart = oddStart;
        this.oddEnd = oddEnd;
    }

    @Override
    public void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h = (2.0 + this.getShapeHeight() - titleHeight) / 2.0;
        double endingPosition = this.timeScale.getEndingPosition(this.start);
        title.drawU(ug.apply(new UTranslate(endingPosition, h)));
    }

    @Override
    protected FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug1) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(startPos + 2.0, 2.0));
        this.drawShape(ug2);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(HColorUtils.BLUE).apply(defaultColor.bg());
    }

    private void drawShape(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        double fullLength = endPos - startPos - 4.0;
        if (fullLength < 10.0) {
            return;
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.oddStart && !this.oddEnd) {
            ug.draw(PathUtils.UtoRight(fullLength, this.getShapeHeight()));
            return;
        }
        if (!this.oddStart && this.oddEnd) {
            ug.draw(PathUtils.UtoLeft(fullLength, this.getShapeHeight()));
            return;
        }
        URectangle full = new URectangle(fullLength, this.getShapeHeight()).rounded(8.0);
        if (this.completion == 100) {
            ug.draw(full);
        } else {
            double partialLength = fullLength * (double)this.completion / 100.0;
            ug.apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(full);
            if (partialLength > 2.0) {
                URectangle partial = new URectangle(partialLength, this.getShapeHeight()).rounded(8.0);
                ug.apply(new HColorNone()).draw(partial);
            }
            if (partialLength > 10.0 && partialLength < fullLength - 10.0) {
                URectangle patch = new URectangle(8.0, this.getShapeHeight());
                ug.apply(new HColorNone()).apply(UTranslate.dx(partialLength - 8.0)).draw(patch);
            }
            ug.apply(new HColorNone().bg()).draw(full);
        }
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public void setColorsAndCompletion(ComplementColors colors, int completion, Url url) {
        this.colors = colors;
        this.completion = completion;
        this.url = url;
    }
}

