/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.report.DownloadStatus;

public class ArtifactDownloadReport {
    private Artifact artifact;
    private ArtifactOrigin origin;
    private File localFile;
    private DownloadStatus downloadStatus;
    private long size;
    private String downloadDetails = "";
    private long downloadTimeMillis;

    public ArtifactDownloadReport(Artifact artifact) {
        this.artifact = artifact;
    }

    public final DownloadStatus getDownloadStatus() {
        return this.downloadStatus;
    }

    public final void setDownloadStatus(DownloadStatus downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public final String getName() {
        return this.artifact.getName();
    }

    public final String getType() {
        return this.artifact.getType();
    }

    public final Artifact getArtifact() {
        return this.artifact;
    }

    public final String getExt() {
        return this.artifact.getExt();
    }

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long l) {
        this.size = l;
    }

    public final void setArtifactOrigin(ArtifactOrigin artifactOrigin) {
        this.origin = artifactOrigin;
    }

    public final ArtifactOrigin getArtifactOrigin() {
        return this.origin;
    }

    public final void setDownloadDetails(String string) {
        this.downloadDetails = string;
    }

    public final String getDownloadDetails() {
        return this.downloadDetails;
    }

    public final void setDownloadTimeMillis(long l) {
        this.downloadTimeMillis = l;
    }

    public final long getDownloadTimeMillis() {
        return this.downloadTimeMillis;
    }

    public String toString() {
        if (this.downloadStatus == DownloadStatus.SUCCESSFUL) {
            return "[SUCCESSFUL ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.FAILED) {
            if (this.downloadDetails == "missing artifact") {
                return "[NOT FOUND  ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
            }
            return "[FAILED     ] " + this.artifact + ": " + this.downloadDetails + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.NO) {
            return "[NOT REQUIRED] " + this.artifact;
        }
        return super.toString();
    }

    public final File getLocalFile() {
        return this.localFile;
    }

    public final void setLocalFile(File file2) {
        this.localFile = file2;
    }

    public final boolean isDownloaded() {
        return DownloadStatus.SUCCESSFUL == this.downloadStatus;
    }

    public int hashCode() {
        return 31 + (this.artifact == null ? 0 : this.artifact.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object;
        return !(this.artifact == null ? artifactDownloadReport.artifact != null : !this.artifact.equals(artifactDownloadReport.artifact));
    }
}

