/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.functional;

public abstract class Either<L, R> {
    private Either() {
    }

    public static <L, R> Left<L, R> leftProjection(Either<L, R> either) throws NotLeftException {
        if (either.isLeft()) {
            return (Left)either;
        }
        throw new NotLeftException();
    }

    public static <L, R> Right<L, R> rightProjection(Either<L, R> either) throws NotRightException {
        if (either.isRight()) {
            return (Right)either;
        }
        throw new NotRightException();
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public R get() {
        if (this.isRight()) {
            return Either.rightProjection(this).getValue();
        }
        throw new NotRightException();
    }

    public static <T> T getOrElse(Either<?, ? extends T> either, T t) {
        return either.isRight() ? either.get() : t;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static <L, R, T extends L> Either<L, R> left(T t) {
        return new Left(t);
    }

    public static <L, R, T extends R> Either<L, R> right(T t) {
        return new Right(t);
    }

    public static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        Right(R r) {
            this.value = r;
        }

        public R getValue() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        public String toString() {
            return "Right(" + this.value + ")";
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Right && this.value.equals(((Right)object).getValue());
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        Left(L l) {
            this.value = l;
        }

        public L getValue() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        public String toString() {
            return "Left(" + this.value + ")";
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Left && this.value.equals(((Left)object).getValue());
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class NotRightException
    extends RuntimeException {
    }

    public static class NotLeftException
    extends RuntimeException {
    }
}

