/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.SField;
import org.objectweb.asm.Type;

public final class ERegex
extends AExpression {
    private final String pattern;
    private final int flags;
    private Constant constant;

    public ERegex(Location location, String pattern, String flagsString) {
        super(location);
        this.pattern = pattern;
        int flags = 0;
        for (int c = 0; c < flagsString.length(); ++c) {
            flags |= this.flagForChar(flagsString.charAt(c));
        }
        this.flags = flags;
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (!scriptRoot.getCompilerSettings().areRegexesEnabled()) {
            throw this.createError(new IllegalStateException("Regexes are disabled. Set [script.painless.regex.enabled] to [true] in elasticsearch.yaml to allow them. Be careful though, regexes break out of Painless's protection against deep recursion and long loops."));
        }
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Regex constant may only be read [" + this.pattern + "]."));
        }
        try {
            Pattern.compile(this.pattern, this.flags);
        }
        catch (PatternSyntaxException e) {
            throw new Location(this.location.getSourceName(), this.location.getOffset() + 1 + e.getIndex()).createError(new IllegalArgumentException("Error compiling regex: " + e.getDescription()));
        }
        String name = scriptRoot.getNextSyntheticName("regex");
        scriptRoot.getClassNode().addField(new SField(this.location, 26, name, Pattern.class, null));
        this.constant = new Constant(this.location, MethodWriter.getType(Pattern.class), name, this::initializeConstant);
        this.actual = Pattern.class;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        methodWriter.getStatic(WriterConstants.CLASS_TYPE, this.constant.name, Type.getType(Pattern.class));
        globals.addConstantInitializer(this.constant);
    }

    private void initializeConstant(MethodWriter writer) {
        writer.push(this.pattern);
        writer.push(this.flags);
        writer.invokeStatic(Type.getType(Pattern.class), WriterConstants.PATTERN_COMPILE);
    }

    private int flagForChar(char c) {
        switch (c) {
            case 'c': {
                return 128;
            }
            case 'i': {
                return 2;
            }
            case 'l': {
                return 16;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'U': {
                return 256;
            }
            case 'u': {
                return 64;
            }
            case 'x': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown flag [" + c + "]");
    }

    @Override
    public String toString() {
        StringBuilder f = new StringBuilder();
        if ((this.flags & 0x80) != 0) {
            f.append('c');
        }
        if ((this.flags & 2) != 0) {
            f.append('i');
        }
        if ((this.flags & 0x10) != 0) {
            f.append('l');
        }
        if ((this.flags & 8) != 0) {
            f.append('m');
        }
        if ((this.flags & 0x20) != 0) {
            f.append('s');
        }
        if ((this.flags & 0x100) != 0) {
            f.append('U');
        }
        if ((this.flags & 0x40) != 0) {
            f.append('u');
        }
        if ((this.flags & 4) != 0) {
            f.append('x');
        }
        String p = "/" + this.pattern + "/";
        if (f.length() == 0) {
            return this.singleLineToString(p);
        }
        return this.singleLineToString(p, f);
    }
}

