/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AbstractRareTermsAggregator<T extends ValuesSource, U extends IncludeExclude.Filter, V>
extends DeferableBucketAggregator {
    static final BucketOrder ORDER = BucketOrder.compound(BucketOrder.count(true), BucketOrder.key(true));
    protected final long maxDocCount;
    protected final double precision;
    protected final DocValueFormat format;
    protected final T valuesSource;
    protected final U includeExclude;
    MergingBucketsDeferringCollector deferringCollector;
    final SetBackedScalingCuckooFilter filter;

    AbstractRareTermsAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, long maxDocCount, double precision, DocValueFormat format, T valuesSource, U includeExclude) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.filter = new SetBackedScalingCuckooFilter(10000, new Random(context.indexShard().shardId().hashCode()), precision);
        this.filter.registerBreaker(this::addRequestCircuitBreakerBytes);
        this.maxDocCount = maxDocCount;
        this.precision = precision;
        this.format = format;
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        String scoringAgg = this.subAggsNeedScore();
        String nestedAgg = this.descendsFromNestedAggregator(parent);
        if (scoringAgg != null && nestedAgg != null) {
            throw new IllegalStateException("RareTerms agg [" + this.name() + "] is the child of the nested agg [" + nestedAgg + "], and also has a scoring child agg [" + scoringAgg + "].  This combination is not supported because it requires executing in [depth_first] mode, which the RareTerms agg cannot do.");
        }
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, AbstractRareTermsAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    private String subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return subAgg.name();
        }
        return null;
    }

    private String descendsFromNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == NestedAggregator.class) {
                return parent.name();
            }
            parent = parent.parent();
        }
        return null;
    }

    protected void doCollect(LeafBucketCollector subCollector, V val, int docId) throws IOException {
        long bucketOrdinal = this.addValueToOrds(val);
        if (bucketOrdinal < 0L) {
            bucketOrdinal = -1L - bucketOrdinal;
            this.collectExistingBucket(subCollector, docId, bucketOrdinal);
        } else {
            this.collectBucket(subCollector, docId, bucketOrdinal);
        }
    }

    abstract long addValueToOrds(V var1);
}

