/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.util.List;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginClassLoader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class PluginProxy
extends Plugin {
    private final Object plugin;
    private final PluginClassLoader classLoader;

    public PluginProxy(Object plugin, PluginInformation info, PluginClassLoader classLoader) {
        super(info);
        this.plugin = plugin;
        this.classLoader = classLoader;
    }

    public Object getPlugin() {
        return this.plugin;
    }

    public PluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void handlePluginException(Throwable e) {
        PluginHandler.pluginLoadingExceptions.put(this.getPluginInformation().name, e);
        BugReportExceptionHandler.handleException(new PluginException(this, this.getPluginInformation().name, e));
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        try {
            this.plugin.getClass().getMethod("mapFrameInitialized", MapFrame.class, MapFrame.class).invoke(this.plugin, oldFrame, newFrame);
        }
        catch (NoSuchMethodException e) {
            Logging.trace(e);
            Logging.debug("Plugin " + this.plugin + " does not define mapFrameInitialized");
        }
        catch (IllegalArgumentException | NoClassDefFoundError | ReflectiveOperationException e) {
            this.handlePluginException(e);
        }
    }

    @Override
    public PreferenceSetting getPreferenceSetting() {
        try {
            return (PreferenceSetting)this.plugin.getClass().getMethod("getPreferenceSetting", new Class[0]).invoke(this.plugin, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Logging.trace(e);
            Logging.debug("Plugin " + this.plugin + " does not define getPreferenceSetting");
            return null;
        }
        catch (IllegalArgumentException | NoClassDefFoundError | ReflectiveOperationException e) {
            this.handlePluginException(e);
            return null;
        }
    }

    @Override
    public void addDownloadSelection(List<DownloadSelection> list) {
        try {
            this.plugin.getClass().getMethod("addDownloadSelection", List.class).invoke(this.plugin, list);
        }
        catch (NoSuchMethodException e) {
            Logging.trace(e);
            Logging.debug("Plugin " + this.plugin + " does not define addDownloadSelection");
        }
        catch (IllegalArgumentException | NoClassDefFoundError | ReflectiveOperationException e) {
            this.handlePluginException(e);
        }
    }
}

