/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.Ivy;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ArtifactOrigin;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.CacheDownloadOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.CacheMetadataOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.CacheResourceOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.CacheUtil;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.DownloadListener;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ModuleDescriptorMemoryCache;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.RepositoryCacheManager;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRules;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.pack.PackagingManager;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.DownloadStatus;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.IvySettingsAware;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.lock.LockStrategy;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MapMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.NoMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ParserSettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.LocalizableResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.Repository;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.ResourceDownloader;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.ResourceHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.AbstractResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Checks;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.FileUtil;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.HexEncoder;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.PropertiesFile;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.StringUtils;

public class DefaultRepositoryCacheManager
implements RepositoryCacheManager,
IvySettingsAware {
    private static final String DEFAULT_ARTIFACT_PATTERN = "[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])";
    private static final String DEFAULT_DATA_FILE_PATTERN = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private static final String DEFAULT_IVY_PATTERN = "[organisation]/[module](/[branch])/ivy-[revision].xml";
    private static final int DEFAULT_MEMORY_CACHE_SIZE = 150;
    private static MessageDigest SHA_DIGEST;
    private IvySettings settings;
    private File basedir;
    private LockStrategy lockStrategy;
    private String name;
    private String ivyPattern;
    private String dataFilePattern = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private String artifactPattern;
    private String lockStrategyName;
    private String changingPattern;
    private String changingMatcherName = "exactOrRegexp";
    private Boolean checkmodified;
    private Boolean useOrigin;
    private ModuleRules<Long> ttlRules = new ModuleRules();
    private Long defaultTTL = null;
    private ModuleDescriptorMemoryCache memoryModuleDescrCache;
    private PackagingManager packagingManager = new PackagingManager();
    private final List<ConfiguredTTL> configuredTTLs = new ArrayList<ConfiguredTTL>();
    private static final Pattern DURATION_PATTERN;
    private static final int MILLIS_IN_SECONDS = 1000;
    private static final int MILLIS_IN_MINUTES = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;
    private static final Pattern ARTIFACT_KEY_PATTERN;

    public DefaultRepositoryCacheManager() {
    }

    public DefaultRepositoryCacheManager(String name, IvySettings settings, File basedir) {
        this.setName(name);
        this.setSettings(settings);
        this.setBasedir(basedir);
    }

    public IvySettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(IvySettings settings) {
        this.settings = settings;
        this.packagingManager.setSettings(settings);
        for (ConfiguredTTL configuredTTL : this.configuredTTLs) {
            this.addTTL(configuredTTL.attributes, configuredTTL.matcher == null ? ExactPatternMatcher.INSTANCE : settings.getMatcher(configuredTTL.matcher), configuredTTL.duration);
        }
        this.configuredTTLs.clear();
    }

    public File getIvyFileInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getIvyPattern(), DefaultArtifact.newIvyArtifact(mrid, null));
        return new File(this.getRepositoryCacheRoot(), file);
    }

    public String getIvyPattern() {
        if (this.ivyPattern == null) {
            if (this.settings != null) {
                this.ivyPattern = this.settings.getDefaultCacheIvyPattern();
            }
            if (this.ivyPattern == null) {
                this.ivyPattern = DEFAULT_IVY_PATTERN;
            }
        }
        return this.ivyPattern;
    }

    public String getArtifactPattern() {
        if (this.artifactPattern == null) {
            if (this.settings != null) {
                this.artifactPattern = this.settings.getDefaultCacheArtifactPattern();
            }
            if (this.artifactPattern == null) {
                this.artifactPattern = DEFAULT_ARTIFACT_PATTERN;
            }
        }
        return this.artifactPattern;
    }

    public void setArtifactPattern(String artifactPattern) {
        CacheUtil.checkCachePattern(artifactPattern);
        this.artifactPattern = artifactPattern;
    }

    public File getBasedir() {
        if (this.basedir == null) {
            this.basedir = this.settings.getDefaultRepositoryCacheBasedir();
        }
        return this.basedir;
    }

    public void setBasedir(File cache) {
        this.basedir = cache;
    }

    public long getDefaultTTL() {
        if (this.defaultTTL == null) {
            this.defaultTTL = this.parseDuration(this.settings.getVariable("ivy.cache.ttl.default"));
        }
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public void setDefaultTTL(String defaultTTL) {
        this.defaultTTL = this.parseDuration(defaultTTL);
    }

    public String getDataFilePattern() {
        return this.dataFilePattern;
    }

    public void setDataFilePattern(String dataFilePattern) {
        CacheUtil.checkCachePattern(dataFilePattern);
        this.dataFilePattern = dataFilePattern;
    }

    public void setIvyPattern(String ivyPattern) {
        CacheUtil.checkCachePattern(ivyPattern);
        this.ivyPattern = ivyPattern;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChangingMatcherName() {
        return this.changingMatcherName;
    }

    public void setChangingMatcher(String changingMatcherName) {
        this.changingMatcherName = changingMatcherName;
    }

    public String getChangingPattern() {
        return this.changingPattern;
    }

    public void setChangingPattern(String changingPattern) {
        this.changingPattern = changingPattern;
    }

    public void addTTL(Map<String, String> attributes, PatternMatcher matcher, long duration) {
        this.ttlRules.defineRule(new MapMatcher(attributes, matcher), duration);
    }

    public void addConfiguredTtl(Map<String, String> attributes) {
        String durationValue = attributes.get("duration");
        if (durationValue == null) {
            throw new IllegalArgumentException("'duration' attribute is mandatory for ttl");
        }
        long duration = this.parseDuration(durationValue);
        ConfiguredTTL configuredTTL = new ConfiguredTTL(duration, attributes.get("matcher"), attributes);
        this.configuredTTLs.add(configuredTTL);
    }

    public void setMemorySize(int size) {
        this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache(size);
    }

    public ModuleDescriptorMemoryCache getMemoryCache() {
        if (this.memoryModuleDescrCache == null) {
            this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache(150);
        }
        return this.memoryModuleDescrCache;
    }

    private long parseDuration(String duration) {
        if (duration == null) {
            return 0L;
        }
        if ("eternal".equals(duration)) {
            return Long.MAX_VALUE;
        }
        Matcher m = DURATION_PATTERN.matcher(duration);
        if (m.matches()) {
            int days = this.getGroupIntValue(m, 1);
            int hours = this.getGroupIntValue(m, 2);
            int minutes = this.getGroupIntValue(m, 3);
            int seconds = this.getGroupIntValue(m, 4);
            int millis = this.getGroupIntValue(m, 5);
            return days * 86400000 + hours * 3600000 + minutes * 60000 + seconds * 1000 + millis;
        }
        throw new IllegalArgumentException("invalid duration '" + duration + "': it must match " + DURATION_PATTERN.pattern() + " or 'eternal'");
    }

    private int getGroupIntValue(Matcher m, int groupNumber) {
        String g = m.group(groupNumber);
        return StringUtils.isNullOrEmpty(g) ? 0 : Integer.parseInt(g);
    }

    public boolean isCheckmodified() {
        if (this.checkmodified == null) {
            return this.getSettings() != null && Boolean.parseBoolean(this.getSettings().getVariable("ivy.resolver.default.check.modified"));
        }
        return this.checkmodified;
    }

    public void setCheckmodified(boolean check2) {
        this.checkmodified = check2;
    }

    public boolean isUseOrigin() {
        if (this.useOrigin == null) {
            return this.getSettings() != null && this.getSettings().isDefaultUseOrigin();
        }
        return this.useOrigin;
    }

    public void setUseOrigin(boolean b) {
        this.useOrigin = b;
    }

    public File getArchiveFileInCache(Artifact artifact) {
        ArtifactOrigin origin = this.getSavedArtifactOrigin(artifact);
        return this.getArchiveFileInCache(artifact, origin);
    }

    public File getArchiveFileInCache(Artifact artifact, ArtifactOrigin origin) {
        File original;
        File archive = new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, origin));
        if (!archive.exists() && !ArtifactOrigin.isUnknown(origin) && origin.isLocal() && (original = Checks.checkAbsolute(origin.getLocation(), artifact + " origin location")).exists()) {
            return original;
        }
        return archive;
    }

    private File getArchiveFileInCache(Artifact artifact, ArtifactOrigin origin, boolean useOrigin) {
        if (useOrigin && !ArtifactOrigin.isUnknown(origin) && origin.isLocal()) {
            return Checks.checkAbsolute(origin.getLocation(), artifact + " origin location");
        }
        return new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, origin));
    }

    public String getArchivePathInCache(Artifact artifact) {
        return IvyPatternHelper.substitute(this.getArtifactPattern(), artifact);
    }

    public String getArchivePathInCache(Artifact artifact, ArtifactOrigin origin) {
        if (this.isOriginalMetadataArtifact(artifact)) {
            return IvyPatternHelper.substitute(this.getIvyPattern() + ".original", artifact, origin);
        }
        return IvyPatternHelper.substitute(this.getArtifactPattern(), artifact, origin);
    }

    private void saveResolver(ModuleDescriptor md, String name) {
        PropertiesFile cdf = this.getCachedDataFile(md);
        cdf.setProperty("resolver", name);
        cdf.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResolvers(ModuleDescriptor md, String metadataResolverName, String artifactResolverName) {
        ModuleRevisionId mrid = md.getResolvedModuleRevisionId();
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return;
        }
        try {
            PropertiesFile cdf = this.getCachedDataFile(md);
            cdf.setProperty("resolver", metadataResolverName);
            cdf.setProperty("artifact.resolver", artifactResolverName);
            cdf.save();
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    private String getSavedResolverName(ModuleDescriptor md) {
        PropertiesFile cdf = this.getCachedDataFile(md);
        return cdf.getProperty("resolver");
    }

    private String getSavedArtResolverName(ModuleDescriptor md) {
        PropertiesFile cdf = this.getCachedDataFile(md);
        return cdf.getProperty("artifact.resolver");
    }

    void saveArtifactOrigin(Artifact artifact, ArtifactOrigin origin) {
        PropertiesFile cdf = this.getCachedDataFile(artifact.getModuleRevisionId());
        cdf.setProperty(this.getIsLocalKey(artifact), String.valueOf(origin.isLocal()));
        cdf.setProperty(this.getLocationKey(artifact), origin.getLocation());
        cdf.setProperty(this.getOriginalKey(artifact), this.getPrefixKey(origin.getArtifact()));
        if (origin.getLastChecked() != null) {
            cdf.setProperty(this.getLastCheckedKey(artifact), origin.getLastChecked().toString());
        }
        cdf.setProperty(this.getExistsKey(artifact), Boolean.toString(origin.isExists()));
        cdf.save();
    }

    private void removeSavedArtifactOrigin(Artifact artifact) {
        PropertiesFile cdf = this.getCachedDataFile(artifact.getModuleRevisionId());
        cdf.remove(this.getLocationKey(artifact));
        cdf.remove(this.getIsLocalKey(artifact));
        cdf.remove(this.getLastCheckedKey(artifact));
        cdf.remove(this.getOriginalKey(artifact));
        cdf.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactOrigin getSavedArtifactOrigin(Artifact artifact) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return ArtifactOrigin.unknown(artifact);
        }
        try {
            boolean isLocal;
            String exists;
            String lastChecked;
            String location;
            block16: {
                PropertiesFile cdf;
                block15: {
                    cdf = this.getCachedDataFile(artifact.getModuleRevisionId());
                    location = cdf.getProperty(this.getLocationKey(artifact));
                    String local = cdf.getProperty(this.getIsLocalKey(artifact));
                    lastChecked = cdf.getProperty(this.getLastCheckedKey(artifact));
                    exists = cdf.getProperty(this.getExistsKey(artifact));
                    String original = cdf.getProperty(this.getOriginalKey(artifact));
                    isLocal = Boolean.valueOf(local);
                    if (location == null) {
                        ArtifactOrigin artifactOrigin = ArtifactOrigin.unknown(artifact);
                        return artifactOrigin;
                    }
                    if (original == null) break block15;
                    Matcher m = ARTIFACT_KEY_PATTERN.matcher(original);
                    if (!m.matches()) break block16;
                    String origName = m.group(1);
                    String string = m.group(2);
                    String origExt = m.group(3);
                    ArtifactRevisionId originArtifactId = ArtifactRevisionId.newInstance(artifact.getModuleRevisionId(), origName, string, origExt);
                    if (m.group(4).equals("" + originArtifactId.hashCode())) {
                        try {
                            artifact = new DefaultArtifact(originArtifactId, artifact.getPublicationDate(), new URL(location), true);
                        }
                        catch (MalformedURLException e) {
                            Message.debug(e);
                        }
                    }
                    break block16;
                }
                if (!location.endsWith("." + artifact.getExt())) {
                    String ownLocationKey = this.getLocationKey(artifact);
                    for (Map.Entry entry : cdf.entrySet()) {
                        Matcher m;
                        if (!entry.getValue().equals(location) || ownLocationKey.equals(entry.getKey()) || !(m = ARTIFACT_KEY_PATTERN.matcher((String)entry.getKey())).matches()) continue;
                        String origName = m.group(1);
                        String origType = m.group(2);
                        String origExt = m.group(3);
                        if (!origType.endsWith(".original")) continue;
                        ArtifactRevisionId originArtifactId = ArtifactRevisionId.newInstance(artifact.getModuleRevisionId(), origName, origType, origExt);
                        if (!m.group(4).equals("" + originArtifactId.hashCode())) break;
                        try {
                            artifact = new DefaultArtifact(originArtifactId, artifact.getPublicationDate(), new URL(location), true);
                        }
                        catch (MalformedURLException e) {
                            Message.debug(e);
                        }
                        break;
                    }
                }
            }
            ArtifactOrigin origin = new ArtifactOrigin(artifact, isLocal, location);
            if (lastChecked != null) {
                origin.setLastChecked(Long.valueOf(lastChecked));
            }
            if (exists != null) {
                origin.setExist(Boolean.valueOf(exists));
            }
            ArtifactOrigin artifactOrigin = origin;
            return artifactOrigin;
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    private String getPrefixKey(Artifact artifact) {
        return String.format("artifact:%s#%s#%s#%d", artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getId().hashCode());
    }

    private String getLocationKey(Artifact artifact) {
        return this.getPrefixKey(artifact) + ".location";
    }

    private String getIsLocalKey(Artifact artifact) {
        return this.getPrefixKey(artifact) + ".is-local";
    }

    private String getLastCheckedKey(Artifact artifact) {
        return this.getPrefixKey(artifact) + ".lastchecked";
    }

    private String getExistsKey(Artifact artifact) {
        return this.getPrefixKey(artifact) + ".exists";
    }

    private String getOriginalKey(Artifact artifact) {
        return this.getPrefixKey(artifact) + ".original";
    }

    private PropertiesFile getCachedDataFile(ModuleDescriptor md) {
        return this.getCachedDataFile(md.getResolvedModuleRevisionId());
    }

    private PropertiesFile getCachedDataFile(ModuleRevisionId mRevId) {
        return new PropertiesFile(new File(this.getRepositoryCacheRoot(), IvyPatternHelper.substitute(this.getDataFilePattern(), mRevId)), "ivy cached data file for " + mRevId);
    }

    private PropertiesFile getCachedDataFile(String resolverName, ModuleRevisionId mRevId) {
        return new PropertiesFile(new File(this.getRepositoryCacheRoot(), IvyPatternHelper.substitute(this.getDataFilePattern(), mRevId) + "." + resolverName), "ivy cached data file for " + mRevId);
    }

    @Override
    public ResolvedModuleRevision findModuleInCache(DependencyDescriptor dd, ModuleRevisionId requestedRevisionId, CacheMetadataOptions options, String expectedResolver) {
        if (this.isCheckmodified(dd, requestedRevisionId, options)) {
            Message.verbose("don't use cache for " + requestedRevisionId + ": checkModified=true");
            return null;
        }
        if (!options.isUseCacheOnly() && this.isChanging(dd, requestedRevisionId, options)) {
            Message.verbose("don't use cache for " + requestedRevisionId + ": changing=true");
            return null;
        }
        return this.doFindModuleInCache(requestedRevisionId, options, expectedResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResolvedModuleRevision doFindModuleInCache(ModuleRevisionId mrid, CacheMetadataOptions options, String expectedResolver) {
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return null;
        }
        boolean unlock = true;
        try {
            File ivyFile;
            if (this.settings.getVersionMatcher().isDynamic(mrid)) {
                String resolvedRevision = this.getResolvedRevision(expectedResolver, mrid, options);
                if (resolvedRevision == null) {
                    ResolvedModuleRevision resolvedModuleRevision = null;
                    return resolvedModuleRevision;
                }
                Message.verbose("found resolved revision in cache: " + mrid + " => " + resolvedRevision);
                this.unlockMetadataArtifact(mrid);
                mrid = ModuleRevisionId.newInstance(mrid, resolvedRevision);
                if (!this.lockMetadataArtifact(mrid)) {
                    Message.error("impossible to acquire lock for " + mrid);
                    unlock = false;
                    ResolvedModuleRevision resolvedModuleRevision = null;
                    return resolvedModuleRevision;
                }
            }
            if ((ivyFile = this.getIvyFileInCache(mrid)).exists()) {
                try {
                    DependencyResolver artResolver;
                    ModuleDescriptorParser parser = this.getModuleDescriptorParser(ivyFile);
                    ModuleDescriptor depMD = this.getMdFromCache(parser, options, ivyFile);
                    String resolverName = this.getSavedResolverName(depMD);
                    String artResolverName = this.getSavedArtResolverName(depMD);
                    DependencyResolver resolver = this.settings.getResolver(resolverName);
                    if (resolver == null) {
                        Message.debug("\tresolver not found: " + resolverName + " => trying to use the one configured for " + mrid);
                        resolver = this.settings.getResolver(depMD.getResolvedModuleRevisionId());
                        if (resolver != null) {
                            Message.debug("\tconfigured resolver found for " + depMD.getResolvedModuleRevisionId() + ": " + resolver.getName() + ": saving this data");
                            this.saveResolver(depMD, resolver.getName());
                        }
                    }
                    if ((artResolver = this.settings.getResolver(artResolverName)) == null) {
                        artResolver = resolver;
                    }
                    if (resolver != null) {
                        Message.debug("\tfound ivy file in cache for " + mrid + " (resolved by " + resolver.getName() + "): " + ivyFile);
                        if (expectedResolver == null || expectedResolver.equals(resolver.getName())) {
                            MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(depMD.getMetadataArtifact());
                            madr.setDownloadStatus(DownloadStatus.NO);
                            madr.setSearched(false);
                            madr.setLocalFile(ivyFile);
                            madr.setSize(ivyFile.length());
                            madr.setArtifactOrigin(this.getSavedArtifactOrigin(depMD.getMetadataArtifact()));
                            if (madr.getArtifactOrigin().isExists()) {
                                if (madr.getArtifactOrigin().isLocal() && madr.getArtifactOrigin().getArtifact().getUrl() != null) {
                                    madr.setOriginalLocalFile(new File(madr.getArtifactOrigin().getArtifact().getUrl().toURI()));
                                } else {
                                    madr.setOriginalLocalFile(this.getArchiveFileInCache(madr.getArtifactOrigin().getArtifact()));
                                }
                            }
                            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(resolver, artResolver, depMD, madr);
                            return resolvedModuleRevision;
                        }
                        Message.debug("found module in cache but with a different resolver: discarding: " + mrid + "; expected resolver=" + expectedResolver + "; resolver=" + resolver.getName());
                        return null;
                    }
                    Message.debug("\tresolver not found: " + resolverName + " => cannot use cached ivy file for " + mrid);
                    return null;
                }
                catch (Exception e) {
                    Message.debug("\tproblem while parsing cached ivy file for: " + mrid, e);
                    return null;
                }
            }
            Message.debug("\tno ivy file in cache for " + mrid + ": tried " + ivyFile);
            return null;
        }
        finally {
            if (unlock) {
                this.unlockMetadataArtifact(mrid);
            }
        }
    }

    protected ModuleDescriptorParser getModuleDescriptorParser(File moduleDescriptorFile) {
        return XmlModuleDescriptorParser.getInstance();
    }

    private ModuleDescriptor getMdFromCache(ModuleDescriptorParser mdParser, CacheMetadataOptions options, File ivyFile) throws ParseException, IOException {
        ModuleDescriptorMemoryCache cache = this.getMemoryCache();
        MyModuleDescriptorProvider mdProvider = new MyModuleDescriptorProvider(mdParser, this.settings);
        return cache.get(ivyFile, this.settings, options.isValidate(), mdProvider);
    }

    private ModuleDescriptor getStaledMd(ModuleDescriptorParser mdParser, CacheMetadataOptions options, File ivyFile, ParserSettings parserSettings) throws ParseException, IOException {
        ModuleDescriptorMemoryCache cache = this.getMemoryCache();
        MyModuleDescriptorProvider mdProvider = new MyModuleDescriptorProvider(mdParser, parserSettings);
        return cache.getStale(ivyFile, this.settings, options.isValidate(), mdProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResolvedRevision(String expectedResolver, ModuleRevisionId mrid, CacheMetadataOptions options) {
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return null;
        }
        try {
            long expiration;
            if (options.isForce()) {
                Message.verbose("refresh mode: no check for cached resolved revision for " + mrid);
                String string = null;
                return string;
            }
            PropertiesFile cachedResolvedRevision = expectedResolver != null ? this.getCachedDataFile(expectedResolver, mrid) : this.getCachedDataFile(mrid);
            String resolvedRevision = cachedResolvedRevision.getProperty("resolved.revision");
            if (resolvedRevision == null) {
                Message.verbose(this.getName() + ": no cached resolved revision for " + mrid);
                String string = null;
                return string;
            }
            String resolvedTime = cachedResolvedRevision.getProperty("resolved.time");
            if (resolvedTime == null) {
                Message.verbose(this.getName() + ": inconsistent or old cache: no cached resolved time for " + mrid);
                this.saveResolvedRevision(expectedResolver, mrid, resolvedRevision);
                String string = resolvedRevision;
                return string;
            }
            if (options.isCheckTTL() && (expiration = Long.parseLong(resolvedTime) + this.getTTL(mrid)) > 0L && System.currentTimeMillis() > expiration) {
                Message.verbose(this.getName() + ": cached resolved revision expired for " + mrid);
                String string = null;
                return string;
            }
            String string = resolvedRevision;
            return string;
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    @Override
    @Deprecated
    public void saveResolvedRevision(ModuleRevisionId mrid, String revision) {
        this.saveResolvedRevision(null, mrid, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResolvedRevision(String resolverName, ModuleRevisionId mrid, String revision) {
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return;
        }
        try {
            PropertiesFile cachedResolvedRevision = resolverName == null ? this.getCachedDataFile(mrid) : this.getCachedDataFile(resolverName, mrid);
            cachedResolvedRevision.setProperty("resolved.time", String.valueOf(System.currentTimeMillis()));
            cachedResolvedRevision.setProperty("resolved.revision", revision);
            if (resolverName != null) {
                cachedResolvedRevision.setProperty("resolver", resolverName);
            }
            cachedResolvedRevision.save();
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    public long getTTL(ModuleRevisionId mrid) {
        Long ttl = this.ttlRules.getRule(mrid);
        return ttl == null ? this.getDefaultTTL() : ttl.longValue();
    }

    public String toString() {
        return this.name;
    }

    public File getRepositoryCacheRoot() {
        return this.getBasedir();
    }

    public LockStrategy getLockStrategy() {
        if (this.lockStrategy == null) {
            this.lockStrategy = this.lockStrategyName != null ? this.settings.getLockStrategy(this.lockStrategyName) : this.settings.getDefaultLockStrategy();
        }
        return this.lockStrategy;
    }

    public void setLockStrategy(LockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    public void setLockStrategy(String lockStrategyName) {
        this.lockStrategyName = lockStrategyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactDownloadReport download(Artifact artifact, ArtifactResourceResolver resourceResolver, ResourceDownloader resourceDownloader, CacheDownloadOptions options) {
        ArtifactDownloadReport adr = new ArtifactDownloadReport(artifact);
        boolean useOrigin = this.isUseOrigin();
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(mrid)) {
            adr.setDownloadStatus(DownloadStatus.FAILED);
            adr.setDownloadDetails("impossible to get lock for " + mrid);
            return adr;
        }
        try {
            ArtifactOrigin origin;
            File archiveFile;
            DownloadListener listener = options.getListener();
            if (listener != null) {
                listener.needArtifact(this, artifact);
            }
            if ((archiveFile = this.getArchiveFileInCache(artifact, origin = this.getSavedArtifactOrigin(artifact), useOrigin)).exists() && !options.isForce()) {
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(archiveFile.length());
                adr.setArtifactOrigin(origin);
                adr.setLocalFile(archiveFile);
            } else {
                long start = System.currentTimeMillis();
                try {
                    ResolvedResource artifactRef = resourceResolver.resolve(artifact);
                    if (artifactRef != null) {
                        Resource artifactRes = artifactRef.getResource();
                        origin = new ArtifactOrigin(artifact, artifactRes.isLocal(), artifactRes.getName());
                        if (useOrigin && artifactRes.isLocal()) {
                            if (artifactRes instanceof LocalizableResource) {
                                origin.setLocation(((LocalizableResource)artifactRes).getFile().getAbsolutePath());
                            }
                            this.saveArtifactOrigin(artifact, origin);
                            archiveFile = this.getArchiveFileInCache(artifact, origin);
                            adr.setDownloadStatus(DownloadStatus.NO);
                            adr.setSize(archiveFile.length());
                            adr.setArtifactOrigin(origin);
                            adr.setLocalFile(archiveFile);
                        } else {
                            archiveFile = this.getArchiveFileInCache(artifact, origin, useOrigin);
                            if (ResourceHelper.equals(artifactRes, archiveFile)) {
                                throw new IllegalStateException("invalid settings for '" + resourceResolver + "': pointing repository to ivy cache is forbidden !");
                            }
                            if (listener != null) {
                                listener.startArtifactDownload(this, artifactRef, artifact, origin);
                            }
                            resourceDownloader.download(artifact, artifactRes, archiveFile);
                            adr.setSize(archiveFile.length());
                            this.saveArtifactOrigin(artifact, origin);
                            adr.setDownloadTimeMillis(System.currentTimeMillis() - start);
                            adr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                            adr.setArtifactOrigin(origin);
                            adr.setLocalFile(archiveFile);
                        }
                    } else {
                        adr.setDownloadStatus(DownloadStatus.FAILED);
                        adr.setDownloadDetails("missing artifact");
                        adr.setDownloadTimeMillis(System.currentTimeMillis() - start);
                    }
                }
                catch (Exception ex) {
                    Message.debug(ex);
                    adr.setDownloadStatus(DownloadStatus.FAILED);
                    adr.setDownloadDetails(ex.getMessage());
                    adr.setDownloadTimeMillis(System.currentTimeMillis() - start);
                }
            }
            if (adr.getDownloadStatus() != DownloadStatus.FAILED) {
                this.unpackArtifact(artifact, adr, options);
            }
            if (listener != null) {
                listener.endArtifactDownload(this, artifact, adr, archiveFile);
            }
            ArtifactDownloadReport artifactDownloadReport = adr;
            return artifactDownloadReport;
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    private void unpackArtifact(Artifact artifact, ArtifactDownloadReport adr, CacheDownloadOptions options) {
        Artifact unpacked = this.packagingManager.getUnpackedArtifact(artifact);
        if (unpacked == null) {
            return;
        }
        File archiveFile = this.getArchiveFileInCache(unpacked, null, false);
        if (archiveFile.exists() && !options.isForce()) {
            adr.setUnpackedLocalFile(archiveFile);
            adr.setUnpackedArtifact(unpacked);
        } else {
            Message.info("\tUnpacking " + artifact.getId());
            try {
                Artifact unpackedArtifact = this.packagingManager.unpackArtifact(artifact, adr.getLocalFile(), archiveFile);
                adr.setUnpackedLocalFile(archiveFile);
                adr.setUnpackedArtifact(unpackedArtifact);
            }
            catch (Exception e) {
                Message.debug(e);
                adr.setDownloadStatus(DownloadStatus.FAILED);
                adr.setDownloadDetails("The packed artifact " + artifact.getId() + " could not be unpacked (" + e.getMessage() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactDownloadReport downloadRepositoryResource(Resource resource, String name, String type, String extension, CacheResourceOptions options, Repository repository) {
        String hash = this.computeResourceNameHash(resource);
        ModuleRevisionId mrid = ModuleRevisionId.newInstance("_repository_metadata_", hash, Ivy.getWorkingRevision());
        DefaultArtifact artifact = new DefaultArtifact(mrid, null, name, type, extension);
        ArtifactDownloadReport adr = new ArtifactDownloadReport(artifact);
        boolean useOrigin = this.isUseOrigin();
        try {
            DownloadListener listener = options.getListener();
            if (listener != null) {
                listener.needArtifact(this, artifact);
            }
            ArtifactOrigin savedOrigin = this.getSavedArtifactOrigin(artifact);
            File archiveFile = this.getArchiveFileInCache(artifact, savedOrigin, useOrigin);
            ArtifactOrigin origin = new ArtifactOrigin(artifact, resource.isLocal(), resource.getName());
            if (!options.isForce() && this.checkCacheUptodate(archiveFile, resource, savedOrigin, origin, options.getTtl())) {
                if (archiveFile.exists()) {
                    this.saveArtifactOrigin(artifact, origin);
                    adr.setDownloadStatus(DownloadStatus.NO);
                    adr.setSize(archiveFile.length());
                    adr.setArtifactOrigin(savedOrigin);
                    adr.setLocalFile(archiveFile);
                } else {
                    adr.setDownloadStatus(DownloadStatus.FAILED);
                    adr.setDownloadDetails("Remote resource is known to not exist");
                }
            } else {
                long start = System.currentTimeMillis();
                origin.setLastChecked(start);
                try {
                    ResolvedResource artifactRef = new ResolvedResource(resource, Ivy.getWorkingRevision());
                    if (useOrigin && resource.isLocal()) {
                        this.saveArtifactOrigin(artifact, origin);
                        archiveFile = this.getArchiveFileInCache(artifact, origin);
                        adr.setDownloadStatus(DownloadStatus.NO);
                        adr.setSize(archiveFile.length());
                        adr.setArtifactOrigin(origin);
                        adr.setLocalFile(archiveFile);
                    } else {
                        if (listener != null) {
                            listener.startArtifactDownload(this, artifactRef, artifact, origin);
                        }
                        if (archiveFile.exists()) {
                            archiveFile.delete();
                        }
                        File part = new File(archiveFile.getAbsolutePath() + ".part");
                        repository.get(resource.getName(), part);
                        if (!part.renameTo(archiveFile)) {
                            throw new IOException("impossible to move part file to definitive one: " + part + " -> " + archiveFile);
                        }
                        adr.setSize(archiveFile.length());
                        this.saveArtifactOrigin(artifact, origin);
                        adr.setDownloadTimeMillis(System.currentTimeMillis() - start);
                        adr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                        adr.setArtifactOrigin(origin);
                        adr.setLocalFile(archiveFile);
                    }
                }
                catch (Exception ex) {
                    Message.debug(ex);
                    origin.setExist(false);
                    this.saveArtifactOrigin(artifact, origin);
                    adr.setDownloadStatus(DownloadStatus.FAILED);
                    adr.setDownloadDetails(ex.getMessage());
                    adr.setDownloadTimeMillis(System.currentTimeMillis() - start);
                }
            }
            if (listener != null) {
                listener.endArtifactDownload(this, artifact, adr, archiveFile);
            }
            ArtifactDownloadReport artifactDownloadReport = adr;
            return artifactDownloadReport;
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    private String computeResourceNameHash(Resource resource) {
        return HexEncoder.encode(SHA_DIGEST.digest(resource.getName().getBytes(StandardCharsets.UTF_8)));
    }

    private boolean checkCacheUptodate(File archiveFile, Resource resource, ArtifactOrigin savedOrigin, ArtifactOrigin origin, long ttl) {
        long time = System.currentTimeMillis();
        if (savedOrigin.getLastChecked() != null && time - savedOrigin.getLastChecked() < ttl) {
            return archiveFile.exists() || !savedOrigin.isExists();
        }
        if (!archiveFile.exists()) {
            return false;
        }
        origin.setLastChecked(time);
        return archiveFile.lastModified() >= resource.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void originalToCachedModuleDescriptor(DependencyResolver resolver, ResolvedResource originalMetadataRef, Artifact requestedMetadataArtifact, ResolvedModuleRevision rmr, ModuleDescriptorWriter writer) {
        ModuleDescriptor md = rmr.getDescriptor();
        Artifact originalMetadataArtifact = this.getOriginalMetadataArtifact(requestedMetadataArtifact);
        File mdFileInCache = this.getIvyFileInCache(md.getResolvedModuleRevisionId());
        ModuleRevisionId mrid = requestedMetadataArtifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(mrid)) {
            Message.warn("impossible to acquire lock for: " + mrid);
            return;
        }
        try {
            File originalFileInCache = this.getArchiveFileInCache(originalMetadataArtifact);
            writer.write(originalMetadataRef, md, originalFileInCache, mdFileInCache);
            this.getMemoryCache().putInCache(mdFileInCache, new ParserSettingsMonitor(this.settings), true, md);
            this.saveResolvers(md, resolver.getName(), resolver.getName());
            if (!md.isDefault()) {
                rmr.getReport().setOriginalLocalFile(originalFileInCache);
            }
            rmr.getReport().setLocalFile(mdFileInCache);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String metadataRef = originalMetadataRef == null ? String.valueOf(md.getResolvedModuleRevisionId()) : String.valueOf(originalMetadataRef);
            Message.warn("impossible to put metadata file in cache: " + metadataRef, e);
        }
        finally {
            this.unlockMetadataArtifact(mrid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedModuleRevision cacheModuleDescriptor(DependencyResolver resolver, final ResolvedResource mdRef, DependencyDescriptor dd, Artifact moduleArtifact, ResourceDownloader downloader, CacheMetadataOptions options) throws ParseException {
        Date cachedPublicationDate = null;
        ModuleRevisionId mrid = moduleArtifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(mrid)) {
            Message.error("impossible to acquire lock for " + mrid);
            return null;
        }
        BackupResourceDownloader backupDownloader = new BackupResourceDownloader(downloader);
        try {
            ModuleDescriptor md;
            if (!moduleArtifact.isMetadata()) {
                if (this.isChanging(dd, mrid, options)) {
                    ArtifactOrigin origin;
                    long repoLastModified = mdRef.getLastModified();
                    Artifact transformedArtifact = NameSpaceHelper.transform(moduleArtifact, options.getNamespace().getToSystemTransformer());
                    File artFile = this.getArchiveFileInCache(transformedArtifact, origin = this.getSavedArtifactOrigin(transformedArtifact), false);
                    if (artFile.exists() && repoLastModified > artFile.lastModified()) {
                        Message.verbose(mrid + " has changed: deleting old artifacts");
                        Message.debug("deleting " + artFile);
                        if (!artFile.delete()) {
                            Message.error("Couldn't delete outdated artifact from cache: " + artFile);
                            ResolvedModuleRevision resolvedModuleRevision = null;
                            return resolvedModuleRevision;
                        }
                        this.removeSavedArtifactOrigin(transformedArtifact);
                    }
                }
                ResolvedModuleRevision repoLastModified = null;
                return repoLastModified;
            }
            ResolvedModuleRevision rmr = this.doFindModuleInCache(mrid, options, null);
            if (rmr != null) {
                if (rmr.getDescriptor().isDefault() && rmr.getResolver() != resolver) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + mrid + " (resolved by " + rmr.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    if (!this.isCheckmodified(dd, mrid, options) && !this.isChanging(dd, mrid, options)) {
                        Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                        rmr.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision = rmr;
                        return resolvedModuleRevision;
                    }
                    long repLastModified = mdRef.getLastModified();
                    long cacheLastModified = rmr.getDescriptor().getLastModified();
                    if (!rmr.getDescriptor().isDefault() && repLastModified <= cacheLastModified) {
                        Message.verbose("\t" + this.getName() + ": revision in cache (not updated): " + mrid);
                        rmr.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision = rmr;
                        return resolvedModuleRevision;
                    }
                    Message.verbose("\t" + this.getName() + ": revision in cache is not up to date: " + mrid);
                    if (this.isChanging(dd, mrid, options)) {
                        cachedPublicationDate = rmr.getDescriptor().getResolvedPublicationDate();
                    }
                }
            }
            Artifact originalMetadataArtifact = this.getOriginalMetadataArtifact(moduleArtifact);
            ArtifactDownloadReport report = this.download(originalMetadataArtifact, new ArtifactResourceResolver(){

                @Override
                public ResolvedResource resolve(Artifact artifact) {
                    return mdRef;
                }
            }, backupDownloader, new CacheDownloadOptions().setListener(options.getListener()).setForce(true));
            Message.verbose("\t" + report);
            if (report.getDownloadStatus() == DownloadStatus.FAILED) {
                Message.warn("problem while downloading module descriptor: " + mdRef.getResource() + ": " + report.getDownloadDetails() + " (" + report.getDownloadTimeMillis() + "ms)");
                ResolvedModuleRevision transformedArtifact = null;
                return transformedArtifact;
            }
            ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(mdRef.getResource());
            ParserSettings parserSettings = this.settings;
            if (resolver instanceof AbstractResolver) {
                parserSettings = ((AbstractResolver)resolver).getParserSettings();
            }
            if ((md = this.getStaledMd(parser, options, report.getLocalFile(), parserSettings)) == null) {
                throw new IllegalStateException("module descriptor parser returned a null module descriptor, which is not allowed. parser=" + parser + "; parser class=" + parser.getClass().getName() + "; module descriptor resource=" + mdRef.getResource());
            }
            Message.debug("\t" + this.getName() + ": parsed downloaded md file for " + mrid + "; parsed=" + md.getModuleRevisionId());
            boolean deleteOldArtifacts = false;
            if (cachedPublicationDate != null && !cachedPublicationDate.equals(md.getResolvedPublicationDate())) {
                Message.verbose(mrid + " has changed: deleting old artifacts");
                deleteOldArtifacts = true;
            }
            if (deleteOldArtifacts) {
                for (String conf : md.getConfigurationsNames()) {
                    for (Artifact art : md.getArtifacts(conf)) {
                        ArtifactOrigin origin;
                        Artifact transformedArtifact = NameSpaceHelper.transform(art, options.getNamespace().getToSystemTransformer());
                        File artFile = this.getArchiveFileInCache(transformedArtifact, origin = this.getSavedArtifactOrigin(transformedArtifact), false);
                        if (artFile.exists()) {
                            Message.debug("deleting " + artFile);
                            if (!artFile.delete()) {
                                backupDownloader.restore();
                                Message.error("Couldn't delete outdated artifact from cache: " + artFile);
                                ResolvedModuleRevision resolvedModuleRevision = null;
                                return resolvedModuleRevision;
                            }
                        }
                        this.removeSavedArtifactOrigin(transformedArtifact);
                    }
                }
            } else if (this.isChanging(dd, mrid, options)) {
                Message.verbose(mrid + " is changing, but has not changed: will trust cached artifacts if any");
            }
            MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(md.getMetadataArtifact());
            madr.setSearched(true);
            madr.setDownloadStatus(report.getDownloadStatus());
            madr.setDownloadDetails(report.getDownloadDetails());
            madr.setArtifactOrigin(report.getArtifactOrigin());
            madr.setDownloadTimeMillis(report.getDownloadTimeMillis());
            madr.setOriginalLocalFile(report.getLocalFile());
            madr.setSize(report.getSize());
            Artifact transformedMetadataArtifact = NameSpaceHelper.transform(md.getMetadataArtifact(), options.getNamespace().getToSystemTransformer());
            this.saveArtifactOrigin(transformedMetadataArtifact, report.getArtifactOrigin());
            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(resolver, resolver, md, madr);
            return resolvedModuleRevision;
        }
        finally {
            this.unlockMetadataArtifact(mrid);
            backupDownloader.cleanUp();
        }
    }

    private boolean lockMetadataArtifact(ModuleRevisionId mrid) {
        Artifact artifact = this.getDefaultMetadataArtifact(mrid);
        try {
            return this.getLockStrategy().lockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(mrid)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("operation interrupted");
        }
    }

    private void unlockMetadataArtifact(ModuleRevisionId mrid) {
        Artifact artifact = this.getDefaultMetadataArtifact(mrid);
        this.getLockStrategy().unlockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(mrid)));
    }

    private ArtifactOrigin getDefaultMetadataArtifactOrigin(ModuleRevisionId mrid) {
        String location;
        try {
            location = this.getIvyFileInCache(mrid).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to determine artifact origin for " + mrid);
        }
        return new ArtifactOrigin(DefaultArtifact.newIvyArtifact(mrid, null), false, location);
    }

    private Artifact getDefaultMetadataArtifact(ModuleRevisionId mrid) {
        return new DefaultArtifact(mrid, new Date(), "metadata", "metadata", "ivy", true);
    }

    public Artifact getOriginalMetadataArtifact(Artifact moduleArtifact) {
        return DefaultArtifact.cloneWithAnotherType(moduleArtifact, moduleArtifact.getType() + ".original");
    }

    private boolean isOriginalMetadataArtifact(Artifact artifact) {
        return artifact.isMetadata() && artifact.getType().endsWith(".original");
    }

    private boolean isChanging(DependencyDescriptor dd, ModuleRevisionId requestedRevisionId, CacheMetadataOptions options) {
        return dd.isChanging() || this.getChangingMatcher(options).matches(requestedRevisionId.getRevision());
    }

    private org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.Matcher getChangingMatcher(CacheMetadataOptions options) {
        String changingPattern;
        String string = changingPattern = options.getChangingPattern() != null ? options.getChangingPattern() : this.changingPattern;
        if (changingPattern == null) {
            return NoMatcher.INSTANCE;
        }
        String changingMatcherName = options.getChangingMatcherName() != null ? options.getChangingMatcherName() : this.changingMatcherName;
        PatternMatcher matcher = this.settings.getMatcher(changingMatcherName);
        if (matcher == null) {
            throw new IllegalStateException("unknown matcher '" + changingMatcherName + "'. It is set as changing matcher in " + this);
        }
        return matcher.getMatcher(changingPattern);
    }

    private boolean isCheckmodified(DependencyDescriptor dd, ModuleRevisionId requestedRevisionId, CacheMetadataOptions options) {
        return options.isCheckmodified() == null ? this.isCheckmodified() : options.isCheckmodified().booleanValue();
    }

    @Override
    public void clean() {
        FileUtil.forceDelete(this.getBasedir());
    }

    public void dumpSettings() {
        Message.verbose("\t" + this.getName());
        Message.debug("\t\tivyPattern: " + this.getIvyPattern());
        Message.debug("\t\tartifactPattern: " + this.getArtifactPattern());
        Message.debug("\t\tlockingStrategy: " + this.getLockStrategy().getName());
        Message.debug("\t\tchangingPattern: " + this.getChangingPattern());
        Message.debug("\t\tchangingMatcher: " + this.getChangingMatcherName());
    }

    static {
        try {
            SHA_DIGEST = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The SHA1 algorithm is not available in your classpath", e);
        }
        DURATION_PATTERN = Pattern.compile("(?:(\\d+)d)? ?(?:(\\d+)h)? ?(?:(\\d+)m)? ?(?:(\\d+)s)? ?(?:(\\d+)ms)?");
        ARTIFACT_KEY_PATTERN = Pattern.compile(".*:(.*)#(.*)#(.*)#(.*)(\\.location)?");
    }

    private static final class ConfiguredTTL {
        private static final Set<String> attributesNotContributingToMatching = new HashSet<String>();
        private final String matcher;
        private final long duration;
        private final Map<String, String> attributes;

        private ConfiguredTTL(long duration, String matcher, Map<String, String> attributes) {
            this.matcher = matcher;
            this.duration = duration;
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            } else {
                HashMap<String, String> attrs = new HashMap<String, String>(attributes);
                for (String removable : attributesNotContributingToMatching) {
                    attrs.remove(removable);
                }
                this.attributes = Collections.unmodifiableMap(attrs);
            }
        }

        static {
            attributesNotContributingToMatching.add("duration");
            attributesNotContributingToMatching.add("matcher");
        }
    }

    private final class BackupResourceDownloader
    implements ResourceDownloader {
        private ResourceDownloader delegate;
        private File backup;
        private String originalPath;

        private BackupResourceDownloader(ResourceDownloader delegate) {
            this.delegate = delegate;
        }

        @Override
        public void download(Artifact artifact, Resource resource, File dest) throws IOException {
            if (dest.exists()) {
                this.originalPath = dest.getAbsolutePath();
                this.backup = new File(dest.getAbsolutePath() + ".backup");
                FileUtil.copy(dest, this.backup, null, true);
            }
            this.delegate.download(artifact, resource, dest);
        }

        public void restore() throws IOException {
            if (this.backup != null && this.backup.exists()) {
                File original = new File(this.originalPath);
                FileUtil.copy(this.backup, original, null, true);
                this.backup.delete();
            }
        }

        public void cleanUp() {
            if (this.backup != null && this.backup.exists()) {
                this.backup.delete();
            }
        }
    }

    private class MyModuleDescriptorProvider
    implements ModuleDescriptorProvider {
        private final ModuleDescriptorParser mdParser;
        private final ParserSettings settings;

        public MyModuleDescriptorProvider(ModuleDescriptorParser mdParser, ParserSettings settings) {
            this.mdParser = mdParser;
            this.settings = settings;
        }

        @Override
        public ModuleDescriptor provideModule(ParserSettings ivySettings, File descriptorURL, boolean validate) throws ParseException, IOException {
            return this.mdParser.parseDescriptor(this.settings, descriptorURL.toURI().toURL(), validate);
        }
    }
}

