/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.extra;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.bean.Command;
import org.jsmpp.extra.ResponseTimeoutException;

public class PendingResponse<T extends Command> {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private long timeout;
    private T response;
    private InvalidResponseException illegalResponseException;

    public PendingResponse(long timeout) {
        this.timeout = timeout;
    }

    private boolean isDoneResponse() {
        return this.response != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(T response) throws IllegalArgumentException {
        block4: {
            this.lock.lock();
            try {
                if (response != null) {
                    this.response = response;
                    this.condition.signal();
                    break block4;
                }
                throw new IllegalArgumentException("response cannot be null");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneWithInvalidResponse(InvalidResponseException e) {
        this.lock.lock();
        try {
            this.illegalResponseException = e;
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResponse() {
        this.lock.lock();
        try {
            T t = this.response;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitDone() throws ResponseTimeoutException, InvalidResponseException {
        this.lock.lock();
        try {
            if (!this.isDoneResponse()) {
                try {
                    this.condition.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted");
                }
            }
            if (this.illegalResponseException != null) {
                throw this.illegalResponseException;
            }
            if (!this.isDoneResponse()) {
                throw new ResponseTimeoutException("No response after " + this.timeout + " millis");
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

