/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.about.PluginInfoTable;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;

public class AboutPanel
extends JPanel {
    public AboutPanel() {
        this.setLayout(new BorderLayout());
        BundleContext applicationContext = PluginUtilities.getInstance().getApplicationContext();
        Bundle application = applicationContext.getBundle();
        Version v = PluginUtilities.getBundleVersion(application);
        String versionString = String.format("%d.%d.%d", v.getMajor(), v.getMinor(), v.getMicro());
        if (!v.getQualifier().isEmpty()) {
            versionString = versionString + " Build " + v.getQualifier();
        }
        Runtime runtime = Runtime.getRuntime();
        long maxMemMB = runtime.maxMemory() / 0x100000L;
        long usedMemMB = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        panel.addGroup("Version");
        panel.addGroupComponent(new JLabel(versionString, 0));
        panel.addVerticalPadding();
        panel.addGroup("Memory settings");
        panel.addGroupComponent(new JLabel(String.format("<html><body>Max memory set to %d MB    <span style='color: #707070;'>(via Java -Xmx setting)</span></body></html>", maxMemMB)));
        panel.addGroupComponent(new JLabel(String.format("Currently using %d MB", usedMemMB)));
        panel.addVerticalPadding();
        panel.addGroup("Installed Plugins");
        JScrollPane sp = new JScrollPane(new PluginInfoTable());
        sp.setPreferredSize(new Dimension(500, 200));
        sp.setMinimumSize(new Dimension(500, 200));
        panel.addGroupComponent(sp);
        panel.addVerticalPadding();
        panel.addGroup("About");
        JLabel copy = new JLabel("<html><body>Prot\u00e9g\u00e9 is developed by the Stanford Center for Biomedical Informatics Research.<br>Prot\u00e9g\u00e9 is a national resource for biomedical ontologies and knowledge bases<br>supported by the National Institute of General Medical Sciences.<br><br>Previous versions of the Prot\u00e9g\u00e9 series were developed in collaboration with the<br>Bio-Health Informatics Group in the School of Computer Science at<br>The University of Manchester.");
        copy.setMinimumSize(copy.getPreferredSize());
        panel.addGroupComponent(copy);
        this.add((Component)panel, "North");
    }

    public static void showDialog() {
        AboutPanel about = new AboutPanel();
        JOptionPane op = new JOptionPane(about, -1, -1);
        JDialog dlg = op.createDialog(null, "About");
        dlg.pack();
        dlg.setVisible(true);
    }
}

