/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AddReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.DeleteNodeSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.DeleteReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.MoveReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SplitShardSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.UnsupportedSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Policy
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String POLICY = "policy";
    public static final String EACH = "#EACH";
    public static final String ANY = "#ANY";
    public static final String POLICIES = "policies";
    public static final String CLUSTER_POLICY = "cluster-policy";
    public static final String CLUSTER_PREFERENCES = "cluster-preferences";
    public static final Set<String> GLOBAL_ONLY_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cores", "withCollection")));
    public static final List<Preference> DEFAULT_PREFERENCES = Collections.unmodifiableList(Arrays.asList(new Preference((Map)Utils.fromJSONString("{minimize : cores, precision:1}")), new Preference((Map)Utils.fromJSONString("{maximize : freedisk}"))));
    private static final List<String> DEFAULT_PARAMS_OF_INTEREST = Arrays.asList("freedisk", "cores");
    final Map<String, List<Clause>> policies;
    final List<Clause> clusterPolicy;
    final List<Preference> clusterPreferences;
    final List<Pair<String, Variable.Type>> params;
    final List<String> perReplicaAttributes;
    final int zkVersion;
    final boolean empty;
    final boolean emptyPreferences;
    private static final Map<CollectionParams.CollectionAction, Supplier<Suggester>> ops = new HashMap<CollectionParams.CollectionAction, Supplier<Suggester>>();

    public Policy() {
        this(Collections.emptyMap());
    }

    public Policy(Map<String, Object> jsonMap) {
        this(jsonMap, 0);
    }

    public Policy(Map<String, Object> jsonMap, int version) {
        this.empty = jsonMap.get(CLUSTER_PREFERENCES) == null && jsonMap.get(CLUSTER_POLICY) == null && jsonMap.get(POLICIES) == null;
        this.zkVersion = version;
        int[] idx = new int[1];
        List initialClusterPreferences = jsonMap.getOrDefault(CLUSTER_PREFERENCES, Collections.emptyList()).stream().map(m -> {
            int n = idx[0];
            idx[0] = n + 1;
            return new Preference((Map<String, Object>)m, n);
        }).collect(Collectors.toList());
        for (int i = 0; i < initialClusterPreferences.size() - 1; ++i) {
            Preference preference2 = (Preference)initialClusterPreferences.get(i);
            preference2.next = (Preference)initialClusterPreferences.get(i + 1);
        }
        this.emptyPreferences = initialClusterPreferences.isEmpty();
        if (this.emptyPreferences) {
            initialClusterPreferences.addAll(DEFAULT_PREFERENCES);
        }
        this.clusterPreferences = Collections.unmodifiableList(initialClusterPreferences);
        TreeSet<String> paramsOfInterest = new TreeSet<String>(DEFAULT_PARAMS_OF_INTEREST);
        this.clusterPreferences.forEach(preference -> paramsOfInterest.add(preference.name.toString()));
        ArrayList<String> newParams = new ArrayList<String>(paramsOfInterest);
        this.clusterPolicy = jsonMap.getOrDefault(CLUSTER_POLICY, Collections.emptyList()).stream().map(Clause::create).filter(clause -> {
            clause.addTags(newParams);
            return true;
        }).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        for (String newParam : new ArrayList<String>(newParams)) {
            Variable.Type t = VariableBase.getTagType(newParam);
            if (t == null || t.associatedPerNodeValues.isEmpty()) continue;
            for (String s2 : t.associatedPerNodeValues) {
                if (newParams.contains(s2)) continue;
                newParams.add(s2);
            }
        }
        this.policies = Collections.unmodifiableMap(Policy.clausesFromMap(jsonMap.getOrDefault(POLICIES, Collections.emptyMap()), newParams));
        List params = newParams.stream().map(s -> new Pair<String, Variable.Type>((String)s, VariableBase.getTagType(s))).collect(Collectors.toList());
        params.add(new Pair<String, Variable.Type>(Variable.Type.WITH_COLLECTION.tagName, Variable.Type.WITH_COLLECTION));
        this.params = Collections.unmodifiableList(params);
        this.perReplicaAttributes = this.readPerReplicaAttrs();
    }

    private List<String> readPerReplicaAttrs() {
        return this.params.stream().map(s -> ((Variable.Type)s.second()).perReplicaValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Policy(Map<String, List<Clause>> policies, List<Clause> clusterPolicy, List<Preference> clusterPreferences, int version) {
        this.empty = policies == null && clusterPolicy == null && clusterPreferences == null;
        this.zkVersion = version;
        this.policies = policies != null ? Collections.unmodifiableMap(policies) : Collections.emptyMap();
        this.clusterPolicy = clusterPolicy != null ? Collections.unmodifiableList(clusterPolicy) : Collections.emptyList();
        this.emptyPreferences = clusterPreferences == null;
        this.clusterPreferences = this.emptyPreferences ? DEFAULT_PREFERENCES : Collections.unmodifiableList(clusterPreferences);
        this.params = Collections.unmodifiableList(this.buildParams(this.clusterPreferences, this.clusterPolicy, this.policies).stream().map(s -> new Pair<String, Variable.Type>((String)s, VariableBase.getTagType(s))).collect(Collectors.toList()));
        this.perReplicaAttributes = this.readPerReplicaAttrs();
    }

    private List<String> buildParams(List<Preference> preferences, List<Clause> policy, Map<String, List<Clause>> policies) {
        TreeSet paramsOfInterest = new TreeSet();
        preferences.forEach(p -> {
            if (paramsOfInterest.contains(p.name.name())) {
                throw new RuntimeException((Object)((Object)p.name) + " is repeated");
            }
            paramsOfInterest.add(p.name.toString());
        });
        ArrayList<String> newParams = new ArrayList<String>(paramsOfInterest);
        policy.forEach(c -> c.addTags(newParams));
        policies.values().forEach(clauses -> clauses.forEach(c -> c.addTags(newParams)));
        return newParams;
    }

    public Policy withPolicies(Map<String, List<Clause>> policies) {
        return new Policy(policies, this.clusterPolicy, this.clusterPreferences, 0);
    }

    public Policy withClusterPreferences(List<Preference> clusterPreferences) {
        return new Policy(this.policies, this.clusterPolicy, clusterPreferences, 0);
    }

    public Policy withClusterPolicy(List<Clause> clusterPolicy) {
        return new Policy(this.policies, clusterPolicy, this.clusterPreferences, 0);
    }

    public Policy withParams(List<String> params) {
        return new Policy(this.policies, this.clusterPolicy, this.clusterPreferences, 0);
    }

    public List<Clause> getClusterPolicy() {
        return this.clusterPolicy;
    }

    public List<Preference> getClusterPreferences() {
        return this.clusterPreferences;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.empty) {
            return;
        }
        if (!this.policies.isEmpty()) {
            ew.put((CharSequence)POLICIES, ew1 -> {
                for (Map.Entry<String, List<Clause>> e : this.policies.entrySet()) {
                    ew1.put((CharSequence)e.getKey(), e.getValue());
                }
            });
        }
        if (!this.emptyPreferences && !this.clusterPreferences.isEmpty()) {
            ew.put((CharSequence)CLUSTER_PREFERENCES, iw -> {
                for (Preference p : this.clusterPreferences) {
                    iw.add(p);
                }
            });
        }
        if (!this.clusterPolicy.isEmpty()) {
            ew.put((CharSequence)CLUSTER_POLICY, iw -> {
                for (Clause c : this.clusterPolicy) {
                    iw.add(c);
                }
            });
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        if (!this.getPolicies().equals(policy.getPolicies())) {
            return false;
        }
        if (!this.getClusterPolicy().equals(policy.getClusterPolicy())) {
            return false;
        }
        return this.getClusterPreferences().equals(policy.getClusterPreferences());
    }

    public static Map<String, List<Clause>> clausesFromMap(Map<String, List<Map<String, Object>>> map, List<String> newParams) {
        HashMap<String, List<Clause>> newPolicies = new HashMap<String, List<Clause>>();
        map.forEach((s, l1) -> newPolicies.put((String)s, l1.stream().map(Clause::create).filter(clause -> {
            if (!clause.isPerCollectiontag()) {
                throw new RuntimeException(clause.getGlobalTag().name + " is only allowed in 'cluster-policy'");
            }
            clause.addTags(newParams);
            return true;
        }).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList))));
        return newPolicies;
    }

    static void setApproxValuesAndSortNodes(List<Preference> clusterPreferences, List<Row> matrix) {
        ArrayList<Row> matrixCopy = new ArrayList<Row>(matrix);
        ArrayList<Row> deadNodes = null;
        Iterator<Row> it = matrix.iterator();
        while (it.hasNext()) {
            Row row = it.next();
            if (row.isLive) continue;
            if (deadNodes == null) {
                deadNodes = new ArrayList<Row>();
            }
            deadNodes.add(row);
            it.remove();
        }
        if (!clusterPreferences.isEmpty()) {
            ArrayList<Row> tmpMatrix = new ArrayList<Row>(matrix);
            Row[] lastComparison = new Row[2];
            for (Preference p : clusterPreferences) {
                try {
                    tmpMatrix.sort((r1, r2) -> {
                        lastComparison[0] = r1;
                        lastComparison[1] = r2;
                        return p.compare((Row)r1, (Row)r2, false);
                    });
                }
                catch (Exception e) {
                    try {
                        Map<String, MapWriter> m = Collections.singletonMap("diagnostics", ew -> {
                            PolicyHelper.writeNodes(ew, matrixCopy);
                            ew.put((CharSequence)"config", ((Row)matrix.get((int)0)).session.getPolicy());
                        });
                        log.error("Exception! prefs = {}, recent r1 = {}, r2 = {}, matrix = {}", new Object[]{clusterPreferences, lastComparison[0].node, lastComparison[1].node, Utils.writeJson(m, new StringWriter(), true).toString()});
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(e.getMessage());
                }
                p.setApproxVal(tmpMatrix);
            }
            matrix.sort((r1, r2) -> {
                int result = ((Preference)clusterPreferences.get(0)).compare((Row)r1, (Row)r2, true);
                if (result == 0) {
                    result = ((Preference)clusterPreferences.get(0)).compare((Row)r1, (Row)r2, false);
                }
                return result;
            });
            if (deadNodes != null) {
                for (Row deadNode : deadNodes) {
                    matrix.add(0, deadNode);
                }
            }
        }
    }

    static List<Clause> insertColl(String coll, Collection<Clause> conditions) {
        return conditions.stream().filter(Clause::isPerCollectiontag).map(clause -> {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(clause.original);
            if (!copy.containsKey("collection")) {
                copy.put("collection", coll);
                copy.put(Clause.class.getName(), clause);
            }
            return Clause.create(copy);
        }).filter(it -> it.getCollection().isPass(coll)).collect(Collectors.toList());
    }

    public Session createSession(SolrCloudManager cloudManager) {
        return this.createSession(cloudManager, null);
    }

    private Session createSession(SolrCloudManager cloudManager, Transaction tx) {
        return new Session(cloudManager, tx);
    }

    public static List<Clause> mergePolicies(String coll, List<Clause> collPolicy, List<Clause> globalPolicy) {
        List<Clause> merged = Policy.insertColl(coll, collPolicy);
        List<Clause> global = Policy.insertColl(coll, globalPolicy);
        merged.addAll(global.stream().filter(clusterPolicyClause -> merged.stream().noneMatch(perCollPolicy -> perCollPolicy.doesOverride((Clause)clusterPolicyClause))).collect(Collectors.toList()));
        return merged;
    }

    public Map<String, List<Clause>> getPolicies() {
        return this.policies;
    }

    public List<String> getParams() {
        return this.params.stream().map(Pair::first).collect(Collectors.toList());
    }

    public List<String> getPerReplicaAttributes() {
        return Collections.unmodifiableList(this.perReplicaAttributes);
    }

    static int compareRows(Row r1, Row r2, Policy policy) {
        return policy.clusterPreferences.get(0).compare(r1, r2, true);
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isEmptyPreferences() {
        return this.emptyPreferences;
    }

    static {
        ops.put(CollectionParams.CollectionAction.ADDREPLICA, AddReplicaSuggester::new);
        ops.put(CollectionParams.CollectionAction.DELETEREPLICA, DeleteReplicaSuggester::new);
        ops.put(CollectionParams.CollectionAction.DELETENODE, DeleteNodeSuggester::new);
        ops.put(CollectionParams.CollectionAction.MOVEREPLICA, MoveReplicaSuggester::new);
        ops.put(CollectionParams.CollectionAction.SPLITSHARD, SplitShardSuggester::new);
        ops.put(CollectionParams.CollectionAction.MERGESHARDS, () -> new UnsupportedSuggester(CollectionParams.CollectionAction.MERGESHARDS));
        ops.put(CollectionParams.CollectionAction.NONE, () -> new UnsupportedSuggester(CollectionParams.CollectionAction.NONE));
    }

    static class Transaction {
        private final Policy policy;
        private boolean open = false;
        private Session firstSession;
        private Session currentSession;

        public Transaction(Policy config) {
            this.policy = config;
        }

        public Session open(SolrCloudManager cloudManager) {
            this.firstSession = this.currentSession = this.policy.createSession(cloudManager, this);
            this.open = true;
            return this.firstSession;
        }

        public boolean isOpen() {
            return this.open;
        }

        List<Violation> close() {
            if (!this.open) {
                throw new RuntimeException("Already closed");
            }
            this.open = false;
            return this.currentSession.getViolations();
        }

        public Session getCurrentSession() {
            return this.currentSession;
        }

        void updateSession(Session session) {
            this.currentSession = session;
        }
    }

    public class Session
    implements MapWriter {
        final List<String> nodes;
        final SolrCloudManager cloudManager;
        final List<Row> matrix;
        final NodeStateProvider nodeStateProvider;
        final int znodeVersion;
        Set<String> collections = new HashSet<String>();
        List<Clause> expandedClauses;
        List<Violation> violations = new ArrayList<Violation>();
        Transaction transaction;

        private Session(List<String> nodes, SolrCloudManager cloudManager, List<Row> matrix, List<Clause> expandedClauses, int znodeVersion, NodeStateProvider nodeStateProvider, Transaction transaction) {
            this.transaction = transaction;
            this.nodes = nodes;
            this.cloudManager = cloudManager;
            this.matrix = matrix;
            this.expandedClauses = expandedClauses;
            this.znodeVersion = znodeVersion;
            this.nodeStateProvider = nodeStateProvider;
            for (Row row : matrix) {
                row.session = this;
            }
        }

        Session(SolrCloudManager cloudManager, Transaction transaction) {
            Map withCollMap;
            Map<String, Object> vals;
            this.transaction = transaction;
            ClusterState state = null;
            this.nodeStateProvider = cloudManager.getNodeStateProvider();
            try {
                state = cloudManager.getClusterStateProvider().getClusterState();
                log.trace("-- session created with cluster state: {}", (Object)state);
            }
            catch (Exception e) {
                log.trace("-- session created, can't obtain cluster state", (Throwable)e);
            }
            this.znodeVersion = state != null ? state.getZNodeVersion() : -1;
            this.nodes = new ArrayList<String>(cloudManager.getClusterStateProvider().getLiveNodes());
            this.cloudManager = cloudManager;
            for (String node : this.nodes) {
                this.collections.addAll(this.nodeStateProvider.getReplicaInfo(node, Collections.emptyList()).keySet());
            }
            this.expandedClauses = Policy.this.clusterPolicy.stream().filter(clause -> !clause.isPerCollectiontag()).collect(Collectors.toList());
            if (this.nodes.size() > 0 && !(vals = this.nodeStateProvider.getNodeValues(this.nodes.get(0), Collections.singleton("withCollection"))).isEmpty() && vals.get("withCollection") != null && !(withCollMap = (Map)vals.get("withCollection")).isEmpty()) {
                Clause withCollClause = new Clause((Map)Utils.fromJSONString("{withCollection:'*' , node: '#ANY'}"), new Condition(Variable.Type.NODE.tagName, Policy.ANY, Operand.EQUAL, null, null), new Condition(Variable.Type.WITH_COLLECTION.tagName, "*", Operand.EQUAL, null, null), true, null, false);
                this.expandedClauses.add(withCollClause);
            }
            ClusterStateProvider stateProvider = cloudManager.getClusterStateProvider();
            for (String c : this.collections) {
                this.addClausesForCollection(stateProvider, c);
            }
            Collections.sort(this.expandedClauses);
            this.matrix = new ArrayList<Row>(this.nodes.size());
            for (String node : this.nodes) {
                this.matrix.add(new Row(node, Policy.this.params, Policy.this.perReplicaAttributes, this));
            }
            this.applyRules();
        }

        void addClausesForCollection(ClusterStateProvider stateProvider, String c) {
            List<Clause> perCollPolicy;
            String p = stateProvider.getPolicyNameByCollection(c);
            if (p != null && (perCollPolicy = Policy.this.policies.get(p)) == null) {
                return;
            }
            this.expandedClauses.addAll(Policy.mergePolicies(c, Policy.this.policies.getOrDefault(p, Collections.emptyList()), Policy.this.clusterPolicy));
        }

        Session copy() {
            return new Session(this.nodes, this.cloudManager, this.getMatrixCopy(), this.expandedClauses, this.znodeVersion, this.nodeStateProvider, this.transaction);
        }

        public Row getNode(String node) {
            for (Row row : this.matrix) {
                if (!row.node.equals(node)) continue;
                return row;
            }
            return null;
        }

        List<Row> getMatrixCopy() {
            return this.matrix.stream().map(row -> row.copy(this)).collect(Collectors.toList());
        }

        public Policy getPolicy() {
            return Policy.this;
        }

        void applyRules() {
            this.sortNodes();
            for (Clause clause : this.expandedClauses) {
                List<Violation> errs = clause.test(this, null);
                this.violations.addAll(errs);
            }
        }

        void sortNodes() {
            Policy.setApproxValuesAndSortNodes(Policy.this.clusterPreferences, this.matrix);
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public Suggester getSuggester(CollectionParams.CollectionAction action) {
            Suggester op = (Suggester)((Supplier)ops.get((Object)action)).get();
            if (op == null) {
                throw new UnsupportedOperationException(action.toString() + "is not supported");
            }
            op._init(this);
            return op;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"znodeVersion", this.znodeVersion);
            for (Row row : this.matrix) {
                ew.put((CharSequence)row.node, row);
            }
        }

        public String toString() {
            return Utils.toJSONString(this.toMap(new LinkedHashMap<String, Object>()));
        }

        public List<Row> getSortedNodes() {
            return Collections.unmodifiableList(this.matrix);
        }

        public NodeStateProvider getNodeStateProvider() {
            return this.nodeStateProvider;
        }

        public int indexOf(String node) {
            for (int i = 0; i < this.matrix.size(); ++i) {
                if (!this.matrix.get((int)i).node.equals(node)) continue;
                return i;
            }
            throw new RuntimeException("NO such node found " + node);
        }
    }

    public static enum SortParam {
        freedisk(0, Integer.MAX_VALUE),
        cores(0, Integer.MAX_VALUE),
        heapUsage(0, Integer.MAX_VALUE),
        sysLoadAvg(0, 100);

        public final int min;
        public final int max;

        private SortParam(int min, int max) {
            this.min = min;
            this.max = max;
        }

        static SortParam get(String m) {
            for (SortParam p : SortParam.values()) {
                if (!p.name().equals(m)) continue;
                return p;
            }
            throw new RuntimeException(StrUtils.formatString("Invalid sort {0} Sort must be on one of these {1}", m, Arrays.asList(SortParam.values())));
        }
    }

    static enum Sort {
        maximize(1),
        minimize(-1);

        final int sortval;

        private Sort(int i) {
            this.sortval = i;
        }

        static Sort get(Map<String, Object> m) {
            if (m.containsKey(maximize.name()) && m.containsKey(minimize.name())) {
                throw new RuntimeException("Cannot have both 'maximize' and 'minimize'");
            }
            if (m.containsKey(maximize.name())) {
                return maximize;
            }
            if (m.containsKey(minimize.name())) {
                return minimize;
            }
            throw new RuntimeException("must have either 'maximize' or 'minimize'");
        }
    }
}

