/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureTable;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ExportableView;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.FurnitureView;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class FurnitureTablePanel
extends JPanel
implements FurnitureView,
Printable {
    private JComponent furnitureTable;
    private JLabel totalPriceLabel;
    private JFormattedTextField totalPriceTextField;
    private JLabel totalValueAddedTaxLabel;
    private JFormattedTextField totalValueAddedTaxTextField;
    private JLabel totalPriceValueAddedTaxIncludedLabel;
    private JFormattedTextField totalPriceValueAddedTaxIncludedTextField;

    public FurnitureTablePanel(Home home, UserPreferences userPreferences, FurnitureController furnitureController) {
        super(new GridBagLayout());
        this.createComponents(home, userPreferences, furnitureController);
        this.layoutComponents();
    }

    private void createComponents(final Home home, final UserPreferences userPreferences, FurnitureController furnitureController) {
        this.furnitureTable = (JComponent)((Object)this.createFurnitureTable(home, userPreferences, furnitureController));
        this.totalPriceLabel = new JLabel(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalPriceLabel.text", new Object[0]));
        this.totalPriceTextField = this.createTotalTextField();
        this.totalValueAddedTaxLabel = new JLabel(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalValueAddedTaxLabel.text", new Object[0]));
        this.totalValueAddedTaxTextField = this.createTotalTextField();
        this.totalPriceValueAddedTaxIncludedLabel = new JLabel(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalPriceValueAddedTaxIncludedLabel.text", new Object[0]));
        this.totalPriceValueAddedTaxIncludedTextField = this.createTotalTextField();
        this.updateTotalsVisibility(userPreferences);
        this.updateTotals(home, userPreferences);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.PRICE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.VALUE_ADDED_TAX_PERCENTAGE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.CURRENCY.name().equals(propertyChangeEvent.getPropertyName())) {
                    FurnitureTablePanel.this.updateTotals(home, userPreferences);
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
            this.addPropertyChangeListener(homePieceOfFurniture, propertyChangeListener);
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    FurnitureTablePanel.this.addPropertyChangeListener(homePieceOfFurniture, propertyChangeListener);
                } else {
                    FurnitureTablePanel.this.removePropertyChangeListener(homePieceOfFurniture, propertyChangeListener);
                }
                FurnitureTablePanel.this.updateTotals(home, userPreferences);
            }
        });
        UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this, home);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.CURRENCY, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.VALUE_ADDED_TAX_ENABLED, userPreferencesChangeListener);
    }

    private void addPropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                this.addPropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
            }
        } else {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private void removePropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                this.removePropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
            }
        } else {
            homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected FurnitureView createFurnitureTable(Home home, UserPreferences userPreferences, FurnitureController furnitureController) {
        return new FurnitureTable(home, userPreferences, furnitureController);
    }

    private JFormattedTextField createTotalTextField() {
        NumberFormat numberFormat = DecimalFormat.getCurrencyInstance();
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setFocusable(false);
        return jFormattedTextField;
    }

    private void updateTotalsVisibility(UserPreferences userPreferences) {
        this.totalPriceLabel.setVisible(userPreferences.getCurrency() != null);
        this.totalPriceTextField.setVisible(userPreferences.getCurrency() != null);
        this.totalValueAddedTaxLabel.setVisible(userPreferences.isValueAddedTaxEnabled());
        this.totalValueAddedTaxTextField.setVisible(userPreferences.isValueAddedTaxEnabled());
        this.totalPriceValueAddedTaxIncludedLabel.setVisible(userPreferences.isValueAddedTaxEnabled());
        this.totalPriceValueAddedTaxIncludedTextField.setVisible(userPreferences.isValueAddedTaxEnabled());
    }

    private void updateTotals(Home home, UserPreferences userPreferences) {
        List<HomePieceOfFurniture> list = home.getFurniture();
        if (list.size() > 0) {
            BigDecimal bigDecimal = new BigDecimal("0");
            BigDecimal bigDecimal2 = new BigDecimal("0");
            BigDecimal bigDecimal3 = new BigDecimal("0");
            FurnitureView.FurnitureFilter furnitureFilter = this.getFurnitureFilter();
            String string = null;
            boolean bl = false;
            for (HomePieceOfFurniture serializable2 : home.getFurniture()) {
                BigDecimal bigDecimal4;
                if (furnitureFilter != null && !furnitureFilter.include(home, serializable2) || (bigDecimal4 = serializable2.getPrice()) == null) continue;
                if (!bl) {
                    bl = true;
                    string = serializable2.getCurrency();
                } else if (!(string == null && serializable2.getCurrency() == null || string != null && string.equals(serializable2.getCurrency()))) {
                    this.totalPriceTextField.setValue(null);
                    this.totalValueAddedTaxTextField.setValue(null);
                    this.totalPriceValueAddedTaxIncludedTextField.setValue(null);
                    return;
                }
                bigDecimal = bigDecimal.add(bigDecimal4);
                BigDecimal bigDecimal5 = serializable2.getValueAddedTax();
                if (bigDecimal5 != null) {
                    bigDecimal2 = bigDecimal2.add(bigDecimal5);
                }
                bigDecimal3 = bigDecimal3.add(serializable2.getPriceValueAddedTaxIncluded());
            }
            NumberFormat numberFormat = DecimalFormat.getCurrencyInstance();
            if (string == null) {
                string = userPreferences.getCurrency();
            }
            if (string != null) {
                try {
                    Currency illegalArgumentException = Currency.getInstance(string);
                    numberFormat.setCurrency(illegalArgumentException);
                    numberFormat.setMaximumFractionDigits(illegalArgumentException.getDefaultFractionDigits());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(new NumberFormatter(numberFormat));
            this.totalPriceTextField.setFormatterFactory(defaultFormatterFactory);
            this.totalValueAddedTaxTextField.setFormatterFactory(defaultFormatterFactory);
            this.totalPriceValueAddedTaxIncludedTextField.setFormatterFactory(defaultFormatterFactory);
            this.totalPriceTextField.setValue(bigDecimal);
            this.totalValueAddedTaxTextField.setValue(bigDecimal2);
            this.totalPriceValueAddedTaxIncludedTextField.setValue(bigDecimal3);
        } else {
            this.totalPriceTextField.setValue(null);
            this.totalValueAddedTaxTextField.setValue(null);
            this.totalPriceValueAddedTaxIncludedTextField.setValue(null);
        }
        this.revalidate();
    }

    private void layoutComponents() {
        JScrollPane jScrollPane = SwingTools.createScrollPane(this.furnitureTable);
        jScrollPane.setMinimumSize(new Dimension());
        final JViewport jViewport = jScrollPane.getViewport();
        jViewport.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jViewport.getView().requestFocusInWindow();
            }
        });
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.furnitureTable.setFocusTraversalKeys(0, keyboardFocusManager.getDefaultFocusTraversalKeys(0));
        this.furnitureTable.setFocusTraversalKeys(1, keyboardFocusManager.getDefaultFocusTraversalKeys(1));
        SwingTools.installFocusBorder(this.furnitureTable);
        this.setFocusTraversalPolicyProvider(false);
        this.setMinimumSize(new Dimension());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(2.0f * SwingTools.getResolutionScale());
        this.add((Component)this.totalPriceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(n2, 2, 0, n2), 0, 0));
        this.add((Component)this.totalPriceTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
        this.add((Component)this.totalValueAddedTaxLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(n2, n2, 0, n2), 0, 0));
        this.add((Component)this.totalValueAddedTaxTextField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
        this.add((Component)this.totalPriceValueAddedTaxIncludedLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(n2, n2, 0, n2), 0, 0));
        this.add((Component)this.totalPriceValueAddedTaxIncludedTextField, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
    }

    @Override
    public void doLayout() {
        super.doLayout();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        int[][] nArray = gridBagLayout.getLayoutDimensions();
        if (nArray.length > 1 && this.totalValueAddedTaxLabel.isVisible()) {
            int[] nArray2 = nArray[0];
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.totalValueAddedTaxLabel);
            GridBagConstraints gridBagConstraints2 = gridBagLayout.getConstraints(this.totalPriceLabel);
            if (gridBagConstraints.gridy == gridBagConstraints2.gridy) {
                if (nArray2[5] < this.totalPriceValueAddedTaxIncludedTextField.getPreferredSize().width) {
                    gridBagConstraints.gridx = gridBagConstraints2.gridx;
                    gridBagConstraints.gridy = gridBagConstraints2.gridy + 1;
                    gridBagLayout.setConstraints(this.totalValueAddedTaxLabel, gridBagConstraints);
                    gridBagConstraints = gridBagLayout.getConstraints(this.totalValueAddedTaxTextField);
                    gridBagConstraints.gridx = gridBagConstraints2.gridx + 1;
                    gridBagConstraints.gridy = gridBagConstraints2.gridy + 1;
                    gridBagLayout.setConstraints(this.totalValueAddedTaxTextField, gridBagConstraints);
                    gridBagConstraints = gridBagLayout.getConstraints(this.totalPriceValueAddedTaxIncludedLabel);
                    gridBagConstraints.gridx = gridBagConstraints2.gridx;
                    gridBagConstraints.gridy = gridBagConstraints2.gridy + 2;
                    gridBagLayout.setConstraints(this.totalPriceValueAddedTaxIncludedLabel, gridBagConstraints);
                    gridBagConstraints = gridBagLayout.getConstraints(this.totalPriceValueAddedTaxIncludedTextField);
                    gridBagConstraints.gridx = gridBagConstraints2.gridx + 1;
                    gridBagConstraints.gridy = gridBagConstraints2.gridy + 2;
                    gridBagLayout.setConstraints(this.totalPriceValueAddedTaxIncludedTextField, gridBagConstraints);
                    super.doLayout();
                }
            } else {
                gridBagConstraints.gridx = gridBagConstraints2.gridx + 2;
                gridBagConstraints.gridy = gridBagConstraints2.gridy;
                gridBagLayout.setConstraints(this.totalValueAddedTaxLabel, gridBagConstraints);
                gridBagConstraints = gridBagLayout.getConstraints(this.totalValueAddedTaxTextField);
                gridBagConstraints.gridx = gridBagConstraints2.gridx + 3;
                gridBagConstraints.gridy = gridBagConstraints2.gridy;
                gridBagLayout.setConstraints(this.totalValueAddedTaxTextField, gridBagConstraints);
                gridBagConstraints = gridBagLayout.getConstraints(this.totalPriceValueAddedTaxIncludedLabel);
                gridBagConstraints.gridx = gridBagConstraints2.gridx + 4;
                gridBagConstraints.gridy = gridBagConstraints2.gridy;
                gridBagLayout.setConstraints(this.totalPriceValueAddedTaxIncludedLabel, gridBagConstraints);
                gridBagConstraints = gridBagLayout.getConstraints(this.totalPriceValueAddedTaxIncludedTextField);
                gridBagConstraints.gridx = gridBagConstraints2.gridx + 5;
                gridBagConstraints.gridy = gridBagConstraints2.gridy;
                gridBagLayout.setConstraints(this.totalPriceValueAddedTaxIncludedTextField, gridBagConstraints);
                this.doLayout();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.furnitureTable instanceof Printable) {
            return ((Printable)((Object)this.furnitureTable)).print(graphics, pageFormat, n);
        }
        throw new IllegalStateException("Embeded furniture view not printable");
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.furnitureTable.setTransferHandler(transferHandler);
        ((JViewport)this.furnitureTable.getParent()).setTransferHandler(transferHandler);
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        this.furnitureTable.setComponentPopupMenu(jPopupMenu);
        ((JViewport)this.furnitureTable.getParent()).setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public Object createTransferData(TransferableView.DataType dataType) {
        return ((FurnitureView)((Object)this.furnitureTable)).createTransferData(dataType);
    }

    @Override
    public boolean isFormatTypeSupported(ExportableView.FormatType formatType) {
        return ((FurnitureView)((Object)this.furnitureTable)).isFormatTypeSupported(formatType);
    }

    @Override
    public void exportData(OutputStream outputStream, ExportableView.FormatType formatType, Properties properties) throws IOException {
        ((FurnitureView)((Object)this.furnitureTable)).exportData(outputStream, formatType, properties);
    }

    @Override
    public void setFurnitureFilter(FurnitureView.FurnitureFilter furnitureFilter) {
        ((FurnitureView)((Object)this.furnitureTable)).setFurnitureFilter(furnitureFilter);
    }

    @Override
    public FurnitureView.FurnitureFilter getFurnitureFilter() {
        return ((FurnitureView)((Object)this.furnitureTable)).getFurnitureFilter();
    }

    public static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private final WeakReference<FurnitureTablePanel> furnitureTablePanel;
        private final WeakReference<Home> home;

        public UserPreferencesChangeListener(FurnitureTablePanel furnitureTablePanel, Home home) {
            this.furnitureTablePanel = new WeakReference<FurnitureTablePanel>(furnitureTablePanel);
            this.home = new WeakReference<Home>(home);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureTablePanel furnitureTablePanel = (FurnitureTablePanel)this.furnitureTablePanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
            if (furnitureTablePanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                switch (property) {
                    case LANGUAGE: 
                    case CURRENCY: {
                        furnitureTablePanel.totalPriceLabel.setText(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalPriceLabel.text", new Object[0]));
                        furnitureTablePanel.totalValueAddedTaxLabel.setText(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalValueAddedTaxLabel.text", new Object[0]));
                        furnitureTablePanel.totalPriceValueAddedTaxIncludedLabel.setText(userPreferences.getLocalizedString(FurnitureTablePanel.class, "totalPriceValueAddedTaxIncludedLabel.text", new Object[0]));
                        furnitureTablePanel.updateTotals((Home)this.home.get(), userPreferences);
                    }
                    case VALUE_ADDED_TAX_ENABLED: {
                        furnitureTablePanel.updateTotalsVisibility(userPreferences);
                    }
                }
            }
        }
    }
}

