/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.ShapeTools;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.swing.CalculatorFormat;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ExportableView;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTKeyStroke;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.util.UserProperties;

public class PlanComponent
extends JComponent
implements PlanView,
Scrollable,
Printable {
    private static final float MARGIN = 40.0f;
    private final Home home;
    private final UserPreferences preferences;
    private final Object3DFactory object3dFactory;
    private float resolutionScale = SwingTools.getResolutionScale();
    private float scale = 0.5f * this.resolutionScale;
    private boolean selectedItemsOutlinePainted = true;
    private boolean backgroundPainted = true;
    private PlanRulerComponent horizontalRuler;
    private PlanRulerComponent verticalRuler;
    private final Cursor rotationCursor;
    private final Cursor elevationCursor;
    private final Cursor heightCursor;
    private final Cursor powerCursor;
    private final Cursor resizeCursor;
    private final Cursor moveCursor;
    private final Cursor panningCursor;
    private final Cursor duplicationCursor;
    private Rectangle2D rectangleFeedback;
    private Class<? extends Selectable> alignedObjectClass;
    private Selectable alignedObjectFeedback;
    private Point2D locationFeeback;
    private boolean showPointFeedback;
    private Point2D centerAngleFeedback;
    private Point2D point1AngleFeedback;
    private Point2D point2AngleFeedback;
    private List<Selectable> draggedItemsFeedback;
    private List<DimensionLine> dimensionLinesFeedback;
    private boolean selectionScrollUpdated;
    private boolean wallsDoorsOrWindowsModification;
    private JToolTip toolTip;
    private JWindow toolTipWindow;
    private boolean resizeIndicatorVisible;
    private Map<PlanController.EditableProperty, JFormattedTextField> toolTipEditableTextFields;
    private KeyListener toolTipKeyListener;
    private List<HomePieceOfFurniture> sortedLevelFurniture;
    private List<Room> sortedLevelRooms;
    private Map<TextStyle, Font> fonts;
    private Map<TextStyle, FontMetrics> fontsMetrics;
    private Rectangle2D planBoundsCache;
    private boolean planBoundsCacheValid = false;
    private Rectangle2D invalidPlanBounds;
    private BufferedImage backgroundImageCache;
    private Map<TextureImage, BufferedImage> patternImagesCache;
    private List<Wall> otherLevelsWallsCache;
    private Area otherLevelsWallAreaCache;
    private List<Room> otherLevelsRoomsCache;
    private Area otherLevelsRoomAreaCache;
    private Color wallsPatternBackgroundCache;
    private Color wallsPatternForegroundCache;
    private Map<Collection<Wall>, Area> wallAreasCache;
    private Map<HomeDoorOrWindow, Area> doorOrWindowWallThicknessAreasCache;
    private Map<HomeTexture, BufferedImage> floorTextureImagesCache;
    private Map<HomePieceOfFurniture, HomePieceOfFurnitureTopViewIconKey> furnitureTopViewIconKeys;
    private Map<HomePieceOfFurnitureTopViewIconKey, PieceOfFurnitureTopViewIcon> furnitureTopViewIconsCache;
    private static ExecutorService backgroundImageLoader;
    private static final Shape POINT_INDICATOR;
    private static final GeneralPath FURNITURE_ROTATION_INDICATOR;
    private static final GeneralPath FURNITURE_PITCH_ROTATION_INDICATOR;
    private static final Shape FURNITURE_ROLL_ROTATION_INDICATOR;
    private static final GeneralPath FURNITURE_RESIZE_INDICATOR;
    private static final GeneralPath ELEVATION_INDICATOR;
    private static final Shape ELEVATION_POINT_INDICATOR;
    private static final GeneralPath FURNITURE_HEIGHT_INDICATOR;
    private static final Shape FURNITURE_HEIGHT_POINT_INDICATOR;
    private static final GeneralPath LIGHT_POWER_INDICATOR;
    private static final Shape LIGHT_POWER_POINT_INDICATOR;
    private static final GeneralPath WALL_ORIENTATION_INDICATOR;
    private static final Shape WALL_POINT;
    private static final GeneralPath WALL_ARC_EXTENT_INDICATOR;
    private static final GeneralPath WALL_AND_LINE_RESIZE_INDICATOR;
    private static final Shape CAMERA_YAW_ROTATION_INDICATOR;
    private static final Shape CAMERA_PITCH_ROTATION_INDICATOR;
    private static final GeneralPath CAMERA_ELEVATION_INDICATOR;
    private static final Shape CAMERA_BODY;
    private static final Shape CAMERA_HEAD;
    private static final GeneralPath DIMENSION_LINE_END;
    private static final GeneralPath TEXT_LOCATION_INDICATOR;
    private static final GeneralPath TEXT_ANGLE_INDICATOR;
    private static final Shape LABEL_CENTER_INDICATOR;
    private static final Shape COMPASS_DISC;
    private static final GeneralPath COMPASS;
    private static final GeneralPath COMPASS_ROTATION_INDICATOR;
    private static final GeneralPath COMPASS_RESIZE_INDICATOR;
    private static final GeneralPath ARROW;
    private static final Stroke INDICATOR_STROKE;
    private static final Stroke POINT_STROKE;
    private static final float WALL_STROKE_WIDTH = 1.5f;
    private static final float BORDER_STROKE_WIDTH = 1.0f;
    private static final BufferedImage ERROR_TEXTURE_IMAGE;
    private static final BufferedImage WAIT_TEXTURE_IMAGE;

    public PlanComponent(Home home, UserPreferences userPreferences, PlanController planController) {
        this(home, userPreferences, null, planController);
    }

    public PlanComponent(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, PlanController planController) {
        this.home = home;
        this.preferences = userPreferences;
        try {
            if (object3DFactory == null && !Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
                object3DFactory = new Object3DBranchFactory();
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.object3dFactory = object3DFactory;
        this.setOpaque(true);
        this.addModelListeners(home, userPreferences, planController);
        this.createToolTipTextFields(userPreferences, planController);
        if (planController != null) {
            this.addMouseListeners(planController);
            this.addFocusListener(planController);
            this.addControllerListener(planController);
            this.createActions(planController);
            this.installDefaultKeyboardActions();
            this.setFocusable(true);
            this.setAutoscrolls(true);
        }
        this.rotationCursor = this.createCustomCursor("resources/cursors/rotation16x16.png", "resources/cursors/rotation32x32.png", "Rotation cursor", 13);
        this.elevationCursor = this.createCustomCursor("resources/cursors/elevation16x16.png", "resources/cursors/elevation32x32.png", "Elevation cursor", 13);
        this.heightCursor = this.createCustomCursor("resources/cursors/height16x16.png", "resources/cursors/height32x32.png", "Height cursor", 13);
        this.powerCursor = this.createCustomCursor("resources/cursors/power16x16.png", "resources/cursors/power32x32.png", "Power cursor", 13);
        this.resizeCursor = this.createCustomCursor("resources/cursors/resize16x16.png", "resources/cursors/resize32x32.png", "Resize cursor", 13);
        this.moveCursor = this.createCustomCursor("resources/cursors/move16x16.png", "resources/cursors/move32x32.png", "Move cursor", 13);
        this.panningCursor = this.createCustomCursor("resources/cursors/panning16x16.png", "resources/cursors/panning32x32.png", "Panning cursor", 12);
        this.duplicationCursor = DragSource.DefaultCopyDrop;
        this.patternImagesCache = new HashMap<TextureImage, BufferedImage>();
        super.setForeground(UIManager.getColor("TextField.foreground"));
        super.setBackground(UIManager.getColor("TextField.background"));
    }

    private void addModelListeners(final Home home, final UserPreferences userPreferences, final PlanController planController) {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if (PlanComponent.this.furnitureTopViewIconKeys != null && (HomePieceOfFurniture.Property.MODEL_TRANSFORMATIONS.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ROLL.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.PITCH.name().equals(propertyChangeEvent.getPropertyName()) || (HomePieceOfFurniture.Property.WIDTH_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.DEPTH_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.HEIGHT_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName())) && (((HomePieceOfFurniture)propertyChangeEvent.getSource()).isHorizontallyRotated() || ((HomePieceOfFurniture)propertyChangeEvent.getSource()).getTexture() != null))) {
                    if (HomePieceOfFurniture.Property.HEIGHT_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName())) {
                        PlanComponent.this.sortedLevelFurniture = null;
                    }
                    if (!(propertyChangeEvent.getSource() instanceof HomeFurnitureGroup)) {
                        if (planController == null || !planController.isModificationState()) {
                            PlanComponent.this.furnitureTopViewIconKeys.remove((HomePieceOfFurniture)propertyChangeEvent.getSource());
                        } else {
                            planController.addPropertyChangeListener(PlanController.Property.MODIFICATION_STATE, new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent propertyChangeEvent2) {
                                    PlanComponent.this.furnitureTopViewIconKeys.remove((HomePieceOfFurniture)propertyChangeEvent.getSource());
                                    PlanComponent.this.repaint();
                                    planController.removePropertyChangeListener(PlanController.Property.MODIFICATION_STATE, this);
                                }
                            });
                        }
                    }
                    PlanComponent.this.revalidate();
                } else if (PlanComponent.this.furnitureTopViewIconKeys != null && (HomePieceOfFurniture.Property.COLOR.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.MODEL_MATERIALS.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.SHININESS.name().equals(propertyChangeEvent.getPropertyName()))) {
                    PlanComponent.this.furnitureTopViewIconKeys.remove((HomePieceOfFurniture)propertyChangeEvent.getSource());
                    PlanComponent.this.repaint();
                } else if (HomePieceOfFurniture.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.LEVEL.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.HEIGHT_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName())) {
                    PlanComponent.this.sortedLevelFurniture = null;
                    PlanComponent.this.repaint();
                } else if (PlanComponent.this.doorOrWindowWallThicknessAreasCache != null && PlanComponent.this.doorOrWindowWallThicknessAreasCache.containsKey(propertyChangeEvent.getSource()) && (HomePieceOfFurniture.Property.WIDTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.DEPTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ANGLE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.MODEL_MIRRORED.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.MODEL_TRANSFORMATIONS.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.X.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.Y.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.LEVEL.name().equals(propertyChangeEvent.getPropertyName()))) {
                    PlanComponent.this.doorOrWindowWallThicknessAreasCache.remove(propertyChangeEvent.getSource());
                    PlanComponent.this.revalidate();
                } else {
                    PlanComponent.this.revalidate();
                }
            }
        };
        for (HomePieceOfFurniture object62 : home.getFurniture()) {
            object62.addPropertyChangeListener(propertyChangeListener);
            if (!(object62 instanceof HomeFurnitureGroup)) continue;
            for (HomePieceOfFurniture homePieceOfFurniture : ((HomeFurnitureGroup)object62).getAllFurniture()) {
                homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
            }
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
                    if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                        for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture2.addPropertyChangeListener(propertyChangeListener);
                        }
                    }
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
                    if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                        for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture3.removePropertyChangeListener(propertyChangeListener);
                        }
                    }
                }
                PlanComponent.this.sortedLevelFurniture = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Wall.Property.X_START.name().equals(string) || Wall.Property.X_END.name().equals(string) || Wall.Property.Y_START.name().equals(string) || Wall.Property.Y_END.name().equals(string) || Wall.Property.WALL_AT_START.name().equals(string) || Wall.Property.WALL_AT_END.name().equals(string) || Wall.Property.THICKNESS.name().equals(string) || Wall.Property.ARC_EXTENT.name().equals(string) || Wall.Property.PATTERN.name().equals(string)) {
                    if (home.isAllLevelsSelection()) {
                        PlanComponent.this.otherLevelsWallAreaCache = null;
                        PlanComponent.this.otherLevelsWallsCache = null;
                    }
                    PlanComponent.this.wallAreasCache = null;
                    PlanComponent.this.doorOrWindowWallThicknessAreasCache = null;
                    PlanComponent.this.revalidate();
                } else if (Wall.Property.LEVEL.name().equals(string) || Wall.Property.HEIGHT.name().equals(string) || Wall.Property.HEIGHT_AT_END.name().equals(string)) {
                    PlanComponent.this.otherLevelsWallAreaCache = null;
                    PlanComponent.this.otherLevelsWallsCache = null;
                    PlanComponent.this.wallAreasCache = null;
                    PlanComponent.this.repaint();
                }
            }
        };
        for (Wall wall : home.getWalls()) {
            wall.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addWallsListener(new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
                PlanComponent.this.otherLevelsWallAreaCache = null;
                PlanComponent.this.otherLevelsWallsCache = null;
                PlanComponent.this.wallAreasCache = null;
                PlanComponent.this.doorOrWindowWallThicknessAreasCache = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Room.Property.POINTS.name().equals(string) || Room.Property.NAME.name().equals(string) || Room.Property.NAME_X_OFFSET.name().equals(string) || Room.Property.NAME_Y_OFFSET.name().equals(string) || Room.Property.NAME_STYLE.name().equals(string) || Room.Property.NAME_ANGLE.name().equals(string) || Room.Property.AREA_VISIBLE.name().equals(string) || Room.Property.AREA_X_OFFSET.name().equals(string) || Room.Property.AREA_Y_OFFSET.name().equals(string) || Room.Property.AREA_STYLE.name().equals(string) || Room.Property.AREA_ANGLE.name().equals(string)) {
                    PlanComponent.this.sortedLevelRooms = null;
                    PlanComponent.this.otherLevelsRoomAreaCache = null;
                    PlanComponent.this.otherLevelsRoomsCache = null;
                    PlanComponent.this.revalidate();
                } else if (userPreferences.isRoomFloorColoredOrTextured() && (Room.Property.FLOOR_COLOR.name().equals(string) || Room.Property.FLOOR_TEXTURE.name().equals(string) || Room.Property.FLOOR_VISIBLE.name().equals(string))) {
                    PlanComponent.this.repaint();
                }
            }
        };
        for (Room room : home.getRooms()) {
            room.addPropertyChangeListener(propertyChangeListener3);
        }
        home.addRoomsListener(new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener3);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener3);
                }
                PlanComponent.this.sortedLevelRooms = null;
                PlanComponent.this.otherLevelsRoomAreaCache = null;
                PlanComponent.this.otherLevelsRoomsCache = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Polyline.Property.COLOR.name().equals(string) || Polyline.Property.DASH_STYLE.name().equals(string)) {
                    PlanComponent.this.repaint();
                } else {
                    PlanComponent.this.revalidate();
                }
            }
        };
        for (Polyline polyline : home.getPolylines()) {
            polyline.addPropertyChangeListener(propertyChangeListener4);
        }
        home.addPolylinesListener(new CollectionListener<Polyline>(){

            @Override
            public void collectionChanged(CollectionEvent<Polyline> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener4);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener4);
                }
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.revalidate();
            }
        };
        for (DimensionLine dimensionLine : home.getDimensionLines()) {
            dimensionLine.addPropertyChangeListener(propertyChangeListener5);
        }
        home.addDimensionLinesListener(new CollectionListener<DimensionLine>(){

            @Override
            public void collectionChanged(CollectionEvent<DimensionLine> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener5);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener5);
                }
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.revalidate();
            }
        };
        for (Label label : home.getLabels()) {
            label.addPropertyChangeListener(propertyChangeListener6);
        }
        home.addLabelsListener(new CollectionListener<Label>(){

            @Override
            public void collectionChanged(CollectionEvent<Label> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener6);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener6);
                }
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener7 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Level.Property.BACKGROUND_IMAGE.name().equals(string)) {
                    PlanComponent.this.backgroundImageCache = null;
                    PlanComponent.this.revalidate();
                } else if (Level.Property.ELEVATION.name().equals(string) || Level.Property.ELEVATION_INDEX.name().equals(string) || Level.Property.VIEWABLE.name().equals(string)) {
                    PlanComponent.this.backgroundImageCache = null;
                    PlanComponent.this.otherLevelsWallAreaCache = null;
                    PlanComponent.this.otherLevelsWallsCache = null;
                    PlanComponent.this.otherLevelsRoomAreaCache = null;
                    PlanComponent.this.otherLevelsRoomsCache = null;
                    PlanComponent.this.wallAreasCache = null;
                    PlanComponent.this.doorOrWindowWallThicknessAreasCache = null;
                    PlanComponent.this.sortedLevelFurniture = null;
                    PlanComponent.this.sortedLevelRooms = null;
                    PlanComponent.this.repaint();
                }
            }
        };
        for (Level level : home.getLevels()) {
            level.addPropertyChangeListener(propertyChangeListener7);
        }
        home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                Level level = collectionEvent.getItem();
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    level.addPropertyChangeListener(propertyChangeListener7);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    level.removePropertyChangeListener(propertyChangeListener7);
                }
                PlanComponent.this.revalidate();
            }
        });
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.revalidate();
            }
        });
        home.getObserverCamera().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Camera.Property.X.name().equals(string) || Camera.Property.Y.name().equals(string) || Camera.Property.FIELD_OF_VIEW.name().equals(string) || Camera.Property.YAW.name().equals(string) || ObserverCamera.Property.WIDTH.name().equals(string) || ObserverCamera.Property.DEPTH.name().equals(string) || ObserverCamera.Property.HEIGHT.name().equals(string)) {
                    PlanComponent.this.revalidate();
                }
            }
        });
        home.getCompass().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Compass.Property.X.name().equals(string) || Compass.Property.Y.name().equals(string) || Compass.Property.NORTH_DIRECTION.name().equals(string) || Compass.Property.DIAMETER.name().equals(string) || Compass.Property.VISIBLE.name().equals(string)) {
                    PlanComponent.this.revalidate();
                }
            }
        });
        home.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                PlanComponent.this.repaint();
            }
        });
        home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.backgroundImageCache = null;
                PlanComponent.this.repaint();
            }
        });
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.backgroundImageCache = null;
                PlanComponent.this.otherLevelsWallAreaCache = null;
                PlanComponent.this.otherLevelsWallsCache = null;
                PlanComponent.this.otherLevelsRoomAreaCache = null;
                PlanComponent.this.otherLevelsRoomsCache = null;
                PlanComponent.this.wallAreasCache = null;
                PlanComponent.this.doorOrWindowWallThicknessAreasCache = null;
                PlanComponent.this.sortedLevelRooms = null;
                PlanComponent.this.sortedLevelFurniture = null;
                PlanComponent.this.repaint();
            }
        });
        UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.GRID_VISIBLE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.DEFAULT_FONT_NAME, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_VIEWED_FROM_TOP, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_MODEL_ICON_SIZE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.ROOM_FLOOR_COLORED_OR_TEXTURED, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.WALL_PATTERN, userPreferencesChangeListener);
    }

    @Override
    public void revalidate() {
        super.revalidate();
        this.repaint();
        if (this.horizontalRuler != null) {
            this.horizontalRuler.revalidate();
            this.horizontalRuler.repaint();
        }
        if (this.verticalRuler != null) {
            this.verticalRuler.revalidate();
            this.verticalRuler.repaint();
        }
    }

    private void invalidate(boolean bl) {
        if (this.isValid()) {
            if (bl) {
                boolean bl2 = this.planBoundsCacheValid;
                if (this.invalidPlanBounds == null) {
                    this.invalidPlanBounds = this.getPlanBounds().getBounds2D();
                }
                if (bl2) {
                    this.planBoundsCacheValid = false;
                }
            }
            super.invalidate();
        }
    }

    @Override
    public void invalidate() {
        this.invalidate(true);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.invalidPlanBounds != null && this.getParent() instanceof JViewport) {
            float f = (float)this.getPlanBounds().getMinX();
            float f2 = (float)this.getPlanBounds().getMinY();
            if ((double)f < this.invalidPlanBounds.getMinX() || (double)f2 < this.invalidPlanBounds.getMinY()) {
                JViewport jViewport = (JViewport)this.getParent();
                Point point = jViewport.getViewPosition();
                Dimension dimension = jViewport.getExtentSize();
                Dimension dimension2 = jViewport.getViewSize();
                if (dimension.width < dimension2.width || dimension.height < dimension2.height) {
                    int n = Math.round(((float)this.invalidPlanBounds.getMinX() - f) * this.getScale());
                    int n2 = Math.round(((float)this.invalidPlanBounds.getMinY() - f2) * this.getScale());
                    jViewport.setViewPosition(new Point(point.x + n, point.y + n2));
                }
            }
        }
        this.invalidPlanBounds = null;
    }

    private void addMouseListeners(final PlanController planController) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private Point lastMousePressedLocation;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.lastMousePressedLocation = mouseEvent.getPoint();
                if (PlanComponent.this.isEnabled() && !mouseEvent.isPopupTrigger()) {
                    PlanComponent.this.requestFocusInWindow();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        boolean bl;
                        boolean bl2 = OperatingSystem.isWindows() || OperatingSystem.isMacOSX() ? mouseEvent.isShiftDown() : mouseEvent.isShiftDown() && !mouseEvent.isAltDown();
                        boolean bl3 = bl = OperatingSystem.isMacOSX() ? mouseEvent.isAltDown() : mouseEvent.isControlDown();
                        boolean bl4 = OperatingSystem.isWindows() ? mouseEvent.isAltDown() : (OperatingSystem.isMacOSX() ? mouseEvent.isMetaDown() : mouseEvent.isShiftDown() && mouseEvent.isAltDown());
                        planController.pressMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()), mouseEvent.getClickCount(), mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown(), bl2, bl, bl4);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (PlanComponent.this.isEnabled() && !mouseEvent.isPopupTrigger() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    planController.releaseMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()));
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (this.lastMousePressedLocation != null && !this.lastMousePressedLocation.equals(mouseEvent.getPoint())) {
                    this.lastMousePressedLocation = null;
                }
                if (this.lastMousePressedLocation == null && PlanComponent.this.isEnabled()) {
                    planController.moveMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()));
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlanComponent.this.isEnabled()) {
                    this.mouseMoved(mouseEvent);
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getModifiers() == PlanComponent.this.getToolkit().getMenuShortcutKeyMask()) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n = 0;
                    int n2 = 0;
                    if (PlanComponent.this.getParent() instanceof JViewport) {
                        f = PlanComponent.this.convertXPixelToModel(mouseWheelEvent.getX());
                        f2 = PlanComponent.this.convertYPixelToModel(mouseWheelEvent.getY());
                        Rectangle rectangle = ((JViewport)PlanComponent.this.getParent()).getViewRect();
                        n = mouseWheelEvent.getX() - rectangle.x;
                        n2 = mouseWheelEvent.getY() - rectangle.y;
                    }
                    float f3 = PlanComponent.this.getScale();
                    planController.zoom((float)(mouseWheelEvent.getWheelRotation() < 0 ? Math.pow(1.05, -mouseWheelEvent.getWheelRotation()) : Math.pow(0.95, mouseWheelEvent.getWheelRotation())));
                    if (PlanComponent.this.getScale() != f3 && PlanComponent.this.getParent() instanceof JViewport) {
                        ((JViewport)PlanComponent.this.getParent()).setViewPosition(new Point());
                        PlanComponent.this.moveView(f - PlanComponent.this.convertXPixelToModel(n), f2 - PlanComponent.this.convertYPixelToModel(n2));
                    }
                } else if (PlanComponent.this.getMouseWheelListeners().length == 1) {
                    PlanComponent.this.getParent().dispatchEvent(new MouseWheelEvent((Component)PlanComponent.this.getParent(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx() | mouseWheelEvent.getModifiers(), mouseWheelEvent.getX() - PlanComponent.this.getX(), mouseWheelEvent.getY() - PlanComponent.this.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
                }
            }
        });
    }

    private void addFocusListener(final PlanController planController) {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                planController.escape();
            }
        });
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.addPropertyChangeListener("Frame.active", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!PlanComponent.this.home.getSelectedItems().isEmpty()) {
                        PlanComponent.this.repaint();
                    }
                }
            });
        }
    }

    private void addControllerListener(final PlanController planController) {
        planController.addPropertyChangeListener(PlanController.Property.BASE_PLAN_MODIFICATION_STATE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = planController.isBasePlanModificationState();
                if (bl && planController.getMode() != PlanController.Mode.WALL_CREATION) {
                    for (Selectable selectable : PlanComponent.this.draggedItemsFeedback != null ? PlanComponent.this.draggedItemsFeedback : PlanComponent.this.home.getSelectedItems()) {
                        if (selectable instanceof Wall || selectable instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)selectable).isDoorOrWindow()) continue;
                        bl = false;
                    }
                }
                if (PlanComponent.this.wallsDoorsOrWindowsModification != bl) {
                    PlanComponent.this.wallsDoorsOrWindowsModification = bl;
                    PlanComponent.this.repaint();
                }
            }
        });
    }

    private void installDefaultKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), (Object)ActionType.DELETE_SELECTION);
        inputMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), (Object)ActionType.DELETE_SELECTION);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("shift ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), (Object)ActionType.MOVE_SELECTION_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), (Object)ActionType.MOVE_SELECTION_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("UP"), (Object)ActionType.MOVE_SELECTION_UP);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), (Object)ActionType.MOVE_SELECTION_FAST_UP);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), (Object)ActionType.MOVE_SELECTION_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), (Object)ActionType.MOVE_SELECTION_FAST_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), (Object)ActionType.MOVE_SELECTION_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), (Object)ActionType.MOVE_SELECTION_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("meta alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("meta released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift meta alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift meta released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("meta control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("meta released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift meta control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift meta released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("control ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("control ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        }
        if (OperatingSystem.isWindows()) {
            inputMap.put(KeyStroke.getKeyStroke("alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("control alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("control released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("shift control alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("shift control released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        } else if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("meta pressed META"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("released META"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("shift meta pressed META"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("shift released META"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("alt meta pressed META"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("alt released META"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("shift alt meta pressed META"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("shift alt released META"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("meta ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("meta ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("alt shift pressed SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("alt released SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("control shift alt pressed ALT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("control alt shift pressed SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("control alt released SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("control shift released ALT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
            inputMap.put(KeyStroke.getKeyStroke("alt shift ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt shift  ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("control alt shift ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("control alt shift  ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        }
        inputMap.put(KeyStroke.getKeyStroke("shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
        inputMap.put(KeyStroke.getKeyStroke("released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
        if (OperatingSystem.isWindows()) {
            inputMap.put(KeyStroke.getKeyStroke("control shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("control released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("alt shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("alt released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
        } else if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("alt shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("alt released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("meta shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("meta released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("control shift pressed SHIFT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("control released SHIFT"), (Object)ActionType.DEACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
            inputMap.put(KeyStroke.getKeyStroke("control shift released ALT"), (Object)ActionType.ACTIVATE_ALIGNMENT);
        }
    }

    private void installEditionKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("shift ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
        if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("alt shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("control ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("control ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("control shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
        }
    }

    private void createActions(final PlanController planController) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.deleteSelection();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.escape();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.DELETE_SELECTION, abstractAction);
        actionMap.put((Object)ActionType.ESCAPE, abstractAction2);
        class MoveSelectionAction
        extends AbstractAction {
            private final int dx;
            private final int dy;

            public MoveSelectionAction(int n, int n2) {
                this.dx = n;
                this.dy = n2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.moveSelection((float)this.dx / PlanComponent.this.getScale(), (float)this.dy / PlanComponent.this.getScale());
            }
        }
        actionMap.put((Object)ActionType.MOVE_SELECTION_LEFT, new MoveSelectionAction(-1, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_LEFT, new MoveSelectionAction(-10, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_UP, new MoveSelectionAction(0, -1));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_UP, new MoveSelectionAction(0, -10));
        actionMap.put((Object)ActionType.MOVE_SELECTION_DOWN, new MoveSelectionAction(0, 1));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_DOWN, new MoveSelectionAction(0, 10));
        actionMap.put((Object)ActionType.MOVE_SELECTION_RIGHT, new MoveSelectionAction(1, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_RIGHT, new MoveSelectionAction(10, 0));
        class ToggleMagnetismAction
        extends AbstractAction {
            private final boolean toggle;

            public ToggleMagnetismAction(boolean bl) {
                this.toggle = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.toggleMagnetism(this.toggle);
            }
        }
        actionMap.put((Object)ActionType.TOGGLE_MAGNETISM_ON, new ToggleMagnetismAction(true));
        actionMap.put((Object)ActionType.TOGGLE_MAGNETISM_OFF, new ToggleMagnetismAction(false));
        class SetAlignmentActivatedAction
        extends AbstractAction {
            private final boolean alignmentActivated;

            public SetAlignmentActivatedAction(boolean bl) {
                this.alignmentActivated = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.setAlignmentActivated(this.alignmentActivated);
            }
        }
        actionMap.put((Object)ActionType.ACTIVATE_ALIGNMENT, new SetAlignmentActivatedAction(true));
        actionMap.put((Object)ActionType.DEACTIVATE_ALIGNMENT, new SetAlignmentActivatedAction(false));
        class SetDuplicationActivatedAction
        extends AbstractAction {
            private final boolean duplicationActivated;

            public SetDuplicationActivatedAction(boolean bl) {
                this.duplicationActivated = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.setDuplicationActivated(this.duplicationActivated);
            }
        }
        actionMap.put((Object)ActionType.ACTIVATE_DUPLICATION, new SetDuplicationActivatedAction(true));
        actionMap.put((Object)ActionType.DEACTIVATE_DUPLICATION, new SetDuplicationActivatedAction(false));
        class SetEditionActivatedAction
        extends AbstractAction {
            private final boolean editionActivated;

            public SetEditionActivatedAction(boolean bl) {
                this.editionActivated = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.setEditionActivated(this.editionActivated);
            }
        }
        actionMap.put((Object)ActionType.ACTIVATE_EDITIION, new SetEditionActivatedAction(true));
        actionMap.put((Object)ActionType.DEACTIVATE_EDITIION, new SetEditionActivatedAction(false));
    }

    private void createToolTipTextFields(UserPreferences userPreferences, final PlanController planController) {
        this.toolTipEditableTextFields = new HashMap<PlanController.EditableProperty, JFormattedTextField>();
        Font font = UIManager.getFont("ToolTip.font");
        for (final PlanController.EditableProperty editableProperty : PlanController.EditableProperty.values()) {
            final JFormattedTextField jFormattedTextField = new JFormattedTextField(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(dimension.width + 1, dimension.height);
                }
            };
            PlanComponent.updateToolTipTextFieldFormatterFactory(jFormattedTextField, editableProperty, userPreferences);
            jFormattedTextField.setFont(font);
            jFormattedTextField.setOpaque(false);
            jFormattedTextField.setBorder(null);
            if (planController != null) {
                jFormattedTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        try {
                            jFormattedTextField.commitEdit();
                            planController.updateEditableProperty(editableProperty, jFormattedTextField.getValue());
                        }
                        catch (ParseException parseException) {
                            planController.updateEditableProperty(editableProperty, null);
                        }
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }
                });
            }
            this.toolTipEditableTextFields.put(editableProperty, jFormattedTextField);
        }
    }

    private static void updateToolTipTextFieldFormatterFactory(JFormattedTextField jFormattedTextField, PlanController.EditableProperty editableProperty, UserPreferences userPreferences) {
        InternationalFormatter internationalFormatter;
        if (editableProperty == PlanController.EditableProperty.ANGLE) {
            DecimalFormat decimalFormat = new DecimalFormat("0.#");
            try {
                decimalFormat = new CalculatorFormat(decimalFormat, null);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            internationalFormatter = new NumberFormatter(decimalFormat);
        } else {
            Format format = userPreferences.getLengthUnit().getFormat();
            if (format instanceof DecimalFormat) {
                try {
                    format = new CalculatorFormat((DecimalFormat)format, userPreferences.getLengthUnit());
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
                internationalFormatter = new NumberFormatter((DecimalFormat)format);
            } else {
                internationalFormatter = new InternationalFormatter(format);
            }
        }
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(internationalFormatter));
    }

    private Cursor createCustomCursor(String string, String string2, String string3, int n) {
        if (OperatingSystem.isMacOSX()) {
            string = string.replace(".png", "-macosx.png");
        }
        return this.createCustomCursor(PlanComponent.class.getResource(string), PlanComponent.class.getResource(string2), 0.5f, 0.5f, string3, Cursor.getPredefinedCursor(n));
    }

    protected Cursor createCustomCursor(URL uRL, URL uRL2, float f, float f2, String string, Cursor cursor) {
        return SwingTools.createCustomCursor(uRL, uRL2, f, f2, string, cursor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return new Dimension(Math.round(((float)rectangle2D.getWidth() + 80.0f) * this.getScale()) + insets.left + insets.right, Math.round(((float)rectangle2D.getHeight() + 80.0f) * this.getScale()) + insets.top + insets.bottom);
    }

    private Rectangle2D getPlanBounds() {
        if (!this.planBoundsCacheValid) {
            Object object;
            Object object2;
            if (this.planBoundsCache == null || !(this.getParent() instanceof JViewport)) {
                this.planBoundsCache = new Rectangle2D.Float(0.0f, 0.0f, 1000.0f, 1000.0f);
            }
            if (this.backgroundImageCache != null) {
                object2 = this.home.getBackgroundImage();
                if (object2 != null) {
                    this.planBoundsCache.add(-((BackgroundImage)object2).getXOrigin(), -((BackgroundImage)object2).getYOrigin());
                    this.planBoundsCache.add((float)this.backgroundImageCache.getWidth() * ((BackgroundImage)object2).getScale() - ((BackgroundImage)object2).getXOrigin(), (float)this.backgroundImageCache.getHeight() * ((BackgroundImage)object2).getScale() - ((BackgroundImage)object2).getYOrigin());
                }
                object = this.home.getLevels().iterator();
                while (object.hasNext()) {
                    Level level = (Level)object.next();
                    BackgroundImage backgroundImage = level.getBackgroundImage();
                    if (backgroundImage == null) continue;
                    this.planBoundsCache.add(-backgroundImage.getXOrigin(), -backgroundImage.getYOrigin());
                    this.planBoundsCache.add((float)this.backgroundImageCache.getWidth() * backgroundImage.getScale() - backgroundImage.getXOrigin(), (float)this.backgroundImageCache.getHeight() * backgroundImage.getScale() - backgroundImage.getYOrigin());
                }
            }
            if ((object2 = (Graphics2D)this.getGraphics()) != null) {
                this.setRenderingHints((Graphics2D)object2);
            }
            if ((object = this.getItemsBounds((Graphics)object2, this.getPaintedItems())) != null) {
                this.planBoundsCache.add((Rectangle2D)object);
            }
            for (Object object3 : (Level)this.home.getObserverCamera().getPoints()) {
                this.planBoundsCache.add((double)object3[0], (double)object3[1]);
            }
            this.planBoundsCacheValid = true;
        }
        return this.planBoundsCache;
    }

    protected List<Selectable> getPaintedItems() {
        return this.home.getSelectableViewableItems();
    }

    private Rectangle2D getItemsBounds(Graphics graphics, Collection<? extends Selectable> collection) {
        Rectangle2D rectangle2D = null;
        for (Selectable selectable : collection) {
            if (rectangle2D == null) {
                rectangle2D = this.getItemBounds(graphics, selectable);
                continue;
            }
            rectangle2D.add(this.getItemBounds(graphics, selectable));
        }
        return rectangle2D;
    }

    protected Rectangle2D getItemBounds(Graphics graphics, Selectable selectable) {
        float[][] fArray = selectable.getPoints();
        Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0][0], fArray[0][1], 0.0f, 0.0f);
        for (int i = 1; i < fArray.length; ++i) {
            float_.add(fArray[i][0], fArray[i][1]);
        }
        Font font = graphics != null ? graphics.getFont() : this.getFont();
        if (selectable instanceof Room) {
            float f;
            Room room = (Room)selectable;
            float f2 = room.getXCenter();
            float f3 = room.getYCenter();
            String string = room.getName();
            if (string != null && string.length() > 0) {
                this.addTextBounds(room.getClass(), string, room.getNameStyle(), f2 + room.getNameXOffset(), f3 + room.getNameYOffset(), room.getNameAngle(), float_);
            }
            if (room.isAreaVisible() && (f = room.getArea()) > 0.01f) {
                String string2 = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(f));
                this.addTextBounds(room.getClass(), string2, room.getAreaStyle(), f2 + room.getAreaXOffset(), f3 + room.getAreaYOffset(), room.getAreaAngle(), float_);
            }
        } else {
            if (selectable instanceof Polyline) {
                Polyline polyline = (Polyline)selectable;
                return ShapeTools.getPolylineShape(polyline.getPoints(), polyline.getJoinStyle() == Polyline.JoinStyle.CURVED, polyline.isClosedPath()).getBounds2D();
            }
            if (selectable instanceof HomePieceOfFurniture) {
                HomePieceOfFurniture homePieceOfFurniture;
                if (selectable instanceof HomeDoorOrWindow) {
                    homePieceOfFurniture = (HomeDoorOrWindow)selectable;
                    for (Sash sash : ((HomeDoorOrWindow)homePieceOfFurniture).getSashes()) {
                        float_.add(this.getDoorOrWindowSashShape((HomeDoorOrWindow)homePieceOfFurniture, sash).getBounds2D());
                    }
                } else if (selectable instanceof HomeFurnitureGroup) {
                    float_.add(this.getItemsBounds(graphics, ((HomeFurnitureGroup)selectable).getFurniture()));
                }
                homePieceOfFurniture = (HomePieceOfFurniture)selectable;
                String string = homePieceOfFurniture.getName();
                if (homePieceOfFurniture.isVisible() && homePieceOfFurniture.isNameVisible() && string.length() > 0) {
                    this.addTextBounds(homePieceOfFurniture.getClass(), string, homePieceOfFurniture.getNameStyle(), homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset(), homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset(), homePieceOfFurniture.getNameAngle(), float_);
                }
            } else if (selectable instanceof DimensionLine) {
                float[] fArray2;
                DimensionLine dimensionLine = (DimensionLine)selectable;
                float f = dimensionLine.getLength();
                String string = this.preferences.getLengthUnit().getFormat().format(Float.valueOf(f));
                TextStyle textStyle = dimensionLine.getLengthStyle();
                if (textStyle == null) {
                    textStyle = this.preferences.getDefaultTextStyle(dimensionLine.getClass());
                }
                FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(dimensionLine.getXStart(), dimensionLine.getYStart());
                affineTransform.rotate(d);
                affineTransform.translate(0.0, dimensionLine.getOffset());
                affineTransform.translate(((double)f - rectangle2D.getWidth()) / 2.0, dimensionLine.getOffset() <= 0.0f ? (double)(-fontMetrics.getDescent() - 1) : (double)(fontMetrics.getAscent() + 1));
                GeneralPath generalPath = new GeneralPath(rectangle2D);
                PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
                while (!pathIterator.isDone()) {
                    fArray2 = new float[2];
                    if (pathIterator.currentSegment(fArray2) != 4) {
                        float_.add(fArray2[0], fArray2[1]);
                    }
                    pathIterator.next();
                }
                affineTransform.setToTranslation(dimensionLine.getXStart(), dimensionLine.getYStart());
                affineTransform.rotate(d);
                affineTransform.translate(0.0, dimensionLine.getOffset());
                pathIterator = DIMENSION_LINE_END.getPathIterator(affineTransform);
                while (!pathIterator.isDone()) {
                    fArray2 = new float[2];
                    if (pathIterator.currentSegment(fArray2) != 4) {
                        float_.add(fArray2[0], fArray2[1]);
                    }
                    pathIterator.next();
                }
                affineTransform.translate(f, 0.0);
                pathIterator = DIMENSION_LINE_END.getPathIterator(affineTransform);
                while (!pathIterator.isDone()) {
                    fArray2 = new float[2];
                    if (pathIterator.currentSegment(fArray2) != 4) {
                        float_.add(fArray2[0], fArray2[1]);
                    }
                    pathIterator.next();
                }
            } else if (selectable instanceof Label) {
                Label label = (Label)selectable;
                this.addTextBounds(label.getClass(), label.getText(), label.getStyle(), label.getX(), label.getY(), label.getAngle(), float_);
            } else if (selectable instanceof Compass) {
                Compass compass = (Compass)selectable;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(compass.getX(), compass.getY());
                affineTransform.scale(compass.getDiameter(), compass.getDiameter());
                affineTransform.rotate(compass.getNorthDirection());
                return COMPASS.createTransformedShape(affineTransform).getBounds2D();
            }
        }
        return float_;
    }

    private void addTextBounds(Class<? extends Selectable> clazz, String string, TextStyle textStyle, float f, float f2, float f3, Rectangle2D rectangle2D) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(clazz);
        }
        for (float[] fArray : this.getTextBounds(string, textStyle, f, f2, f3)) {
            rectangle2D.add(fArray[0], fArray[1]);
        }
    }

    @Override
    public float[][] getTextBounds(String string, TextStyle textStyle, float f, float f2, float f3) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont(), textStyle);
        RectangularShape rectangularShape = null;
        String[] stringArray = string.split("\n");
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            this.setRenderingHints(graphics2D);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(stringArray[i], graphics2D);
            if (rectangularShape != null && !(rectangularShape.getWidth() < rectangle2D.getWidth())) continue;
            rectangularShape = rectangle2D;
        }
        float f4 = (float)rectangularShape.getWidth();
        float f5 = textStyle.getAlignment() == TextStyle.Alignment.LEFT ? 0.0f : (textStyle.getAlignment() == TextStyle.Alignment.RIGHT ? -f4 : -f4 / 2.0f);
        if (f3 == 0.0f) {
            float f6 = (float)((double)f2 + rectangularShape.getY());
            float f7 = (float)((double)f6 + rectangularShape.getHeight());
            return new float[][]{{f + f5, f6 -= (float)(rectangularShape.getHeight() * (double)(stringArray.length - 1))}, {f + f5 + f4, f6}, {f + f5 + f4, f7}, {f + f5, f7}};
        }
        ((Rectangle2D)rectangularShape).add(rectangularShape.getX(), rectangularShape.getY() - rectangularShape.getHeight() * (double)(stringArray.length - 1));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        affineTransform.rotate(f3);
        affineTransform.translate(f5, 0.0);
        GeneralPath generalPath = new GeneralPath(rectangularShape);
        ArrayList<float[]> arrayList = new ArrayList<float[]>(4);
        PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            float[] fArray = new float[2];
            if (pathIterator.currentSegment(fArray) != 4) {
                arrayList.add(fArray);
            }
            pathIterator.next();
        }
        return (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
    }

    protected Font getFont(Font font, TextStyle textStyle) {
        Font font2;
        if (this.fonts == null) {
            this.fonts = new WeakHashMap<TextStyle, Font>();
        }
        if ((font2 = this.fonts.get(textStyle)) == null) {
            int n = 0;
            if (textStyle.isBold()) {
                n = 1;
            }
            if (textStyle.isItalic()) {
                n |= 2;
            }
            if (font == null || this.preferences.getDefaultFontName() != null || textStyle.getFontName() != null) {
                String string = textStyle.getFontName();
                if (string == null) {
                    string = this.preferences.getDefaultFontName();
                }
                font = new Font(string, n, 1);
            }
            font2 = font.deriveFont(n, textStyle.getFontSize());
            this.fonts.put(textStyle, font2);
        }
        return font2;
    }

    protected FontMetrics getFontMetrics(Font font, TextStyle textStyle) {
        FontMetrics fontMetrics;
        if (this.fontsMetrics == null) {
            this.fontsMetrics = new WeakHashMap<TextStyle, FontMetrics>();
        }
        if ((fontMetrics = this.fontsMetrics.get(textStyle)) == null) {
            fontMetrics = this.getFontMetrics(this.getFont(font, textStyle));
            this.fontsMetrics.put(textStyle, fontMetrics);
        }
        return fontMetrics;
    }

    public void setBackgroundPainted(boolean bl) {
        if (this.backgroundPainted != bl) {
            this.backgroundPainted = bl;
            this.repaint();
        }
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    public void setSelectedItemsOutlinePainted(boolean bl) {
        if (this.selectedItemsOutlinePainted != bl) {
            this.selectedItemsOutlinePainted = bl;
            this.repaint();
        }
    }

    public boolean isSelectedItemsOutlinePainted() {
        return this.selectedItemsOutlinePainted;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.backgroundPainted) {
            this.paintBackground(graphics2D, this.getBackgroundColor(PaintMode.PAINT));
        }
        Insets insets = this.getInsets();
        graphics2D.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        Rectangle2D rectangle2D = this.getPlanBounds();
        float f = this.getScale();
        graphics2D.translate((double)insets.left + (40.0 - rectangle2D.getMinX()) * (double)f, (double)insets.top + (40.0 - rectangle2D.getMinY()) * (double)f);
        graphics2D.scale(f, f);
        this.setRenderingHints(graphics2D);
        try {
            this.paintContent(graphics2D, f, PaintMode.PAINT);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        graphics2D.dispose();
    }

    public float getPrintPreferredScale(Graphics graphics, PageFormat pageFormat) {
        return this.getPrintPreferredScale(LengthUnit.inchToCentimeter((float)pageFormat.getImageableWidth() / 72.0f), LengthUnit.inchToCentimeter((float)pageFormat.getImageableHeight() / 72.0f));
    }

    @Override
    public float getPrintPreferredScale(float f, float f2) {
        Rectangle2D rectangle2D;
        List<Selectable> list = this.getPaintedItems();
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            this.setRenderingHints(graphics2D);
        }
        if ((rectangle2D = this.getItemsBounds(graphics2D, list)) != null) {
            float f3 = this.getStrokeWidthExtraMargin(list, PaintMode.PRINT);
            int n = (int)Math.ceil(Math.max((rectangle2D.getWidth() + (double)(2.0f * f3)) / (double)f, (rectangle2D.getHeight() + (double)(2.0f * f3)) / (double)f2));
            return 1.0f / (float)n;
        }
        return 0.0f;
    }

    private float getStrokeWidthExtraMargin(List<Selectable> list, PaintMode paintMode) {
        List<Polyline> list2;
        float f = 1.0f;
        if (Home.getFurnitureSubList(list).size() > 0) {
            f = Math.max(f, this.getStrokeWidth(HomePieceOfFurniture.class, paintMode));
        }
        if (Home.getWallsSubList(list).size() > 0) {
            f = Math.max(f, this.getStrokeWidth(Wall.class, paintMode));
        }
        if (Home.getRoomsSubList(list).size() > 0) {
            f = Math.max(f, this.getStrokeWidth(Room.class, paintMode));
        }
        if ((list2 = Home.getPolylinesSubList(list)).size() > 0) {
            for (Polyline polyline : list2) {
                f = Math.max(f, polyline.getStartArrowStyle() != null || polyline.getEndArrowStyle() != null ? 1.5f * polyline.getThickness() : polyline.getThickness());
            }
        }
        if (Home.getDimensionLinesSubList(list).size() > 0) {
            f = Math.max(f, this.getStrokeWidth(DimensionLine.class, paintMode));
        }
        return f / 2.0f;
    }

    private float getStrokeWidth(Class<? extends Selectable> clazz, PaintMode paintMode) {
        float f = Wall.class.isAssignableFrom(clazz) || Room.class.isAssignableFrom(clazz) ? 1.5f : 1.0f;
        f = paintMode == PaintMode.PRINT ? (float)((double)f * 0.5) : (f *= this.resolutionScale);
        return f;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        List<Selectable> list = this.getPaintedItems();
        Rectangle2D rectangle2D = this.getItemsBounds(graphics, list);
        if (rectangle2D != null) {
            float f;
            float f2;
            int n2;
            int n3;
            float f3;
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            double d3 = pageFormat.getImageableWidth();
            double d4 = pageFormat.getImageableHeight();
            if (this.home.getPrint() == null || this.home.getPrint().getPlanScale() == null) {
                f3 = this.getPrintPreferredScale(graphics, pageFormat) * LengthUnit.centimeterToInch(72.0f);
                if (n > 0) {
                    return 1;
                }
                n3 = 1;
                n2 = 1;
                f2 = 0.0f;
                f = 0.0f;
            } else {
                f3 = this.home.getPrint().getPlanScale().floatValue() * LengthUnit.centimeterToInch(72.0f);
                n3 = (int)(rectangle2D.getWidth() * (double)f3 / d3);
                if (rectangle2D.getWidth() * (double)f3 != d3) {
                    ++n3;
                }
                n2 = (int)(rectangle2D.getHeight() * (double)f3 / d4);
                if (rectangle2D.getHeight() * (double)f3 != d4) {
                    ++n2;
                }
                if (n >= n3 * n2) {
                    return 1;
                }
                f2 = n / n3;
                f = (float)n - f2 * (float)n3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.clip(new Rectangle2D.Double(d, d2, d3, d4));
            graphics2D.translate(d - (double)f * d3, d2 - (double)f2 * d4);
            graphics2D.scale(f3, f3);
            float f4 = this.getStrokeWidthExtraMargin(list, PaintMode.PRINT);
            graphics2D.translate(-rectangle2D.getMinX() + (double)f4, -rectangle2D.getMinY() + (double)f4);
            graphics2D.translate(Math.max(0.0, (d3 * (double)n3 / (double)f3 - rectangle2D.getWidth() - (double)(2.0f * f4)) / 2.0), Math.max(0.0, (d4 * (double)n2 / (double)f3 - rectangle2D.getHeight() - (double)(2.0f * f4)) / 2.0));
            this.setRenderingHints(graphics2D);
            try {
                this.paintContent(graphics2D, f3, PaintMode.PRINT);
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
            graphics2D.dispose();
            return 0;
        }
        return 1;
    }

    @Override
    public Object createTransferData(TransferableView.DataType dataType) {
        if (dataType == TransferableView.DataType.PLAN_IMAGE) {
            return this.getClipboardImage();
        }
        return null;
    }

    public BufferedImage getClipboardImage() {
        Rectangle2D rectangle2D = this.getSelectionBounds(false);
        if (rectangle2D == null) {
            return null;
        }
        float f = 1.0f;
        float f2 = this.getStrokeWidthExtraMargin(this.home.getSelectedItems(), PaintMode.CLIPBOARD);
        BufferedImage bufferedImage = new BufferedImage((int)Math.ceil(rectangle2D.getWidth() * (double)f + (double)(2.0f * f2)), (int)Math.ceil(rectangle2D.getHeight() * (double)f + (double)(2.0f * f2)), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.scale(f, f);
        graphics2D.translate(-rectangle2D.getMinX() + (double)f2, -rectangle2D.getMinY() + (double)f2);
        this.setRenderingHints(graphics2D);
        try {
            this.paintContent(graphics2D, f, PaintMode.CLIPBOARD);
        }
        catch (InterruptedIOException interruptedIOException) {
            return null;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public boolean isFormatTypeSupported(ExportableView.FormatType formatType) {
        return formatType == ExportableView.FormatType.SVG;
    }

    @Override
    public void exportData(OutputStream outputStream, ExportableView.FormatType formatType, Properties properties) throws IOException {
        if (formatType != ExportableView.FormatType.SVG) {
            throw new UnsupportedOperationException("Unsupported format " + formatType);
        }
        this.exportToSVG(outputStream);
    }

    public void exportToSVG(OutputStream outputStream) throws IOException {
        SVGSupport.exportToSVG(outputStream, this);
    }

    private void checkCurrentThreadIsntInterrupted(PaintMode paintMode) throws InterruptedIOException {
        if (paintMode == PaintMode.EXPORT && Thread.interrupted()) {
            throw new InterruptedIOException("Current thread interrupted");
        }
    }

    private void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private void paintBackground(Graphics2D graphics2D, Color color) {
        if (this.isOpaque()) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean paintBackgroundImage(Graphics2D graphics2D, PaintMode paintMode) {
        Cloneable cloneable;
        Object object;
        Level level = this.home.getSelectedLevel();
        Cloneable cloneable2 = null;
        if (level != null) {
            void var6_7;
            object = this.home.getLevels();
            int bl = object.size() - 1;
            while (var6_7 >= 0) {
                cloneable = (Level)object.get((int)var6_7);
                if (((Level)cloneable).getElevation() == level.getElevation() && ((Level)cloneable).getElevationIndex() <= level.getElevationIndex() && ((Level)cloneable).isViewable() && ((Level)cloneable).getBackgroundImage() != null && ((Level)cloneable).getBackgroundImage().isVisible()) {
                    cloneable2 = cloneable;
                    break;
                }
                --var6_7;
            }
        }
        Object object2 = object = cloneable2 == null ? this.home.getBackgroundImage() : cloneable2.getBackgroundImage();
        if (object != null && ((BackgroundImage)object).isVisible()) {
            boolean bl = OperatingSystem.isMacOSX();
            if (this.backgroundImageCache == null && paintMode == PaintMode.PAINT) {
                if (backgroundImageLoader == null) {
                    backgroundImageLoader = Executors.newSingleThreadExecutor();
                }
                backgroundImageLoader.execute(new Runnable((BackgroundImage)object, bl){
                    final /* synthetic */ BackgroundImage val$backgroundImage;
                    final /* synthetic */ boolean val$prepareBackgroundImageWithAlphaInMemory;
                    {
                        this.val$backgroundImage = backgroundImage;
                        this.val$prepareBackgroundImageWithAlphaInMemory = bl;
                    }

                    @Override
                    public void run() {
                        if (PlanComponent.this.backgroundImageCache == null) {
                            PlanComponent.this.backgroundImageCache = PlanComponent.this.readBackgroundImage(this.val$backgroundImage.getImage(), this.val$prepareBackgroundImageWithAlphaInMemory);
                            PlanComponent.this.revalidate();
                        }
                    }
                });
            } else {
                cloneable = graphics2D.getTransform();
                graphics2D.translate(-((BackgroundImage)object).getXOrigin(), -((BackgroundImage)object).getYOrigin());
                float f = ((BackgroundImage)object).getScale();
                graphics2D.scale(f, f);
                Composite composite = null;
                if (!bl) {
                    composite = this.setTransparency(graphics2D, 0.7f);
                }
                graphics2D.drawImage((Image)(this.backgroundImageCache != null ? this.backgroundImageCache : this.readBackgroundImage(((BackgroundImage)object).getImage(), bl)), 0, 0, this);
                if (!bl) {
                    graphics2D.setComposite(composite);
                }
                graphics2D.setTransform((AffineTransform)cloneable);
            }
            return true;
        }
        return false;
    }

    protected Color getForegroundColor(PaintMode paintMode) {
        if (paintMode == PaintMode.PAINT) {
            return this.getForeground();
        }
        return Color.BLACK;
    }

    protected Color getBackgroundColor(PaintMode paintMode) {
        if (paintMode == PaintMode.PAINT) {
            return this.getBackground();
        }
        return Color.WHITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage readBackgroundImage(Content content, boolean bl) {
        InputStream inputStream = null;
        try {
            try {
                inputStream = content.openStream();
                BufferedImage bufferedImage2 = ImageIO.read(inputStream);
                if (bl) {
                    BufferedImage bufferedImage4 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                    graphics2D.drawRenderedImage(bufferedImage2, null);
                    graphics2D.dispose();
                    BufferedImage bufferedImage3 = bufferedImage4;
                    return bufferedImage3;
                }
                BufferedImage bufferedImage = bufferedImage2;
                return bufferedImage;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            return new BufferedImage(1, 1, 2);
        }
    }

    private void paintOtherLevels(Graphics2D graphics2D, float f, Color color, Color color2) {
        List<Level> list = this.home.getLevels();
        Level level = this.home.getSelectedLevel();
        if (list.size() > 1 && level != null) {
            boolean bl = list.get(0).getElevation() == level.getElevation();
            ArrayList<Object> arrayList = null;
            if (this.otherLevelsRoomsCache == null || this.otherLevelsWallsCache == null) {
                float f2;
                Object object;
                int n;
                int n2 = list.indexOf(level);
                arrayList = new ArrayList<Object>();
                if (bl) {
                    n = n2;
                    while (++n < list.size() && list.get(n).getElevation() == level.getElevation()) {
                    }
                    if (n < list.size()) {
                        object = list.get(n);
                        f2 = ((Level)object).getElevation();
                        do {
                            if (!((Level)object).isViewable()) continue;
                            arrayList.add(object);
                        } while (++n < list.size() && ((Level)(object = list.get(n))).getElevation() == f2);
                    }
                } else {
                    n = n2;
                    while (--n >= 0 && list.get(n).getElevation() == level.getElevation()) {
                    }
                    if (n >= 0) {
                        object = list.get(n);
                        f2 = ((Level)object).getElevation();
                        do {
                            if (!((Level)object).isViewable()) continue;
                            arrayList.add(object);
                        } while (--n >= 0 && ((Level)(object = list.get(n))).getElevation() == f2);
                    }
                }
                if (this.otherLevelsRoomsCache == null) {
                    if (!arrayList.isEmpty()) {
                        ArrayList<Room> arrayList2 = new ArrayList<Room>();
                        for (Room room : this.home.getRooms()) {
                            for (Level level2 : arrayList) {
                                if (room.getLevel() != level2 || (!bl || !room.isFloorVisible()) && (bl || !room.isCeilingVisible())) continue;
                                arrayList2.add(room);
                            }
                        }
                        if (arrayList2.size() > 0) {
                            this.otherLevelsRoomAreaCache = this.getItemsArea(arrayList2);
                            this.otherLevelsRoomsCache = arrayList2;
                        }
                    }
                    if (this.otherLevelsRoomsCache == null) {
                        this.otherLevelsRoomsCache = Collections.emptyList();
                    }
                }
                if (this.otherLevelsWallsCache == null && !arrayList.isEmpty()) {
                    ArrayList<Wall> arrayList3 = new ArrayList<Wall>();
                    for (Wall wall : this.home.getWalls()) {
                        if (this.isViewableAtSelectedLevel(wall)) continue;
                        for (Level level2 : arrayList) {
                            if (wall.getLevel() != level2) continue;
                            arrayList3.add(wall);
                        }
                    }
                    if (arrayList3.size() > 0) {
                        this.otherLevelsWallAreaCache = this.getItemsArea(arrayList3);
                        this.otherLevelsWallsCache = arrayList3;
                    }
                }
                if (this.otherLevelsWallsCache == null) {
                    this.otherLevelsWallsCache = Collections.emptyList();
                }
            }
            if (!this.otherLevelsRoomsCache.isEmpty()) {
                Composite composite = this.setTransparency(graphics2D, this.preferences.isGridVisible() ? 0.2f : 0.1f);
                graphics2D.setPaint(Color.GRAY);
                graphics2D.fill(this.otherLevelsRoomAreaCache);
                graphics2D.setComposite(composite);
            }
            if (!this.otherLevelsWallsCache.isEmpty()) {
                Composite composite = this.setTransparency(graphics2D, this.preferences.isGridVisible() ? 0.2f : 0.1f);
                this.fillAndDrawWallsArea(graphics2D, this.otherLevelsWallAreaCache, f, this.getWallPaint(f, color, color2, this.preferences.getNewWallPattern()), color2, PaintMode.PAINT);
                graphics2D.setComposite(composite);
            }
        }
    }

    private Composite setTransparency(Graphics2D graphics2D, float f) {
        Composite composite = graphics2D.getComposite();
        if (composite instanceof AlphaComposite) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((AlphaComposite)composite).getAlpha() * f));
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        return composite;
    }

    private void paintGrid(Graphics2D graphics2D, float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = this.getGridSize(f);
        float f7 = this.getMainGridSize(f);
        Rectangle2D rectangle2D = this.getPlanBounds();
        if (this.getParent() instanceof JViewport) {
            Rectangle rectangle = ((JViewport)this.getParent()).getViewRect();
            f5 = this.convertXPixelToModel(rectangle.x - 1);
            f4 = this.convertYPixelToModel(rectangle.y - 1);
            f3 = this.convertXPixelToModel(rectangle.x + rectangle.width);
            f2 = this.convertYPixelToModel(rectangle.y + rectangle.height);
        } else {
            f5 = (float)rectangle2D.getMinX() - 40.0f;
            f4 = (float)rectangle2D.getMinY() - 40.0f;
            f3 = this.convertXPixelToModel(this.getWidth());
            f2 = this.convertYPixelToModel(this.getHeight());
        }
        boolean bl = false;
        try {
            bl = OperatingSystem.isMacOSX() && System.getProperty("apple.awt.graphics.UseQuartz", "false").equals("false");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        if (bl) {
            int n = Math.round(f7 * f);
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            this.setRenderingHints(graphics2D2);
            graphics2D2.scale(f, f);
            this.paintGridLines(graphics2D2, f, 0.0f, f7, 0.0f, f7, f6, f7);
            graphics2D2.dispose();
            graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, f7, f7)));
            graphics2D.fill(new Rectangle2D.Float(f5, f4, f3 - f5, f2 - f4));
        } else {
            this.paintGridLines(graphics2D, f, f5, f3, f4, f2, f6, f7);
        }
    }

    private void paintGridLines(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        double d;
        graphics2D.setColor(UIManager.getColor("controlShadow"));
        graphics2D.setStroke(new BasicStroke(0.5f / f));
        for (d = (double)((float)((int)(f2 / f6)) * f6); d < (double)f3; d += (double)f6) {
            graphics2D.draw(new Line2D.Double(d, f4, d, f5));
        }
        for (d = (double)((float)((int)(f4 / f6)) * f6); d < (double)f5; d += (double)f6) {
            graphics2D.draw(new Line2D.Double(f2, d, f3, d));
        }
        if (f7 != f6) {
            graphics2D.setStroke(new BasicStroke(1.5f / f, 0, 2));
            for (d = (double)((float)((int)(f2 / f7)) * f7); d < (double)f3; d += (double)f7) {
                graphics2D.draw(new Line2D.Double(d, f4, d, f5));
            }
            for (d = (double)((float)((int)(f4 / f7)) * f7); d < (double)f5; d += (double)f7) {
                graphics2D.draw(new Line2D.Double(f2, d, f3, d));
            }
        }
    }

    private float getMainGridSize(float f) {
        float[] fArray;
        float f2;
        LengthUnit lengthUnit = this.preferences.getLengthUnit();
        if (lengthUnit == LengthUnit.INCH || lengthUnit == LengthUnit.INCH_DECIMALS) {
            f2 = 30.48f;
            fArray = new float[]{f2, 3.0f * f2, 6.0f * f2, 12.0f * f2, 24.0f * f2, 48.0f * f2, 96.0f * f2, 192.0f * f2, 384.0f * f2};
        } else {
            fArray = new float[]{100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f, 10000.0f};
        }
        f2 = fArray[0];
        for (int i = 1; i < fArray.length && f2 * f < 50.0f; ++i) {
            f2 = fArray[i];
        }
        return f2;
    }

    private float getGridSize(float f) {
        float[] fArray;
        float f2;
        LengthUnit lengthUnit = this.preferences.getLengthUnit();
        if (lengthUnit == LengthUnit.INCH || lengthUnit == LengthUnit.INCH_DECIMALS) {
            f2 = 30.48f;
            fArray = new float[]{2.54f, 5.08f, 7.62f, 15.24f, f2, 3.0f * f2, 6.0f * f2, 12.0f * f2, 24.0f * f2, 48.0f * f2, 96.0f * f2, 192.0f * f2, 384.0f * f2};
        } else {
            fArray = new float[]{1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 50.0f, 100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f, 10000.0f};
        }
        f2 = fArray[0];
        for (int i = 1; i < fArray.length && f2 * f < 10.0f; ++i) {
            f2 = fArray[i];
        }
        return f2;
    }

    private void paintContent(Graphics2D graphics2D, float f, PaintMode paintMode) throws InterruptedIOException {
        Color color = this.getBackgroundColor(paintMode);
        Color color2 = this.getForegroundColor(paintMode);
        if (this.backgroundPainted) {
            this.paintBackgroundImage(graphics2D, paintMode);
            if (paintMode == PaintMode.PAINT) {
                this.paintOtherLevels(graphics2D, f, color, color2);
                if (this.preferences.isGridVisible()) {
                    this.paintGrid(graphics2D, f);
                }
            }
        }
        this.paintHomeItems(graphics2D, f, color, color2, paintMode);
        if (paintMode == PaintMode.PAINT) {
            List<Selectable> list = this.home.getSelectedItems();
            Color color3 = this.getSelectionColor();
            Color color4 = this.getFurnitureOutlineColor();
            Color color5 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 128);
            BasicStroke basicStroke = new BasicStroke(6.0f / f * this.resolutionScale, 1, 1);
            BasicStroke basicStroke2 = new BasicStroke(4.0f / f * this.resolutionScale, 1, 1);
            BasicStroke basicStroke3 = new BasicStroke(1.0f / f * this.resolutionScale, 2, 2, 0.0f, new float[]{20.0f / f, 5.0f / f, 5.0f / f, 5.0f / f}, 4.0f / f);
            this.paintCamera(graphics2D, list, color5, basicStroke, color3, f, color, color2);
            if (this.alignedObjectClass != null) {
                if (Wall.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintWallAlignmentFeedback(graphics2D, (Wall)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                } else if (Room.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintRoomAlignmentFeedback(graphics2D, (Room)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                } else if (Polyline.class.isAssignableFrom(this.alignedObjectClass)) {
                    if (this.showPointFeedback) {
                        this.paintPointFeedback(graphics2D, this.locationFeeback, color3, f, color5, basicStroke);
                    }
                } else if (DimensionLine.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintDimensionLineAlignmentFeedback(graphics2D, (DimensionLine)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                }
            }
            if (this.centerAngleFeedback != null) {
                this.paintAngleFeedback(graphics2D, this.centerAngleFeedback, this.point1AngleFeedback, this.point2AngleFeedback, f, color3);
            }
            if (this.dimensionLinesFeedback != null) {
                List<Selectable> list2 = Collections.emptyList();
                this.paintDimensionLines(graphics2D, this.dimensionLinesFeedback, list2, null, null, null, basicStroke3, f, color, color3, paintMode, true);
            }
            if (this.draggedItemsFeedback != null) {
                this.paintDimensionLines(graphics2D, Home.getDimensionLinesSubList(this.draggedItemsFeedback), this.draggedItemsFeedback, color5, basicStroke2, null, basicStroke3, f, color, color2, paintMode, false);
                this.paintLabels(graphics2D, Home.getLabelsSubList(this.draggedItemsFeedback), this.draggedItemsFeedback, color5, basicStroke2, null, f, color2, paintMode);
                this.paintRoomsOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
                this.paintWallsOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
                this.paintFurniture(graphics2D, Home.getFurnitureSubList(this.draggedItemsFeedback), list, f, null, color2, color4, paintMode, false);
                this.paintFurnitureOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
            }
            this.paintRectangleFeedback(graphics2D, color3, f);
        }
    }

    protected void paintHomeItems(Graphics graphics, float f, Color color, Color color2, PaintMode paintMode) throws InterruptedIOException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<Selectable> list = this.home.getSelectedItems();
        if (this.sortedLevelFurniture == null) {
            this.sortedLevelFurniture = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture serializable2 : this.home.getFurniture()) {
                if (!this.isViewableAtSelectedLevel(serializable2)) continue;
                this.sortedLevelFurniture.add(serializable2);
            }
            Collections.sort(this.sortedLevelFurniture, new Comparator<HomePieceOfFurniture>(){

                @Override
                public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                    return Float.compare(homePieceOfFurniture.getGroundElevation(), homePieceOfFurniture2.getGroundElevation());
                }
            });
        }
        Color color3 = this.getSelectionColor();
        Color color4 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 128);
        BasicStroke basicStroke = new BasicStroke(6.0f / f * this.resolutionScale, 1, 1);
        BasicStroke basicStroke2 = new BasicStroke(4.0f / f * this.resolutionScale, 1, 1);
        BasicStroke basicStroke3 = new BasicStroke(1.0f / f * this.resolutionScale, 2, 2, 0.0f, new float[]{20.0f / f, 5.0f / f, 5.0f / f, 5.0f / f}, 4.0f / f);
        this.paintCompass(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintRooms(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintWalls(graphics2D, list, f, color, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintFurniture(graphics2D, this.sortedLevelFurniture, list, f, color, color2, this.getFurnitureOutlineColor(), paintMode, true);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintPolylines(graphics2D, this.home.getPolylines(), list, color4, color3, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintDimensionLines(graphics2D, this.home.getDimensionLines(), list, color4, basicStroke2, color3, basicStroke3, f, color, color2, paintMode, false);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintRoomsNameAndArea(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintFurnitureName(graphics2D, this.sortedLevelFurniture, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintLabels(graphics2D, this.home.getLabels(), list, color4, basicStroke2, color3, f, color2, paintMode);
        if (paintMode == PaintMode.PAINT && this.selectedItemsOutlinePainted) {
            this.paintCompassOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintRoomsOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintWallsOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintFurnitureOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
        }
    }

    protected Color getSelectionColor() {
        return PlanComponent.getDefaultSelectionColor(this);
    }

    static Color getDefaultSelectionColor(JComponent jComponent) {
        if (OperatingSystem.isMacOSX()) {
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                Color color;
                Window window = SwingUtilities.getWindowAncestor(jComponent);
                if (window != null && !window.isActive() && (color = UIManager.getColor("List.selectionInactiveBackground")) != null) {
                    return color.darker();
                }
                color = UIManager.getColor("List.selectionBackground");
                if (color != null) {
                    return color;
                }
            }
            return UIManager.getColor("textHighlight");
        }
        return UIManager.getColor("textHighlight").darker();
    }

    protected Color getFurnitureOutlineColor() {
        return new Color(this.getForeground().getRGB() & 0xFFFFFF | 0x55000000, true);
    }

    private void paintRooms(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        if (this.sortedLevelRooms == null) {
            this.sortedLevelRooms = new ArrayList<Room>();
            for (Room object : this.home.getRooms()) {
                if (!this.isViewableAtSelectedLevel(object)) continue;
                this.sortedLevelRooms.add(object);
            }
            Collections.sort(this.sortedLevelRooms, new Comparator<Room>(){

                @Override
                public int compare(Room room, Room room2) {
                    if (room.isFloorVisible() == room2.isFloorVisible() && room.isCeilingVisible() == room2.isCeilingVisible()) {
                        return 0;
                    }
                    if (!room2.isFloorVisible() || room2.isCeilingVisible()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        Color color2 = paintMode == PaintMode.PRINT ? Color.WHITE : Color.GRAY;
        graphics2D.setStroke(new BasicStroke(this.getStrokeWidth(Room.class, paintMode) / f));
        for (Room room : this.sortedLevelRooms) {
            BufferedImage bufferedImage;
            Object object;
            boolean bl = list.contains(room);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            graphics2D.setPaint(color2);
            float f2 = 0.0f;
            if (this.preferences.isRoomFloorColoredOrTextured() && room.isFloorVisible()) {
                if (room.getFloorColor() != null) {
                    graphics2D.setPaint(new Color(room.getFloorColor()));
                } else {
                    object = room.getFloorTexture();
                    if (object != null) {
                        if (this.floorTextureImagesCache == null) {
                            this.floorTextureImagesCache = new WeakHashMap<HomeTexture, BufferedImage>();
                        }
                        if ((bufferedImage = this.floorTextureImagesCache.get(object)) == null || bufferedImage == WAIT_TEXTURE_IMAGE) {
                            boolean f3;
                            boolean bl2 = f3 = paintMode != PaintMode.PAINT;
                            if (!(!PlanComponent.isTextureManagerAvailable() || OperatingSystem.isLinux() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7"))) {
                                TextureManager.getInstance().loadTexture(((HomeTexture)object).getImage(), f3, new TextureManager.TextureObserver((HomeTexture)object, f3){
                                    final /* synthetic */ HomeTexture val$floorTexture;
                                    final /* synthetic */ boolean val$waitForTexture;
                                    {
                                        this.val$floorTexture = homeTexture;
                                        this.val$waitForTexture = bl;
                                    }

                                    @Override
                                    public void textureUpdated(Texture texture) {
                                        PlanComponent.this.floorTextureImagesCache.put(this.val$floorTexture, ((ImageComponent2D)texture.getImage(0)).getImage());
                                        if (!this.val$waitForTexture) {
                                            PlanComponent.this.repaint();
                                        }
                                    }
                                });
                            } else {
                                Icon icon = IconManager.getInstance().getIcon(((HomeTexture)object).getImage(), f3 ? null : this);
                                if (IconManager.getInstance().isWaitIcon(icon)) {
                                    this.floorTextureImagesCache.put((HomeTexture)object, WAIT_TEXTURE_IMAGE);
                                } else if (IconManager.getInstance().isErrorIcon(icon)) {
                                    this.floorTextureImagesCache.put((HomeTexture)object, ERROR_TEXTURE_IMAGE);
                                } else {
                                    BufferedImage bufferedImage2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
                                    icon.paintIcon(this, graphics2D2, 0, 0);
                                    graphics2D2.dispose();
                                    this.floorTextureImagesCache.put((HomeTexture)object, bufferedImage2);
                                }
                            }
                            bufferedImage = this.floorTextureImagesCache.get(object);
                        }
                        float f3 = ((HomeTexture)object).getWidth();
                        float icon = ((HomeTexture)object).getHeight();
                        if (f3 == -1.0f || icon == -1.0f) {
                            f3 = 100.0f;
                            icon = 100.0f;
                        }
                        float bufferedImage2 = ((HomeTexture)object).getScale();
                        f2 = ((HomeTexture)object).getAngle();
                        double graphics2D2 = Math.cos(f2);
                        double d = Math.sin(f2);
                        graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Double((double)(((HomeTexture)object).getXOffset() * f3 * bufferedImage2) * graphics2D2 - (double)(((HomeTexture)object).getYOffset() * icon * bufferedImage2) * d, (double)(-((HomeTexture)object).getXOffset() * f3 * bufferedImage2) * d - (double)(((HomeTexture)object).getYOffset() * icon * bufferedImage2) * graphics2D2, f3 * bufferedImage2, icon * bufferedImage2)));
                    }
                }
            }
            object = this.setTransparency(graphics2D, 0.75f);
            graphics2D.rotate(f2, 0.0, 0.0);
            bufferedImage = f2 != 0.0f ? AffineTransform.getRotateInstance(-f2, 0.0, 0.0) : null;
            Shape bl2 = ShapeTools.getShape(room.getPoints(), true, (AffineTransform)((Object)bufferedImage));
            this.fillShape(graphics2D, bl2, paintMode);
            graphics2D.setComposite((Composite)object);
            graphics2D.setPaint(color);
            graphics2D.draw(bl2);
            graphics2D.rotate(-f2, 0.0, 0.0);
        }
    }

    private void fillShape(Graphics2D graphics2D, Shape shape, PaintMode paintMode) {
        if (paintMode == PaintMode.PRINT && graphics2D.getPaint() instanceof TexturePaint && OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionBetween("1.7", "1.8.0_152")) {
            double d;
            Shape shape2 = graphics2D.getClip();
            graphics2D.setClip(shape);
            TexturePaint texturePaint = (TexturePaint)graphics2D.getPaint();
            BufferedImage bufferedImage = texturePaint.getImage();
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            double d2 = rectangle2D.getX() + (double)Math.round(rectangle2D2.getX() / rectangle2D.getWidth()) * rectangle2D.getWidth();
            if (d2 > rectangle2D2.getX()) {
                d2 -= rectangle2D.getWidth();
            }
            if ((d = rectangle2D.getY() + (double)Math.round(rectangle2D2.getY() / rectangle2D.getHeight()) * rectangle2D.getHeight()) > rectangle2D2.getY()) {
                d -= rectangle2D.getHeight();
            }
            for (double d3 = d2; d3 < rectangle2D2.getMaxX(); d3 += rectangle2D.getWidth()) {
                for (double d4 = d; d4 < rectangle2D2.getMaxY(); d4 += rectangle2D.getHeight()) {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(d3, d4);
                    affineTransform.concatenate(AffineTransform.getScaleInstance(rectangle2D.getWidth() / (double)bufferedImage.getWidth(), rectangle2D.getHeight() / (double)bufferedImage.getHeight()));
                    graphics2D.drawRenderedImage(bufferedImage, affineTransform);
                }
            }
            graphics2D.setClip(shape2);
        } else {
            graphics2D.fill(shape);
        }
    }

    private static boolean isTextureManagerAvailable() {
        try {
            return !Boolean.getBoolean("com.eteks.sweethome3d.no3D") && (!OperatingSystem.isMacOSX() || !OperatingSystem.isJavaVersionGreaterOrEqual("1.7"));
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    private void paintRoomsNameAndArea(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        graphics2D.setPaint(color);
        Font font = graphics2D.getFont();
        for (Room room : this.sortedLevelRooms) {
            float f2;
            boolean bl = list.contains(room);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            float f3 = room.getXCenter();
            float f4 = room.getYCenter();
            String string = room.getName();
            if (string != null && (string = string.trim()).length() > 0) {
                this.paintText(graphics2D, room.getClass(), string, room.getNameStyle(), null, f3 + room.getNameXOffset(), f4 + room.getNameYOffset(), room.getNameAngle(), font);
            }
            if (!room.isAreaVisible() || !((f2 = room.getArea()) > 0.01f)) continue;
            String string2 = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(f2));
            this.paintText(graphics2D, room.getClass(), string2, room.getAreaStyle(), null, f3 + room.getAreaXOffset(), f4 + room.getAreaYOffset(), room.getAreaAngle(), font);
        }
        graphics2D.setFont(font);
    }

    private void paintText(Graphics2D graphics2D, Class<? extends Selectable> clazz, String string, TextStyle textStyle, Integer n, float f, float f2, float f3, Font font) {
        Font font2;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f, f2);
        graphics2D.rotate(f3);
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(clazz);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
        String[] stringArray = string.split("\n");
        float[] fArray = new float[stringArray.length];
        float f4 = -3.4028235E38f;
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = (float)fontMetrics.getStringBounds(stringArray[i], graphics2D).getWidth();
            f4 = Math.max(fArray[i], f4);
        }
        BasicStroke basicStroke = null;
        if (n != null) {
            basicStroke = new BasicStroke(textStyle.getFontSize() * 0.05f);
            TextStyle textStyle2 = textStyle.deriveStyle(textStyle.getFontSize() - basicStroke.getLineWidth());
            font2 = this.getFont(font, textStyle2);
            graphics2D.setStroke(basicStroke);
        } else {
            font2 = this.getFont(font, textStyle);
        }
        graphics2D.setFont(font2);
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string2 = stringArray[i];
            float f5 = textStyle.getAlignment() == TextStyle.Alignment.LEFT ? 0.0f : (textStyle.getAlignment() == TextStyle.Alignment.RIGHT ? -fArray[i] : -fArray[i] / 2.0f);
            if (n != null) {
                f5 += basicStroke.getLineWidth() / 2.0f;
            }
            graphics2D.translate(f5, 0.0);
            if (n != null) {
                Color color = graphics2D.getColor();
                graphics2D.setColor(new Color(n));
                TextLayout textLayout = new TextLayout(string2, font2, graphics2D.getFontRenderContext());
                graphics2D.draw(textLayout.getOutline(null));
                graphics2D.setColor(color);
            }
            graphics2D.drawString(string2, 0, 0);
            graphics2D.translate(-f5, (double)(-fontMetrics.getHeight()));
        }
        graphics2D.setTransform(affineTransform);
    }

    private void paintRoomsOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        List<Room> list2 = Home.getRoomsSubList(list);
        AffineTransform affineTransform = graphics2D.getTransform();
        float f2 = 1.0f / f;
        for (Room room : list2) {
            if (!this.isViewableAtSelectedLevel(room)) continue;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(ShapeTools.getShape(room.getPoints(), true, null));
            if (paint2 == null) continue;
            graphics2D.setPaint(paint2);
            for (float[] fArray : room.getPoints()) {
                graphics2D.translate(fArray[0], fArray[1]);
                graphics2D.scale(f2, f2);
                graphics2D.setStroke(POINT_STROKE);
                graphics2D.fill(WALL_POINT);
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(this.getStrokeWidth(Room.class, PaintMode.PAINT) / f));
        Object object = list2.iterator();
        while (object.hasNext()) {
            Room room;
            room = (Room)object.next();
            if (!this.isViewableAtSelectedLevel(room)) continue;
            graphics2D.draw(ShapeTools.getShape(room.getPoints(), true, null));
        }
        if (list.size() == 1 && list2.size() == 1 && paint2 != null && this.isViewableAtSelectedLevel((Elevatable)(object = (Room)list2.iterator().next()))) {
            graphics2D.setPaint(paint2);
            this.paintPointsResizeIndicators(graphics2D, (Selectable)object, paint2, f, true, 0.0f, 0.0f, true);
            this.paintRoomNameOffsetIndicator(graphics2D, (Room)object, paint2, f);
            this.paintRoomAreaOffsetIndicator(graphics2D, (Room)object, paint2, f);
        }
    }

    private void paintPointsResizeIndicators(Graphics2D graphics2D, Selectable selectable, Paint paint, float f, boolean bl, float f2, float f3, boolean bl2) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float f4 = 1.0f / f * this.resolutionScale;
            float[][] fArray = selectable.getPoints();
            Shape shape = this.getIndicator(selectable, IndicatorType.RESIZE);
            for (int i = 0; i < fArray.length; ++i) {
                double d;
                float[] fArray2;
                float[] fArray3 = fArray[i];
                graphics2D.translate(fArray3[0], fArray3[1]);
                graphics2D.scale(f4, f4);
                float[] fArray4 = i == 0 ? fArray[fArray.length - 1] : fArray[i - 1];
                float[] fArray5 = fArray2 = i == fArray.length - 1 ? fArray[0] : fArray[i + 1];
                if (bl || i > 0 && i < fArray.length - 1) {
                    float f5 = (float)Point2D.distance(fArray4[0], fArray4[1], fArray3[0], fArray3[1]);
                    float f6 = (fArray3[1] - fArray4[1]) / f5;
                    float f7 = (fArray4[0] - fArray3[0]) / f5;
                    float f8 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray3[0], fArray3[1]);
                    float f9 = (fArray2[1] - fArray3[1]) / f8;
                    float f10 = (fArray3[0] - fArray2[0]) / f8;
                    d = Math.atan2(f7 + f10, f6 + f9);
                    if (bl2 && selectable.containsPoint(fArray3[0] + (float)Math.cos(d), fArray3[1] + (float)Math.sin(d), 0.001f) || !bl2 && f6 * f10 - f7 * f9 < 0.0f) {
                        d += Math.PI;
                    }
                } else {
                    d = i == 0 ? (double)f2 : (double)f3;
                }
                graphics2D.rotate(d);
                graphics2D.draw(shape);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    protected Shape getIndicator(Selectable selectable, IndicatorType indicatorType) {
        if (IndicatorType.RESIZE.equals(indicatorType)) {
            if (selectable instanceof HomePieceOfFurniture) {
                return FURNITURE_RESIZE_INDICATOR;
            }
            if (selectable instanceof Compass) {
                return COMPASS_RESIZE_INDICATOR;
            }
            return WALL_AND_LINE_RESIZE_INDICATOR;
        }
        if (IndicatorType.ROTATE.equals(indicatorType)) {
            if (selectable instanceof HomePieceOfFurniture) {
                return FURNITURE_ROTATION_INDICATOR;
            }
            if (selectable instanceof Compass) {
                return COMPASS_ROTATION_INDICATOR;
            }
            if (selectable instanceof Camera) {
                return CAMERA_YAW_ROTATION_INDICATOR;
            }
        } else {
            if (IndicatorType.ELEVATE.equals(indicatorType)) {
                if (selectable instanceof Camera) {
                    return CAMERA_ELEVATION_INDICATOR;
                }
                return ELEVATION_INDICATOR;
            }
            if (IndicatorType.RESIZE_HEIGHT.equals(indicatorType)) {
                if (selectable instanceof HomePieceOfFurniture) {
                    return FURNITURE_HEIGHT_INDICATOR;
                }
            } else if (IndicatorType.CHANGE_POWER.equals(indicatorType)) {
                if (selectable instanceof HomeLight) {
                    return LIGHT_POWER_INDICATOR;
                }
            } else {
                if (IndicatorType.MOVE_TEXT.equals(indicatorType)) {
                    return TEXT_LOCATION_INDICATOR;
                }
                if (IndicatorType.ROTATE_TEXT.equals(indicatorType)) {
                    return TEXT_ANGLE_INDICATOR;
                }
                if (IndicatorType.ROTATE_PITCH.equals(indicatorType)) {
                    if (selectable instanceof HomePieceOfFurniture) {
                        return FURNITURE_PITCH_ROTATION_INDICATOR;
                    }
                    if (selectable instanceof Camera) {
                        return CAMERA_PITCH_ROTATION_INDICATOR;
                    }
                } else if (IndicatorType.ROTATE_ROLL.equals(indicatorType)) {
                    if (selectable instanceof HomePieceOfFurniture) {
                        return FURNITURE_ROLL_ROTATION_INDICATOR;
                    }
                } else if (IndicatorType.ARC_EXTENT.equals(indicatorType) && selectable instanceof Wall) {
                    return WALL_ARC_EXTENT_INDICATOR;
                }
            }
        }
        return null;
    }

    private void paintRoomNameOffsetIndicator(Graphics2D graphics2D, Room room, Paint paint, float f) {
        if (this.resizeIndicatorVisible && room.getName() != null && room.getName().trim().length() > 0) {
            float f2 = room.getXCenter() + room.getNameXOffset();
            float f3 = room.getYCenter() + room.getNameYOffset();
            this.paintTextIndicators(graphics2D, room.getClass(), this.getLineCount(room.getName()), room.getNameStyle(), f2, f3, room.getNameAngle(), paint, f);
        }
    }

    private void paintRoomAreaOffsetIndicator(Graphics2D graphics2D, Room room, Paint paint, float f) {
        if (this.resizeIndicatorVisible && room.isAreaVisible() && room.getArea() > 0.01f) {
            float f2 = room.getXCenter() + room.getAreaXOffset();
            float f3 = room.getYCenter() + room.getAreaYOffset();
            this.paintTextIndicators(graphics2D, room.getClass(), 1, room.getAreaStyle(), f2, f3, room.getAreaAngle(), paint, f);
        }
    }

    private void paintTextIndicators(Graphics2D graphics2D, Class<? extends Selectable> clazz, int n, TextStyle textStyle, float f, float f2, float f3, Paint paint, float f4) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float f5 = 1.0f / f4 * this.resolutionScale;
            graphics2D.translate(f, f2);
            graphics2D.rotate(f3);
            graphics2D.scale(f5, f5);
            if (Label.class.isAssignableFrom(clazz)) {
                graphics2D.draw(LABEL_CENTER_INDICATOR);
            } else {
                graphics2D.draw(this.getIndicator(null, IndicatorType.MOVE_TEXT));
            }
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(clazz);
            }
            FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont(), textStyle);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(f, f2);
            graphics2D.rotate(f3);
            graphics2D.translate(0.0, (double)(-fontMetrics.getHeight() * (n - 1)) - (double)fontMetrics.getAscent() * (Label.class.isAssignableFrom(clazz) ? 1.0 : 0.85));
            graphics2D.scale(f5, f5);
            graphics2D.draw(this.getIndicator(null, IndicatorType.ROTATE_TEXT));
            graphics2D.setTransform(affineTransform);
        }
    }

    private int getLineCount(String string) {
        int n = 1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private void paintWalls(Graphics2D graphics2D, List<Selectable> list, float f, Color color, Color color2, PaintMode paintMode) {
        Map<Collection<Wall>, Area> map;
        if (paintMode != PaintMode.CLIPBOARD) {
            map = this.getWallAreas();
        } else {
            List<Wall> list2 = Home.getWallsSubList(list);
            map = this.getWallAreas(this.getDrawableWallsInSelectedLevel(list2));
        }
        float f2 = paintMode == PaintMode.PRINT ? f / 72.0f * 150.0f : f / this.resolutionScale;
        Composite composite = null;
        if (paintMode == PaintMode.PAINT && this.backgroundPainted && this.backgroundImageCache != null && this.wallsDoorsOrWindowsModification) {
            composite = this.setTransparency(graphics2D, 0.5f);
        }
        Iterator<Map.Entry<Collection<Wall>, Area>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            TextureImage textureImage;
            Map.Entry<Collection<Wall>, Area> entry;
            this.fillAndDrawWallsArea(graphics2D, entry.getValue(), f, this.getWallPaint(f2, color, color2, (textureImage = (entry = iterator.next()).getKey().iterator().next().getPattern()) != null ? textureImage : this.preferences.getWallPattern()), color2, paintMode);
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    private void fillAndDrawWallsArea(Graphics2D graphics2D, Area area, float f, Paint paint, Paint paint2, PaintMode paintMode) {
        graphics2D.setPaint(paint);
        this.fillShape(graphics2D, area, paintMode);
        graphics2D.setPaint(paint2);
        graphics2D.setStroke(new BasicStroke(this.getStrokeWidth(Wall.class, paintMode) / f));
        graphics2D.draw(area);
    }

    private void paintWallsOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        float f2 = 1.0f / f;
        List<Wall> list2 = Home.getWallsSubList(list);
        AffineTransform affineTransform = graphics2D.getTransform();
        for (Wall cloneable : list2) {
            double d;
            double d2;
            if (!this.isViewableAtSelectedLevel(cloneable)) continue;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(ShapeTools.getShape(cloneable.getPoints(), true, null));
            if (paint2 == null) continue;
            graphics2D.translate(cloneable.getXStart(), cloneable.getYStart());
            graphics2D.scale(f2, f2);
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(POINT_STROKE);
            graphics2D.fill(WALL_POINT);
            Float f3 = cloneable.getArcExtent();
            float f4 = 0.0f;
            float f5 = 0.0f;
            double d3 = 0.0;
            double d4 = cloneable.getStartPointToEndPointDistance();
            double d5 = Math.atan2(cloneable.getYEnd() - cloneable.getYStart(), cloneable.getXEnd() - cloneable.getXStart());
            if (f3 != null && f3.floatValue() != 0.0f) {
                f4 = cloneable.getXArcCircleCenter();
                f5 = cloneable.getYArcCircleCenter();
                d3 = Point2D.distance(cloneable.getXStart(), cloneable.getYStart(), f4, f5);
                d2 = d3 * (double)Math.abs(f3.floatValue()) * (double)f;
                d = Math.atan2(f5 - cloneable.getYStart(), f4 - cloneable.getXStart()) + (f3.floatValue() > 0.0f ? -1.5707963267948966 : 1.5707963267948966);
            } else {
                d2 = d4 * (double)f;
                d = d5;
            }
            if (d2 < 30.0) {
                graphics2D.rotate(d5);
                if (f3 != null) {
                    double d6 = (double)Math.abs(f3.floatValue()) > Math.PI ? -(Math.PI + (double)f3.floatValue()) / 2.0 : (Math.PI - (double)f3.floatValue()) / 2.0;
                    float f6 = (float)(Math.tan(d6) * d4 / 2.0);
                    graphics2D.translate(d4 * (double)f / 2.0, ((double)f6 - d3 * (double)(Math.abs(d5) > 1.5707963267948966 ? -1 : 1)) * (double)f);
                } else {
                    graphics2D.translate(d2 / 2.0, 0.0);
                }
            } else {
                graphics2D.rotate(d);
                graphics2D.translate(8, 0);
            }
            graphics2D.draw(WALL_ORIENTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(cloneable.getXEnd(), cloneable.getYEnd());
            graphics2D.scale(f2, f2);
            graphics2D.fill(WALL_POINT);
            if (d2 >= 30.0) {
                if (f3 != null) {
                    d += (double)f3.floatValue();
                }
                graphics2D.rotate(d);
                graphics2D.translate(-10, 0);
                graphics2D.draw(WALL_ORIENTATION_INDICATOR);
            }
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(this.getStrokeWidth(Wall.class, PaintMode.PAINT) / f));
        Object object = this.getWallAreas(this.getDrawableWallsInSelectedLevel(list2)).values().iterator();
        while (object.hasNext()) {
            Area area = (Area)object.next();
            graphics2D.draw(area);
        }
        if (list.size() == 1 && list2.size() == 1 && paint2 != null && this.isViewableAtSelectedLevel((Elevatable)(object = (Wall)list2.iterator().next()))) {
            this.paintWallResizeIndicators(graphics2D, (Wall)object, paint2, f);
        }
    }

    protected boolean isViewableAtSelectedLevel(Elevatable elevatable) {
        Level level = elevatable.getLevel();
        return level == null || level.isViewable() && elevatable.isAtLevel(this.home.getSelectedLevel());
    }

    private void paintWallResizeIndicators(Graphics2D graphics2D, Wall wall, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float f2 = 1.0f / f * this.resolutionScale;
            float[][] fArray = wall.getPoints();
            int n = fArray.length / 4;
            double d = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
            if (fArray.length % 4 == 0) {
                graphics2D.translate((fArray[n - 1][0] + fArray[n][0]) / 2.0f, (fArray[n - 1][1] + fArray[n][1]) / 2.0f);
            } else {
                graphics2D.translate(fArray[n][0], fArray[n][1]);
            }
            graphics2D.scale(f2, f2);
            graphics2D.rotate(d + Math.PI);
            graphics2D.draw(this.getIndicator(wall, IndicatorType.ARC_EXTENT));
            graphics2D.setTransform(affineTransform);
            Float f3 = wall.getArcExtent();
            double d2 = f3 != null && f3.floatValue() != 0.0f ? Math.atan2(wall.getYArcCircleCenter() - wall.getYEnd(), wall.getXArcCircleCenter() - wall.getXEnd()) + (f3.floatValue() > 0.0f ? -1.5707963267948966 : 1.5707963267948966) : d;
            graphics2D.translate(wall.getXEnd(), wall.getYEnd());
            graphics2D.scale(f2, f2);
            graphics2D.rotate(d2);
            graphics2D.draw(this.getIndicator(wall, IndicatorType.RESIZE));
            graphics2D.setTransform(affineTransform);
            d2 = f3 != null ? (d2 += Math.PI - (double)f3.floatValue()) : (d2 += Math.PI);
            graphics2D.translate(wall.getXStart(), wall.getYStart());
            graphics2D.scale(f2, f2);
            graphics2D.rotate(d2);
            graphics2D.draw(this.getIndicator(wall, IndicatorType.RESIZE));
            graphics2D.setTransform(affineTransform);
        }
    }

    private Map<Collection<Wall>, Area> getWallAreas() {
        if (this.wallAreasCache == null) {
            this.wallAreasCache = this.getWallAreas(this.getDrawableWallsInSelectedLevel(this.home.getWalls()));
        }
        return this.wallAreasCache;
    }

    private Collection<Wall> getDrawableWallsInSelectedLevel(Collection<Wall> collection) {
        ArrayList<Wall> arrayList = new ArrayList<Wall>();
        for (Wall wall : collection) {
            if (!this.isViewableAtSelectedLevel(wall)) continue;
            arrayList.add(wall);
        }
        return arrayList;
    }

    private Map<Collection<Wall>, Area> getWallAreas(Collection<Wall> collection) {
        if (collection.size() == 0) {
            return Collections.emptyMap();
        }
        TextureImage textureImage = collection.iterator().next().getPattern();
        boolean bl = true;
        for (Wall cloneable : collection) {
            if (textureImage == cloneable.getPattern()) continue;
            bl = false;
            break;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (bl) {
            linkedHashMap.put(collection, this.getItemsArea(collection));
        } else {
            LinkedHashMap<TextureImage, ArrayList<Wall>> linkedHashMap2 = new LinkedHashMap<TextureImage, ArrayList<Wall>>();
            for (Wall wall : collection) {
                ArrayList<Wall> arrayList;
                TextureImage textureImage2 = wall.getPattern();
                if (textureImage2 == null) {
                    textureImage2 = this.preferences.getWallPattern();
                }
                if ((arrayList = (ArrayList<Wall>)linkedHashMap2.get(textureImage2)) == null) {
                    arrayList = new ArrayList<Wall>();
                    linkedHashMap2.put(textureImage2, arrayList);
                }
                arrayList.add(wall);
            }
            for (Collection collection2 : linkedHashMap2.values()) {
                linkedHashMap.put(collection2, this.getItemsArea(collection2));
            }
        }
        return linkedHashMap;
    }

    private Area getItemsArea(Collection<? extends Selectable> collection) {
        Area area = new Area();
        for (Selectable selectable : collection) {
            area.add(new Area(ShapeTools.getShape(selectable.getPoints(), true, null)));
        }
        return area;
    }

    private Paint getWallPaint(float f, Color color, Color color2, TextureImage textureImage) {
        BufferedImage bufferedImage = this.patternImagesCache.get(textureImage);
        if (bufferedImage == null || !color.equals(this.wallsPatternBackgroundCache) || !color2.equals(this.wallsPatternForegroundCache)) {
            bufferedImage = SwingTools.getPatternImage(textureImage, color, color2);
            this.patternImagesCache.put(textureImage, bufferedImage);
            this.wallsPatternBackgroundCache = color;
            this.wallsPatternForegroundCache = color2;
        }
        return new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, 10.0f / f, 10.0f / f));
    }

    private void paintFurniture(Graphics2D graphics2D, List<HomePieceOfFurniture> list, List<? extends Selectable> list2, float f, Color color, Color color2, Color color3, PaintMode paintMode, boolean bl) {
        if (!list.isEmpty()) {
            BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(HomePieceOfFurniture.class, paintMode) / f);
            Boolean bl2 = null;
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                boolean bl3;
                Object object;
                List list3;
                if (!homePieceOfFurniture.isVisible()) continue;
                boolean bl4 = list2.contains(homePieceOfFurniture);
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    list3 = ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture();
                    object = Collections.emptyList();
                    this.paintFurniture(graphics2D, list3, (List<? extends Selectable>)(bl4 ? list3 : object), f, color, color2, color3, paintMode, bl);
                    continue;
                }
                if (paintMode == PaintMode.CLIPBOARD && !bl4) continue;
                list3 = ShapeTools.getShape(homePieceOfFurniture.getPoints(), true, null);
                if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                    HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)homePieceOfFurniture;
                    object = this.getDoorOrWindowWallPartShape(homeDoorOrWindow);
                    if (this.draggedItemsFeedback == null || !this.draggedItemsFeedback.contains(homePieceOfFurniture)) {
                        this.paintDoorOrWindowWallThicknessArea(graphics2D, homeDoorOrWindow, f, color, color2, paintMode);
                    }
                    this.paintDoorOrWindowSashes(graphics2D, homeDoorOrWindow, f, color2, paintMode);
                } else {
                    object = list3;
                }
                if (this.preferences.isFurnitureViewedFromTop()) {
                    if (homePieceOfFurniture.getPlanIcon() != null || homePieceOfFurniture instanceof HomeDoorOrWindow) {
                        bl3 = true;
                    } else {
                        if (bl2 == null) {
                            try {
                                bl2 = !Boolean.getBoolean("com.eteks.sweethome3d.no3D") && Component3DManager.getInstance().isOffScreenImageSupported();
                            }
                            catch (AccessControlException accessControlException) {
                                bl2 = false;
                            }
                        }
                        bl3 = bl2;
                    }
                } else {
                    bl3 = false;
                }
                if (bl && bl3) {
                    if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                        graphics2D.setPaint(color);
                        graphics2D.fill((Shape)object);
                        graphics2D.setPaint(color2);
                        graphics2D.setStroke(basicStroke);
                        graphics2D.draw((Shape)object);
                    } else {
                        this.paintPieceOfFurnitureTop(graphics2D, homePieceOfFurniture, (Shape)object, basicStroke, f, color, color2, paintMode);
                    }
                    if (paintMode != PaintMode.PAINT) continue;
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setPaint(color3);
                    graphics2D.draw((Shape)((Object)list3));
                    continue;
                }
                if (bl) {
                    this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, (Shape)object, f, color, paintMode);
                }
                graphics2D.setPaint(color2);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw((Shape)object);
                if (!(homePieceOfFurniture instanceof HomeDoorOrWindow) || paintMode != PaintMode.PAINT) continue;
                graphics2D.setPaint(color3);
                graphics2D.draw((Shape)((Object)list3));
            }
        }
    }

    private Shape getDoorOrWindowWallPartShape(HomeDoorOrWindow homeDoorOrWindow) {
        Rectangle2D rectangle2D = this.getDoorOrWindowRectangle(homeDoorOrWindow, true);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(homeDoorOrWindow.getAngle(), homeDoorOrWindow.getX(), homeDoorOrWindow.getY());
        PathIterator pathIterator = rectangle2D.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private Rectangle2D getDoorOrWindowRectangle(HomeDoorOrWindow homeDoorOrWindow, boolean bl) {
        Shape shape;
        float f = homeDoorOrWindow.getDepth() * (bl ? homeDoorOrWindow.getWallThickness() : 1.0f);
        float f2 = homeDoorOrWindow.getDepth() * (bl ? homeDoorOrWindow.getWallDistance() : 0.0f);
        String string = homeDoorOrWindow.getCutOutShape();
        float f3 = homeDoorOrWindow.getWidth();
        float f4 = homeDoorOrWindow.getWallWidth() * f3;
        float f5 = homeDoorOrWindow.getX() - f3 / 2.0f;
        f5 += homeDoorOrWindow.isModelMirrored() ? (1.0f - homeDoorOrWindow.getWallLeft() - homeDoorOrWindow.getWallWidth()) * f3 : homeDoorOrWindow.getWallLeft() * f3;
        if (string != null && !"M0,0 v1 h1 v-1 z".equals(string)) {
            shape = ShapeTools.getShape(string);
            Rectangle2D rectangle2D = shape.getBounds2D();
            f5 = homeDoorOrWindow.isModelMirrored() ? (f5 += (float)(1.0 - rectangle2D.getX() - rectangle2D.getWidth()) * f4) : (f5 += (float)rectangle2D.getX() * f4);
            f4 = (float)((double)f4 * rectangle2D.getWidth());
        }
        shape = new Rectangle2D.Float(f5, homeDoorOrWindow.getY() - homeDoorOrWindow.getDepth() / 2.0f + f2, f4, f);
        return shape;
    }

    private void paintDoorOrWindowWallThicknessArea(Graphics2D graphics2D, HomeDoorOrWindow homeDoorOrWindow, float f, Color color, Color color2, PaintMode paintMode) {
        if (homeDoorOrWindow.isWallCutOutOnBothSides()) {
            Area area = null;
            if (this.doorOrWindowWallThicknessAreasCache != null) {
                area = this.doorOrWindowWallThicknessAreasCache.get(homeDoorOrWindow);
            }
            if (area == null) {
                Rectangle2D rectangle2D = this.getDoorOrWindowRectangle(homeDoorOrWindow, false);
                AffineTransform affineTransform = AffineTransform.getRotateInstance(homeDoorOrWindow.getAngle(), homeDoorOrWindow.getX(), homeDoorOrWindow.getY());
                PathIterator pathIterator = rectangle2D.getPathIterator(affineTransform);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(pathIterator, false);
                Area area2 = new Area(generalPath);
                area = new Area();
                for (Wall wall : this.home.getWalls()) {
                    if (!wall.isAtLevel(homeDoorOrWindow.getLevel()) || !homeDoorOrWindow.isParallelToWall(wall)) continue;
                    Shape shape = ShapeTools.getShape(wall.getPoints(), true, null);
                    Area area3 = new Area(shape);
                    area3.intersect(area2);
                    if (area3.isEmpty()) continue;
                    Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY() - 2.0f * wall.getThickness(), (float)rectangle2D.getWidth(), (float)rectangle2D.getWidth() + 4.0f * wall.getThickness());
                    pathIterator = float_.getPathIterator(affineTransform);
                    GeneralPath generalPath2 = new GeneralPath();
                    generalPath2.append(pathIterator, false);
                    area3 = new Area(shape);
                    area3.intersect(new Area(generalPath2));
                    area.add(area3);
                }
            }
            if (this.doorOrWindowWallThicknessAreasCache == null) {
                this.doorOrWindowWallThicknessAreasCache = new WeakHashMap<HomeDoorOrWindow, Area>();
            }
            this.doorOrWindowWallThicknessAreasCache.put(homeDoorOrWindow, area);
            graphics2D.setPaint(color);
            graphics2D.fill(area);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(new BasicStroke(this.getStrokeWidth(HomePieceOfFurniture.class, paintMode) / f));
            graphics2D.draw(area);
        }
    }

    private void paintDoorOrWindowSashes(Graphics2D graphics2D, HomeDoorOrWindow homeDoorOrWindow, float f, Color color, PaintMode paintMode) {
        BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(HomePieceOfFurniture.class, paintMode) / f);
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        for (Sash sash : homeDoorOrWindow.getSashes()) {
            graphics2D.draw(this.getDoorOrWindowSashShape(homeDoorOrWindow, sash));
        }
    }

    private GeneralPath getDoorOrWindowSashShape(HomeDoorOrWindow homeDoorOrWindow, Sash sash) {
        float f = homeDoorOrWindow.isModelMirrored() ? -1.0f : 1.0f;
        float f2 = f * sash.getXAxis() * homeDoorOrWindow.getWidth();
        float f3 = sash.getYAxis() * homeDoorOrWindow.getDepth();
        float f4 = sash.getWidth() * homeDoorOrWindow.getWidth();
        float f5 = (float)Math.toDegrees(sash.getStartAngle());
        if (homeDoorOrWindow.isModelMirrored()) {
            f5 = 180.0f - f5;
        }
        float f6 = f * (float)Math.toDegrees(sash.getEndAngle() - sash.getStartAngle());
        Arc2D.Float float_ = new Arc2D.Float(f2 - f4, f3 - f4, 2.0f * f4, 2.0f * f4, f5, f6, 2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(homeDoorOrWindow.getX(), homeDoorOrWindow.getY());
        affineTransform.rotate(homeDoorOrWindow.getAngle());
        affineTransform.translate(f * -homeDoorOrWindow.getWidth() / 2.0f, -homeDoorOrWindow.getDepth() / 2.0f);
        PathIterator pathIterator = float_.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private void paintFurnitureName(Graphics2D graphics2D, List<HomePieceOfFurniture> list, List<? extends Selectable> list2, float f, Color color, PaintMode paintMode) {
        Font font = graphics2D.getFont();
        graphics2D.setPaint(color);
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            List list3;
            if (!homePieceOfFurniture.isVisible()) continue;
            boolean bl = list2.contains(homePieceOfFurniture);
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                list3 = ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture();
                List list4 = Collections.emptyList();
                this.paintFurnitureName(graphics2D, list3, bl ? list3 : list4, f, color, paintMode);
            }
            if (!homePieceOfFurniture.isNameVisible() || paintMode == PaintMode.CLIPBOARD && !bl || ((String)((Object)(list3 = homePieceOfFurniture.getName().trim()))).length() <= 0) continue;
            this.paintText(graphics2D, (Class<? extends Selectable>)homePieceOfFurniture.getClass(), (String)((Object)list3), homePieceOfFurniture.getNameStyle(), null, homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset(), homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset(), homePieceOfFurniture.getNameAngle(), font);
        }
        graphics2D.setFont(font);
    }

    private void paintFurnitureOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        Shape shape;
        Object object;
        BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(HomePieceOfFurniture.class, PaintMode.PAINT) / f);
        BasicStroke basicStroke2 = new BasicStroke(4.0f * this.getStrokeWidth(HomePieceOfFurniture.class, PaintMode.PAINT) / f, 0, 0);
        List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
        Shape shape2 = null;
        BasicStroke basicStroke3 = new BasicStroke(15.0f / f * this.resolutionScale, 2, 1);
        Object object2 = null;
        Shape shape3 = null;
        List<HomePieceOfFurniture> list3 = this.home.getFurniture();
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            HomePieceOfFurniture homePieceOfFurniture = object3.next();
            if (homePieceOfFurniture.isVisible() && this.isViewableAtSelectedLevel(homePieceOfFurniture)) {
                Shape shape4;
                object = this.getPieceOfFurnitureInHomeFurniture(homePieceOfFurniture, list3);
                if (object == homePieceOfFurniture) continue;
                shape = null;
                if (object2 != object) {
                    shape4 = ShapeTools.getShape(((HomePieceOfFurniture)object).getPoints(), true, null);
                    shape = new Area(shape4);
                    ((Area)shape).add(new Area(basicStroke3.createStrokedShape(shape4)));
                }
                shape4 = new Area(ShapeTools.getShape(homePieceOfFurniture.getPoints(), true, null));
                if (shape2 == null) {
                    shape2 = shape;
                    shape3 = shape4;
                } else {
                    if (object2 != object) {
                        ((Area)shape2).add((Area)shape);
                    }
                    ((Area)shape3).add((Area)shape4);
                }
                object2 = object;
                continue;
            }
            object3.remove();
        }
        if (shape2 != null) {
            ((Area)shape2).subtract((Area)shape3);
            object3 = this.setTransparency(graphics2D, 0.6f);
            graphics2D.setPaint(paint);
            graphics2D.fill(shape2);
            graphics2D.setComposite((Composite)object3);
        }
        for (HomePieceOfFurniture homePieceOfFurniture : list2) {
            object = homePieceOfFurniture.getPoints();
            shape = ShapeTools.getShape((float[][])object, true, null);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(shape);
            graphics2D.setPaint(color);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
            graphics2D.setStroke(basicStroke2);
            graphics2D.draw(new Line2D.Float((float)object[2][0], (float)object[2][1], (float)object[3][0], (float)object[3][1]));
            if (list.size() != 1 || paint2 == null) continue;
            this.paintPieceOFFurnitureIndicators(graphics2D, homePieceOfFurniture, paint2, f);
        }
    }

    private HomePieceOfFurniture getPieceOfFurnitureInHomeFurniture(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        if (!list.contains(homePieceOfFurniture)) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
                if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || !((HomeFurnitureGroup)homePieceOfFurniture2).getAllFurniture().contains(homePieceOfFurniture)) continue;
                return homePieceOfFurniture2;
            }
        }
        return homePieceOfFurniture;
    }

    private void paintPieceOfFurnitureIcon(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Shape shape, float f, Color color, PaintMode paintMode) {
        Icon icon = IconManager.getInstance().getIcon(homePieceOfFurniture.getIcon(), 128, paintMode == PaintMode.PAINT ? this : null);
        this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, icon, shape, f, color);
    }

    private void paintPieceOfFurnitureIcon(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Icon icon, Shape shape, float f, Color color) {
        graphics2D.setPaint(color);
        graphics2D.fill(shape);
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D rectangle2D = shape.getBounds2D();
        graphics2D.translate(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        float f2 = homePieceOfFurniture.getDepthInPlan();
        if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
            f2 *= ((HomeDoorOrWindow)homePieceOfFurniture).getWallThickness();
        }
        float f3 = Math.min(homePieceOfFurniture.getWidthInPlan(), f2);
        float f4 = Math.min(1.0f / f, f3 / (float)icon.getIconHeight());
        if (homePieceOfFurniture.isModelMirrored()) {
            graphics2D.scale(-f4, f4);
        } else {
            graphics2D.scale(f4, f4);
        }
        icon.paintIcon(this, graphics2D, -icon.getIconWidth() / 2, -icon.getIconHeight() / 2);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape2);
    }

    private void paintPieceOfFurnitureTop(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Shape shape, BasicStroke basicStroke, float f, Color color, Color color2, PaintMode paintMode) {
        Object object;
        PieceOfFurnitureTopViewIcon pieceOfFurnitureTopViewIcon;
        HomePieceOfFurnitureTopViewIconKey object2;
        if (this.furnitureTopViewIconKeys == null) {
            this.furnitureTopViewIconKeys = new WeakHashMap<HomePieceOfFurniture, HomePieceOfFurnitureTopViewIconKey>();
            this.furnitureTopViewIconsCache = new WeakHashMap<HomePieceOfFurnitureTopViewIconKey, PieceOfFurnitureTopViewIcon>();
        }
        if ((object2 = this.furnitureTopViewIconKeys.get(homePieceOfFurniture)) == null) {
            object2 = new HomePieceOfFurnitureTopViewIconKey(homePieceOfFurniture.clone());
            pieceOfFurnitureTopViewIcon = this.furnitureTopViewIconsCache.get(object2);
            if (pieceOfFurnitureTopViewIcon == null || pieceOfFurnitureTopViewIcon.isWaitIcon() && paintMode != PaintMode.PAINT) {
                object = paintMode == PaintMode.PAINT ? this : null;
                pieceOfFurnitureTopViewIcon = homePieceOfFurniture.getPlanIcon() != null ? new PieceOfFurniturePlanIcon(homePieceOfFurniture, (Component)object) : new PieceOfFurnitureModelIcon(homePieceOfFurniture, this.object3dFactory, (Component)object, this.preferences.getFurnitureModelIconSize());
                this.furnitureTopViewIconsCache.put(object2, pieceOfFurnitureTopViewIcon);
            } else {
                for (HomePieceOfFurnitureTopViewIconKey object3 : this.furnitureTopViewIconsCache.keySet()) {
                    if (!object3.equals(object2)) continue;
                    object2 = object3;
                    break;
                }
            }
            this.furnitureTopViewIconKeys.put(homePieceOfFurniture, object2);
        } else {
            pieceOfFurnitureTopViewIcon = this.furnitureTopViewIconsCache.get(object2);
        }
        if (pieceOfFurnitureTopViewIcon.isWaitIcon() || pieceOfFurnitureTopViewIcon.isErrorIcon()) {
            this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, pieceOfFurnitureTopViewIcon, shape, f, color);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
        } else {
            object = graphics2D.getTransform();
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.translate(rectangle2D.getCenterX(), rectangle2D.getCenterY());
            graphics2D.rotate(homePieceOfFurniture.getAngle());
            float f2 = homePieceOfFurniture.getDepthInPlan();
            if (homePieceOfFurniture.isModelMirrored()) {
                graphics2D.scale(-homePieceOfFurniture.getWidthInPlan() / (float)pieceOfFurnitureTopViewIcon.getIconWidth(), f2 / (float)pieceOfFurnitureTopViewIcon.getIconHeight());
            } else {
                graphics2D.scale(homePieceOfFurniture.getWidthInPlan() / (float)pieceOfFurnitureTopViewIcon.getIconWidth(), f2 / (float)pieceOfFurnitureTopViewIcon.getIconHeight());
            }
            pieceOfFurnitureTopViewIcon.paintIcon(this, graphics2D, -pieceOfFurnitureTopViewIcon.getIconWidth() / 2, -pieceOfFurnitureTopViewIcon.getIconHeight() / 2);
            graphics2D.setTransform((AffineTransform)object);
        }
    }

    private void paintPieceOFFurnitureIndicators(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            Shape shape;
            Shape shape2;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = homePieceOfFurniture.getPoints();
            float f2 = 1.0f / f * this.resolutionScale;
            float f3 = homePieceOfFurniture.getAngle();
            Shape shape3 = this.getIndicator(homePieceOfFurniture, IndicatorType.ROTATE);
            if (shape3 != null) {
                graphics2D.translate(fArray[0][0], fArray[0][1]);
                graphics2D.scale(f2, f2);
                graphics2D.rotate(f3);
                graphics2D.draw(shape3);
                graphics2D.setTransform(affineTransform);
            }
            if ((shape2 = this.getIndicator(homePieceOfFurniture, IndicatorType.ELEVATE)) != null) {
                graphics2D.translate(fArray[1][0], fArray[1][1]);
                graphics2D.scale(f2, f2);
                graphics2D.rotate(f3);
                graphics2D.draw(ELEVATION_POINT_INDICATOR);
                graphics2D.translate(6.5, -6.5);
                graphics2D.rotate(-f3);
                graphics2D.draw(shape2);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.translate(fArray[3][0], fArray[3][1]);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(f3);
            if (homePieceOfFurniture.getPitch() != 0.0f && this.isFurnitureSizeInPlanSupported()) {
                shape = this.getIndicator(homePieceOfFurniture, IndicatorType.ROTATE_PITCH);
                if (shape != null) {
                    graphics2D.draw(shape);
                }
            } else if (homePieceOfFurniture.getRoll() != 0.0f && this.isFurnitureSizeInPlanSupported()) {
                shape = this.getIndicator(homePieceOfFurniture, IndicatorType.ROTATE_ROLL);
                if (shape != null) {
                    graphics2D.draw(shape);
                }
            } else if (homePieceOfFurniture instanceof HomeLight) {
                shape = this.getIndicator(homePieceOfFurniture, IndicatorType.CHANGE_POWER);
                if (shape != null) {
                    graphics2D.draw(LIGHT_POWER_POINT_INDICATOR);
                    graphics2D.translate(-7.5, 7.5);
                    graphics2D.rotate(-f3);
                    graphics2D.draw(shape);
                }
            } else if (homePieceOfFurniture.isResizable() && !homePieceOfFurniture.isHorizontallyRotated() && (shape = this.getIndicator(homePieceOfFurniture, IndicatorType.RESIZE_HEIGHT)) != null) {
                graphics2D.draw(FURNITURE_HEIGHT_POINT_INDICATOR);
                graphics2D.translate(-7.5, 7.5);
                graphics2D.rotate(-f3);
                graphics2D.draw(shape);
            }
            graphics2D.setTransform(affineTransform);
            if (homePieceOfFurniture.isResizable() && (shape = this.getIndicator(homePieceOfFurniture, IndicatorType.RESIZE)) != null) {
                graphics2D.translate(fArray[2][0], fArray[2][1]);
                graphics2D.scale(f2, f2);
                graphics2D.rotate(f3);
                graphics2D.draw(shape);
                graphics2D.setTransform(affineTransform);
            }
            if (homePieceOfFurniture.isNameVisible() && homePieceOfFurniture.getName().trim().length() > 0) {
                float f4 = homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset();
                float f5 = homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset();
                this.paintTextIndicators(graphics2D, homePieceOfFurniture.getClass(), this.getLineCount(homePieceOfFurniture.getName()), homePieceOfFurniture.getNameStyle(), f4, f5, homePieceOfFurniture.getNameAngle(), paint, f);
            }
        }
    }

    private void paintPolylines(Graphics2D graphics2D, Collection<Polyline> collection, List<Selectable> list, Paint paint, Paint paint2, float f, Color color, PaintMode paintMode) {
        for (Polyline polyline : collection) {
            Polyline polyline2;
            if (!this.isViewableAtSelectedLevel(polyline)) continue;
            boolean bl = list.contains(polyline);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            graphics2D.setPaint(new Color(polyline.getColor()));
            float f2 = polyline.getThickness();
            graphics2D.setStroke(ShapeTools.getStroke(f2, polyline.getCapStyle(), polyline.getJoinStyle(), polyline.getDashPattern(), polyline.getDashOffset()));
            Shape shape = ShapeTools.getPolylineShape(polyline.getPoints(), polyline.getJoinStyle() == Polyline.JoinStyle.CURVED, polyline.isClosedPath());
            graphics2D.draw(shape);
            float[] fArray = null;
            float[] fArray2 = null;
            float[] fArray3 = null;
            float[] fArray4 = null;
            PathIterator pathIterator = shape.getPathIterator(null, 0.5);
            while (!pathIterator.isDone()) {
                float[] fArray5 = new float[2];
                if (pathIterator.currentSegment(fArray5) != 4) {
                    if (fArray == null) {
                        fArray = fArray5;
                    } else if (fArray2 == null) {
                        fArray2 = fArray5;
                    }
                    fArray3 = fArray4;
                    fArray4 = fArray5;
                }
                pathIterator.next();
            }
            float f3 = (float)Math.atan2((double)(fArray[1] - fArray2[1]), (double)(fArray[0] - fArray2[0]));
            float f4 = (float)Math.atan2(fArray4[1] - fArray3[1], fArray4[0] - fArray3[0]);
            float f5 = polyline.getCapStyle() != Polyline.CapStyle.BUTT ? f2 / 2.0f : 0.0f;
            this.paintArrow(graphics2D, fArray, f3, polyline.getStartArrowStyle(), f2, f5);
            this.paintArrow(graphics2D, fArray4, f4, polyline.getEndArrowStyle(), f2, f5);
            if (!bl || paintMode != PaintMode.PAINT) continue;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(SwingTools.getStroke(f2 + 4.0f / f, polyline.getCapStyle(), polyline.getJoinStyle(), Polyline.DashStyle.SOLID));
            graphics2D.draw(shape);
            if (list.size() != 1 || paint2 == null || !this.isViewableAtSelectedLevel(polyline2 = (Polyline)list.get(0))) continue;
            graphics2D.setPaint(paint2);
            this.paintPointsResizeIndicators(graphics2D, polyline2, paint2, f, polyline2.isClosedPath(), f3, f4, false);
        }
    }

    private void paintArrow(Graphics2D graphics2D, float[] fArray, float f, Polyline.ArrowStyle arrowStyle, float f2, float f3) {
        if (arrowStyle != null && arrowStyle != Polyline.ArrowStyle.NONE) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(fArray[0], fArray[1]);
            graphics2D.rotate(f);
            graphics2D.translate(f3, 0.0);
            double d = Math.pow(f2, 0.66f) * 2.0;
            graphics2D.scale(d, d);
            switch (arrowStyle) {
                case DISC: {
                    graphics2D.fill(new Ellipse2D.Float(-3.5f, -2.0f, 4.0f, 4.0f));
                    break;
                }
                case OPEN: {
                    graphics2D.scale(0.9, 0.9);
                    graphics2D.setStroke(new BasicStroke((float)((double)f2 / d / 0.9), 0, 0));
                    graphics2D.draw(ARROW);
                    break;
                }
                case DELTA: {
                    graphics2D.translate(1.65f, 0.0);
                    graphics2D.fill(ARROW);
                    break;
                }
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintDimensionLines(Graphics2D graphics2D, Collection<DimensionLine> collection, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, Stroke stroke2, float f, Color color, Color color2, PaintMode paintMode, boolean bl) {
        if (paintMode == PaintMode.CLIPBOARD) {
            collection = Home.getDimensionLinesSubList(list);
        }
        graphics2D.setPaint(color2);
        BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(DimensionLine.class, paintMode) / f);
        Font font = graphics2D.getFont();
        for (DimensionLine dimensionLine : collection) {
            if (!this.isViewableAtSelectedLevel(dimensionLine)) continue;
            AffineTransform affineTransform = graphics2D.getTransform();
            double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            float f2 = dimensionLine.getLength();
            graphics2D.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            if (paintMode == PaintMode.PAINT && this.selectedItemsOutlinePainted && list.contains(dimensionLine)) {
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.draw(new Line2D.Float(0.0f, 0.0f, f2, 0.0f));
                graphics2D.draw(DIMENSION_LINE_END);
                graphics2D.translate(f2, 0.0);
                graphics2D.draw(DIMENSION_LINE_END);
                graphics2D.translate(-f2, 0.0);
                graphics2D.draw(new Line2D.Float(0.0f, -dimensionLine.getOffset(), 0.0f, -5.0f));
                graphics2D.draw(new Line2D.Float(f2, -dimensionLine.getOffset(), f2, -5.0f));
                graphics2D.setPaint(color2);
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(new Line2D.Float(0.0f, 0.0f, f2, 0.0f));
            graphics2D.draw(DIMENSION_LINE_END);
            graphics2D.translate(f2, 0.0);
            graphics2D.draw(DIMENSION_LINE_END);
            graphics2D.translate(-f2, 0.0);
            graphics2D.setStroke(stroke2);
            graphics2D.draw(new Line2D.Float(0.0f, -dimensionLine.getOffset(), 0.0f, -5.0f));
            graphics2D.draw(new Line2D.Float(f2, -dimensionLine.getOffset(), f2, -5.0f));
            String string = this.preferences.getLengthUnit().getFormat().format(Float.valueOf(f2));
            TextStyle textStyle = dimensionLine.getLengthStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(dimensionLine.getClass());
            }
            if (bl && this.getFont() != null) {
                textStyle = textStyle.deriveStyle((float)this.getFont().getSize() / this.getScale());
            }
            Font font2 = this.getFont(font, textStyle);
            FontMetrics fontMetrics = this.getFontMetrics(font2, textStyle);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            int n = fontMetrics.getAscent();
            graphics2D.translate((f2 - (float)rectangle2D.getWidth()) / 2.0f, dimensionLine.getOffset() <= 0.0f ? (double)(-fontMetrics.getDescent() - 1) : (double)(n + 1));
            if (bl) {
                graphics2D.setPaint(color);
                Composite composite = this.setTransparency(graphics2D, 0.7f);
                graphics2D.setStroke(new BasicStroke(4.0f / f * this.resolutionScale, 2, 1));
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                TextLayout textLayout = new TextLayout(string, font2, fontRenderContext);
                graphics2D.draw(textLayout.getOutline(new AffineTransform()));
                graphics2D.setComposite(composite);
                graphics2D.setPaint(color2);
            }
            graphics2D.setFont(font2);
            graphics2D.drawString(string, 0, 0);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setFont(font);
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && paintMode == PaintMode.PAINT && paint2 != null) {
            this.paintDimensionLineResizeIndicator(graphics2D, (DimensionLine)list.get(0), paint2, f);
        }
    }

    private void paintDimensionLineResizeIndicator(Graphics2D graphics2D, DimensionLine dimensionLine, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            AffineTransform affineTransform = graphics2D.getTransform();
            float f2 = 1.0f / f * this.resolutionScale;
            graphics2D.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.rotate(Math.PI);
            graphics2D.scale(f2, f2);
            Shape shape = this.getIndicator(dimensionLine, IndicatorType.RESIZE);
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(dimensionLine.getXEnd(), dimensionLine.getYEnd());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.scale(f2, f2);
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((dimensionLine.getXStart() + dimensionLine.getXEnd()) / 2.0f, (dimensionLine.getYStart() + dimensionLine.getYEnd()) / 2.0f);
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.rotate(dimensionLine.getOffset() <= 0.0f ? 1.5707963267948966 : -1.5707963267948966);
            graphics2D.scale(f2, f2);
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintLabels(Graphics2D graphics2D, Collection<Label> collection, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color, PaintMode paintMode) {
        Font font = graphics2D.getFont();
        for (Label label : collection) {
            Shape shape;
            Integer n;
            if (!this.isViewableAtSelectedLevel(label)) continue;
            boolean bl = list.contains(label);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            String string = label.getText();
            float f2 = label.getX();
            float f3 = label.getY();
            float f4 = label.getAngle();
            TextStyle textStyle = label.getStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(label.getClass());
            }
            if (textStyle.getFontName() == null && this.getFont() != null) {
                textStyle = textStyle.deriveStyle(this.getFont().getFontName());
            }
            graphics2D.setPaint((n = label.getColor()) != null ? new Color(n) : color);
            this.paintText(graphics2D, label.getClass(), string, textStyle, label.getOutlineColor(), f2, f3, f4, font);
            if (paintMode != PaintMode.PAINT || !this.selectedItemsOutlinePainted || !bl) continue;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            float[][] fArray = this.getTextBounds(string, textStyle, f2, f3, f4);
            graphics2D.draw(ShapeTools.getShape(fArray, true, null));
            graphics2D.setPaint(color);
            if (paint2 == null || list.size() != 1 || list.get(0) != label) continue;
            this.paintTextIndicators(graphics2D, label.getClass(), this.getLineCount(string), textStyle, f2, f3, f4, paint2, f);
            if (!this.resizeIndicatorVisible || label.getPitch() == null || (shape = this.getIndicator(label, IndicatorType.ELEVATE)) == null) continue;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
                graphics2D.translate(fArray[3][0], fArray[3][1]);
            } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
                graphics2D.translate(fArray[2][0], fArray[2][1]);
            } else {
                graphics2D.translate((fArray[2][0] + fArray[3][0]) / 2.0f, (fArray[2][1] + fArray[3][1]) / 2.0f);
            }
            float f5 = 1.0f / f * this.resolutionScale;
            graphics2D.scale(f5, f5);
            graphics2D.rotate(label.getAngle());
            graphics2D.draw(ELEVATION_POINT_INDICATOR);
            graphics2D.translate(0.0, 10.0);
            graphics2D.rotate(-label.getAngle());
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setFont(font);
    }

    private void paintCompass(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        Compass compass = this.home.getCompass();
        if (compass.isVisible() && (paintMode != PaintMode.CLIPBOARD || list.contains(compass))) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(compass.getX(), compass.getY());
            graphics2D.rotate(compass.getNorthDirection());
            float f2 = compass.getDiameter();
            graphics2D.scale(f2, f2);
            graphics2D.setColor(color);
            graphics2D.fill(COMPASS);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintCompassOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        Compass compass = this.home.getCompass();
        if (list.contains(compass) && compass.isVisible()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(compass.getX(), compass.getY());
            graphics2D.rotate(compass.getNorthDirection());
            float f2 = compass.getDiameter();
            graphics2D.scale(f2, f2);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(new BasicStroke((5.5f + f) / f2 / f * this.resolutionScale));
            graphics2D.draw(COMPASS_DISC);
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(1.0f / f2 / f * this.resolutionScale));
            graphics2D.draw(COMPASS_DISC);
            graphics2D.setTransform(affineTransform);
            if (list.size() == 1 && list.get(0) == compass) {
                graphics2D.setPaint(paint2);
                this.paintCompassIndicators(graphics2D, compass, paint2, f);
            }
        }
    }

    private void paintCompassIndicators(Graphics2D graphics2D, Compass compass, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = compass.getPoints();
            float f2 = 1.0f / f * this.resolutionScale;
            graphics2D.translate((fArray[2][0] + fArray[3][0]) / 2.0f, (fArray[2][1] + fArray[3][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(compass.getNorthDirection());
            graphics2D.draw(this.getIndicator(compass, IndicatorType.ROTATE));
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((fArray[1][0] + fArray[2][0]) / 2.0f, (fArray[1][1] + fArray[2][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(compass.getNorthDirection());
            graphics2D.draw(this.getIndicator(compass, IndicatorType.RESIZE));
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintWallAlignmentFeedback(Graphics2D graphics2D, Wall wall, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Wall wall2 : this.getViewedItems(this.home.getWalls(), this.otherLevelsWallsCache)) {
                if (wall2 == wall) continue;
                if (Math.abs(f3 - wall2.getXStart()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (Math.abs(f6) > Math.abs(f4 - wall2.getYStart())) {
                        f6 = f4 - wall2.getYStart();
                    }
                } else if (Math.abs(f3 - wall2.getXEnd()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall)) && Math.abs(f6) > Math.abs(f4 - wall2.getYEnd())) {
                    f6 = f4 - wall2.getYEnd();
                }
                if (Math.abs(f4 - wall2.getYStart()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (Math.abs(f5) > Math.abs(f3 - wall2.getXStart())) {
                        f5 = f3 - wall2.getXStart();
                    }
                } else if (Math.abs(f4 - wall2.getYEnd()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall)) && Math.abs(f5) > Math.abs(f3 - wall2.getXEnd())) {
                    f5 = f3 - wall2.getXEnd();
                }
                Object object = wall2.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (int i = 0; i < ((float[][])object).length; ++i) {
                    if (Math.abs(f3 - object[i][0]) < f2 && (wall == null || !this.equalsWallPoint(object[i][0], object[i][1], wall)) && Math.abs(f6) > Math.abs(f4 - object[i][1])) {
                        f6 = f4 - object[i][1];
                    }
                    if (!(Math.abs(f4 - object[i][1]) < f2) || wall != null && this.equalsWallPoint(object[i][0], object[i][1], wall) || !(Math.abs(f5) > Math.abs(f3 - object[i][0]))) continue;
                    f5 = f3 - object[i][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private <T extends Elevatable> Collection<T> getViewedItems(Collection<T> collection, List<T> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null) {
            arrayList.addAll(list);
        }
        for (Elevatable elevatable : collection) {
            if (!this.isViewableAtSelectedLevel(elevatable)) continue;
            arrayList.add(elevatable);
        }
        return arrayList;
    }

    private void paintPointFeedback(Graphics2D graphics2D, Point2D point2D, Paint paint, float f, Paint paint2, Stroke stroke) {
        graphics2D.setPaint(paint2);
        graphics2D.setStroke(stroke);
        Ellipse2D.Float float_ = new Ellipse2D.Float((float)point2D.getX() - 10.0f / f, (float)point2D.getY() - 10.0f / f, 20.0f / f, 20.0f / f);
        graphics2D.fill(float_);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(new BasicStroke(1.0f / f * this.resolutionScale));
        graphics2D.draw(float_);
        graphics2D.draw(new Line2D.Float((float)point2D.getX(), (float)point2D.getY() - 5.0f / f, (float)point2D.getX(), (float)point2D.getY() + 5.0f / f));
        graphics2D.draw(new Line2D.Float((float)point2D.getX() - 5.0f / f, (float)point2D.getY(), (float)point2D.getX() + 5.0f / f, (float)point2D.getY()));
    }

    private boolean equalsWallPoint(float f, float f2, Wall wall) {
        return f == wall.getXStart() && f2 == wall.getYStart() || f == wall.getXEnd() && f2 == wall.getYEnd();
    }

    private void paintRoomAlignmentFeedback(Graphics2D graphics2D, Room room, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            int n;
            Object object;
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Room homeObject : this.getViewedItems(this.home.getRooms(), this.otherLevelsRoomsCache)) {
                int n2;
                object = homeObject.getPoints();
                n = -1;
                if (homeObject == room) {
                    for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                        if (object[n2][0] != f3 || object[n2][1] != f4) continue;
                        n = n2;
                        break;
                    }
                }
                for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                    if (n != -1 && (n2 == n || ((float[][])object).length <= 2)) continue;
                    if (Math.abs(f3 - object[n2][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n2][1])) {
                        f6 = f4 - object[n2][1];
                    }
                    if (!(Math.abs(f4 - object[n2][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n2][0]))) continue;
                    f5 = f3 - object[n2][0];
                }
            }
            for (Wall wall : this.getViewedItems(this.home.getWalls(), this.otherLevelsWallsCache)) {
                object = wall.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private void paintDimensionLineAlignmentFeedback(Graphics2D graphics2D, DimensionLine dimensionLine, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            int n;
            Object object;
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Room homeObject : this.getViewedItems(this.home.getRooms(), this.otherLevelsRoomsCache)) {
                object = homeObject.getPoints();
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            for (DimensionLine dimensionLine2 : this.home.getDimensionLines()) {
                if (!this.isViewableAtSelectedLevel(dimensionLine2) || dimensionLine2 == dimensionLine) continue;
                if (Math.abs(f3 - dimensionLine2.getXStart()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXStart(), dimensionLine2.getYStart(), dimensionLine))) {
                    if (Math.abs(f6) > Math.abs(f4 - dimensionLine2.getYStart())) {
                        f6 = f4 - dimensionLine2.getYStart();
                    }
                } else if (Math.abs(f3 - dimensionLine2.getXEnd()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXEnd(), dimensionLine2.getYEnd(), dimensionLine)) && Math.abs(f6) > Math.abs(f4 - dimensionLine2.getYEnd())) {
                    f6 = f4 - dimensionLine2.getYEnd();
                }
                if (Math.abs(f4 - dimensionLine2.getYStart()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXStart(), dimensionLine2.getYStart(), dimensionLine))) {
                    if (!(Math.abs(f5) > Math.abs(f3 - dimensionLine2.getXStart()))) continue;
                    f5 = f3 - dimensionLine2.getXStart();
                    continue;
                }
                if (!(Math.abs(f4 - dimensionLine2.getYEnd()) < f2) || dimensionLine != null && this.equalsDimensionLinePoint(dimensionLine2.getXEnd(), dimensionLine2.getYEnd(), dimensionLine) || !(Math.abs(f5) > Math.abs(f3 - dimensionLine2.getXEnd()))) continue;
                f5 = f3 - dimensionLine2.getXEnd();
            }
            for (Wall wall : this.getViewedItems(this.home.getWalls(), this.otherLevelsWallsCache)) {
                object = wall.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
                if (!homePieceOfFurniture.isVisible() || !this.isViewableAtSelectedLevel(homePieceOfFurniture)) continue;
                object = homePieceOfFurniture.getPoints();
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private boolean equalsDimensionLinePoint(float f, float f2, DimensionLine dimensionLine) {
        return f == dimensionLine.getXStart() && f2 == dimensionLine.getYStart() || f == dimensionLine.getXEnd() && f2 == dimensionLine.getYEnd();
    }

    private void paintAngleFeedback(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, Point2D point2D3, float f, Color color) {
        double d;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f / f * this.resolutionScale));
        double d2 = Math.atan2(point2D.getY() - point2D2.getY(), point2D2.getX() - point2D.getX());
        if (d2 < 0.0) {
            d2 = Math.PI * 2 + d2;
        }
        if ((d = Math.atan2(point2D.getY() - point2D3.getY(), point2D3.getX() - point2D.getX())) < 0.0) {
            d = Math.PI * 2 + d;
        }
        double d3 = d - d2;
        if (d2 > d) {
            d3 = Math.PI * 2 + d3;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(point2D.getX(), point2D.getY());
        float f2 = 20.0f / f;
        graphics2D.draw(new Arc2D.Double(-f2, -f2, f2 * 2.0f, f2 * 2.0f, Math.toDegrees(d2), Math.toDegrees(d3), 0));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, (double)(f2 += 5.0f / f) * Math.cos(d2), (double)(-f2) * Math.sin(d2)));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, (double)f2 * Math.cos(d2 + d3), (double)(-f2) * Math.sin(d2 + d3)));
        graphics2D.setTransform(affineTransform);
    }

    private void paintCamera(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color, Color color2) {
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera == this.home.getCamera()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(observerCamera.getX(), observerCamera.getY());
            graphics2D.rotate(observerCamera.getYaw());
            float[][] fArray = observerCamera.getPoints();
            double d = Point2D.distance(fArray[0][0], fArray[0][1], fArray[3][0], fArray[3][1]);
            double d2 = Point2D.distance(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d2, d);
            Area area = new Area(CAMERA_BODY).createTransformedArea(affineTransform2);
            Area area2 = new Area(CAMERA_HEAD).createTransformedArea(affineTransform2);
            graphics2D.setPaint(color);
            graphics2D.fill(area);
            graphics2D.setPaint(color2);
            BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(ObserverCamera.class, PaintMode.PAINT) / f);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(area);
            if (list.contains(observerCamera) && this.selectedItemsOutlinePainted) {
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                Area area3 = new Area(area);
                area3.add(new Area(area2));
                graphics2D.draw(area3);
            }
            graphics2D.setPaint(color);
            graphics2D.fill(area2);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(area2);
            double d3 = (float)Math.sin(observerCamera.getFieldOfView() / 2.0f);
            double d4 = (float)Math.cos(observerCamera.getFieldOfView() / 2.0f);
            float f2 = (float)((double)0.9f * d * d3);
            float f3 = (float)((double)0.9f * d * d4);
            float f4 = (float)((double)2.2f * d * d3);
            float f5 = (float)((double)2.2f * d * d4);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f2, f3);
            generalPath.lineTo(f4, f5);
            generalPath.moveTo(-f2, f3);
            generalPath.lineTo(-f4, f5);
            graphics2D.draw(generalPath);
            graphics2D.setTransform(affineTransform);
            if (list.size() == 1 && list.get(0) == observerCamera) {
                this.paintCameraRotationIndicators(graphics2D, observerCamera, paint2, f);
            }
        }
    }

    private void paintCameraRotationIndicators(Graphics2D graphics2D, ObserverCamera observerCamera, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = observerCamera.getPoints();
            float f2 = 1.0f / f * this.resolutionScale;
            graphics2D.translate((fArray[0][0] + fArray[3][0]) / 2.0f, (fArray[0][1] + fArray[3][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(observerCamera.getYaw());
            graphics2D.draw(this.getIndicator(observerCamera, IndicatorType.ROTATE));
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((fArray[1][0] + fArray[2][0]) / 2.0f, (fArray[1][1] + fArray[2][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(observerCamera.getYaw());
            graphics2D.draw(this.getIndicator(observerCamera, IndicatorType.ROTATE_PITCH));
            graphics2D.setTransform(affineTransform);
            Shape shape = this.getIndicator(observerCamera, IndicatorType.ELEVATE);
            if (shape != null) {
                graphics2D.translate((fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
                graphics2D.scale(f2, f2);
                graphics2D.draw(POINT_INDICATOR);
                graphics2D.translate(Math.sin(observerCamera.getYaw()) * 8.0, -Math.cos(observerCamera.getYaw()) * 8.0);
                graphics2D.draw(shape);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    private void paintRectangleFeedback(Graphics2D graphics2D, Color color, float f) {
        if (this.rectangleFeedback != null) {
            graphics2D.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
            graphics2D.fill(this.rectangleFeedback);
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f / f * this.resolutionScale));
            graphics2D.draw(this.rectangleFeedback);
        }
    }

    @Override
    public void setRectangleFeedback(float f, float f2, float f3, float f4) {
        this.rectangleFeedback = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        this.rectangleFeedback.add(f3, f4);
        this.repaint();
    }

    @Override
    public void makeSelectionVisible() {
        if (!this.selectionScrollUpdated) {
            this.selectionScrollUpdated = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlanComponent.this.selectionScrollUpdated = false;
                    Rectangle2D rectangle2D = PlanComponent.this.getSelectionBounds(true);
                    if (rectangle2D != null) {
                        Rectangle rectangle = PlanComponent.this.getShapePixelBounds(rectangle2D);
                        rectangle.grow(5, 5);
                        Rectangle rectangle2 = PlanComponent.this.getVisibleRect();
                        if (!rectangle.intersects(rectangle2)) {
                            PlanComponent.this.scrollRectToVisible(rectangle);
                        }
                    }
                }
            });
        }
    }

    private Rectangle2D getSelectionBounds(boolean bl) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            this.setRenderingHints(graphics2D);
        }
        if (bl) {
            return this.getItemsBounds(graphics2D, this.home.getSelectedItems());
        }
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.home.getSelectedItems());
        arrayList.remove(this.home.getCamera());
        return this.getItemsBounds(graphics2D, arrayList);
    }

    @Override
    public void makePointVisible(float f, float f2) {
        this.scrollRectToVisible(this.getShapePixelBounds(new Rectangle2D.Float(f, f2, 1.0f / this.getScale(), 1.0f / this.getScale())));
    }

    @Override
    public void moveView(float f, float f2) {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = jViewport.getViewRect();
            rectangle.translate(Math.round(f * this.getScale()), Math.round(f2 * this.getScale()));
            rectangle.x = Math.min(Math.max(0, rectangle.x), this.getWidth() - rectangle.width);
            rectangle.y = Math.min(Math.max(0, rectangle.y), this.getHeight() - rectangle.height);
            jViewport.setViewPosition(rectangle.getLocation());
        }
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float f) {
        if (this.scale != f) {
            JViewport jViewport = null;
            Rectangle rectangle = null;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.getParent() instanceof JViewport) {
                jViewport = (JViewport)this.getParent();
                rectangle = jViewport.getViewRect();
                f2 = this.convertXPixelToModel(rectangle.x + rectangle.width / 2);
                f3 = this.convertYPixelToModel(rectangle.y + rectangle.height / 2);
            }
            this.scale = f;
            this.invalidate(false);
            this.revalidate();
            if (jViewport instanceof JViewport) {
                Dimension dimension = jViewport.getViewSize();
                float f4 = this.convertXPixelToModel(rectangle.x + rectangle.width) - this.convertXPixelToModel(rectangle.x);
                int n = Math.max(0, Math.min(this.convertXModelToPixel(f2 - f4 / 2.0f), dimension.width - rectangle.x));
                float f5 = this.convertYPixelToModel(rectangle.y + rectangle.height) - this.convertYPixelToModel(rectangle.y);
                int n2 = Math.max(0, Math.min(this.convertYModelToPixel(f3 - f5 / 2.0f), dimension.height - rectangle.y));
                jViewport.setViewPosition(new Point(n, n2));
            }
        }
    }

    @Override
    public float convertXPixelToModel(int n) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (float)(n - insets.left) / this.getScale() - 40.0f + (float)rectangle2D.getMinX();
    }

    @Override
    public float convertYPixelToModel(int n) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (float)(n - insets.top) / this.getScale() - 40.0f + (float)rectangle2D.getMinY();
    }

    private int convertXModelToPixel(float f) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (int)Math.round(((double)f - rectangle2D.getMinX() + 40.0) * (double)this.getScale()) + insets.left;
    }

    private int convertYModelToPixel(float f) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (int)Math.round(((double)f - rectangle2D.getMinY() + 40.0) * (double)this.getScale()) + insets.top;
    }

    @Override
    public int convertXModelToScreen(float f) {
        Point point = new Point(this.convertXModelToPixel(f), 0);
        SwingUtilities.convertPointToScreen(point, this);
        return point.x;
    }

    @Override
    public int convertYModelToScreen(float f) {
        Point point = new Point(0, this.convertYModelToPixel(f));
        SwingUtilities.convertPointToScreen(point, this);
        return point.y;
    }

    @Override
    public float getPixelLength() {
        return 1.0f / this.getScale();
    }

    private Rectangle getShapePixelBounds(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        return new Rectangle(this.convertXModelToPixel((float)rectangle2D.getMinX()), this.convertYModelToPixel((float)rectangle2D.getMinY()), (int)Math.round(rectangle2D.getWidth() * (double)this.getScale()), (int)Math.round(rectangle2D.getHeight() * (double)this.getScale()));
    }

    @Override
    public void setCursor(PlanView.CursorType cursorType) {
        switch (cursorType) {
            case DRAW: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case ROTATION: {
                this.setCursor(this.rotationCursor);
                break;
            }
            case HEIGHT: {
                this.setCursor(this.heightCursor);
                break;
            }
            case POWER: {
                this.setCursor(this.powerCursor);
                break;
            }
            case ELEVATION: {
                this.setCursor(this.elevationCursor);
                break;
            }
            case RESIZE: {
                this.setCursor(this.resizeCursor);
                break;
            }
            case PANNING: {
                this.setCursor(this.panningCursor);
                break;
            }
            case DUPLICATION: {
                this.setCursor(this.duplicationCursor);
                break;
            }
            case MOVE: {
                this.setCursor(this.moveCursor);
                break;
            }
            default: {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void setToolTipFeedback(String string, float f, float f2) {
        this.stopToolTipPropertiesEdition();
        JToolTip jToolTip = this.getToolTip();
        jToolTip.setTipText(string);
        this.showToolTipComponentAt(jToolTip, f, f2);
    }

    private JToolTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new JToolTip();
            this.toolTip.setComponent(this);
        }
        return this.toolTip;
    }

    private void showToolTipComponentAt(JComponent jComponent, float f, float f2) {
        Object object;
        if (this.toolTipWindow == null) {
            this.toolTipWindow = new JWindow(JOptionPane.getFrameForComponent(this));
            this.toolTipWindow.setFocusableWindowState(false);
            this.toolTipWindow.add(jComponent);
            object = new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    PlanComponent.this.dispatchEvent(SwingUtilities.convertMouseEvent(PlanComponent.this.toolTipWindow, mouseEvent, PlanComponent.this));
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }
            };
            this.toolTipWindow.addMouseListener((MouseListener)object);
            this.toolTipWindow.addMouseMotionListener((MouseMotionListener)object);
        } else {
            object = this.toolTipWindow.getContentPane();
            if (((Container)object).getComponent(0) != jComponent) {
                ((Container)object).removeAll();
                ((Container)object).add(jComponent);
            }
            jComponent.revalidate();
        }
        object = new Point(this.convertXModelToPixel(f), this.convertYModelToPixel(f2));
        SwingUtilities.convertPointToScreen((Point)object, this);
        Dimension dimension = this.getToolkit().getBestCursorSize(16, 16);
        if (dimension.width != 0) {
            ((Point)object).x += dimension.width / 2 + 3;
            ((Point)object).y += dimension.height / 2 + 3;
        } else {
            ((Point)object).x += 11;
            ((Point)object).y += 11;
        }
        this.toolTipWindow.setLocation((Point)object);
        this.toolTipWindow.pack();
        this.toolTipWindow.setVisible(!OperatingSystem.isMacOSX() || !OperatingSystem.isJavaVersionGreaterOrEqual("1.7") || SwingUtilities.getAncestorOfClass(JApplet.class, this) == null);
        jComponent.paintImmediately(jComponent.getBounds());
    }

    @Override
    public void setToolTipEditedProperties(final PlanController.EditableProperty[] editablePropertyArray, Object[] objectArray, float f, float f2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = UIManager.getBorder("ToolTip.border");
        if (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior()) {
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 3, 0, 2));
        }
        jPanel.setBorder(border);
        JToolTip jToolTip = this.getToolTip();
        jPanel.setBackground(jToolTip.getBackground());
        jPanel.setForeground(jToolTip.getForeground());
        for (int i = 0; i < editablePropertyArray.length; ++i) {
            JFormattedTextField jFormattedTextField = this.toolTipEditableTextFields.get((Object)editablePropertyArray[i]);
            jFormattedTextField.setValue(objectArray[i]);
            JLabel jLabel = new JLabel(this.preferences.getLocalizedString(PlanComponent.class, editablePropertyArray[i].name() + ".editablePropertyLabel.text", new Object[0]) + " ");
            jLabel.setFont(jFormattedTextField.getFont());
            JLabel jLabel2 = null;
            if (editablePropertyArray[i] == PlanController.EditableProperty.ANGLE || editablePropertyArray[i] == PlanController.EditableProperty.ARC_EXTENT) {
                jLabel2 = new JLabel(this.preferences.getLocalizedString(PlanComponent.class, "degreeLabel.text", new Object[0]));
            } else if (this.preferences.getLengthUnit() != LengthUnit.INCH || this.preferences.getLengthUnit() != LengthUnit.INCH_DECIMALS) {
                jLabel2 = new JLabel(" " + this.preferences.getLengthUnit().getName());
            }
            JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
            jPanel2.setOpaque(false);
            jPanel2.add(jLabel);
            jPanel2.add(jFormattedTextField);
            if (jLabel2 != null) {
                jLabel2.setFont(jFormattedTextField.getFont());
                jPanel2.add(jLabel2);
            }
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.showToolTipComponentAt(jPanel, f, f2);
        this.toolTipKeyListener = new KeyListener(){
            private int focusedTextFieldIndex;
            private JFormattedTextField focusedTextField;
            {
                this.setFocusedTextFieldIndex(0);
            }

            private void setFocusedTextFieldIndex(int n) {
                if (this.focusedTextField != null) {
                    this.focusedTextField.getCaret().setVisible(false);
                    this.focusedTextField.getCaret().setSelectionVisible(false);
                    this.focusedTextField.setValue(this.focusedTextField.getValue());
                }
                this.focusedTextFieldIndex = n;
                this.focusedTextField = (JFormattedTextField)PlanComponent.this.toolTipEditableTextFields.get((Object)editablePropertyArray[n]);
                if (this.focusedTextField.getText().length() == 0) {
                    this.focusedTextField.getCaret().setVisible(false);
                } else {
                    this.focusedTextField.selectAll();
                }
                this.focusedTextField.getCaret().setSelectionVisible(true);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.keyTyped(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this.focusedTextField, keyEvent);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Set<AWTKeyStroke> set = this.focusedTextField.getFocusTraversalKeys(0);
                if (set.contains(AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent)) || keyEvent.getKeyCode() == 40) {
                    this.setFocusedTextFieldIndex((this.focusedTextFieldIndex + 1) % editablePropertyArray.length);
                    keyEvent.consume();
                } else {
                    Set<AWTKeyStroke> set2 = this.focusedTextField.getFocusTraversalKeys(1);
                    if (set2.contains(AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent)) || keyEvent.getKeyCode() == 38) {
                        this.setFocusedTextFieldIndex((this.focusedTextFieldIndex - 1 + editablePropertyArray.length) % editablePropertyArray.length);
                        keyEvent.consume();
                    } else if ((keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35) && OperatingSystem.isMacOSX() && !OperatingSystem.isMacOSXLeopardOrSuperior()) {
                        if (keyEvent.getKeyCode() == 36) {
                            this.focusedTextField.setCaretPosition(0);
                        } else if (keyEvent.getKeyCode() == 35) {
                            this.focusedTextField.setCaretPosition(this.focusedTextField.getText().length());
                        }
                        keyEvent.consume();
                    } else if (keyEvent.getKeyCode() != 27 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this.focusedTextField, keyEvent);
                        this.focusedTextField.getCaret().setVisible(true);
                        PlanComponent.this.toolTipWindow.pack();
                    }
                }
            }
        };
        this.addKeyListener(this.toolTipKeyListener);
        this.setFocusTraversalKeysEnabled(false);
        this.installEditionKeyboardActions();
    }

    @Override
    public void deleteToolTipFeedback() {
        this.stopToolTipPropertiesEdition();
        if (this.toolTip != null) {
            this.toolTip.setTipText(null);
        }
        if (this.toolTipWindow != null) {
            this.toolTipWindow.setVisible(false);
        }
    }

    private void stopToolTipPropertiesEdition() {
        if (this.toolTipKeyListener != null) {
            this.installDefaultKeyboardActions();
            this.setFocusTraversalKeysEnabled(true);
            this.removeKeyListener(this.toolTipKeyListener);
            this.toolTipKeyListener = null;
            for (JFormattedTextField jFormattedTextField : this.toolTipEditableTextFields.values()) {
                jFormattedTextField.getCaret().setVisible(false);
                jFormattedTextField.getCaret().setSelectionVisible(false);
            }
        }
    }

    @Override
    public void setResizeIndicatorVisible(boolean bl) {
        this.resizeIndicatorVisible = bl;
        this.repaint();
    }

    @Override
    public void setAlignmentFeedback(Class<? extends Selectable> clazz, Selectable selectable, float f, float f2, boolean bl) {
        this.alignedObjectClass = clazz;
        this.alignedObjectFeedback = selectable;
        this.locationFeeback = new Point2D.Float(f, f2);
        this.showPointFeedback = bl;
        this.repaint();
    }

    @Override
    public void setAngleFeedback(float f, float f2, float f3, float f4, float f5, float f6) {
        this.centerAngleFeedback = new Point2D.Float(f, f2);
        this.point1AngleFeedback = new Point2D.Float(f3, f4);
        this.point2AngleFeedback = new Point2D.Float(f5, f6);
    }

    @Override
    public void setDraggedItemsFeedback(List<Selectable> list) {
        this.draggedItemsFeedback = list;
        this.repaint();
    }

    @Override
    public void setDimensionLinesFeedback(List<DimensionLine> list) {
        this.dimensionLinesFeedback = list;
        this.repaint();
    }

    @Override
    public void deleteFeedback() {
        this.deleteToolTipFeedback();
        this.rectangleFeedback = null;
        this.alignedObjectClass = null;
        this.alignedObjectFeedback = null;
        this.locationFeeback = null;
        this.centerAngleFeedback = null;
        this.point1AngleFeedback = null;
        this.point2AngleFeedback = null;
        this.draggedItemsFeedback = null;
        this.dimensionLinesFeedback = null;
        this.repaint();
    }

    @Override
    public boolean canImportDraggedItems(List<Selectable> list, int n, int n2) {
        return true;
    }

    @Override
    public float[] getPieceOfFurnitureSizeInPlan(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture.getRoll() == 0.0f && homePieceOfFurniture.getPitch() == 0.0f) {
            return new float[]{homePieceOfFurniture.getWidth(), homePieceOfFurniture.getDepth(), homePieceOfFurniture.getHeight()};
        }
        if (!this.isFurnitureSizeInPlanSupported()) {
            return null;
        }
        return PieceOfFurnitureModelIcon.computePieceOfFurnitureSizeInPlan(homePieceOfFurniture, this.object3dFactory);
    }

    @Override
    public boolean isFurnitureSizeInPlanSupported() {
        try {
            return !Boolean.getBoolean("com.eteks.sweethome3d.no3D");
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 2;
        }
        return rectangle.height / 2;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().height < ((JViewport)this.getParent()).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().width < ((JViewport)this.getParent()).getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 10;
        }
        return rectangle.height / 10;
    }

    @Override
    public View getHorizontalRuler() {
        if (this.horizontalRuler == null) {
            this.horizontalRuler = new PlanRulerComponent(0);
        }
        return this.horizontalRuler;
    }

    @Override
    public View getVerticalRuler() {
        if (this.verticalRuler == null) {
            this.verticalRuler = new PlanRulerComponent(1);
        }
        return this.verticalRuler;
    }

    static {
        INDICATOR_STROKE = new BasicStroke(1.5f);
        POINT_STROKE = new BasicStroke(2.0f);
        POINT_INDICATOR = new Ellipse2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        FURNITURE_ROTATION_INDICATOR = new GeneralPath();
        FURNITURE_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        FURNITURE_ROTATION_INDICATOR.append(new Arc2D.Float(-8.0f, -8.0f, 16.0f, 16.0f, 45.0f, 180.0f, 0), false);
        FURNITURE_ROTATION_INDICATOR.moveTo(2.66f, -5.66f);
        FURNITURE_ROTATION_INDICATOR.lineTo(5.66f, -5.66f);
        FURNITURE_ROTATION_INDICATOR.lineTo(4.0f, -8.3f);
        FURNITURE_PITCH_ROTATION_INDICATOR = new GeneralPath();
        FURNITURE_PITCH_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        FURNITURE_PITCH_ROTATION_INDICATOR.moveTo(-4.5f, 0.0f);
        FURNITURE_PITCH_ROTATION_INDICATOR.lineTo(-5.2f, 0.0f);
        FURNITURE_PITCH_ROTATION_INDICATOR.moveTo(-9.0f, 0.0f);
        FURNITURE_PITCH_ROTATION_INDICATOR.lineTo(-10.0f, 0.0f);
        FURNITURE_PITCH_ROTATION_INDICATOR.append(new Arc2D.Float(-12.0f, -8.0f, 5.0f, 16.0f, 200.0f, 320.0f, 0), false);
        FURNITURE_PITCH_ROTATION_INDICATOR.moveTo(-10.0f, -4.5f);
        FURNITURE_PITCH_ROTATION_INDICATOR.lineTo(-12.3f, -2.0f);
        FURNITURE_PITCH_ROTATION_INDICATOR.lineTo(-12.8f, -5.8f);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966);
        affineTransform.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        FURNITURE_ROLL_ROTATION_INDICATOR = FURNITURE_PITCH_ROTATION_INDICATOR.createTransformedShape(affineTransform);
        ELEVATION_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        ELEVATION_INDICATOR = new GeneralPath();
        ELEVATION_INDICATOR.moveTo(0.0f, -5.0f);
        ELEVATION_INDICATOR.lineTo(0.0f, 5.0f);
        ELEVATION_INDICATOR.moveTo(-2.5f, 5.0f);
        ELEVATION_INDICATOR.lineTo(2.5f, 5.0f);
        ELEVATION_INDICATOR.moveTo(-1.2f, 1.5f);
        ELEVATION_INDICATOR.lineTo(0.0f, 4.5f);
        ELEVATION_INDICATOR.lineTo(1.2f, 1.5f);
        FURNITURE_HEIGHT_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        FURNITURE_HEIGHT_INDICATOR = new GeneralPath();
        FURNITURE_HEIGHT_INDICATOR.moveTo(0.0f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-2.5f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(2.5f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-2.5f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(2.5f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-1.2f, -2.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, -5.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(1.2f, -2.5f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-1.2f, 2.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, 5.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(1.2f, 2.5f);
        LIGHT_POWER_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        LIGHT_POWER_INDICATOR = new GeneralPath();
        LIGHT_POWER_INDICATOR.moveTo(-8.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-6.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-6.0f, -1.0f);
        LIGHT_POWER_INDICATOR.closePath();
        LIGHT_POWER_INDICATOR.moveTo(-3.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-1.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-1.0f, -2.5f);
        LIGHT_POWER_INDICATOR.lineTo(-3.0f, -1.8f);
        LIGHT_POWER_INDICATOR.closePath();
        LIGHT_POWER_INDICATOR.moveTo(2.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(4.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(4.0f, -3.5f);
        LIGHT_POWER_INDICATOR.lineTo(2.0f, -2.8f);
        LIGHT_POWER_INDICATOR.closePath();
        FURNITURE_RESIZE_INDICATOR = new GeneralPath();
        FURNITURE_RESIZE_INDICATOR.append(new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), false);
        FURNITURE_RESIZE_INDICATOR.moveTo(5.0f, -4.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(7.0f, -4.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(7.0f, 7.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(-4.0f, 7.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(-4.0f, 5.0f);
        FURNITURE_RESIZE_INDICATOR.moveTo(3.5f, 3.5f);
        FURNITURE_RESIZE_INDICATOR.lineTo(9.0f, 9.0f);
        FURNITURE_RESIZE_INDICATOR.moveTo(7.0f, 9.5f);
        FURNITURE_RESIZE_INDICATOR.lineTo(10.0f, 10.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(9.5f, 7.0f);
        WALL_ORIENTATION_INDICATOR = new GeneralPath();
        WALL_ORIENTATION_INDICATOR.moveTo(-4.0f, -4.0f);
        WALL_ORIENTATION_INDICATOR.lineTo(4.0f, 0.0f);
        WALL_ORIENTATION_INDICATOR.lineTo(-4.0f, 4.0f);
        WALL_POINT = new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
        WALL_ARC_EXTENT_INDICATOR = new GeneralPath();
        WALL_ARC_EXTENT_INDICATOR.append(new Arc2D.Float(-4.0f, 1.0f, 8.0f, 5.0f, 210.0f, 120.0f, 0), false);
        WALL_ARC_EXTENT_INDICATOR.moveTo(0.0f, 6.0f);
        WALL_ARC_EXTENT_INDICATOR.lineTo(0.0f, 11.0f);
        WALL_ARC_EXTENT_INDICATOR.moveTo(-1.8f, 8.7f);
        WALL_ARC_EXTENT_INDICATOR.lineTo(0.0f, 12.0f);
        WALL_ARC_EXTENT_INDICATOR.lineTo(1.8f, 8.7f);
        WALL_AND_LINE_RESIZE_INDICATOR = new GeneralPath();
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(5.0f, -2.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(5.0f, 2.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(6.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(11.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(8.7f, -1.8f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(12.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(8.7f, 1.8f);
        affineTransform = AffineTransform.getRotateInstance(-0.7853981633974483);
        CAMERA_YAW_ROTATION_INDICATOR = FURNITURE_ROTATION_INDICATOR.createTransformedShape(affineTransform);
        affineTransform = AffineTransform.getRotateInstance(Math.PI);
        CAMERA_PITCH_ROTATION_INDICATOR = FURNITURE_PITCH_ROTATION_INDICATOR.createTransformedShape(affineTransform);
        CAMERA_ELEVATION_INDICATOR = new GeneralPath();
        CAMERA_ELEVATION_INDICATOR.moveTo(0.0f, -4.0f);
        CAMERA_ELEVATION_INDICATOR.lineTo(0.0f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.moveTo(-2.5f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.lineTo(2.5f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.moveTo(-1.2f, 0.5f);
        CAMERA_ELEVATION_INDICATOR.lineTo(0.0f, 3.5f);
        CAMERA_ELEVATION_INDICATOR.lineTo(1.2f, 0.5f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Ellipse2D.Float(-0.5f, -0.425f, 1.0f, 0.85f), false);
        generalPath.append(new Ellipse2D.Float(-0.5f, -0.3f, 0.24f, 0.6f), false);
        generalPath.append(new Ellipse2D.Float(0.26f, -0.3f, 0.24f, 0.6f), false);
        CAMERA_BODY = new Area(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.append(new Ellipse2D.Float(-0.18f, -0.45f, 0.36f, 1.0f), false);
        generalPath2.moveTo(-0.04f, 0.55f);
        generalPath2.lineTo(0.0f, 0.65f);
        generalPath2.lineTo(0.04f, 0.55f);
        generalPath2.closePath();
        CAMERA_HEAD = new Area(generalPath2);
        DIMENSION_LINE_END = new GeneralPath();
        DIMENSION_LINE_END.moveTo(-5.0f, 5.0f);
        DIMENSION_LINE_END.lineTo(5.0f, -5.0f);
        DIMENSION_LINE_END.moveTo(0.0f, 5.0f);
        DIMENSION_LINE_END.lineTo(0.0f, -5.0f);
        TEXT_LOCATION_INDICATOR = new GeneralPath();
        TEXT_LOCATION_INDICATOR.append(new Arc2D.Float(-2.0f, 0.0f, 4.0f, 4.0f, 190.0f, 160.0f, 1), false);
        TEXT_LOCATION_INDICATOR.moveTo(0.0f, 4.0f);
        TEXT_LOCATION_INDICATOR.lineTo(0.0f, 12.0f);
        TEXT_LOCATION_INDICATOR.moveTo(-1.2f, 8.5f);
        TEXT_LOCATION_INDICATOR.lineTo(0.0f, 11.5f);
        TEXT_LOCATION_INDICATOR.lineTo(1.2f, 8.5f);
        TEXT_LOCATION_INDICATOR.moveTo(2.0f, 3.0f);
        TEXT_LOCATION_INDICATOR.lineTo(9.0f, 6.0f);
        TEXT_LOCATION_INDICATOR.moveTo(6.0f, 6.5f);
        TEXT_LOCATION_INDICATOR.lineTo(10.0f, 7.0f);
        TEXT_LOCATION_INDICATOR.lineTo(7.5f, 3.5f);
        TEXT_LOCATION_INDICATOR.moveTo(-2.0f, 3.0f);
        TEXT_LOCATION_INDICATOR.lineTo(-9.0f, 6.0f);
        TEXT_LOCATION_INDICATOR.moveTo(-6.0f, 6.5f);
        TEXT_LOCATION_INDICATOR.lineTo(-10.0f, 7.0f);
        TEXT_LOCATION_INDICATOR.lineTo(-7.5f, 3.5f);
        TEXT_ANGLE_INDICATOR = new GeneralPath();
        TEXT_ANGLE_INDICATOR.append(new Arc2D.Float(-1.25f, -1.25f, 2.5f, 2.5f, 10.0f, 160.0f, 1), false);
        TEXT_ANGLE_INDICATOR.append(new Arc2D.Float(-8.0f, -8.0f, 16.0f, 16.0f, 30.0f, 120.0f, 0), false);
        TEXT_ANGLE_INDICATOR.moveTo(4.0f, -5.2f);
        TEXT_ANGLE_INDICATOR.lineTo(6.9f, -4.0f);
        TEXT_ANGLE_INDICATOR.lineTo(5.8f, -7.0f);
        LABEL_CENTER_INDICATOR = new Ellipse2D.Float(-1.0f, -1.0f, 2.0f, 2.0f);
        COMPASS_DISC = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
        BasicStroke basicStroke = new BasicStroke(0.01f);
        COMPASS = new GeneralPath(basicStroke.createStrokedShape(COMPASS_DISC));
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(-0.6f, 0.0f, -0.5f, 0.0f)), false);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.6f, 0.0f, 0.5f, 0.0f)), false);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.0f, 0.6f, 0.0f, 0.5f)), false);
        basicStroke = new BasicStroke(0.04f, 1, 1);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f)), false);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(0.0f, -0.47f);
        generalPath3.lineTo(0.15f, 0.46f);
        generalPath3.lineTo(0.0f, 0.32f);
        generalPath3.lineTo(-0.15f, 0.46f);
        generalPath3.closePath();
        basicStroke = new BasicStroke(0.03f);
        COMPASS.append(basicStroke.createStrokedShape(generalPath3), false);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo(-0.07f, -0.55f);
        generalPath4.lineTo(-0.07f, -0.69f);
        generalPath4.lineTo(0.07f, -0.56f);
        generalPath4.lineTo(0.07f, -0.7f);
        COMPASS.append(basicStroke.createStrokedShape(generalPath4), false);
        COMPASS_ROTATION_INDICATOR = new GeneralPath();
        COMPASS_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        COMPASS_ROTATION_INDICATOR.append(new Arc2D.Float(-8.0f, -7.0f, 16.0f, 16.0f, 210.0f, 120.0f, 0), false);
        COMPASS_ROTATION_INDICATOR.moveTo(4.0f, 5.66f);
        COMPASS_ROTATION_INDICATOR.lineTo(7.0f, 5.66f);
        COMPASS_ROTATION_INDICATOR.lineTo(5.6f, 8.3f);
        COMPASS_RESIZE_INDICATOR = new GeneralPath();
        COMPASS_RESIZE_INDICATOR.append(new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), false);
        COMPASS_RESIZE_INDICATOR.moveTo(4.0f, -6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(6.0f, -6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(6.0f, 6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(4.0f, 6.0f);
        COMPASS_RESIZE_INDICATOR.moveTo(5.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(9.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.moveTo(9.0f, -1.5f);
        COMPASS_RESIZE_INDICATOR.lineTo(12.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(9.0f, 1.5f);
        ARROW = new GeneralPath();
        ARROW.moveTo(-5.0f, -2.0f);
        ARROW.lineTo(0.0f, 0.0f);
        ARROW.lineTo(-5.0f, 2.0f);
        ERROR_TEXTURE_IMAGE = new BufferedImage(1, 1, 1);
        Graphics graphics = ERROR_TEXTURE_IMAGE.getGraphics();
        graphics.setColor(Color.RED);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
        WAIT_TEXTURE_IMAGE = new BufferedImage(1, 1, 1);
        graphics = WAIT_TEXTURE_IMAGE.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
    }

    protected static enum PaintMode {
        PAINT,
        PRINT,
        CLIPBOARD,
        EXPORT;

    }

    public class PlanRulerComponent
    extends JComponent
    implements View {
        private int orientation;
        private Point mouseLocation;

        public PlanRulerComponent(int n) {
            this.orientation = n;
            this.setOpaque(true);
            this.setFont(UIManager.getFont("ToolTip.font"));
            this.addMouseListeners();
        }

        private void addMouseListeners() {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = null;
                    PlanRulerComponent.this.repaint();
                }
            };
            PlanComponent.this.addMouseListener(mouseInputAdapter);
            PlanComponent.this.addMouseMotionListener(mouseInputAdapter);
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    PlanRulerComponent.this.removeAncestorListener(this);
                    if (PlanRulerComponent.this.getParent() instanceof JViewport) {
                        ((JViewport)PlanRulerComponent.this.getParent()).addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                PlanRulerComponent.this.mouseLocation = MouseInfo.getPointerInfo().getLocation();
                                SwingUtilities.convertPointFromScreen(PlanRulerComponent.this.mouseLocation, PlanComponent.this);
                                PlanRulerComponent.this.repaint();
                            }
                        });
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getAscent() + 6;
            if (this.orientation == 0) {
                return new Dimension(Math.round(((float)rectangle2D.getWidth() + 80.0f) * PlanComponent.this.getScale()) + insets.left + insets.right, n);
            }
            return new Dimension(n, Math.round(((float)rectangle2D.getHeight() + 80.0f) * PlanComponent.this.getScale()) + insets.top + insets.bottom);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            this.paintBackground(graphics2D);
            Insets insets = this.getInsets();
            graphics2D.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            float f = PlanComponent.this.getScale();
            graphics2D.translate((double)insets.left + (40.0 - rectangle2D.getMinX()) * (double)f, (double)insets.top + (40.0 - rectangle2D.getMinY()) * (double)f);
            graphics2D.scale(f, f);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.paintRuler(graphics2D, f);
            graphics2D.dispose();
        }

        private void paintBackground(Graphics2D graphics2D) {
            if (this.isOpaque()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        private void paintRuler(Graphics2D graphics2D, float f) {
            double d;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            Serializable serializable;
            float f8 = PlanComponent.this.getGridSize(f);
            float f9 = PlanComponent.this.getMainGridSize(f);
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            boolean bl = this.getComponentOrientation().isLeftToRight();
            if (this.getParent() instanceof JViewport) {
                serializable = ((JViewport)this.getParent()).getViewRect();
                f7 = PlanComponent.this.convertXPixelToModel(((Rectangle)serializable).x - 1);
                f6 = PlanComponent.this.convertYPixelToModel(((Rectangle)serializable).y - 1);
                f5 = PlanComponent.this.convertXPixelToModel(((Rectangle)serializable).x + ((Rectangle)serializable).width);
                f4 = PlanComponent.this.convertYPixelToModel(((Rectangle)serializable).y + ((Rectangle)serializable).height);
                f3 = bl ? PlanComponent.this.convertXPixelToModel(((Rectangle)serializable).x + ((Rectangle)serializable).width - 1) : PlanComponent.this.convertXPixelToModel(((Rectangle)serializable).x);
                f2 = PlanComponent.this.convertYPixelToModel(((Rectangle)serializable).y + ((Rectangle)serializable).height - 1);
            } else {
                f7 = (float)rectangle2D.getMinX() - 40.0f;
                f6 = (float)rectangle2D.getMinY() - 40.0f;
                f5 = PlanComponent.this.convertXPixelToModel(this.getWidth() - 1);
                f2 = f4 = PlanComponent.this.convertYPixelToModel(this.getHeight() - 1);
                f3 = bl ? f5 : f7;
            }
            serializable = this.getFontMetrics(this.getFont());
            int n = ((FontMetrics)serializable).getAscent();
            float f10 = 5.0f / f;
            float f11 = (float)(n + 6) / f;
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            graphics2D.setColor(this.getForeground());
            float f12 = 0.5f / f;
            graphics2D.setStroke(new BasicStroke(f12));
            if (this.orientation == 0) {
                graphics2D.draw(new Line2D.Float(f7, f2 - f12 / 2.0f, f5, f2 - f12 / 2.0f));
                for (d = (double)((float)((int)(f7 / f8)) * f8); d < (double)f5; d += (double)f8) {
                    graphics2D.draw(new Line2D.Double(d, f4 - f10, d, f4));
                }
            } else {
                if (bl) {
                    graphics2D.draw(new Line2D.Float(f3 - f12 / 2.0f, f6, f3 - f12 / 2.0f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 + f12 / 2.0f, f6, f3 + f12 / 2.0f, f4));
                }
                for (d = (double)((float)((int)(f6 / f8)) * f8); d < (double)f4; d += (double)f8) {
                    if (bl) {
                        graphics2D.draw(new Line2D.Double(f5 - f10, d, f5, d));
                        continue;
                    }
                    graphics2D.draw(new Line2D.Double(f7, d, f7 + f10, d));
                }
            }
            if (f9 != f8) {
                graphics2D.setStroke(new BasicStroke(1.5f / f, 0, 2));
                AffineTransform affineTransform = graphics2D.getTransform();
                if (this.orientation == 0) {
                    for (double d2 = (double)((float)((int)(f7 / f9) - 1) * f9); d2 < (double)f5; d2 += (double)f9) {
                        graphics2D.draw(new Line2D.Double(d2, f4 - f11, d2, f4));
                        graphics2D.translate(d2, f4 - f11);
                        graphics2D.scale(1.0f / f, 1.0f / f);
                        graphics2D.drawString(this.getFormattedTickText(numberFormat, d2), 3, n - 1);
                        graphics2D.setTransform(affineTransform);
                    }
                } else {
                    for (double d3 = (double)((float)((int)(f6 / f9) - 1) * f9); d3 < (double)f4; d3 += (double)f9) {
                        String string = this.getFormattedTickText(numberFormat, d3);
                        if (bl) {
                            graphics2D.draw(new Line2D.Double(f5 - f11, d3, f5, d3));
                            graphics2D.translate(f5 - f11, d3);
                            graphics2D.scale(1.0f / f, 1.0f / f);
                            graphics2D.rotate(-1.5707963267948966);
                            graphics2D.drawString(string, -((FontMetrics)serializable).stringWidth(string) - 3, n - 1);
                        } else {
                            graphics2D.draw(new Line2D.Double(f7, d3, f7 + f11, d3));
                            graphics2D.translate(f7 + f11, d3);
                            graphics2D.scale(1.0f / f, 1.0f / f);
                            graphics2D.rotate(1.5707963267948966);
                            graphics2D.drawString(string, 3, n - 1);
                        }
                        graphics2D.setTransform(affineTransform);
                    }
                }
            }
            if (this.mouseLocation != null) {
                graphics2D.setColor(PlanComponent.this.getSelectionColor());
                graphics2D.setStroke(new BasicStroke(1.0f / f));
                if (this.orientation == 0) {
                    float f13 = PlanComponent.this.convertXPixelToModel(this.mouseLocation.x);
                    graphics2D.draw(new Line2D.Float(f13, f4 - f11, f13, f4));
                } else {
                    float f14 = PlanComponent.this.convertYPixelToModel(this.mouseLocation.y);
                    if (bl) {
                        graphics2D.draw(new Line2D.Float(f5 - f11, f14, f5, f14));
                    } else {
                        graphics2D.draw(new Line2D.Float(f7, f14, f7 + f11, f14));
                    }
                }
            }
        }

        private String getFormattedTickText(NumberFormat numberFormat, double d) {
            String string;
            LengthUnit lengthUnit;
            if (Math.abs(d) < 1.0E-5) {
                d = 0.0;
            }
            if ((lengthUnit = PlanComponent.this.preferences.getLengthUnit()) == LengthUnit.INCH || lengthUnit == LengthUnit.INCH_DECIMALS) {
                string = numberFormat.format(LengthUnit.centimeterToFoot((float)d)) + "'";
            } else {
                string = numberFormat.format(d / 100.0);
                if (d == 0.0) {
                    string = string + LengthUnit.METER.getName();
                }
            }
            return string;
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<PlanComponent> planComponent;

        public UserPreferencesChangeListener(PlanComponent planComponent) {
            this.planComponent = new WeakReference<PlanComponent>(planComponent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PlanComponent planComponent = (PlanComponent)this.planComponent.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
            if (planComponent == null) {
                userPreferences.removePropertyChangeListener(property, this);
            } else {
                switch (property) {
                    case LANGUAGE: 
                    case UNIT: {
                        for (Map.Entry entry : planComponent.toolTipEditableTextFields.entrySet()) {
                            PlanComponent.updateToolTipTextFieldFormatterFactory((JFormattedTextField)entry.getValue(), (PlanController.EditableProperty)((Object)entry.getKey()), userPreferences);
                        }
                        if (planComponent.horizontalRuler != null) {
                            planComponent.horizontalRuler.repaint();
                        }
                        if (planComponent.verticalRuler == null) break;
                        planComponent.verticalRuler.repaint();
                        break;
                    }
                    case DEFAULT_FONT_NAME: {
                        planComponent.fonts = null;
                        planComponent.fontsMetrics = null;
                        planComponent.revalidate();
                        break;
                    }
                    case WALL_PATTERN: {
                        planComponent.wallAreasCache = null;
                        break;
                    }
                    case FURNITURE_VIEWED_FROM_TOP: {
                        if (planComponent.furnitureTopViewIconKeys == null || userPreferences.isFurnitureViewedFromTop()) break;
                        planComponent.furnitureTopViewIconKeys = null;
                        planComponent.furnitureTopViewIconsCache = null;
                        break;
                    }
                    case FURNITURE_MODEL_ICON_SIZE: {
                        planComponent.furnitureTopViewIconKeys = null;
                        planComponent.furnitureTopViewIconsCache = null;
                        break;
                    }
                }
                planComponent.repaint();
            }
        }
    }

    private static enum ActionType {
        DELETE_SELECTION,
        ESCAPE,
        MOVE_SELECTION_LEFT,
        MOVE_SELECTION_UP,
        MOVE_SELECTION_DOWN,
        MOVE_SELECTION_RIGHT,
        MOVE_SELECTION_FAST_LEFT,
        MOVE_SELECTION_FAST_UP,
        MOVE_SELECTION_FAST_DOWN,
        MOVE_SELECTION_FAST_RIGHT,
        TOGGLE_MAGNETISM_ON,
        TOGGLE_MAGNETISM_OFF,
        ACTIVATE_ALIGNMENT,
        DEACTIVATE_ALIGNMENT,
        ACTIVATE_DUPLICATION,
        DEACTIVATE_DUPLICATION,
        ACTIVATE_EDITIION,
        DEACTIVATE_EDITIION;

    }

    private static class SVGSupport {
        private SVGSupport() {
        }

        public static void exportToSVG(OutputStream outputStream, PlanComponent planComponent) throws IOException {
            List<Selectable> list = planComponent.getPaintedItems();
            Rectangle2D rectangle2D = planComponent.getItemsBounds(null, list);
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Float();
            }
            float f = 1.0f;
            float f2 = planComponent.getStrokeWidthExtraMargin(list, PaintMode.EXPORT);
            Dimension dimension = new Dimension((int)Math.ceil(rectangle2D.getWidth() * (double)f + (double)(2.0f * f2)), (int)Math.ceil(rectangle2D.getHeight() * (double)f + (double)(2.0f * f2)));
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(outputStream, dimension){

                public void writeHeader() throws IOException {
                    Locale locale = Locale.getDefault();
                    Locale.setDefault(Locale.ENGLISH);
                    super.writeHeader();
                    Locale.setDefault(locale);
                }
            };
            UserProperties userProperties = new UserProperties();
            userProperties.setProperty(SVGGraphics2D.STYLABLE, true);
            userProperties.setProperty(SVGGraphics2D.WRITE_IMAGES_AS, "PNG");
            userProperties.setProperty(SVGGraphics2D.TITLE, planComponent.home.getName() != null ? planComponent.home.getName() : "");
            userProperties.setProperty(SVGGraphics2D.FOR, System.getProperty("user.name", ""));
            sVGGraphics2D.setProperties((Properties)userProperties);
            sVGGraphics2D.startExport();
            sVGGraphics2D.translate(-rectangle2D.getMinX() + (double)f2, -rectangle2D.getMinY() + (double)f2);
            planComponent.checkCurrentThreadIsntInterrupted(PaintMode.EXPORT);
            planComponent.paintContent((Graphics2D)sVGGraphics2D, f, PaintMode.EXPORT);
            sVGGraphics2D.endExport();
        }
    }

    public static class IndicatorType {
        public static final IndicatorType ROTATE = new IndicatorType("ROTATE");
        public static final IndicatorType RESIZE = new IndicatorType("RESIZE");
        public static final IndicatorType ELEVATE = new IndicatorType("ELEVATE");
        public static final IndicatorType RESIZE_HEIGHT = new IndicatorType("RESIZE_HEIGHT");
        public static final IndicatorType CHANGE_POWER = new IndicatorType("CHANGE_POWER");
        public static final IndicatorType MOVE_TEXT = new IndicatorType("MOVE_TEXT");
        public static final IndicatorType ROTATE_TEXT = new IndicatorType("ROTATE_TEXT");
        public static final IndicatorType ROTATE_PITCH = new IndicatorType("ROTATE_PITCH");
        public static final IndicatorType ROTATE_ROLL = new IndicatorType("ROTATE_ROLL");
        public static final IndicatorType ARC_EXTENT = new IndicatorType("ARC_EXTENT");
        private final String name;

        protected IndicatorType(String string) {
            this.name = string;
        }

        public final String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class HomePieceOfFurnitureTopViewIconKey {
        private HomePieceOfFurniture piece;
        private int hashCode;

        public HomePieceOfFurnitureTopViewIconKey(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.hashCode = (homePieceOfFurniture.getPlanIcon() != null ? homePieceOfFurniture.getPlanIcon().hashCode() : homePieceOfFurniture.getModel().hashCode()) + (homePieceOfFurniture.getColor() != null ? 37 * this.piece.getColor().hashCode() : 1234);
            if (this.piece.isHorizontallyRotated() || this.piece.getTexture() != null) {
                this.hashCode += (homePieceOfFurniture.getTexture() != null ? 37 * this.piece.getTexture().hashCode() : 0) + 37 * Float.valueOf(homePieceOfFurniture.getWidthInPlan()).hashCode() + 37 * Float.valueOf(homePieceOfFurniture.getDepthInPlan()).hashCode() + 37 * Float.valueOf(homePieceOfFurniture.getHeightInPlan()).hashCode();
            }
            if (this.piece.getPlanIcon() != null) {
                this.hashCode += 37 * Arrays.deepHashCode((Object[])homePieceOfFurniture.getModelRotation()) + 37 * Boolean.valueOf(homePieceOfFurniture.isModelCenteredAtOrigin()).hashCode() + 37 * Boolean.valueOf(homePieceOfFurniture.isBackFaceShown()).hashCode() + 37 * Float.valueOf(homePieceOfFurniture.getPitch()).hashCode() + 37 * Float.valueOf(homePieceOfFurniture.getRoll()).hashCode() + 37 * Arrays.hashCode(homePieceOfFurniture.getModelTransformations()) + 37 * Arrays.hashCode(homePieceOfFurniture.getModelMaterials()) + (homePieceOfFurniture.getShininess() != null ? 37 * this.piece.getShininess().hashCode() : 3456);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof HomePieceOfFurnitureTopViewIconKey) {
                HomePieceOfFurniture homePieceOfFurniture = ((HomePieceOfFurnitureTopViewIconKey)object).piece;
                return (this.piece.getPlanIcon() != null ? this.piece.getPlanIcon().equals(homePieceOfFurniture.getPlanIcon()) : this.piece.getModel().equals(homePieceOfFurniture.getModel())) && (this.piece.getColor() == homePieceOfFurniture.getColor() || this.piece.getColor() != null && this.piece.getColor().equals(homePieceOfFurniture.getColor())) && (this.piece.getTexture() == homePieceOfFurniture.getTexture() || this.piece.getTexture() != null && this.piece.getTexture().equals(homePieceOfFurniture.getTexture())) && (!this.piece.isHorizontallyRotated() && !homePieceOfFurniture.isHorizontallyRotated() && this.piece.getTexture() == null && homePieceOfFurniture.getTexture() == null || this.piece.getWidthInPlan() == homePieceOfFurniture.getWidthInPlan() && this.piece.getDepthInPlan() == homePieceOfFurniture.getDepthInPlan() && this.piece.getHeightInPlan() == homePieceOfFurniture.getHeightInPlan()) && (this.piece.getPlanIcon() != null || Arrays.deepEquals((Object[])this.piece.getModelRotation(), (Object[])homePieceOfFurniture.getModelRotation()) && this.piece.isModelCenteredAtOrigin() == homePieceOfFurniture.isModelCenteredAtOrigin() && this.piece.isBackFaceShown() == homePieceOfFurniture.isBackFaceShown() && this.piece.getPitch() == homePieceOfFurniture.getPitch() && this.piece.getRoll() == homePieceOfFurniture.getRoll() && Arrays.equals(this.piece.getModelTransformations(), homePieceOfFurniture.getModelTransformations()) && Arrays.equals(this.piece.getModelMaterials(), homePieceOfFurniture.getModelMaterials()) && (this.piece.getShininess() == homePieceOfFurniture.getShininess() || this.piece.getShininess() != null && this.piece.getShininess().equals(homePieceOfFurniture.getShininess())));
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static abstract class PieceOfFurnitureTopViewIcon
    implements Icon {
        private Icon icon;

        public PieceOfFurnitureTopViewIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
        }

        public boolean isWaitIcon() {
            return IconManager.getInstance().isWaitIcon(this.icon);
        }

        public boolean isErrorIcon() {
            return IconManager.getInstance().isErrorIcon(this.icon);
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }
    }

    private static class PieceOfFurniturePlanIcon
    extends PieceOfFurnitureTopViewIcon {
        private final float pieceWidth;
        private final float pieceDepth;
        private Integer pieceColor;
        private HomeTexture pieceTexture;

        public PieceOfFurniturePlanIcon(HomePieceOfFurniture homePieceOfFurniture, Component component) {
            super(IconManager.getInstance().getIcon(homePieceOfFurniture.getPlanIcon(), component));
            this.pieceWidth = homePieceOfFurniture.getWidth();
            this.pieceDepth = homePieceOfFurniture.getDepth();
            this.pieceColor = homePieceOfFurniture.getColor();
            this.pieceTexture = homePieceOfFurniture.getTexture();
        }

        @Override
        public void paintIcon(final Component component, Graphics graphics, int n, int n2) {
            if (!this.isWaitIcon() && !this.isErrorIcon()) {
                if (this.pieceColor != null) {
                    BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                    Graphics graphics2 = bufferedImage.getGraphics();
                    super.paintIcon(component, graphics2, 0, 0);
                    graphics2.dispose();
                    final int n3 = this.pieceColor & 0xFF0000;
                    final int n4 = this.pieceColor & 0xFF00;
                    final int n5 = this.pieceColor & 0xFF;
                    this.setIcon(new ImageIcon(component.createImage(new FilteredImageSource(bufferedImage.getSource(), new RGBImageFilter(){
                        {
                            this.canFilterIndexColorModel = true;
                        }

                        @Override
                        public int filterRGB(int n, int n2, int n32) {
                            int n42 = n32 & 0xFF000000;
                            int n52 = (n32 & 0xFF0000) >> 16;
                            int n6 = (n32 & 0xFF00) >> 8;
                            int n7 = n32 & 0xFF;
                            int n8 = (n52 + n52 + n52 + n6 + n6 + n6 + n6 + n7 >> 4) + 127;
                            n52 = n3 * n8 / 255 & 0xFF0000;
                            n6 = n4 * n8 / 255 & 0xFF00;
                            n7 = n5 * n8 / 255 & 0xFF;
                            return n42 | n52 | n6 | n7;
                        }
                    }))));
                    this.pieceColor = null;
                } else if (this.pieceTexture != null) {
                    if (PlanComponent.isTextureManagerAvailable()) {
                        TextureManager.getInstance().loadTexture(this.pieceTexture.getImage(), true, new TextureManager.TextureObserver(){

                            @Override
                            public void textureUpdated(Texture texture) {
                                this.setTexturedIcon(component, ((ImageComponent2D)texture.getImage(0)).getImage(), pieceTexture.getAngle());
                            }
                        });
                    } else {
                        Icon icon = IconManager.getInstance().getIcon(this.pieceTexture.getImage(), null);
                        if (IconManager.getInstance().isErrorIcon(icon)) {
                            this.setTexturedIcon(component, ERROR_TEXTURE_IMAGE, 0.0f);
                        } else {
                            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                            icon.paintIcon(component, graphics2D, 0, 0);
                            graphics2D.dispose();
                            this.setTexturedIcon(component, bufferedImage, this.pieceTexture.getAngle());
                        }
                    }
                    this.pieceTexture = null;
                }
            }
            super.paintIcon(component, graphics, n, n2);
        }

        private void setTexturedIcon(Component component, BufferedImage bufferedImage, float f) {
            BufferedImage bufferedImage2 = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            PieceOfFurniturePlanIcon.super.paintIcon(component, graphics2D, 0, 0);
            graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, (float)(-this.getIconWidth()) / this.pieceWidth * this.pieceTexture.getWidth(), (float)(-this.getIconHeight()) / this.pieceDepth * this.pieceTexture.getHeight())));
            graphics2D.setComposite(AlphaComposite.getInstance(5));
            graphics2D.rotate(f);
            float f2 = Math.max(bufferedImage2.getWidth(), bufferedImage2.getHeight());
            graphics2D.fill(new Rectangle2D.Float(-f2, -f2, 3.0f * f2, 3.0f * f2));
            graphics2D.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.dispose();
            this.setIcon(new ImageIcon(bufferedImage2));
        }
    }

    private static class PieceOfFurnitureModelIcon
    extends PieceOfFurnitureTopViewIcon {
        private static BranchGroup sceneRoot;
        private static ExecutorService iconsCreationExecutor;

        public PieceOfFurnitureModelIcon(final HomePieceOfFurniture homePieceOfFurniture, final Object3DFactory object3DFactory, final Component component, final int n) {
            super(IconManager.getInstance().getWaitIcon());
            ModelManager.getInstance().loadModel(homePieceOfFurniture.getModel(), component == null, new ModelManager.ModelObserver(){

                @Override
                public void modelUpdated(BranchGroup branchGroup) {
                    final HomePieceOfFurniture homePieceOfFurniture2 = homePieceOfFurniture.clone();
                    if (homePieceOfFurniture2.isResizable()) {
                        homePieceOfFurniture2.setModelMirrored(false);
                    }
                    final float f = homePieceOfFurniture2.getWidthInPlan();
                    final float f2 = homePieceOfFurniture2.getDepthInPlan();
                    final float f3 = homePieceOfFurniture2.getHeightInPlan();
                    homePieceOfFurniture2.setX(0.0f);
                    homePieceOfFurniture2.setY(0.0f);
                    homePieceOfFurniture2.setElevation(-f3 / 2.0f);
                    homePieceOfFurniture2.setLevel(null);
                    homePieceOfFurniture2.setAngle(0.0f);
                    if (component != null) {
                        if (iconsCreationExecutor == null) {
                            iconsCreationExecutor = Executors.newSingleThreadExecutor();
                        }
                        iconsCreationExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                this.setIcon(this.createIcon((Object3DBranch)((Object)object3DFactory.createObject3D(null, homePieceOfFurniture2, true)), f, f2, f3, n));
                                component.repaint();
                            }
                        });
                    } else {
                        this.setIcon(this.createIcon((Object3DBranch)((Object)object3DFactory.createObject3D(null, homePieceOfFurniture2, true)), f, f2, f3, n));
                    }
                }

                @Override
                public void modelError(Exception exception) {
                    this.setIcon(IconManager.getInstance().getErrorIcon());
                    if (component != null) {
                        component.repaint();
                    }
                }
            });
        }

        private BranchGroup getSceneRoot(int n) {
            if (sceneRoot == null) {
                Light[] lightArray;
                Canvas3D canvas3D = Component3DManager.getInstance().getOffScreenCanvas3D(n, n);
                SimpleUniverse simpleUniverse = new SimpleUniverse(canvas3D);
                ViewingPlatform viewingPlatform = simpleUniverse.getViewingPlatform();
                TransformGroup transformGroup = viewingPlatform.getViewPlatformTransform();
                Transform3D transform3D = new Transform3D();
                transform3D.rotX(-1.5707963267948966);
                Transform3D transform3D2 = new Transform3D();
                transform3D2.setTranslation(new Vector3f(0.0f, 5.0f, 0.0f));
                transform3D2.mul(transform3D);
                transformGroup.setTransform(transform3D2);
                Viewer viewer = viewingPlatform.getViewers()[0];
                javax.media.j3d.View view = viewer.getView();
                view.setProjectionPolicy(0);
                sceneRoot = new BranchGroup();
                sceneRoot.setCapability(12);
                sceneRoot.setCapability(13);
                sceneRoot.setCapability(14);
                Background background = new Background(1.1f, 1.1f, 1.1f);
                background.setCapability(17);
                background.setApplicationBounds((Bounds)new BoundingBox(new Point3d(-1.1, -1.1, -1.1), new Point3d(1.1, 1.1, 1.1)));
                sceneRoot.addChild((Node)background);
                for (Light light : lightArray = new Light[]{new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(-1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(0.0f, -0.8f, 1.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))}) {
                    light.setInfluencingBounds((Bounds)new BoundingBox(new Point3d(-1.1, -1.1, -1.1), new Point3d(1.1, 1.1, 1.1)));
                    sceneRoot.addChild((Node)light);
                }
                simpleUniverse.addBranchGraph(sceneRoot);
            } else {
                SimpleUniverse simpleUniverse = (SimpleUniverse)sceneRoot.getLocale().getVirtualUniverse();
                Canvas3D canvas3D = simpleUniverse.getCanvas();
                if (canvas3D.getWidth() != n) {
                    simpleUniverse.cleanup();
                    sceneRoot = null;
                    return this.getSceneRoot(n);
                }
            }
            return sceneRoot;
        }

        private Icon createIcon(Object3DBranch object3DBranch, float f, float f2, float f3, int n) {
            Transform3D transform3D = new Transform3D();
            transform3D.setScale(new Vector3d((double)(2.0f / f), (double)(2.0f / f3), (double)(2.0f / f2)));
            TransformGroup transformGroup = new TransformGroup();
            transformGroup.setTransform(transform3D);
            transformGroup.addChild((Node)object3DBranch);
            this.cloneTexture((Node)object3DBranch, new IdentityHashMap<Texture, Texture>());
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.addChild((Node)transformGroup);
            BranchGroup branchGroup2 = this.getSceneRoot(n);
            branchGroup2.addChild((Node)branchGroup);
            Background background = (Background)branchGroup2.getChild(0);
            background.setColor(1.0f, 1.0f, 1.0f);
            Canvas3D canvas3D = ((SimpleUniverse)branchGroup2.getLocale().getVirtualUniverse()).getCanvas();
            canvas3D.renderOffScreenBuffer();
            canvas3D.waitForOffScreenRendering();
            BufferedImage bufferedImage = canvas3D.getOffScreenBuffer().getImage();
            int[] nArray = this.getImagePixels(bufferedImage);
            background.setColor(0.0f, 0.0f, 0.0f);
            canvas3D.renderOffScreenBuffer();
            canvas3D.waitForOffScreenRendering();
            BufferedImage bufferedImage2 = canvas3D.getOffScreenBuffer().getImage();
            int[] nArray2 = this.getImagePixels(bufferedImage2);
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == nArray[i] || nArray2[i] != -16777216 || nArray[i] != -1) continue;
                nArray[i] = 0;
            }
            branchGroup2.removeChild((Node)branchGroup);
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth())));
        }

        private void cloneTexture(Node node, Map<Texture, Texture> map) {
            Texture texture;
            Appearance appearance;
            if (node instanceof Group) {
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.cloneTexture((Node)enumeration.nextElement(), map);
                }
            } else if (node instanceof Link) {
                this.cloneTexture((Node)((Link)node).getSharedGroup(), map);
            } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
                Texture texture2 = map.get(texture);
                if (texture2 == null) {
                    texture2 = (Texture)texture.cloneNodeComponent(false);
                    map.put(texture, texture2);
                }
                appearance.setTexture(texture2);
            }
        }

        private int[] getImagePixels(BufferedImage bufferedImage) {
            if (bufferedImage.getType() == 1 || bufferedImage.getType() == 2) {
                return (int[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            }
            return bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        }

        private static float[] computePieceOfFurnitureSizeInPlan(HomePieceOfFurniture homePieceOfFurniture, Object3DFactory object3DFactory) {
            Transform3D transform3D;
            Transform3D transform3D2 = new Transform3D();
            if (homePieceOfFurniture.getPitch() != 0.0f) {
                transform3D2.rotX((double)(-homePieceOfFurniture.getPitch()));
            }
            if (homePieceOfFurniture.getRoll() != 0.0f) {
                transform3D = new Transform3D();
                transform3D.rotZ((double)(-homePieceOfFurniture.getRoll()));
                transform3D2.mul(transform3D, transform3D2);
            }
            homePieceOfFurniture = homePieceOfFurniture.clone();
            homePieceOfFurniture.setX(0.0f);
            homePieceOfFurniture.setY(0.0f);
            homePieceOfFurniture.setElevation(-homePieceOfFurniture.getHeight() / 2.0f);
            homePieceOfFurniture.setLevel(null);
            homePieceOfFurniture.setAngle(0.0f);
            homePieceOfFurniture.setRoll(0.0f);
            homePieceOfFurniture.setPitch(0.0f);
            homePieceOfFurniture.setWidthInPlan(homePieceOfFurniture.getWidth());
            homePieceOfFurniture.setDepthInPlan(homePieceOfFurniture.getDepth());
            homePieceOfFurniture.setHeightInPlan(homePieceOfFurniture.getHeight());
            transform3D = ModelManager.getInstance().getBounds((Node)((Object3DBranch)((Object)object3DFactory.createObject3D(null, homePieceOfFurniture, true))), transform3D2);
            Point3d point3d = new Point3d();
            transform3D.getLower(point3d);
            Point3d point3d2 = new Point3d();
            transform3D.getUpper(point3d2);
            return new float[]{Math.max(0.001f, (float)(point3d2.x - point3d.x)), Math.max(0.001f, (float)(point3d2.z - point3d.z)), Math.max(0.001f, (float)(point3d2.y - point3d.y))};
        }
    }
}

