/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoublePredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class FunctionMatchQuery
extends Query {
    private final DoubleValuesSource source;
    private final DoublePredicate filter;

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter) {
        this.source = source;
        this.filter = filter;
    }

    public String toString(String field) {
        return "FunctionMatchQuery(" + this.source.toString() + ")";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final DoubleValuesSource vs = this.source.rewrite(searcher);
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final DoubleValues values = vs.getValues(context, null);
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    public boolean matches() throws IOException {
                        return values.advanceExact(this.approximation.docID()) && FunctionMatchQuery.this.filter.test(values.doubleValue());
                    }

                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return FunctionMatchQuery.this.source.isCacheable(ctx);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionMatchQuery that = (FunctionMatchQuery)((Object)o);
        return Objects.equals(this.source, that.source) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.filter);
    }
}

